/*
 * Decompiled with CFR 0.152.
 */
package net.foi1y.foi1yscollectables;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.foi1y.foi1yscollectables.ModBlocks;
import net.foi1y.foi1yscollectables.ModCreativeTabs;
import net.foi1y.foi1yscollectables.ModItems;

public final class Main {
    public static final String MOD_ID = "foi1yscollectables";

    public static void init() {
        ModCreativeTabs.initCreativeTabs();
        ModBlocks.initBlocks();
        ModItems.initItems();
        Main.installResourcepackIfNeeded();
    }

    private static void installResourcepackIfNeeded() {
        Path gameDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path resourcepacksDir = gameDir.resolve("resourcepacks");
        Path targetZip = resourcepacksDir.resolve("TitledTooltips.zip");
        try {
            Files.createDirectories(resourcepacksDir, new FileAttribute[0]);
            String internalPath = "/assets/foi1yscollectables/resourcepacks/TitledTooltips.zip";
            InputStream in = Main.class.getResourceAsStream(internalPath);
            if (in == null) {
                System.err.println("Could not find Resourcepack in mod JAR: " + internalPath);
                return;
            }
            Files.copy(in, targetZip, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Installed Resourcepack to: " + targetZip);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

