package de.simon0302010.admintools;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class Admintools implements ModInitializer {
    @Override
    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(class_2170.method_9247("locateplayer")
                    .requires(source -> source.method_9259(1))
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                            .executes(PlayerLocator::getLocation)
                    )
            );
            dispatcher.register(class_2170.method_9247("invsee")
                    .requires(source -> source.method_9259(1))
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                            .executes(InventoryView::showInventory)
                    )
            );
            dispatcher.register(class_2170.method_9247("freeze")
                    .requires(source -> source.method_9259(1))
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                            .executes(FreezePlayer::freezePlayer)
                    )
            );
            dispatcher.register(class_2170.method_9247("unfreeze")
                    .requires(source -> source.method_9259(1))
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                            .executes(FreezePlayer::unfreezePlayer)
                    )
            );
        });

        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (FreezeState.isFrozen(player)) {
                    class_243 frozenPos = FreezeState.getFrozenPosition(player);
                    player.method_6082(frozenPos.field_1352, frozenPos.field_1351, frozenPos.field_1350, false);
                    player.method_18799(class_243.field_1353);
                    player.field_6017 = 0;
                }
            }
        });
    }
}