/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.ExecutableCommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.GreedyArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.exceptions.MissingCommandExecutorException;
import dev.jorel.commandapi.exceptions.OptionalArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCommandAPICommand<Impl extends AbstractCommandAPICommand<Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender>
extends ExecutableCommand<Impl, CommandSender> {
    protected List<Argument> arguments = new ArrayList<Argument>();
    protected List<Impl> subcommands = new ArrayList<Impl>();
    protected boolean isConverted = false;

    protected AbstractCommandAPICommand(String commandName) {
        super(commandName);
    }

    protected AbstractCommandAPICommand(CommandMetaData<CommandSender> metaData) {
        super(metaData);
    }

    public Impl withArguments(List<Argument> args) {
        this.arguments.addAll(args);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    @SafeVarargs
    public final Impl withArguments(Argument ... args) {
        this.arguments.addAll(Arrays.asList(args));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public Impl withOptionalArguments(List<Argument> args) {
        for (AbstractArgument argument2 : args) {
            argument2.setOptional(true);
            this.arguments.add(argument2);
        }
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    @SafeVarargs
    public final Impl withOptionalArguments(Argument ... args) {
        for (Argument argument2 : args) {
            ((AbstractArgument)argument2).setOptional(true);
            this.arguments.add(argument2);
        }
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public Impl withSubcommand(Impl subcommand2) {
        this.subcommands.add(subcommand2);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public Impl withSubcommands(Impl ... subcommands) {
        this.subcommands.addAll(Arrays.asList(subcommands));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> args) {
        this.arguments = args;
    }

    public List<Impl> getSubcommands() {
        return this.subcommands;
    }

    public void setSubcommands(List<Impl> subcommands) {
        this.subcommands = subcommands;
    }

    public boolean isConverted() {
        return this.isConverted;
    }

    Impl setConverted(boolean isConverted) {
        this.isConverted = isConverted;
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    private static <Impl extends AbstractCommandAPICommand<Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender> void flatten(Impl rootCommand, List<Argument> prevArguments, Impl subcommand2, String namespace) {
        String[] literals = new String[subcommand2.meta.aliases.length + 1];
        literals[0] = subcommand2.meta.commandName;
        System.arraycopy(subcommand2.meta.aliases, 0, literals, 1, subcommand2.meta.aliases.length);
        Object literal = CommandAPIHandler.getInstance().getPlatform().newConcreteMultiLiteralArgument(subcommand2.meta.commandName, literals);
        ((AbstractArgument)((AbstractArgument)((AbstractArgument)literal).withPermission(subcommand2.meta.permission)).withRequirement(subcommand2.meta.requirements)).setListed(false);
        prevArguments.add(literal);
        if (subcommand2.executor.hasAnyExecutors()) {
            rootCommand.arguments = prevArguments;
            rootCommand.withArguments(subcommand2.arguments);
            rootCommand.executor = subcommand2.executor;
            rootCommand.subcommands = new ArrayList<Impl>();
            rootCommand.register(namespace);
        }
        for (AbstractCommandAPICommand subsubcommand : subcommand2.getSubcommands()) {
            AbstractCommandAPICommand.flatten(rootCommand, new ArrayList<Argument>(prevArguments), subsubcommand, namespace);
        }
    }

    boolean hasAnyExecutors() {
        if (this.executor.hasAnyExecutors()) {
            return true;
        }
        for (AbstractCommandAPICommand subcommand2 : this.subcommands) {
            if (!subcommand2.hasAnyExecutors()) continue;
            return true;
        }
        return false;
    }

    private void checkHasExecutors() {
        if (!this.hasAnyExecutors()) {
            throw new MissingCommandExecutorException(this.meta.commandName);
        }
    }

    @Override
    public void register(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Parameter 'namespace' was null when registering command /" + this.meta.commandName + "!");
        }
        AbstractArgument[] argumentsArray = this.arguments == null ? new AbstractArgument[]{} : (AbstractArgument[])this.arguments.toArray(AbstractArgument[]::new);
        this.checkGreedyArgumentConstraints(argumentsArray);
        this.checkHasExecutors();
        for (AbstractArgument argument2 : argumentsArray) {
            if (argument2.getArgumentPermission() != null) continue;
            argument2.withPermission(this.meta.permission);
        }
        if (this.executor.hasAnyExecutors()) {
            CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
            for (AbstractArgument[] args : this.getArgumentsToRegister(argumentsArray)) {
                handler.register(this.meta, args, this.executor, this.isConverted, namespace);
            }
        }
        for (AbstractCommandAPICommand subcommand2 : this.subcommands) {
            AbstractCommandAPICommand.flatten(this.copy(), new ArrayList(), subcommand2, namespace);
        }
    }

    private void checkGreedyArgumentConstraints(Argument[] argumentsArray) {
        for (int i = 0; i < argumentsArray.length; ++i) {
            if (!(argumentsArray[i] instanceof GreedyArgument) || i == argumentsArray.length - 1) continue;
            throw new GreedyArgumentException((AbstractArgument<?, ?, ?, ?>[])argumentsArray);
        }
    }

    public Impl copy() {
        Impl command = this.newConcreteCommandAPICommand(new CommandMetaData(this.meta));
        ((AbstractCommandAPICommand)command).arguments = new ArrayList<Argument>(this.arguments);
        ((AbstractCommandAPICommand)command).subcommands = new ArrayList<Impl>(this.subcommands);
        ((AbstractCommandAPICommand)command).isConverted = this.isConverted;
        return command;
    }

    protected abstract Impl newConcreteCommandAPICommand(CommandMetaData<CommandSender> var1);

    private List<Argument[]> getArgumentsToRegister(Argument[] argumentsArray) {
        AbstractArgument next;
        ArrayList<Argument[]> argumentsToRegister = new ArrayList<Argument[]>();
        ArrayList<AbstractArgument> currentCommand = new ArrayList<AbstractArgument>();
        Iterator<Argument> argumentIterator = List.of(argumentsArray).iterator();
        while (argumentIterator.hasNext()) {
            next = (AbstractArgument)argumentIterator.next();
            if (next.isOptional()) {
                argumentsToRegister.add(currentCommand.toArray(new AbstractArgument[0]));
                currentCommand.addAll(this.unpackCombinedArguments(next));
                break;
            }
            currentCommand.addAll(this.unpackCombinedArguments(next));
        }
        while (argumentIterator.hasNext()) {
            next = (AbstractArgument)argumentIterator.next();
            if (!next.isOptional()) {
                throw new OptionalArgumentException(this.meta.commandName);
            }
            argumentsToRegister.add(currentCommand.toArray(new AbstractArgument[0]));
            currentCommand.addAll(this.unpackCombinedArguments(next));
        }
        argumentsToRegister.add(currentCommand.toArray(new AbstractArgument[0]));
        return argumentsToRegister;
    }

    private List<Argument> unpackCombinedArguments(Argument argument2) {
        if (!((AbstractArgument)argument2).hasCombinedArguments()) {
            return List.of(argument2);
        }
        ArrayList<Object> combinedArguments = new ArrayList<Object>();
        combinedArguments.add(argument2);
        for (AbstractArgument subArgument : ((AbstractArgument)argument2).getCombinedArguments()) {
            subArgument.copyPermissionsAndRequirements(argument2);
            combinedArguments.addAll(this.unpackCombinedArguments(subArgument));
        }
        return combinedArguments;
    }
}

