/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.network;

import dev.jorel.commandapi.exceptions.ProtocolVersionTooOldException;
import dev.jorel.commandapi.network.CommandAPIPacket;
import dev.jorel.commandapi.network.CommandAPIPacketHandlerProvider;
import dev.jorel.commandapi.network.CommandAPIProtocol;
import dev.jorel.commandapi.network.FriendlyByteBuffer;
import dev.jorel.commandapi.network.packets.ProtocolVersionTooOldPacket;
import java.util.Arrays;

public abstract class CommandAPIMessenger<InputChannel, OutputChannel> {
    private final CommandAPIPacketHandlerProvider<InputChannel> packetHandlerProvider;

    protected CommandAPIMessenger(CommandAPIPacketHandlerProvider<InputChannel> packetHandlerProvider) {
        this.packetHandlerProvider = packetHandlerProvider;
    }

    public abstract void close();

    public abstract int getConnectionProtocolVersion(OutputChannel var1);

    protected void messageReceived(CommandAPIProtocol protocol, InputChannel sender, byte[] input) {
        CommandAPIPacket packet;
        int id;
        if (input.length == 0) {
            return;
        }
        FriendlyByteBuffer buffer = new FriendlyByteBuffer(input);
        try {
            id = buffer.readVarInt();
            packet = protocol.createPacket(id, buffer);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Exception while reading packet", e);
        }
        if (packet == null) {
            throw new IllegalStateException("Unknown packet id: " + id);
        }
        if (buffer.countReadableBytes() != 0) {
            throw new IllegalStateException("Packet was larger than expected! " + buffer.countReadableBytes() + " extra byte(s) found after deserializing.\nGiven: " + Arrays.toString(input) + ", Read: " + String.valueOf(packet));
        }
        this.packetHandlerProvider.getHandlerForProtocol(protocol).handlePacket(sender, packet);
    }

    public void sendPacket(OutputChannel target, CommandAPIPacket packet) {
        Class<?> packetType = packet.getClass();
        CommandAPIProtocol protocol = CommandAPIProtocol.getProtocolForPacket(packetType);
        if (protocol == null) {
            throw new IllegalStateException("Packet class \"" + packet.getClass().getSimpleName() + "\" is not associated with a CommandAPIProtocol. This packet must be registered before it can be sent.");
        }
        int id = protocol.getId(packetType);
        assert (id != -1);
        FriendlyByteBuffer output = new FriendlyByteBuffer();
        output.writeVarInt(id);
        try {
            packet.write(output, target, this.getConnectionProtocolVersion(target));
        }
        catch (ProtocolVersionTooOldException exception) {
            this.sendPacket(target, new ProtocolVersionTooOldPacket(1, exception.getReason()));
            throw exception;
        }
        this.sendRawBytes(protocol, target, output.toByteArray());
    }

    protected abstract void sendRawBytes(CommandAPIProtocol var1, OutputChannel var2, byte[] var3);
}

