/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.manager.commands.handle;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0016\u00a8\u0006\u0018"}, d2={"Lyv/tils/smp/manager/commands/handle/FlyHandler;", "", "<init>", "()V", "flySwitch", "", "player", "Lorg/bukkit/entity/Player;", "sender", "Lorg/bukkit/command/CommandSender;", "state", "", "silent", "(Lorg/bukkit/entity/Player;Lorg/bukkit/command/CommandSender;Ljava/lang/Boolean;Z)V", "onLandingDamage", "e", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onRejoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onGamemodeSwitch", "Lorg/bukkit/event/player/PlayerGameModeChangeEvent;", "Companion", "YVtils-SMP_paper"})
public final class FlyHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static Map<UUID, Boolean> fly = new HashMap();
    @NotNull
    private static Map<UUID, Boolean> airAfter = new HashMap();

    public final void flySwitch(@NotNull Player player, @NotNull CommandSender sender, @Nullable Boolean state, boolean silent) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(sender, "sender");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (fly.get(uuid) == null || Intrinsics.areEqual(fly.get(uuid), false) || state == null || state.booleanValue()) {
            fly.put(uuid, true);
            player.setAllowFlight(true);
            player.setFlying(true);
            if (!silent) {
                player.sendMessage(new Language().getMessage(uuid, LangStrings.FLY_COMMAND_ENABLE));
                if (!Intrinsics.areEqual(player, sender)) {
                    sender.sendMessage(new Placeholder().replacer(new Language().getMessage(sender, LangStrings.FLY_COMMAND_ENABLE_OTHER), CollectionsKt.listOf("player"), CollectionsKt.listOf(player.getName())));
                }
            }
        } else {
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                fly.put(uuid, false);
            } else {
                airAfter.put(uuid, player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir());
                fly.put(uuid, false);
                player.setAllowFlight(false);
                player.setFlying(false);
            }
            if (!silent) {
                player.sendMessage(new Language().getMessage(uuid, LangStrings.FLY_COMMAND_DISABLE));
                if (!Intrinsics.areEqual(player, sender)) {
                    sender.sendMessage(new Placeholder().replacer(new Language().getMessage(sender, LangStrings.FLY_COMMAND_DISABLE_OTHER), CollectionsKt.listOf("player"), CollectionsKt.listOf(player.getName())));
                }
            }
        }
    }

    public static /* synthetic */ void flySwitch$default(FlyHandler flyHandler, Player player, CommandSender commandSender, Boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            commandSender = (CommandSender)player;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        flyHandler.flySwitch(player, commandSender, bl, bl2);
    }

    public final void onLandingDamage(@NotNull EntityDamageEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.getEntity() instanceof Player) {
            Entity entity = e.getEntity();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            Player player = (Player)entity;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uuid = uUID;
            if (Intrinsics.areEqual(fly.get(uuid), true)) {
                if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                    e.setCancelled(true);
                }
            } else if (Intrinsics.areEqual(airAfter.get(uuid), true) && e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                e.setCancelled(true);
                airAfter.put(uuid, false);
            }
        }
    }

    public final void onWorldChange(@NotNull PlayerChangedWorldEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (Intrinsics.areEqual(fly.get(uuid), true)) {
            player2.setAllowFlight(true);
            player2.setFlying(true);
        }
    }

    public final void onRejoin(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (Intrinsics.areEqual(fly.get(uuid), true)) {
            player2.setAllowFlight(true);
            player2.setFlying(true);
        }
    }

    public final void onGamemodeSwitch(@NotNull PlayerGameModeChangeEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Bukkit.getScheduler().runTaskLater((Plugin)YVtils.Companion.getInstance(), () -> FlyHandler.onGamemodeSwitch$lambda$0(uuid, player2), 1L);
    }

    private static final void onGamemodeSwitch$lambda$0(UUID $uuid, Player $player) {
        if (Intrinsics.areEqual(fly.get($uuid), true)) {
            $player.setAllowFlight(true);
            $player.setFlying(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lyv/tils/smp/manager/commands/handle/FlyHandler$Companion;", "", "<init>", "()V", "fly", "", "Ljava/util/UUID;", "", "getFly", "()Ljava/util/Map;", "setFly", "(Ljava/util/Map;)V", "airAfter", "getAirAfter", "setAirAfter", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<UUID, Boolean> getFly() {
            return fly;
        }

        public final void setFly(@NotNull Map<UUID, Boolean> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            fly = map;
        }

        @NotNull
        public final Map<UUID, Boolean> getAirAfter() {
            return airAfter;
        }

        public final void setAirAfter(@NotNull Map<UUID, Boolean> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            airAfter = map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

