/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.admin.moderation.handler;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.admin.mutedPlayers_yml;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.internalAPI.Vars;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\bJ\b\u0010\u0014\u001a\u00020\u0005H\u0002J\"\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lyv/tils/smp/mods/admin/moderation/handler/MuteHandler;", "", "<init>", "()V", "mutePlayer", "", "targets", "", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "sender", "Lorg/bukkit/command/CommandSender;", "reason", "", "silent", "", "playerChat", "e", "Lio/papermc/paper/event/player/AsyncChatEvent;", "checkMute", "target", "refreshMutedPlayers", "updateMute", "duration", "YVtils-SMP_paper"})
public final class MuteHandler {
    public final void mutePlayer(@NotNull List<? extends PlayerProfile> targets, @NotNull CommandSender sender, @NotNull String reason, boolean silent) {
        Intrinsics.checkNotNullParameter(targets, "targets");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(reason, "reason");
        for (PlayerProfile playerProfile : targets) {
            try {
                OfflinePlayer offlinePlayer;
                if (playerProfile.getId() == null) {
                    sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to mute the player."));
                    return;
                }
                UUID uUID = playerProfile.getId();
                Intrinsics.checkNotNull(uUID);
                Intrinsics.checkNotNullExpressionValue(Bukkit.getOfflinePlayer((UUID)uUID), "getOfflinePlayer(...)");
                if (new MuteHandler().checkMute(playerProfile)) {
                    sender.sendMessage(new Language().getMessage(sender, LangStrings.PLAYER_ALREADY_MUTED));
                    return;
                }
                MuteHandler.updateMute$default(this, playerProfile, reason, null, 4, null);
                if (offlinePlayer.isOnline()) {
                    Player player = offlinePlayer.getPlayer();
                    if (player != null) {
                        Placeholder placeholder = new Placeholder();
                        Language language = new Language();
                        UUID uUID2 = playerProfile.getId();
                        Intrinsics.checkNotNull(uUID2);
                        String[] stringArray = new String[]{"prefix", "reason"};
                        List<String> list = CollectionsKt.listOf(stringArray);
                        stringArray = new String[]{new Vars().getPrefix(), reason};
                        player.sendMessage(placeholder.replacer(language.getMessage(uUID2, LangStrings.PLAYER_GOT_MUTED), list, CollectionsKt.listOf(stringArray)));
                    }
                }
                if (silent) continue;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("yvtils.smp.command.moderation.announcement")) continue;
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID3 = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
                    Component component = language.getMessage(uUID3, LangStrings.MOD_ANNOUNCEMENT_MUTE);
                    String[] stringArray = new String[]{"prefix", "player", "moderator", "reason"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[4];
                    stringArray[0] = new Vars().getPrefix();
                    String string = playerProfile.getName();
                    if (string == null) {
                        string = "null";
                    }
                    stringArray[1] = string;
                    Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                    stringArray[3] = reason;
                    player.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
                }
                ConsoleCommandSender consoleCommandSender = YVtils.Companion.getInstance().getServer().getConsoleSender();
                Placeholder placeholder = new Placeholder();
                Component component = new Language().getMessage(LangStrings.MOD_ANNOUNCEMENT_MUTE);
                String[] stringArray = new String[]{"prefix", "player", "moderator", "reason"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[4];
                stringArray[0] = new Vars().getPrefix();
                String string = playerProfile.getName();
                if (string == null) {
                    string = "null";
                }
                stringArray[1] = string;
                Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                stringArray[3] = reason;
                consoleCommandSender.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
            }
            catch (Exception exception) {
                sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to mute the player."));
            }
        }
    }

    public static /* synthetic */ void mutePlayer$default(MuteHandler muteHandler, List list, CommandSender commandSender, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        muteHandler.mutePlayer(list, commandSender, string, bl);
    }

    public final void playerChat(@NotNull AsyncChatEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        PlayerProfile playerProfile = player2.getPlayerProfile();
        Intrinsics.checkNotNullExpressionValue(playerProfile, "getPlayerProfile(...)");
        if (this.checkMute(playerProfile)) {
            String[] stringArray;
            List<String> rawDuration;
            e.setCancelled(true);
            List<String> list = mutedPlayers_yml.Companion.getMutedPlayer().get(player2.getUniqueId());
            if (list == null || (list = list.get(1)) == null) {
                list = "null";
            }
            if (!Intrinsics.areEqual(rawDuration = list, "null")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Long.parseLong((String)((Object)rawDuration)));
                stringArray = calendar.getTime().toString();
            } else {
                stringArray = "Permanent";
            }
            String[] stringArray2 = stringArray;
            Intrinsics.checkNotNull(stringArray2);
            String[] duration = stringArray2;
            Placeholder placeholder = new Placeholder();
            Language language = new Language();
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Component component = language.getMessage(uUID, LangStrings.PLAYER_YOU_ARE_MUTED);
            stringArray2 = new String[]{"prefix", "reason", "duration"};
            List<String> list2 = CollectionsKt.listOf(stringArray2);
            stringArray2 = new String[3];
            stringArray2[0] = new Vars().getPrefix();
            List<String> list3 = mutedPlayers_yml.Companion.getMutedPlayer().get(player2.getUniqueId());
            if (list3 == null || (list3 = list3.get(0)) == null) {
                Language language2 = new Language();
                UUID uUID2 = player2.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
                list3 = language2.getRawMessage(uUID2, LangStrings.MOD_NO_REASON);
            }
            stringArray2[1] = list3;
            stringArray2[2] = duration;
            player2.sendMessage(placeholder.replacer(component, list2, CollectionsKt.listOf(stringArray2)));
            ConsoleCommandSender consoleCommandSender = YVtils.Companion.getInstance().getServer().getConsoleSender();
            Placeholder placeholder2 = new Placeholder();
            Component component2 = new Language().getMessage(LangStrings.PLAYER_TRIED_TO_WRITE_WHILE_MUTED);
            stringArray2 = new String[]{"prefix", "player", "message", "reason", "duration"};
            List<String> list4 = CollectionsKt.listOf(stringArray2);
            stringArray2 = new String[5];
            stringArray2[0] = new Vars().getPrefix();
            Intrinsics.checkNotNullExpressionValue(player2.getName(), "getName(...)");
            ColorUtils colorUtils = new ColorUtils();
            Component component3 = e.originalMessage();
            Intrinsics.checkNotNullExpressionValue(component3, "originalMessage(...)");
            stringArray2[2] = colorUtils.convert(component3);
            List<String> list5 = mutedPlayers_yml.Companion.getMutedPlayer().get(player2.getUniqueId());
            if (list5 == null || (list5 = list5.get(0)) == null) {
                Language language3 = new Language();
                UUID uUID3 = player2.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
                list5 = language3.getRawMessage(uUID3, LangStrings.MOD_NO_REASON);
            }
            stringArray2[3] = list5;
            stringArray2[4] = duration;
            consoleCommandSender.sendMessage(placeholder2.replacer(component2, list4, CollectionsKt.listOf(stringArray2)));
        }
    }

    public final boolean checkMute(@NotNull PlayerProfile target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.refreshMutedPlayers();
        return mutedPlayers_yml.Companion.getMutedPlayer().containsKey(target.getId());
    }

    private final void refreshMutedPlayers() {
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "admin/mutedPlayers.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        mutedPlayers_yml.Companion.getMutedPlayer().clear();
        for (String uuid : ymlFile.getKeys(false)) {
            String duration;
            String string;
            String reason;
            if (Intrinsics.areEqual(uuid, "documentation")) continue;
            String string2 = ymlFile.getString(uuid + ".reason");
            if (string2 == null) {
                string2 = reason = "null";
            }
            if ((string = ymlFile.getString(uuid + ".duration")) == null) {
                string = "null";
            }
            if (!Intrinsics.areEqual(duration = string, "null")) {
                long durationLong = Long.parseLong(duration);
                long currentTime = System.currentTimeMillis();
                if (currentTime > durationLong) {
                    ymlFile.set(uuid, null);
                    ymlFile.save(file);
                    continue;
                }
            }
            Map<UUID, List<String>> map = mutedPlayers_yml.Companion.getMutedPlayer();
            UUID uUID = UUID.fromString(uuid);
            Object object = new String[]{reason, duration};
            object = CollectionsKt.listOf(object);
            map.put(uUID, (List<String>)object);
        }
    }

    public final void updateMute(@NotNull PlayerProfile target, @NotNull String reason, @NotNull String duration) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(duration, "duration");
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "admin/mutedPlayers.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        Map<UUID, List<String>> map = mutedPlayers_yml.Companion.getMutedPlayer();
        UUID uUID = target.getId();
        Intrinsics.checkNotNull(uUID);
        UUID uUID2 = uUID;
        Object object = new String[]{reason, duration};
        object = CollectionsKt.listOf(object);
        map.put(uUID2, (List<String>)object);
        ymlFile.set(target.getId() + ".reason", (Object)reason);
        ymlFile.set(target.getId() + ".duration", (Object)duration);
        ymlFile.save(file);
    }

    public static /* synthetic */ void updateMute$default(MuteHandler muteHandler, PlayerProfile playerProfile, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "null";
        }
        if ((n & 4) != 0) {
            string2 = "null";
        }
        muteHandler.updateMute(playerProfile, string, string2);
    }
}

