/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.admin.moderation.handler;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.ban.BanListType;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.internalAPI.Vars;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lyv/tils/smp/mods/admin/moderation/handler/UnbanHandler;", "", "<init>", "()V", "unbanPlayer", "", "targets", "", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "sender", "Lorg/bukkit/command/CommandSender;", "silent", "", "YVtils-SMP_paper"})
public final class UnbanHandler {
    public final void unbanPlayer(@NotNull List<? extends PlayerProfile> targets, @NotNull CommandSender sender, boolean silent) {
        Intrinsics.checkNotNullParameter(targets, "targets");
        Intrinsics.checkNotNullParameter(sender, "sender");
        for (PlayerProfile playerProfile : targets) {
            try {
                OfflinePlayer offlinePlayer;
                if (playerProfile.getId() == null) {
                    sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to unban the player."));
                    return;
                }
                UUID uUID = playerProfile.getId();
                Intrinsics.checkNotNull(uUID);
                Intrinsics.checkNotNullExpressionValue(Bukkit.getOfflinePlayer((UUID)uUID), "getOfflinePlayer(...)");
                if (!offlinePlayer.isBanned()) {
                    sender.sendMessage(new Language().getMessage(sender, LangStrings.MOD_PLAYER_NOT_BANNED));
                    return;
                }
                Date date = new Date();
                date.setTime(0L);
                ((ProfileBanList)Bukkit.getBanList((BanListType)BanListType.PROFILE)).addBan(playerProfile, null, date, sender.getName());
                if (silent) continue;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("yvtils.smp.command.moderation.announcement")) continue;
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID2 = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
                    Component component = language.getMessage(uUID2, LangStrings.MOD_ANNOUNCEMENT_UNBAN);
                    String[] stringArray = new String[]{"prefix", "player", "moderator"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[3];
                    stringArray[0] = new Vars().getPrefix();
                    String string = playerProfile.getName();
                    if (string == null) {
                        string = "null";
                    }
                    stringArray[1] = string;
                    Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                    player.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
                }
                ConsoleCommandSender consoleCommandSender = YVtils.Companion.getInstance().getServer().getConsoleSender();
                Placeholder placeholder = new Placeholder();
                Component component = new Language().getMessage(LangStrings.MOD_ANNOUNCEMENT_UNBAN);
                String[] stringArray = new String[]{"prefix", "player", "moderator"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[3];
                stringArray[0] = new Vars().getPrefix();
                String string = playerProfile.getName();
                if (string == null) {
                    string = "null";
                }
                stringArray[1] = string;
                Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                consoleCommandSender.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
            }
            catch (Exception exception) {
                sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to unban the player."));
            }
        }
    }

    public static /* synthetic */ void unbanPlayer$default(UnbanHandler unbanHandler, List list, CommandSender commandSender, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        unbanHandler.unbanPlayer(list, commandSender, bl);
    }
}

