/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.admin.moderation.handler;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.admin.moderation.handler.MuteHandler;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.admin.mutedPlayers_yml;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.internalAPI.Vars;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lyv/tils/smp/mods/admin/moderation/handler/UnmuteHandler;", "", "<init>", "()V", "unmutePlayer", "", "targets", "", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "sender", "Lorg/bukkit/command/CommandSender;", "silent", "", "removeMute", "target", "YVtils-SMP_paper"})
public final class UnmuteHandler {
    public final void unmutePlayer(@NotNull List<? extends PlayerProfile> targets, @NotNull CommandSender sender, boolean silent) {
        Intrinsics.checkNotNullParameter(targets, "targets");
        Intrinsics.checkNotNullParameter(sender, "sender");
        for (PlayerProfile playerProfile : targets) {
            try {
                OfflinePlayer offlinePlayer;
                String[] stringArray;
                if (playerProfile.getId() == null) {
                    sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to unmute the player."));
                    return;
                }
                UUID uUID = playerProfile.getId();
                Intrinsics.checkNotNull(uUID);
                Intrinsics.checkNotNullExpressionValue(Bukkit.getOfflinePlayer((UUID)uUID), "getOfflinePlayer(...)");
                if (!new MuteHandler().checkMute(playerProfile)) {
                    Placeholder placeholder = new Placeholder();
                    Component component = new Language().getMessage(sender, LangStrings.MOD_PLAYER_NOT_MUTED);
                    stringArray = new String[]{"prefix", "player"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[2];
                    stringArray[0] = new Vars().getPrefix();
                    String string = playerProfile.getName();
                    if (string == null) {
                        string = "null";
                    }
                    stringArray[1] = string;
                    sender.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
                    return;
                }
                this.removeMute(playerProfile);
                if (offlinePlayer.isOnline()) {
                    Player player = offlinePlayer.getPlayer();
                    if (player != null) {
                        Placeholder placeholder = new Placeholder();
                        Language language = new Language();
                        UUID uUID2 = playerProfile.getId();
                        Intrinsics.checkNotNull(uUID2);
                        player.sendMessage(placeholder.replacer(language.getMessage(uUID2, LangStrings.PLAYER_GOT_UNMUTED), CollectionsKt.listOf("prefix"), CollectionsKt.listOf(new Vars().getPrefix())));
                    }
                }
                if (silent) continue;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("yvtils.smp.command.moderation.announcement")) continue;
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID3 = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
                    Component component = language.getMessage(uUID3, LangStrings.MOD_ANNOUNCEMENT_UNMUTE);
                    String[] stringArray2 = new String[]{"prefix", "player", "moderator"};
                    List<String> list = CollectionsKt.listOf(stringArray2);
                    stringArray2 = new String[3];
                    stringArray2[0] = new Vars().getPrefix();
                    String string = playerProfile.getName();
                    if (string == null) {
                        string = "null";
                    }
                    stringArray2[1] = string;
                    Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                    player.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray2)));
                }
                ConsoleCommandSender consoleCommandSender = YVtils.Companion.getInstance().getServer().getConsoleSender();
                Placeholder placeholder = new Placeholder();
                Component component = new Language().getMessage(LangStrings.MOD_ANNOUNCEMENT_UNMUTE);
                stringArray = new String[]{"prefix", "player", "moderator"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[3];
                stringArray[0] = new Vars().getPrefix();
                String string = playerProfile.getName();
                if (string == null) {
                    string = "null";
                }
                stringArray[1] = string;
                Intrinsics.checkNotNullExpressionValue(sender.getName(), "getName(...)");
                consoleCommandSender.sendMessage(placeholder.replacer(component, list, CollectionsKt.listOf(stringArray)));
            }
            catch (Exception exception) {
                sender.sendMessage(new ColorUtils().convert("<red>An error occurred while trying to unmute the player."));
            }
        }
    }

    public static /* synthetic */ void unmutePlayer$default(UnmuteHandler unmuteHandler, List list, CommandSender commandSender, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        unmuteHandler.unmutePlayer(list, commandSender, bl);
    }

    private final void removeMute(PlayerProfile target) {
        Map<UUID, List<String>> map = mutedPlayers_yml.Companion.getMutedPlayer();
        UUID uUID = target.getId();
        TypeIntrinsics.asMutableMap(map).remove(uUID);
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "admin/mutedPlayers.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        ymlFile.set(String.valueOf(target.getId()), null);
        ymlFile.save(file);
    }
}

