/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.admin.vanish.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.mods.admin.vanish.Vanish;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.inventory.GUIFiller;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lyv/tils/smp/mods/admin/vanish/gui/VBuilder;", "", "<init>", "()V", "openGUI", "", "sender", "Lorg/bukkit/entity/Player;", "target", "buildGUI", "Lorg/bukkit/inventory/Inventory;", "vData", "Lyv/tils/smp/mods/admin/vanish/Vanish$VanishedPlayer;", "toggleSetting", "", "", "Lorg/bukkit/inventory/ItemStack;", "layerSetting", "itemPickupSetting", "invInteractionSetting", "mobTargetSetting", "toggleItem", "state", "", "YVtils-SMP_paper"})
public final class VBuilder {
    public final void openGUI(@NotNull Player sender, @NotNull Player target) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(target, "target");
        Vanish.VanishedPlayer vanishedPlayer = Vanish.Companion.getVanish().get(target.getUniqueId());
        Intrinsics.checkNotNull(vanishedPlayer);
        Inventory inv = this.buildGUI(vanishedPlayer, sender);
        sender.openInventory(inv);
    }

    private final Inventory buildGUI(Vanish.VanishedPlayer vData, Player sender) {
        Map guiMap = new LinkedHashMap();
        guiMap.putAll(this.toggleSetting(vData, sender));
        guiMap.putAll(this.layerSetting(vData, sender));
        guiMap.putAll(this.itemPickupSetting(vData, sender));
        guiMap.putAll(this.invInteractionSetting(vData, sender));
        guiMap.putAll(this.mobTargetSetting(vData, sender));
        Inventory inventory = Bukkit.createInventory((InventoryHolder)((InventoryHolder)sender), (int)36, (Component)new ColorUtils().convert("<#6D8896>Vanish"));
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inv = inventory;
        for (Map.Entry entry : guiMap.entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = (ItemStack)entry.getValue();
            inv.setItem(slot, item);
        }
        inv = GUIFiller.fillInventory$default(new GUIFiller(), inv, null, null, 6, null);
        return inv;
    }

    @NotNull
    public final Map<Integer, ItemStack> toggleSetting(@NotNull Vanish.VanishedPlayer vData, @NotNull Player sender) {
        Intrinsics.checkNotNullParameter(vData, "vData");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Map items = new LinkedHashMap();
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ItemStack vanish = new ItemStack(Material.POTION);
        ItemMeta itemMeta = vanish.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.PotionMeta");
        PotionMeta vanishMeta = (PotionMeta)itemMeta;
        List vanishLore = new ArrayList();
        vanishMeta.displayName(new ColorUtils().convert("<#96C8FF>Vanish"));
        vanishMeta.setColor(Color.fromRGB((int)246, (int)246, (int)246));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        vanishMeta.addItemFlags(itemFlagArray);
        vanishLore.addAll((Collection)new ColorUtils().handleLore(new Language().getMessage(uuid, LangStrings.MODULE_VANISH_VANISH_LORE)));
        vanishMeta.lore(vanishLore);
        vanish.setItemMeta((ItemMeta)vanishMeta);
        items.put(10, vanish);
        items.put(19, this.toggleItem(sender, vData.getVanish()));
        return items;
    }

    @NotNull
    public final Map<Integer, ItemStack> layerSetting(@NotNull Vanish.VanishedPlayer vData, @NotNull Player sender) {
        Intrinsics.checkNotNullParameter(vData, "vData");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Map items = new LinkedHashMap();
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        int currentLayer = vData.getLayer();
        ItemStack layer = new ItemStack(Material.FILLED_MAP);
        ItemMeta layerMeta = layer.getItemMeta();
        List layerLore = new ArrayList();
        layerMeta.displayName(new ColorUtils().convert("<#96C8FF>Layer"));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        layerMeta.addItemFlags(itemFlagArray);
        layerLore.addAll((Collection)new ColorUtils().handleLore(new Language().getMessage(uuid, LangStrings.MODULE_VANISH_LAYER_LORE)));
        layerMeta.lore(layerLore);
        layer.setItemMeta(layerMeta);
        layer.setAmount(currentLayer);
        items.put(12, layer);
        items.put(21, this.toggleItem(sender, vData.getLayer() != 4));
        return items;
    }

    @NotNull
    public final Map<Integer, ItemStack> itemPickupSetting(@NotNull Vanish.VanishedPlayer vData, @NotNull Player sender) {
        Intrinsics.checkNotNullParameter(vData, "vData");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Map items = new LinkedHashMap();
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ItemStack itemPickup = new ItemStack(Material.HOPPER);
        ItemMeta itemPickupMeta = itemPickup.getItemMeta();
        List itemPickupLore = new ArrayList();
        itemPickupMeta.displayName(new ColorUtils().convert("<#96C8FF>Item Pickup"));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        itemPickupMeta.addItemFlags(itemFlagArray);
        itemPickupLore.addAll((Collection)new ColorUtils().handleLore(new Language().getMessage(uuid, LangStrings.MODULE_VANISH_ITEM_PICKUP_LORE)));
        itemPickupMeta.lore(itemPickupLore);
        itemPickup.setItemMeta(itemPickupMeta);
        items.put(14, itemPickup);
        items.put(23, this.toggleItem(sender, vData.getItemPickup()));
        return items;
    }

    @NotNull
    public final Map<Integer, ItemStack> invInteractionSetting(@NotNull Vanish.VanishedPlayer vData, @NotNull Player sender) {
        Intrinsics.checkNotNullParameter(vData, "vData");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Map items = new LinkedHashMap();
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ItemStack invInteraction = new ItemStack(Material.LIGHT_GRAY_SHULKER_BOX);
        ItemMeta invInteractionMeta = invInteraction.getItemMeta();
        List invInteractionLore = new ArrayList();
        invInteractionMeta.displayName(new ColorUtils().convert("<#96C8FF>Silent Inventory Interaction"));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        invInteractionMeta.addItemFlags(itemFlagArray);
        invInteractionLore.addAll((Collection)new ColorUtils().handleLore(new Language().getMessage(uuid, LangStrings.MODULE_VANISH_INV_INTERACTION_LORE)));
        invInteractionMeta.lore(invInteractionLore);
        invInteraction.setItemMeta(invInteractionMeta);
        items.put(15, invInteraction);
        items.put(24, this.toggleItem(sender, vData.getInvInteraction()));
        return items;
    }

    @NotNull
    public final Map<Integer, ItemStack> mobTargetSetting(@NotNull Vanish.VanishedPlayer vData, @NotNull Player sender) {
        Intrinsics.checkNotNullParameter(vData, "vData");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Map items = new LinkedHashMap();
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ItemStack mobTarget = new ItemStack(Material.SPAWNER);
        ItemMeta mobTargetMeta = mobTarget.getItemMeta();
        List mobTargetLore = new ArrayList();
        mobTargetMeta.displayName(new ColorUtils().convert("<#96C8FF>Anti Mob Target"));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        mobTargetMeta.addItemFlags(itemFlagArray);
        mobTargetLore.addAll((Collection)new ColorUtils().handleLore(new Language().getMessage(uuid, LangStrings.MODULE_VANISH_MOB_TARGET_LORE)));
        mobTargetMeta.lore(mobTargetLore);
        mobTarget.setItemMeta(mobTargetMeta);
        items.put(16, mobTarget);
        items.put(25, this.toggleItem(sender, vData.getMobTarget()));
        return items;
    }

    private final ItemStack toggleItem(Player sender, boolean state) {
        String string;
        ItemStack toggle = new ItemStack(state ? Material.LIME_DYE : Material.RED_DYE);
        ItemMeta toggleMeta = toggle.getItemMeta();
        ColorUtils colorUtils = new ColorUtils();
        if (state) {
            Language language = new Language();
            UUID uUID = sender.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            string = "<#96C8FF>[" + language.getRawMessage(uUID, LangStrings.ENABLED) + "]";
        } else {
            Language language = new Language();
            UUID uUID = sender.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            string = "<#96C8FF>[" + language.getRawMessage(uUID, LangStrings.DISABLED);
        }
        toggleMeta.displayName(colorUtils.convert(string));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        toggleMeta.addItemFlags(itemFlagArray);
        toggle.setItemMeta(toggleMeta);
        return toggle;
    }
}

