/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.discord;

import java.time.Duration;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.discord.commandManager.CMDHandler;
import yv.tils.smp.mods.discord.commandManager.CMDRegister;
import yv.tils.smp.mods.discord.sync.chatSync.SyncChats;
import yv.tils.smp.mods.discord.sync.consoleSync.GetConsole;
import yv.tils.smp.mods.discord.sync.consoleSync.SendCMD;
import yv.tils.smp.mods.discord.sync.stats.CollectStats;
import yv.tils.smp.mods.discord.sync.stats.StatsChannel;
import yv.tils.smp.mods.discord.sync.stats.StatsDescription;
import yv.tils.smp.mods.discord.whitelist.ForceRemove;
import yv.tils.smp.mods.discord.whitelist.SelfAdd;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.discord.DiscordConfig;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.logger.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lyv/tils/smp/mods/discord/BotManager;", "", "<init>", "()V", "token", "", "mainGuild", "status", "activity", "activityMessage", "logChannel", "startBot", "", "checkToken", "", "appearance", "stopBot", "Companion", "YVtils-SMP_paper"})
public final class BotManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    @NotNull
    private final String mainGuild;
    @NotNull
    private final String status;
    @NotNull
    private final String activity;
    @NotNull
    private final String activityMessage;
    @NotNull
    private final String logChannel;
    private static boolean active;
    public static BotManager instance;
    public static JDA jda;
    public static JDABuilder builder;

    public BotManager() {
        Object object = DiscordConfig.Companion.getConfig().get("botToken");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        this.token = (String)object;
        this.mainGuild = new DiscordConfig().readChannelID("mainGuild");
        Object object2 = DiscordConfig.Companion.getConfig().get("botSettings.onlineStatus");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.String");
        this.status = (String)object2;
        Object object3 = DiscordConfig.Companion.getConfig().get("botSettings.activity");
        Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.String");
        this.activity = (String)object3;
        Object object4 = DiscordConfig.Companion.getConfig().get("botSettings.activityMessage");
        Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.String");
        this.activityMessage = (String)object4;
        this.logChannel = new DiscordConfig().readChannelID("logChannel");
    }

    public final void startBot() {
        if (active && this.checkToken()) {
            Companion.setInstance(this);
            this.appearance();
        }
    }

    private final boolean checkToken() {
        if (!(((CharSequence)this.token).length() == 0 || StringsKt.isBlank(this.token) || Intrinsics.areEqual(this.token, new ColorUtils().convert(new Language().directFormat("YOUR TOKEN HERE", "DEINEN BOT TOKEN"))))) {
            JDABuilder jDABuilder = JDABuilder.createDefault(this.token);
            Intrinsics.checkNotNullExpressionValue(jDABuilder, "createDefault(...)");
            Companion.setBuilder(jDABuilder);
            return true;
        }
        YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().getMessage(LangStrings.MODULE_DISCORD_NO_BOT_TOKEN_GIVEN));
        YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().getMessage(LangStrings.MODULE_DISCORD_STARTUP_FAILED));
        active = false;
        return false;
    }

    private final void appearance() {
        Companion.getBuilder().enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]);
        Companion.getBuilder().enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[0]);
        Companion.getBuilder().setMemberCachePolicy(MemberCachePolicy.ALL);
        Object[] objectArray = this.activity.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(objectArray, "toLowerCase(...)");
        switch (objectArray) {
            case "playing": {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(Activity.playing(this.activityMessage));
                break;
            }
            case "listening": {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(Activity.listening(this.activityMessage));
                break;
            }
            case "watching": {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(Activity.watching(this.activityMessage));
                break;
            }
            case "competing": {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(Activity.competing(this.activityMessage));
                break;
            }
            case "custom": {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(Activity.customStatus(this.activityMessage));
                break;
            }
            default: {
                JDABuilder jDABuilder = Companion.getBuilder().setActivity(null);
            }
        }
        String string = this.status.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "online": {
                JDABuilder jDABuilder = Companion.getBuilder().setStatus(OnlineStatus.ONLINE);
                break;
            }
            case "idle": {
                JDABuilder jDABuilder = Companion.getBuilder().setStatus(OnlineStatus.IDLE);
                break;
            }
            case "dnd": {
                JDABuilder jDABuilder = Companion.getBuilder().setStatus(OnlineStatus.DO_NOT_DISTURB);
                break;
            }
            case "invisible": {
                JDABuilder jDABuilder = Companion.getBuilder().setStatus(OnlineStatus.INVISIBLE);
                break;
            }
            default: {
                JDABuilder jDABuilder = Companion.getBuilder().setStatus(OnlineStatus.ONLINE);
            }
        }
        Object[] objectArray2 = new Object[]{new CMDRegister()};
        Companion.getBuilder().addEventListeners(objectArray2);
        objectArray2 = new Object[]{new CMDHandler()};
        Companion.getBuilder().addEventListeners(objectArray2);
        objectArray2 = new Object[]{new ForceRemove()};
        Companion.getBuilder().addEventListeners(objectArray2);
        objectArray2 = new Object[]{new SelfAdd()};
        Companion.getBuilder().addEventListeners(objectArray2);
        objectArray2 = new Object[]{new SyncChats()};
        Companion.getBuilder().addEventListeners(objectArray2);
        objectArray2 = new Object[]{new SendCMD()};
        Companion.getBuilder().addEventListeners(objectArray2);
        try {
            JDA jDA = Companion.getBuilder().build();
            Intrinsics.checkNotNullExpressionValue(jDA, "build(...)");
            Companion.setJda(jDA);
        }
        catch (Exception e) {
            YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().getMessage(LangStrings.MODULE_DISCORD_STARTUP_FAILED));
            e.printStackTrace();
        }
        try {
            JDA e = Companion.getJda().awaitReady();
            Intrinsics.checkNotNull(e);
        }
        catch (Exception e) {
            YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().getMessage(LangStrings.MODULE_DISCORD_STARTUP_FAILED));
            e.printStackTrace();
        }
        GetConsole appender = new GetConsole();
        BotManager botManager = this;
        try {
            BotManager $this$appearance_u24lambda_u240 = botManager;
            boolean bl = false;
            Logger logger = LogManager.getRootLogger();
            Intrinsics.checkNotNull(logger, "null cannot be cast to non-null type org.apache.logging.log4j.core.Logger");
            org.apache.logging.log4j.core.Logger logger2 = (org.apache.logging.log4j.core.Logger)logger;
            logger2.addAppender((Appender)appender);
            Object object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        appender.syncTask();
        new CollectStats().collect();
        YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().getMessage(LangStrings.MODULE_DISCORD_STARTUP_FINISHED));
    }

    public final void stopBot() {
        if (active) {
            try {
                new StatsChannel().deleteChannels();
                new StatsDescription().serverShutdown();
                GetConsole.Companion.setActive(false);
                new GetConsole().stop();
                try {
                    Companion.getBuilder().setStatus(OnlineStatus.OFFLINE);
                    Companion.getJda().shutdown();
                    if (!Companion.getJda().awaitShutdown(Duration.ofSeconds(10L))) {
                        Companion.getJda().shutdownNow();
                        Companion.getJda().awaitShutdown();
                    }
                }
                catch (Exception e) {
                    YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().directFormat("There was an error while shutting down the bot, for more details enable debug in the config.yml file!", "Es gab einen Fehler beim Herunterfahren des Bots, um weitere Details zu erhalten, aktiviere das Debuggen in der config.yml-Datei"));
                    String message = String.valueOf(e.getMessage());
                    new Debugger().log("Bot shutting down failed!", message, "yv.tils.smp.mods.discord.BotManager.stopBot()");
                }
            }
            catch (UninitializedPropertyAccessException e) {
                YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().directFormat("There was an error while shutting down the bot, for more details enable debug in the config.yml file!", "Es gab einen Fehler beim Herunterfahren des Bots, um weitere Details zu erhalten, aktiviere das Debuggen in der config.yml-Datei"));
                String message = String.valueOf(e.getMessage());
                new Debugger().log("Bot shutting down failed!", message, "yv.tils.smp.mods.discord.BotManager.stopBot()");
            }
        }
    }

    static {
        Object object = Config.Companion.getConfig().get("modules.discord");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        active = (Boolean)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lyv/tils/smp/mods/discord/BotManager$Companion;", "", "<init>", "()V", "active", "", "getActive", "()Z", "setActive", "(Z)V", "instance", "Lyv/tils/smp/mods/discord/BotManager;", "getInstance", "()Lyv/tils/smp/mods/discord/BotManager;", "setInstance", "(Lyv/tils/smp/mods/discord/BotManager;)V", "jda", "Lnet/dv8tion/jda/api/JDA;", "getJda", "()Lnet/dv8tion/jda/api/JDA;", "setJda", "(Lnet/dv8tion/jda/api/JDA;)V", "builder", "Lnet/dv8tion/jda/api/JDABuilder;", "getBuilder", "()Lnet/dv8tion/jda/api/JDABuilder;", "setBuilder", "(Lnet/dv8tion/jda/api/JDABuilder;)V", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getActive() {
            return active;
        }

        public final void setActive(boolean bl) {
            active = bl;
        }

        @NotNull
        public final BotManager getInstance() {
            BotManager botManager = instance;
            if (botManager != null) {
                return botManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final void setInstance(@NotNull BotManager botManager) {
            Intrinsics.checkNotNullParameter(botManager, "<set-?>");
            instance = botManager;
        }

        @NotNull
        public final JDA getJda() {
            JDA jDA = jda;
            if (jDA != null) {
                return jDA;
            }
            Intrinsics.throwUninitializedPropertyAccessException("jda");
            return null;
        }

        public final void setJda(@NotNull JDA jDA) {
            Intrinsics.checkNotNullParameter(jDA, "<set-?>");
            jda = jDA;
        }

        @NotNull
        public final JDABuilder getBuilder() {
            JDABuilder jDABuilder = builder;
            if (jDABuilder != null) {
                return jDABuilder;
            }
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            return null;
        }

        public final void setBuilder(@NotNull JDABuilder jDABuilder) {
            Intrinsics.checkNotNullParameter(jDABuilder, "<set-?>");
            builder = jDABuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

