/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.discord.embedManager.whitelist.discord;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.interactions.components.selections.StringSelectMenu;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.mods.discord.embedManager.EmbedVars;
import yv.tils.smp.mods.discord.whitelist.ImportWhitelist;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\nJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lyv/tils/smp/mods/discord/embedManager/whitelist/discord/ForceRemove;", "", "<init>", "()V", "builder", "Lnet/dv8tion/jda/api/EmbedBuilder;", "getBuilder", "()Lnet/dv8tion/jda/api/EmbedBuilder;", "embed", "playerCount", "", "whitelist", "", "site", "embedRemove", "acc", "", "", "makeDropDown", "Lnet/dv8tion/jda/api/interactions/components/selections/StringSelectMenu$Builder;", "makeButtons", "Lnet/dv8tion/jda/api/interactions/components/buttons/Button;", "YVtils-SMP_paper"})
public final class ForceRemove {
    @NotNull
    private final EmbedBuilder builder = new EmbedBuilder();

    @NotNull
    public final EmbedBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final EmbedBuilder embed(int playerCount, boolean whitelist, int site) {
        String status = whitelist ? "on" : "off";
        int maxSite = (playerCount - 1) / 25 + 1;
        EmbedBuilder embedBuilder = this.builder.setTitle(new ColorUtils().convert(new Language().getMessage(LangStrings.EMBED_CMD_WHITELIST_REMOVE_TITLE))).setDescription(new ColorUtils().convert(new Language().getMessage(LangStrings.EMBED_CMD_WHITELIST_REMOVE_DESC))).addField("Whitelisted Players:", String.valueOf(playerCount), true).addField("Whitelist Status:", status, true).setColor(EmbedVars.Companion.getInfoColor()).setFooter("YVtils-SMP \u2022 Site " + site + " / " + maxSite, EmbedVars.Companion.getFooterIcon()).setAuthor(EmbedVars.Companion.getAuthorName(), EmbedVars.Companion.getAuthorLink(), EmbedVars.Companion.getAuthorIcon());
        Intrinsics.checkNotNullExpressionValue(embedBuilder, "setAuthor(...)");
        return embedBuilder;
    }

    @NotNull
    public final EmbedBuilder embedRemove(int playerCount, boolean whitelist, int site, @NotNull List<String> acc) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        String status = whitelist ? "on" : "off";
        int maxSite = (playerCount - 1) / 25 + 1;
        List list = new ArrayList();
        list.add(acc.get(1));
        CharSequence charSequence = acc.get(0);
        boolean bl = new Regex("\\d+").matches(charSequence) ? list.add("<@" + acc.get(0) + ">") : list.add(acc.get(0));
        String[] stringArray = new String[]{"mcName", "dcName"};
        EmbedBuilder embedBuilder = this.builder.setTitle(new ColorUtils().convert(new Placeholder().replacer(new Language().getMessage(LangStrings.EMBED_CMD_WHITELIST_REMOVED_TITLE), CollectionsKt.listOf(stringArray), list))).setDescription(new ColorUtils().convert(new Language().getMessage(LangStrings.EMBED_CMD_WHITELIST_REMOVED_DESC))).addField("Whitelisted Players:", String.valueOf(playerCount), true).addField("Whitelist Status:", status, true).setColor(EmbedVars.Companion.getInfoColor()).setFooter("YVtils-SMP \u2022 Site " + site + " / " + maxSite, EmbedVars.Companion.getFooterIcon()).setAuthor(EmbedVars.Companion.getAuthorName(), EmbedVars.Companion.getAuthorLink(), EmbedVars.Companion.getAuthorIcon());
        Intrinsics.checkNotNullExpressionValue(embedBuilder, "setAuthor(...)");
        return embedBuilder;
    }

    @NotNull
    public final StringSelectMenu.Builder makeDropDown(int site) {
        int start;
        List<String> list = ImportWhitelist.Companion.getWhitelistManager();
        if (list.isEmpty()) {
            StringSelectMenu.Builder builder = ((StringSelectMenu.Builder)((StringSelectMenu.Builder)StringSelectMenu.create("players").setPlaceholder(new ColorUtils().convert(new Language().getMessage(LangStrings.WHITELIST_EMPTY)))).setDisabled(true)).addOption("null", "null");
            Intrinsics.checkNotNullExpressionValue(builder, "addOption(...)");
            return builder;
        }
        List options = new ArrayList();
        int n = list.size();
        for (int i = start = (site - 1) * 25; i < n; ++i) {
            SelectOption selectOption = SelectOption.of(list.get(i), list.get(i));
            Intrinsics.checkNotNullExpressionValue(selectOption, "of(...)");
            options.add(selectOption);
            if (i >= start + 24) break;
        }
        StringSelectMenu.Builder builder = ((StringSelectMenu.Builder)StringSelectMenu.create("players").setPlaceholder("Discord Tag,Minecraft Name,UUID")).addOptions(options);
        Intrinsics.checkNotNullExpressionValue(builder, "addOptions(...)");
        return builder;
    }

    @NotNull
    public final List<Button> makeButtons(int playerCount, int site) {
        int maxSite = (playerCount - 1) / 25 + 1;
        List buttons = new ArrayList();
        if (maxSite == 1) {
            Button button = Button.danger("whitelist_remove_prev", "\u00ab").asDisabled();
            Intrinsics.checkNotNullExpressionValue(button, "asDisabled(...)");
            buttons.add(button);
            Button button2 = Button.success("whitelist_remove_next", "\u00bb").asDisabled();
            Intrinsics.checkNotNullExpressionValue(button2, "asDisabled(...)");
            v2 = buttons.add(button2);
        } else if (site == maxSite) {
            Button button = Button.danger("whitelist_remove_prev", "\u00ab");
            Intrinsics.checkNotNullExpressionValue(button, "danger(...)");
            buttons.add(button);
            Button button3 = Button.success("whitelist_remove_next", "\u00bb").asDisabled();
            Intrinsics.checkNotNullExpressionValue(button3, "asDisabled(...)");
            v2 = buttons.add(button3);
        } else if (site == 1) {
            Button button = Button.danger("whitelist_remove_prev", "\u00ab").asDisabled();
            Intrinsics.checkNotNullExpressionValue(button, "asDisabled(...)");
            buttons.add(button);
            Button button4 = Button.success("whitelist_remove_next", "\u00bb");
            Intrinsics.checkNotNullExpressionValue(button4, "success(...)");
            v2 = buttons.add(button4);
        } else {
            Button button = Button.danger("whitelist_remove_prev", "\u00ab");
            Intrinsics.checkNotNullExpressionValue(button, "danger(...)");
            buttons.add(button);
            Button button5 = Button.success("whitelist_remove_next", "\u00bb");
            Intrinsics.checkNotNullExpressionValue(button5, "success(...)");
            v2 = buttons.add(button5);
        }
        return buttons;
    }
}

