/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.discord.sync.chatSync;

import io.papermc.paper.event.player.AsyncChatEvent;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.discord.BotManager;
import yv.tils.smp.mods.discord.sync.chatSync.Embed;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.discord.DiscordConfig;
import yv.tils.smp.utils.configs.language.Language;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lyv/tils/smp/mods/discord/sync/chatSync/SyncChats;", "Lnet/dv8tion/jda/api/hooks/ListenerAdapter;", "<init>", "()V", "minecraftToDiscord", "", "e", "Lio/papermc/paper/event/player/AsyncChatEvent;", "sendDiscordMessage", "sender", "Lorg/bukkit/entity/Player;", "message", "", "discordToMinecraft", "Lnet/dv8tion/jda/api/events/message/MessageReceivedEvent;", "onMessageReceived", "Companion", "YVtils-SMP_paper"})
public final class SyncChats
extends ListenerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean active;
    @NotNull
    private static final String channelID;
    @NotNull
    private static final String minecraftPermission;
    @NotNull
    private static final String discordPermission;

    public final void minecraftToDiscord(@NotNull AsyncChatEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Component component = e.originalMessage();
        Intrinsics.checkNotNullExpressionValue(component, "originalMessage(...)");
        Component message = component;
        if (!active) {
            return;
        }
        if (!e.getPlayer().hasPermission(minecraftPermission)) {
            return;
        }
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.sendDiscordMessage(player, new ColorUtils().stripChatMessage(message));
    }

    private final void sendDiscordMessage(Player sender, String message) {
        try {
            try {
                TextChannel textChannel = BotManager.Companion.getJda().getTextChannelById(channelID);
                if (textChannel == null) {
                    return;
                }
                TextChannel channel = textChannel;
                channel.sendMessageEmbeds(new Embed().embed(sender, message).build(), new MessageEmbed[0]).queue();
            }
            catch (NumberFormatException numberFormatException) {
                YVtils.Companion.getInstance().getServer().getConsoleSender().sendMessage(new Language().directFormat("Invalid channel ID: '" + channelID + "'! Make sure to put a valid channel ID in the config file or disable this feature! (plugins/YVtils-SMP/discord/config.yml/chatSync)", "Ung\u00fcltige Kanal ID: '" + channelID + "'! Kontrolliere das eine g\u00fcltige Kanal ID in der Config steht oder deaktiviere dieses Feature! (plugins/YVtils-SMP/discord/config.yml/chatSync)"));
                active = false;
            }
        }
        catch (UninitializedPropertyAccessException uninitializedPropertyAccessException) {
            active = false;
        }
    }

    private final void discordToMinecraft(MessageReceivedEvent e) {
        String message;
        String author;
        block6: {
            String string = e.getAuthor().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            author = string;
            String string2 = e.getMessage().getContentDisplay();
            Intrinsics.checkNotNullExpressionValue(string2, "getContentDisplay(...)");
            message = string2;
            if (!active) {
                return;
            }
            if (e.getAuthor().isBot()) {
                return;
            }
            if (!Intrinsics.areEqual(e.getChannel().getId(), channelID)) {
                return;
            }
            try {
                Member member = e.getMember();
                Intrinsics.checkNotNull(member);
                Permission[] permissionArray = new Permission[]{Permission.valueOf(discordPermission)};
                if (!member.hasPermission(permissionArray)) {
                    return;
                }
            }
            catch (Exception exception) {
                Member member = e.getMember();
                Intrinsics.checkNotNull(member);
                Permission[] permissionArray = new Permission[]{Permission.MESSAGE_SEND};
                if (member.hasPermission(permissionArray)) break block6;
                return;
            }
        }
        YVtils.Companion.getInstance().getServer().broadcast(new ColorUtils().convert("<gray>[<#7289da>DISCORD<gray>]<white> " + author + "<gray>:<white> " + message));
    }

    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.discordToMinecraft(e);
    }

    static {
        Object object = DiscordConfig.Companion.getConfig().get("chatSync.enabled");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        active = (Boolean)object;
        channelID = new DiscordConfig().readChannelID("chatSync.channel");
        minecraftPermission = "yvtils.smp.chatSync";
        Object object2 = DiscordConfig.Companion.getConfig().get("chatSync.permission");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.String");
        discordPermission = (String)object2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lyv/tils/smp/mods/discord/sync/chatSync/SyncChats$Companion;", "", "<init>", "()V", "active", "", "getActive", "()Z", "setActive", "(Z)V", "channelID", "", "getChannelID", "()Ljava/lang/String;", "minecraftPermission", "getMinecraftPermission", "discordPermission", "getDiscordPermission", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getActive() {
            return active;
        }

        public final void setActive(boolean bl) {
            active = bl;
        }

        @NotNull
        public final String getChannelID() {
            return channelID;
        }

        @NotNull
        public final String getMinecraftPermission() {
            return minecraftPermission;
        }

        @NotNull
        public final String getDiscordPermission() {
            return discordPermission;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

