/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.fusionCrafting;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.fusionCrafting.FusionKeys;
import yv.tils.smp.mods.fusionCrafting.fusions.invisItemFrames.InvisItemFrame;
import yv.tils.smp.mods.fusionCrafting.fusions.lightBlock.LightBlock;
import yv.tils.smp.mods.fusionCrafting.fusions.playerHeads.PlayerHeads;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.logger.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lyv/tils/smp/mods/fusionCrafting/FusionLoader;", "", "<init>", "()V", "generateDefaultFusions", "", "loadFusionThumbnail", "loadFusion", "", "", "fusion", "Companion", "YVtils-SMP_paper"})
public final class FusionLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, ItemStack> fusionThumbnails = new LinkedHashMap();
    @NotNull
    private static final Map<Component, String> component2name = new LinkedHashMap();
    @NotNull
    private static final Map<String, List<String>> tagMap = new LinkedHashMap();
    @NotNull
    private static final List<String> disabledFusions = new ArrayList();

    public final void generateDefaultFusions() {
        File playerHeadsFile;
        File invisItemFrameFile;
        File lightBlockFile;
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(lightBlockFile = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/lightBlock.yml")).exists()) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)lightBlockFile);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration lightBlockYML = yamlConfiguration;
            new LightBlock().configFile(lightBlockYML);
            lightBlockYML.save(lightBlockFile);
            new Debugger().log("Generated default fusion", "Generated default fusion: lightBlock", "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        }
        if (!(invisItemFrameFile = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/invisItemFrame.yml")).exists()) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)invisItemFrameFile);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration invisItemFrameYML = yamlConfiguration;
            new InvisItemFrame().configFile(invisItemFrameYML);
            invisItemFrameYML.save(invisItemFrameFile);
            new Debugger().log("Generated default fusion", "Generated default fusion: invisItemFrame", "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        }
        if (!(playerHeadsFile = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/playerHeads.yml")).exists()) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)playerHeadsFile);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration playerHeadsYML = yamlConfiguration;
            new PlayerHeads().configFile(playerHeadsYML);
            playerHeadsYML.save(playerHeadsFile);
            new Debugger().log("Generated default fusion", "Generated default fusion: playerHeads", "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        }
    }

    public final void loadFusionThumbnail() {
        disabledFusions.clear();
        fusionThumbnails.clear();
        component2name.clear();
        tagMap.clear();
        File[] fileArray = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions").listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            YamlConfiguration ymlFile;
            Intrinsics.checkNotNullExpressionValue(YamlConfiguration.loadConfiguration((File)file), "loadConfiguration(...)");
            Intrinsics.checkNotNull(file);
            if (!Intrinsics.areEqual(FilesKt.getExtension(file), "yml")) continue;
            if (!ymlFile.getBoolean("enabled")) {
                disabledFusions.add(FilesKt.getNameWithoutExtension(file));
            }
            String name = FilesKt.getNameWithoutExtension(file);
            String string = ymlFile.getString("displayItem");
            if (string == null) {
                string = "DIRT";
            }
            ItemStack displayItem = new ItemStack(Material.valueOf((String)string));
            ItemMeta displayItemMeta = displayItem.getItemMeta();
            List tagList = new ArrayList();
            String string2 = ymlFile.getString("tags");
            Intrinsics.checkNotNull(string2);
            String[] stringArray = new String[]{";"};
            Iterator iterator2 = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null).iterator();
            while (iterator2.hasNext()) {
                String tag;
                String newTag = tag = (String)iterator2.next();
                newTag = StringsKt.replace$default(newTag, " ", "", false, 4, null);
                if (Intrinsics.areEqual(newTag = StringsKt.replace$default(newTag, ";", "", false, 4, null), "")) continue;
                tagList.add(newTag);
            }
            displayItemMeta.displayName(new ColorUtils().convert("<aqua>" + ymlFile.getString("name")));
            displayItemMeta.getPersistentDataContainer().set(FusionKeys.FUSION_GUI.getKey(), PersistentDataType.STRING, (Object)"true");
            List lore = new ArrayList();
            lore.add(new ColorUtils().convert("<white>" + ymlFile.getString("description")));
            lore.add(new ColorUtils().convert("<gray>Click to view fusion"));
            lore.add(new ColorUtils().convert(" "));
            lore.add(new ColorUtils().convert("<white>Tags: <gray>" + CollectionsKt.joinToString$default(tagList, ", ", null, null, 0, null, null, 62, null)));
            displayItemMeta.lore(lore);
            displayItem.setItemMeta(displayItemMeta);
            fusionThumbnails.put(name, displayItem);
            component2name.put(displayItem.displayName(), name);
            for (String tag : tagList) {
                if (tagMap.containsKey(tag)) {
                    List<String> list = tagMap.get(tag);
                    if (list != null) {
                        list.add(name);
                    }
                    continue;
                }
                Map<String, List<String>> map = tagMap;
                Object object = new String[]{name};
                object = CollectionsKt.mutableListOf(object);
                map.put(tag, (List<String>)object);
            }
            new Debugger().log("Loaded fusion thumbnail", "Name: " + name + " | File: " + file.getPath() + " | Map: " + fusionThumbnails.get(name), "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        }
    }

    @NotNull
    public final Map<String, Object> loadFusion(@NotNull String fusion) {
        Map fusionMap;
        Intrinsics.checkNotNullParameter(fusion, "fusion");
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/" + fusion + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        Map map = fusionMap = (Map)new LinkedHashMap();
        String string = "name";
        String string2 = ymlFile.getString("name");
        if (string2 == null) {
            string2 = "Unknown";
        }
        Iterator iterator2 = string2;
        map.put(string, iterator2);
        map = fusionMap;
        string = "description";
        String string3 = ymlFile.getString("description");
        if (string3 == null) {
            string3 = "Unknown";
        }
        iterator2 = string3;
        map.put(string, iterator2);
        ConfigurationSection configurationSection = ymlFile.getConfigurationSection("input");
        Set inputItems = configurationSection != null ? configurationSection.getKeys(false) : null;
        ConfigurationSection configurationSection2 = ymlFile.getConfigurationSection("output");
        Set outputItems = configurationSection2 != null ? configurationSection2.getKeys(false) : null;
        try {
            Set set = inputItems;
            Intrinsics.checkNotNull(set);
            for (String input : set) {
                Set inputSectionKeys;
                ConfigurationSection inputSection;
                ConfigurationSection configurationSection3 = inputSection = ymlFile.getConfigurationSection("input." + input);
                Set set2 = inputSectionKeys = configurationSection3 != null ? configurationSection3.getKeys(false) : null;
                Intrinsics.checkNotNull(set2);
                for (String key : set2) {
                    List subinputSection;
                    Intrinsics.checkNotNullExpressionValue(ymlFile.getMapList("input." + input + "." + key), "getMapList(...)");
                    fusionMap.put("input." + input + "." + key, subinputSection);
                }
            }
            Set set3 = outputItems;
            Intrinsics.checkNotNull(set3);
            for (String output : set3) {
                List suboutputSection;
                Intrinsics.checkNotNullExpressionValue(ymlFile.getMapList("output." + output), "getMapList(...)");
                fusionMap.put("output." + output, suboutputSection);
            }
        }
        catch (NullPointerException e) {
            new Debugger().log("Failed to load fusion input/output", "Name: " + fusion + " | File: " + file.getPath() + " | Error: " + e.getMessage(), "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        }
        new Debugger().log("Loaded fusion", "Name: " + fusion + " | File: " + file.getPath() + " | Map: " + fusionMap, "yv/tils/smp/mods/fusionCrafting/FusionLoader.kt");
        return fusionMap;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lyv/tils/smp/mods/fusionCrafting/FusionLoader$Companion;", "", "<init>", "()V", "fusionThumbnails", "", "", "Lorg/bukkit/inventory/ItemStack;", "getFusionThumbnails", "()Ljava/util/Map;", "component2name", "Lnet/kyori/adventure/text/Component;", "getComponent2name", "tagMap", "", "getTagMap", "disabledFusions", "getDisabledFusions", "()Ljava/util/List;", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, ItemStack> getFusionThumbnails() {
            return fusionThumbnails;
        }

        @NotNull
        public final Map<Component, String> getComponent2name() {
            return component2name;
        }

        @NotNull
        public final Map<String, List<String>> getTagMap() {
            return tagMap;
        }

        @NotNull
        public final List<String> getDisabledFusions() {
            return disabledFusions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

