/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.fusionCrafting.enchantments;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.URI;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.fusionCrafting.FusionKeys;
import yv.tils.smp.utils.MojangAPI;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lyv/tils/smp/mods/fusionCrafting/enchantments/PlayerHeadLoad;", "", "<init>", "()V", "loadPlayerHead", "Lorg/bukkit/inventory/meta/SkullMeta;", "nameTag", "Lorg/bukkit/inventory/ItemStack;", "outPut", "getHead", "name", "", "YVtils-SMP_paper"})
public final class PlayerHeadLoad {
    @NotNull
    public final SkullMeta loadPlayerHead(@NotNull ItemStack nameTag, @NotNull ItemStack outPut) {
        Intrinsics.checkNotNullParameter(nameTag, "nameTag");
        Intrinsics.checkNotNullParameter(outPut, "outPut");
        ColorUtils colorUtils = new ColorUtils();
        Component component = nameTag.displayName();
        Intrinsics.checkNotNullExpressionValue(component, "displayName(...)");
        String playerName = colorUtils.strip(component);
        playerName = StringsKt.replace$default(StringsKt.replace$default(playerName, "[", "", false, 4, null), "]", "", false, 4, null);
        ItemStack playerHead = this.getHead(playerName);
        if (playerHead != null) {
            ItemMeta itemMeta = playerHead.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
            SkullMeta meta = (SkullMeta)itemMeta;
            meta.displayName(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_FUSION_PLAYER_HEAD_DISPLAY_NAME), MapsKt.mapOf(TuplesKt.to("player", playerName))));
            meta.lore(outPut.getItemMeta().lore());
            meta.getPersistentDataContainer().remove(FusionKeys.FUSION_PLAYER_HEAD.getKey());
            outPut.setItemMeta((ItemMeta)meta);
            return meta;
        }
        YVtils.Companion.getInstance().getLogger().warning("Failed to load player head for " + playerName);
        ItemMeta itemMeta = outPut.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta meta = (SkullMeta)itemMeta;
        meta.displayName(new Language().getMessage(LangStrings.MODULE_FUSION_LOAD_PLAYER_HEAD_FAILED));
        meta.lore(outPut.getItemMeta().lore());
        meta.getPersistentDataContainer().remove(FusionKeys.FUSION_PLAYER_HEAD.getKey());
        outPut.setItemMeta((ItemMeta)meta);
        return meta;
    }

    private final ItemStack getHead(String name) {
        String skinURL;
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = playerHead.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        Player onlinePlayer = Bukkit.getPlayerExact((String)name);
        if (onlinePlayer != null) {
            skullMeta.setOwningPlayer((OfflinePlayer)onlinePlayer);
            playerHead.setItemMeta((ItemMeta)skullMeta);
            return playerHead;
        }
        UUID playerUUID = new MojangAPI().name2uuid(name);
        if (playerUUID != null && (skinURL = MojangAPI.getSkinTextures$default(new MojangAPI(), playerUUID, null, 2, null)) != null) {
            PlayerProfile playerProfile = Bukkit.createProfile((UUID)playerUUID, (String)name);
            Intrinsics.checkNotNullExpressionValue(playerProfile, "createProfile(...)");
            PlayerProfile profile = playerProfile;
            PlayerTextures playerTextures = profile.getTextures();
            Intrinsics.checkNotNullExpressionValue(playerTextures, "getTextures(...)");
            PlayerTextures textures = playerTextures;
            textures.setSkin(new URI(skinURL).toURL());
            profile.setTextures(textures);
            skullMeta.setPlayerProfile(profile);
            playerHead.setItemMeta((ItemMeta)skullMeta);
            return playerHead;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        if (offlinePlayer2.hasPlayedBefore()) {
            skullMeta.setOwningPlayer(offlinePlayer2);
            playerHead.setItemMeta((ItemMeta)skullMeta);
            return playerHead;
        }
        return null;
    }
}

