/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.fusionCrafting.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.fusionCrafting.FusionKeys;
import yv.tils.smp.mods.fusionCrafting.FusionLoader;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.inventory.GUIFiller;
import yv.tils.smp.utils.logger.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a8\u0006\u001a"}, d2={"Lyv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI;", "", "<init>", "()V", "openInventory", "", "player", "Lorg/bukkit/entity/Player;", "fusion", "", "collectData", "Lyv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI$Fusion;", "fusionName", "setData", "generateFileName", "createBackup", "ymlFile", "Lorg/bukkit/configuration/file/YamlConfiguration;", "file", "Ljava/io/File;", "deleteFusion", "generateContent", "Lorg/bukkit/inventory/Inventory;", "inv", "Companion", "Fusion", "YVtils-SMP_paper"})
public final class FusionManagerGUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<UUID, Fusion> playerManager = new LinkedHashMap();

    public final void openInventory(@NotNull Player player, @NotNull String fusion) {
        Fusion fusion2;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(fusion, "fusion");
        Inventory inventory = Bukkit.createInventory(null, (int)27, (Component)new ColorUtils().convert("<gold>Fusion Manager"));
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inv = inventory;
        if (playerManager.containsKey(player.getUniqueId())) {
            Fusion fusion3 = playerManager.get(player.getUniqueId());
            Intrinsics.checkNotNull(fusion3);
            fusion2 = fusion3;
        } else {
            Fusion fusion4;
            try {
                fusion4 = this.collectData(fusion);
            }
            catch (Exception e) {
                player.sendMessage(new ColorUtils().convert("<red>Failed to load fusion data"));
                YVtils.Companion.getInstance().getLogger().warning("Failed to load fusion data -> " + e.getMessage());
                new Debugger().log("Failed to load fusion data", e.getCause() + " -> " + e.getMessage(), "yv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI.kt");
                return;
            }
            fusion2 = fusion4;
        }
        Fusion data = fusion2;
        inv = this.generateContent(inv, data);
        playerManager.put(player.getUniqueId(), data);
        player.openInventory(inv);
    }

    private final Fusion collectData(String fusionName) {
        String string;
        boolean state = false;
        ItemStack thumbnail = new ItemStack(Material.BARRIER);
        String name = "";
        String description = "";
        List tags = new ArrayList();
        Map<String, Object> fusionInv = new LinkedHashMap();
        String fileName = "";
        if (Intrinsics.areEqual(fusionName, "null")) {
            return new Fusion(state, thumbnail, name, description, tags, fusionInv, fileName);
        }
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/" + fusionName + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        fileName = fusionName;
        state = ymlFile.getBoolean("enabled");
        String string2 = ymlFile.getString("displayItem");
        if (string2 == null) {
            string2 = "ITEM_FRAME";
        }
        thumbnail = new ItemStack(Material.valueOf((String)string2));
        String string3 = ymlFile.getString("name");
        if (string3 == null) {
            string3 = name = "";
        }
        if ((string = ymlFile.getString("description")) == null) {
            string = "";
        }
        description = string;
        String string4 = ymlFile.getString("tags");
        Intrinsics.checkNotNull(string4);
        String[] stringArray = new String[]{";"};
        Iterator iterator2 = StringsKt.split$default((CharSequence)string4, stringArray, false, 0, 6, null).iterator();
        while (iterator2.hasNext()) {
            String tag;
            String newTag = tag = (String)iterator2.next();
            newTag = StringsKt.replace$default(newTag, " ", "", false, 4, null);
            if (Intrinsics.areEqual(newTag = StringsKt.replace$default(newTag, ";", " ", false, 4, null), "")) continue;
            tags.add(newTag);
        }
        fusionInv = new FusionLoader().loadFusion(fusionName);
        return new Fusion(state, thumbnail, name, description, tags, fusionInv, fileName);
    }

    public final void setData(@NotNull Fusion fusion) {
        Intrinsics.checkNotNullParameter(fusion, "fusion");
        if (Intrinsics.areEqual(fusion.getFileName(), "")) {
            fusion.setFileName(this.generateFileName(fusion));
        }
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/" + fusion.getFileName() + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        this.createBackup(ymlFile, file);
        ymlFile.set("enabled", (Object)fusion.getState());
        ymlFile.set("displayItem", (Object)fusion.getThumbnail().getType().toString());
        ymlFile.set("name", (Object)fusion.getName());
        ymlFile.set("description", (Object)fusion.getDescription());
        ymlFile.set("tags", (Object)CollectionsKt.joinToString$default(fusion.getTags(), ";", null, null, 0, null, null, 62, null));
        ymlFile.set("input", null);
        ymlFile.set("output", null);
        Map<String, Object> fusionInv = fusion.getFusionInv();
        for (Map.Entry<String, Object> fusionItem : fusionInv.entrySet()) {
            String key = fusionItem.getKey();
            Object value = fusionItem.getValue();
            if (StringsKt.startsWith$default(key, "input.", false, 2, null)) {
                ymlFile.set(key, value);
                continue;
            }
            if (!StringsKt.startsWith$default(key, "output.", false, 2, null)) continue;
            ymlFile.set(key, value);
        }
        ymlFile.save(file);
        new FusionLoader().loadFusionThumbnail();
    }

    private final String generateFileName(Fusion fusion) {
        String name = fusion.getName();
        String string = StringsKt.replace$default(name, " ", "_", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String fileName = string;
        Object returnName = fileName;
        int i = 1;
        while (new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/" + (String)returnName + ".yml").exists()) {
            returnName = fileName + "_" + i;
            ++i;
        }
        return returnName;
    }

    private final void createBackup(YamlConfiguration ymlFile, File file) {
        File backupFile = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/backup/" + FilesKt.getNameWithoutExtension(file) + ".yml");
        ymlFile.save(backupFile);
    }

    public final void deleteFusion(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Fusion fusion = playerManager.get(player.getUniqueId());
        if (fusion == null) {
            return;
        }
        Fusion fusion2 = fusion;
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "fusions/" + fusion2.getFileName() + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        this.createBackup(yamlConfiguration, file);
        file.delete();
        new FusionLoader().loadFusionThumbnail();
    }

    private final Inventory generateContent(Inventory inv, Fusion fusion) {
        Inventory inv2 = inv;
        boolean fusionToggled = fusion.getState();
        ItemStack toggleSwitch = null;
        ItemMeta toggleSwitchMeta = null;
        boolean bl = fusionToggled;
        if (bl) {
            toggleSwitch = new ItemStack(Material.LIME_DYE);
            ItemMeta itemMeta = toggleSwitch.getItemMeta();
            Intrinsics.checkNotNullExpressionValue(itemMeta, "getItemMeta(...)");
            toggleSwitchMeta = itemMeta;
            toggleSwitchMeta.displayName(new ColorUtils().convert("<red>DISABLE FUSION"));
        } else if (!bl) {
            toggleSwitch = new ItemStack(Material.RED_DYE);
            ItemMeta itemMeta = toggleSwitch.getItemMeta();
            Intrinsics.checkNotNullExpressionValue(itemMeta, "getItemMeta(...)");
            toggleSwitchMeta = itemMeta;
            toggleSwitchMeta.displayName(new ColorUtils().convert("<green>ENABLE FUSION"));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        toggleSwitch.setItemMeta(toggleSwitchMeta);
        inv2.setItem(0, toggleSwitch);
        ItemStack thumbnail = fusion.getThumbnail();
        ItemMeta itemMeta = thumbnail.getItemMeta();
        Intrinsics.checkNotNullExpressionValue(itemMeta, "getItemMeta(...)");
        ItemMeta displayMeta = itemMeta;
        displayMeta.displayName(new ColorUtils().convert("<gold>Display Item"));
        thumbnail.setItemMeta(displayMeta);
        inv2.setItem(11, thumbnail);
        ItemStack displayName = new ItemStack(Material.NAME_TAG);
        ItemMeta displayNameMeta = displayName.getItemMeta();
        String displayNameContent = fusion.getName();
        List displayNameLore = new ArrayList();
        displayNameMeta.displayName(new ColorUtils().convert("<gold>Display Name"));
        displayNameLore.add(new ColorUtils().convert(" "));
        displayNameLore.add(new ColorUtils().convert("<aqua>" + displayNameContent));
        displayNameMeta.lore(displayNameLore);
        displayName.setItemMeta(displayNameMeta);
        inv2.setItem(12, displayName);
        ItemStack description = new ItemStack(Material.MAP);
        ItemMeta descriptionMeta = description.getItemMeta();
        List descriptionList = new ArrayList();
        List descriptionLore = new ArrayList();
        descriptionMeta.displayName(new ColorUtils().convert("<gold>Description"));
        descriptionList.add(fusion.getDescription());
        descriptionLore.add(new ColorUtils().convert(" "));
        for (String descLine : descriptionList) {
            descriptionLore.add(new ColorUtils().convert("<white>" + descLine));
        }
        descriptionMeta.lore(descriptionLore);
        description.setItemMeta(descriptionMeta);
        inv2.setItem(13, description);
        ItemStack tags = new ItemStack(Material.BOOK);
        ItemMeta tagsMeta = tags.getItemMeta();
        List tagsLore = new ArrayList();
        tagsMeta.displayName(new ColorUtils().convert("<gold>Filter Tags"));
        tagsLore.add(new ColorUtils().convert(" "));
        for (String tag : fusion.getTags()) {
            tagsLore.add(new ColorUtils().convert("<gray>" + tag));
        }
        tagsMeta.lore(tagsLore);
        tags.setItemMeta(tagsMeta);
        inv2.setItem(14, tags);
        ItemStack fusionInv = new ItemStack(Material.BARREL);
        ItemMeta fusionInvMeta = fusionInv.getItemMeta();
        fusionInvMeta.displayName(new ColorUtils().convert("<gold>Edit Fusion"));
        fusionInv.setItemMeta(fusionInvMeta);
        inv2.setItem(15, fusionInv);
        ItemStack back = new ItemStack(Material.TIPPED_ARROW);
        ItemMeta itemMeta2 = back.getItemMeta();
        Intrinsics.checkNotNull(itemMeta2, "null cannot be cast to non-null type org.bukkit.inventory.meta.PotionMeta");
        PotionMeta backMeta = (PotionMeta)itemMeta2;
        backMeta.setColor(Color.fromRGB((int)150, (int)85, (int)95));
        backMeta.displayName(new ColorUtils().convert("<red>Back"));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        backMeta.addItemFlags(itemFlagArray);
        back.setItemMeta((ItemMeta)backMeta);
        inv2.setItem(18, back);
        ItemStack delete = new ItemStack(Material.BARRIER);
        ItemMeta deleteMeta = delete.getItemMeta();
        deleteMeta.displayName(new ColorUtils().convert("<red>Delete Fusion"));
        delete.setItemMeta(deleteMeta);
        inv2.setItem(26, delete);
        inv2 = GUIFiller.fillInventory$default(new GUIFiller(), inv2, null, null, 6, null);
        int n = inv2.getSize();
        for (int i = 0; i < n; ++i) {
            ItemStack item;
            if (inv2.getItem(i) == null) continue;
            item.getItemMeta().getPersistentDataContainer().set(FusionKeys.FUSION_GUI.getKey(), PersistentDataType.STRING, (Object)"fusion");
            inv2.setItem(i, item);
        }
        return inv2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lyv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI$Companion;", "", "<init>", "()V", "playerManager", "", "Ljava/util/UUID;", "Lyv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI$Fusion;", "getPlayerManager", "()Ljava/util/Map;", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<UUID, Fusion> getPlayerManager() {
            return playerManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b&\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0003J\u0015\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\fH\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003Ja\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00100\u001a\u00020\u00032\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001b\u00a8\u00065"}, d2={"Lyv/tils/smp/mods/fusionCrafting/manager/FusionManagerGUI$Fusion;", "", "state", "", "thumbnail", "Lorg/bukkit/inventory/ItemStack;", "name", "", "description", "tags", "", "fusionInv", "", "fileName", "<init>", "(ZLorg/bukkit/inventory/ItemStack;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;)V", "getState", "()Z", "setState", "(Z)V", "getThumbnail", "()Lorg/bukkit/inventory/ItemStack;", "setThumbnail", "(Lorg/bukkit/inventory/ItemStack;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getDescription", "setDescription", "getTags", "()Ljava/util/List;", "setTags", "(Ljava/util/List;)V", "getFusionInv", "()Ljava/util/Map;", "setFusionInv", "(Ljava/util/Map;)V", "getFileName", "setFileName", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "YVtils-SMP_paper"})
    public static final class Fusion {
        private boolean state;
        @NotNull
        private ItemStack thumbnail;
        @NotNull
        private String name;
        @NotNull
        private String description;
        @NotNull
        private List<String> tags;
        @NotNull
        private Map<String, Object> fusionInv;
        @NotNull
        private String fileName;

        public Fusion(boolean state, @NotNull ItemStack thumbnail, @NotNull String name, @NotNull String description, @NotNull List<String> tags, @NotNull Map<String, Object> fusionInv, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter(thumbnail, "thumbnail");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(description, "description");
            Intrinsics.checkNotNullParameter(tags, "tags");
            Intrinsics.checkNotNullParameter(fusionInv, "fusionInv");
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            this.state = state;
            this.thumbnail = thumbnail;
            this.name = name;
            this.description = description;
            this.tags = tags;
            this.fusionInv = fusionInv;
            this.fileName = fileName;
        }

        public final boolean getState() {
            return this.state;
        }

        public final void setState(boolean bl) {
            this.state = bl;
        }

        @NotNull
        public final ItemStack getThumbnail() {
            return this.thumbnail;
        }

        public final void setThumbnail(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter(itemStack, "<set-?>");
            this.thumbnail = itemStack;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.description = string;
        }

        @NotNull
        public final List<String> getTags() {
            return this.tags;
        }

        public final void setTags(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.tags = list;
        }

        @NotNull
        public final Map<String, Object> getFusionInv() {
            return this.fusionInv;
        }

        public final void setFusionInv(@NotNull Map<String, Object> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            this.fusionInv = map;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fileName = string;
        }

        public final boolean component1() {
            return this.state;
        }

        @NotNull
        public final ItemStack component2() {
            return this.thumbnail;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final String component4() {
            return this.description;
        }

        @NotNull
        public final List<String> component5() {
            return this.tags;
        }

        @NotNull
        public final Map<String, Object> component6() {
            return this.fusionInv;
        }

        @NotNull
        public final String component7() {
            return this.fileName;
        }

        @NotNull
        public final Fusion copy(boolean state, @NotNull ItemStack thumbnail, @NotNull String name, @NotNull String description, @NotNull List<String> tags, @NotNull Map<String, Object> fusionInv, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter(thumbnail, "thumbnail");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(description, "description");
            Intrinsics.checkNotNullParameter(tags, "tags");
            Intrinsics.checkNotNullParameter(fusionInv, "fusionInv");
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            return new Fusion(state, thumbnail, name, description, tags, fusionInv, fileName);
        }

        public static /* synthetic */ Fusion copy$default(Fusion fusion, boolean bl, ItemStack itemStack, String string, String string2, List list, Map map, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = fusion.state;
            }
            if ((n & 2) != 0) {
                itemStack = fusion.thumbnail;
            }
            if ((n & 4) != 0) {
                string = fusion.name;
            }
            if ((n & 8) != 0) {
                string2 = fusion.description;
            }
            if ((n & 0x10) != 0) {
                list = fusion.tags;
            }
            if ((n & 0x20) != 0) {
                map = fusion.fusionInv;
            }
            if ((n & 0x40) != 0) {
                string3 = fusion.fileName;
            }
            return fusion.copy(bl, itemStack, string, string2, list, map, string3);
        }

        @NotNull
        public String toString() {
            return "Fusion(state=" + this.state + ", thumbnail=" + this.thumbnail + ", name=" + this.name + ", description=" + this.description + ", tags=" + this.tags + ", fusionInv=" + this.fusionInv + ", fileName=" + this.fileName + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.state);
            result = result * 31 + this.thumbnail.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + ((Object)this.tags).hashCode();
            result = result * 31 + ((Object)this.fusionInv).hashCode();
            result = result * 31 + this.fileName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fusion)) {
                return false;
            }
            Fusion fusion = (Fusion)other;
            if (this.state != fusion.state) {
                return false;
            }
            if (!Intrinsics.areEqual(this.thumbnail, fusion.thumbnail)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, fusion.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.description, fusion.description)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tags, fusion.tags)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fusionInv, fusion.fusionInv)) {
                return false;
            }
            return Intrinsics.areEqual(this.fileName, fusion.fileName);
        }
    }
}

