/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.multiMine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.mods.multiMine.MultiMineHandler;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.configs.multiMine.MultiMineConfig;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lyv/tils/smp/mods/multiMine/BlockManage;", "", "<init>", "()V", "addBlock", "", "sender", "Lorg/bukkit/command/CommandSender;", "block", "removeBlock", "checkForContainer", "", "item", "Lorg/bukkit/Material;", "shulkerList", "", "bundleList", "loadContainerContent", "", "container", "Lorg/bukkit/inventory/ItemStack;", "addMultiple", "removeMultiple", "modifyBlockList", "identifier", "", "YVtils-SMP_paper"})
public final class BlockManage {
    public final void addBlock(@NotNull CommandSender sender, @Nullable Object block) {
        Material material;
        ItemStack block2;
        Intrinsics.checkNotNullParameter(sender, "sender");
        ItemStack itemStack = block2 = (ItemStack)block;
        Object object = material = itemStack != null ? itemStack.getType() : null;
        if (!(sender instanceof Player)) {
            if (material == null) {
                sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_NO_BLOCK));
                return;
            }
            boolean b = this.modifyBlockList("+", material, sender);
            if (b) {
                sender.sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_MULTIMINE_ADD_BLOCK), CollectionsKt.listOf("block"), CollectionsKt.listOf(material.name())));
            }
        } else {
            boolean b;
            if (material == null) {
                if (((Player)sender).getInventory().getItemInMainHand().getType() == Material.AIR) {
                    Language language = new Language();
                    UUID uUID = ((Player)sender).getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    sender.sendMessage(language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_NO_BLOCK_IN_HAND));
                    return;
                }
                material = ((Player)sender).getInventory().getItemInMainHand().getType();
            }
            if (b = this.modifyBlockList("+", material, sender)) {
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = ((Player)sender).getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                sender.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_ADD_BLOCK), CollectionsKt.listOf("block"), CollectionsKt.listOf(material.name())));
            }
        }
    }

    public final void removeBlock(@NotNull CommandSender sender, @Nullable Object block) {
        Material material;
        ItemStack block2;
        Intrinsics.checkNotNullParameter(sender, "sender");
        ItemStack itemStack = block2 = (ItemStack)block;
        Object object = material = itemStack != null ? itemStack.getType() : null;
        if (!(sender instanceof Player)) {
            if (material == null) {
                sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_NO_BLOCK));
                return;
            }
            boolean b = this.modifyBlockList("-", material, sender);
            if (b) {
                sender.sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_MULTIMINE_REMOVE_BLOCK), CollectionsKt.listOf("block"), CollectionsKt.listOf(material.name())));
            }
        } else {
            boolean b;
            if (material == null) {
                if (((Player)sender).getInventory().getItemInMainHand().getType() == Material.AIR) {
                    sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_NO_BLOCK_IN_HAND));
                    return;
                }
                material = ((Player)sender).getInventory().getItemInMainHand().getType();
            }
            if (b = this.modifyBlockList("-", material, sender)) {
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = ((Player)sender).getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                sender.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_REMOVE_BLOCK), CollectionsKt.listOf("block"), CollectionsKt.listOf(material.name())));
            }
        }
    }

    private final boolean checkForContainer(Material item) {
        List containerList = new ArrayList();
        containerList.addAll((Collection)this.shulkerList());
        containerList.addAll((Collection)this.bundleList());
        return containerList.contains(item);
    }

    private final List<Material> shulkerList() {
        List shulkerList = new ArrayList();
        shulkerList.add(Material.SHULKER_BOX);
        shulkerList.add(Material.BLACK_SHULKER_BOX);
        shulkerList.add(Material.BLUE_SHULKER_BOX);
        shulkerList.add(Material.BROWN_SHULKER_BOX);
        shulkerList.add(Material.CYAN_SHULKER_BOX);
        shulkerList.add(Material.GRAY_SHULKER_BOX);
        shulkerList.add(Material.GREEN_SHULKER_BOX);
        shulkerList.add(Material.LIGHT_BLUE_SHULKER_BOX);
        shulkerList.add(Material.LIGHT_GRAY_SHULKER_BOX);
        shulkerList.add(Material.LIME_SHULKER_BOX);
        shulkerList.add(Material.MAGENTA_SHULKER_BOX);
        shulkerList.add(Material.ORANGE_SHULKER_BOX);
        shulkerList.add(Material.PINK_SHULKER_BOX);
        shulkerList.add(Material.PURPLE_SHULKER_BOX);
        shulkerList.add(Material.RED_SHULKER_BOX);
        shulkerList.add(Material.WHITE_SHULKER_BOX);
        shulkerList.add(Material.YELLOW_SHULKER_BOX);
        return shulkerList;
    }

    private final List<Material> bundleList() {
        List bundleList = new ArrayList();
        bundleList.add(Material.BUNDLE);
        bundleList.add(Material.BLACK_BUNDLE);
        bundleList.add(Material.BLUE_BUNDLE);
        bundleList.add(Material.BROWN_BUNDLE);
        bundleList.add(Material.CYAN_BUNDLE);
        bundleList.add(Material.GRAY_BUNDLE);
        bundleList.add(Material.GREEN_BUNDLE);
        bundleList.add(Material.LIGHT_BLUE_BUNDLE);
        bundleList.add(Material.LIGHT_GRAY_BUNDLE);
        bundleList.add(Material.LIME_BUNDLE);
        bundleList.add(Material.MAGENTA_BUNDLE);
        bundleList.add(Material.ORANGE_BUNDLE);
        bundleList.add(Material.PINK_BUNDLE);
        bundleList.add(Material.PURPLE_BUNDLE);
        bundleList.add(Material.RED_BUNDLE);
        bundleList.add(Material.WHITE_BUNDLE);
        bundleList.add(Material.YELLOW_BUNDLE);
        return bundleList;
    }

    private final List<Material> loadContainerContent(ItemStack container) {
        List content = new ArrayList();
        if (this.bundleList().contains(container.getType())) {
            ItemMeta itemMeta = container.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.BundleMeta");
            BundleMeta bundle = (BundleMeta)itemMeta;
            for (ItemStack item : bundle.getItems()) {
                Material material = item.getType();
                Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                content.add(material);
            }
        } else {
            ItemMeta itemMeta = container.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.BlockStateMeta");
            BlockStateMeta shulkerBox = (BlockStateMeta)itemMeta;
            BlockState blockState = shulkerBox.getBlockState();
            Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.ShulkerBox");
            ShulkerBox inventory = (ShulkerBox)blockState;
            ItemStack[] itemStackArray = inventory.getInventory().getContents();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
            for (ItemStack item : itemStackArray) {
                if (item == null) continue;
                Material material = item.getType();
                Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                content.add(material);
            }
        }
        return content;
    }

    public final void addMultiple(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (!(sender instanceof Player)) {
            sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_MULTIPLE_CONSOLE));
            return;
        }
        Material material = ((Player)sender).getInventory().getItemInMainHand().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (!this.checkForContainer(material)) {
            sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_NO_CONTAINER_IN_HAND));
            return;
        }
        List blocks = new ArrayList();
        ItemStack itemStack = ((Player)sender).getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        for (Material block : this.loadContainerContent(itemStack)) {
            boolean b = this.modifyBlockList("+", block, sender);
            if (!b) continue;
            blocks.add(block);
        }
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        sender.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_ADD_MULTIPLE), CollectionsKt.listOf("blocks"), CollectionsKt.listOf(CollectionsKt.joinToString$default(blocks, ", ", null, null, 0, null, BlockManage::addMultiple$lambda$0, 30, null))));
    }

    public final void removeMultiple(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (!(sender instanceof Player)) {
            sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_MULTIPLE_CONSOLE));
            return;
        }
        Material material = ((Player)sender).getInventory().getItemInMainHand().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (!this.checkForContainer(material)) {
            sender.sendMessage(new Language().getMessage(LangStrings.MODULE_MULTIMINE_NO_CONTAINER_IN_HAND));
            return;
        }
        List blocks = new ArrayList();
        ItemStack itemStack = ((Player)sender).getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        for (Material block : this.loadContainerContent(itemStack)) {
            boolean b = this.modifyBlockList("-", block, sender);
            if (!b) continue;
            blocks.add(block);
        }
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        sender.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_REMOVE_MULTIPLE), CollectionsKt.listOf("blocks"), CollectionsKt.listOf(CollectionsKt.joinToString$default(blocks, ", ", null, null, 0, null, BlockManage::removeMultiple$lambda$0, 30, null))));
    }

    private final boolean modifyBlockList(String identifier, Material block, CommandSender sender) {
        if (Intrinsics.areEqual(identifier, "+")) {
            if (MultiMineHandler.Companion.getBlocks().contains(block)) {
                sender.sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_MULTIMINE_BLOCK_ALREADY_IN_LIST), CollectionsKt.listOf("block"), CollectionsKt.listOf(block.name())));
                return false;
            }
            MultiMineHandler.Companion.getBlocks().add(block);
        } else if (Intrinsics.areEqual(identifier, "-")) {
            if (!MultiMineHandler.Companion.getBlocks().contains(block)) {
                sender.sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_MULTIMINE_BLOCK_NOT_IN_LIST), CollectionsKt.listOf("block"), CollectionsKt.listOf(block.name())));
                return false;
            }
            MultiMineHandler.Companion.getBlocks().remove(block);
        }
        new MultiMineConfig().updateBlockList(MultiMineHandler.Companion.getBlocks());
        return true;
    }

    private static final CharSequence addMultiple$lambda$0(Material it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.name();
    }

    private static final CharSequence removeMultiple$lambda$0(Material it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.name();
    }
}

