/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.multiMine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.configs.multiMine.MultiMineConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0010H\u0002J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lyv/tils/smp/mods/multiMine/MultiMineHandler;", "", "<init>", "()V", "trigger", "", "e", "Lorg/bukkit/event/block/BlockBreakEvent;", "itemBroke", "", "registerBlocks", "loc", "Lorg/bukkit/Location;", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "breakBlock", "block", "Lorg/bukkit/block/Block;", "damageItem", "damage", "", "setCooldown", "Ljava/util/UUID;", "checkCooldown", "checkBlock", "material", "Lorg/bukkit/Material;", "blocks", "", "checkTool", "tool", "toggle", "sender", "Companion", "YVtils-SMP_paper"})
public final class MultiMineHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean itemBroke;
    private static final boolean active;
    private static final int animationTime;
    private static final int cooldownTime;
    private static final int breakLimit;
    @NotNull
    private static final Map<UUID, Integer> cooldownMap;
    @NotNull
    private static final Map<UUID, Integer> brokenMap;
    @NotNull
    private static final List<Material> blocks;

    public MultiMineHandler() {
        Bukkit.getScheduler().runTaskTimer((Plugin)YVtils.Companion.getInstance(), MultiMineHandler::_init_$lambda$0, 20L, 20L);
    }

    public final void trigger(@NotNull BlockBreakEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!active) {
            return;
        }
        Location location = e.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location loc = location;
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack item = itemStack;
        Block block = e.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (!player2.hasPermission("yvtils.smp.multiMine")) {
            return;
        }
        MultiMineConfig multiMineConfig = new MultiMineConfig();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        if (!multiMineConfig.getPlayerSetting(string)) {
            return;
        }
        Material material = e.getBlock().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (!this.checkBlock(material, blocks)) {
            return;
        }
        if (!this.checkTool(block2, item)) {
            return;
        }
        UUID uUID2 = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        if (this.checkCooldown(uUID2)) {
            return;
        }
        if (player2.isSneaking()) {
            return;
        }
        if (player2.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        brokenMap.put(player2.getUniqueId(), 0);
        UUID uUID3 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        this.setCooldown(uUID3);
        this.registerBlocks(loc, player2, item);
    }

    private final void registerBlocks(Location loc, Player player, ItemStack item) {
        Integer n = brokenMap.get(player.getUniqueId());
        Intrinsics.checkNotNull(n);
        if (((Number)n).intValue() >= breakLimit) {
            return;
        }
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    Block newBlock;
                    if (x == 0 && y == 0 && z == 0) continue;
                    Location newLoc = new Location(loc.getWorld(), loc.getX() + (double)x, loc.getY() + (double)y, loc.getZ() + (double)z);
                    Intrinsics.checkNotNullExpressionValue(newLoc.getBlock(), "getBlock(...)");
                    Bukkit.getScheduler().runTaskLater((Plugin)YVtils.Companion.getInstance(), () -> MultiMineHandler.registerBlocks$lambda$0(this, newBlock, player, item, newLoc), (long)animationTime * 1L);
                }
            }
        }
    }

    private final boolean breakBlock(Block block, Player player, ItemStack item) {
        Material material = block.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (this.checkBlock(material, blocks) && this.checkTool(block, item)) {
            Integer n = brokenMap.get(player.getUniqueId());
            Intrinsics.checkNotNull(n);
            if (((Number)n).intValue() != 0) {
                try {
                    if (this.itemBroke) {
                        return false;
                    }
                    if (this.damageItem(player, 1, item)) {
                        return false;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            UUID uUID = player.getUniqueId();
            Integer n2 = brokenMap.get(player.getUniqueId());
            Intrinsics.checkNotNull(n2);
            brokenMap.put(uUID, ((Number)n2).intValue() + 1);
            block.breakNaturally(item, true, true);
            return true;
        }
        return false;
    }

    private final boolean damageItem(Player player, int damage, ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.Damageable");
        Damageable damageable = (Damageable)itemMeta;
        if (damageable.getDamage() + damage >= item.getType().getMaxDurability()) {
            this.itemBroke = true;
            ItemStack[] itemStackArray = new ItemStack[]{item};
            player.getInventory().removeItem(itemStackArray);
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            return true;
        }
        item.damage(damage, (LivingEntity)player);
        return false;
    }

    private final void setCooldown(UUID player) {
        cooldownMap.put(player, cooldownTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkCooldown(UUID player) {
        if (cooldownMap.get(player) == null) return false;
        Integer n = cooldownMap.get(player);
        if (n == null) return true;
        if (n == 0) return false;
        return true;
    }

    private final boolean checkBlock(Material material, List<? extends Material> blocks) {
        return blocks.contains(material);
    }

    private final boolean checkTool(Block block, ItemStack tool) {
        if (tool.getType() == Material.AIR) {
            return false;
        }
        if (tool.getType().getMaxDurability() == 0) {
            return false;
        }
        Collection collection = block.getDrops(tool);
        Intrinsics.checkNotNullExpressionValue(collection, "getDrops(...)");
        return !collection.isEmpty();
    }

    public final void toggle(@NotNull Player sender) {
        Component component;
        Intrinsics.checkNotNullParameter(sender, "sender");
        String string = sender.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        boolean value = new MultiMineConfig().getPlayerSetting(uuid);
        new MultiMineConfig().changePlayerSetting(uuid, !value);
        if (!value) {
            Language language = new Language();
            UUID uUID = sender.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            component = language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_TOGGLE_ACTIVATE);
        } else {
            Language language = new Language();
            UUID uUID = sender.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            component = language.getMessage(uUID, LangStrings.MODULE_MULTIMINE_TOGGLE_DEACTIVATE);
        }
        sender.sendMessage(component);
    }

    private static final void registerBlocks$lambda$0(MultiMineHandler this$0, Block $newBlock, Player $player, ItemStack $item, Location $newLoc) {
        if (!this$0.breakBlock($newBlock, $player, $item)) {
            return;
        }
        this$0.registerBlocks($newLoc, $player, $item);
    }

    private static final void _init_$lambda$0() {
        for (Map.Entry<UUID, Integer> entry : cooldownMap.entrySet()) {
            if (((Number)entry.getValue()).intValue() == 0) continue;
            cooldownMap.put(entry.getKey(), ((Number)entry.getValue()).intValue() - 1);
        }
    }

    static {
        Object object = Config.Companion.getConfig().get("modules.multiMine");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        active = (Boolean)object;
        Object object2 = MultiMineConfig.Companion.getConfig().get("animationTime");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Int");
        animationTime = (Integer)object2;
        Object object3 = MultiMineConfig.Companion.getConfig().get("cooldownTime");
        Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Int");
        cooldownTime = (Integer)object3;
        Object object4 = MultiMineConfig.Companion.getConfig().get("breakLimit");
        Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.Int");
        breakLimit = (Integer)object4;
        cooldownMap = new LinkedHashMap();
        brokenMap = new LinkedHashMap();
        blocks = MultiMineConfig.Companion.getBlockList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lyv/tils/smp/mods/multiMine/MultiMineHandler$Companion;", "", "<init>", "()V", "active", "", "getActive", "()Z", "animationTime", "", "getAnimationTime", "()I", "cooldownTime", "getCooldownTime", "breakLimit", "getBreakLimit", "cooldownMap", "", "Ljava/util/UUID;", "getCooldownMap", "()Ljava/util/Map;", "brokenMap", "getBrokenMap", "blocks", "", "Lorg/bukkit/Material;", "getBlocks", "()Ljava/util/List;", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getActive() {
            return active;
        }

        public final int getAnimationTime() {
            return animationTime;
        }

        public final int getCooldownTime() {
            return cooldownTime;
        }

        public final int getBreakLimit() {
            return breakLimit;
        }

        @NotNull
        public final Map<UUID, Integer> getCooldownMap() {
            return cooldownMap;
        }

        @NotNull
        public final Map<UUID, Integer> getBrokenMap() {
            return brokenMap;
        }

        @NotNull
        public final List<Material> getBlocks() {
            return blocks;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

