/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.other;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.manager.commands.handle.FlyHandler;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lyv/tils/smp/mods/other/SpawnElytra;", "", "<init>", "()V", "main", "Lyv/tils/smp/YVtils;", "flying", "", "Ljava/util/UUID;", "boosted", "onWorldChange", "", "e", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onDoubleJump", "Lorg/bukkit/event/player/PlayerToggleFlightEvent;", "onLandDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onHandSwap", "Lorg/bukkit/event/player/PlayerSwapHandItemsEvent;", "onToggleGlide", "Lorg/bukkit/event/entity/EntityToggleGlideEvent;", "isInSpawnRadius", "", "player", "Lorg/bukkit/entity/Player;", "Companion", "YVtils-SMP_paper"})
@SourceDebugExtension(value={"SMAP\nSpawnElytra.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnElytra.kt\nyv/tils/smp/mods/other/SpawnElytra\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1869#2,2:132\n*S KotlinDebug\n*F\n+ 1 SpawnElytra.kt\nyv/tils/smp/mods/other/SpawnElytra\n*L\n47#1:132,2\n*E\n"})
public final class SpawnElytra {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YVtils main = YVtils.Companion.getInstance();
    @NotNull
    private List<UUID> flying = new ArrayList();
    @NotNull
    private List<UUID> boosted = new ArrayList();
    private static boolean active;
    private static int radius;
    private static int multiplyValue;
    private static SpawnElytra instance;

    public SpawnElytra() {
        if (active) {
            instance = this;
            Bukkit.getScheduler().runTaskTimer((Plugin)this.main, () -> SpawnElytra._init_$lambda$0(this), 0L, 3L);
        }
    }

    public final void onWorldChange(@NotNull PlayerChangedWorldEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (FlyHandler.Companion.getFly().containsKey(player2.getUniqueId()) && Intrinsics.areEqual(FlyHandler.Companion.getFly().get(player2.getUniqueId()), true)) {
            return;
        }
        if (player2.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        player2.setAllowFlight(false);
        player2.setFlying(false);
        player2.setGliding(false);
        this.boosted.remove(player2.getUniqueId());
        this.flying.remove(player2.getUniqueId());
    }

    public final void onDoubleJump(@NotNull PlayerToggleFlightEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (FlyHandler.Companion.getFly().containsKey(player2.getUniqueId()) && Intrinsics.areEqual(FlyHandler.Companion.getFly().get(player2.getUniqueId()), true)) {
            return;
        }
        if (player2.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (!this.isInSpawnRadius(player2)) {
            if (!Intrinsics.areEqual(player2.getWorld().getName(), "world")) {
                player2.setAllowFlight(false);
            }
            return;
        }
        e.setCancelled(true);
        player2.setGliding(true);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.flying.add(uUID);
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        player2.sendActionBar(placeholder.replacer(language.getMessage(uUID2, LangStrings.SPAWN_ELYTRA_BOOST), CollectionsKt.listOf("key"), CollectionsKt.listOf("<key:key.swapOffhand>")));
    }

    public final void onLandDamage(@NotNull EntityDamageEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.getEntityType() == EntityType.PLAYER && (e.getCause() == EntityDamageEvent.DamageCause.FALL || e.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && this.flying.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    public final void onHandSwap(@NotNull PlayerSwapHandItemsEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.flying.contains(e.getPlayer().getUniqueId())) {
            if (this.boosted.contains(e.getPlayer().getUniqueId())) {
                return;
            }
            e.setCancelled(true);
            UUID uUID = e.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.boosted.add(uUID);
            e.getPlayer().setVelocity(e.getPlayer().getLocation().getDirection().multiply((double)multiplyValue));
        }
    }

    public final void onToggleGlide(@NotNull EntityToggleGlideEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Entity entity = e.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)entity;
        ItemStack itemStack = player.getInventory().getChestplate();
        if ((itemStack != null ? itemStack.getType() : null) == Material.ELYTRA) {
            return;
        }
        if (this.flying.contains(e.getEntity().getUniqueId()) && !e.isGliding()) {
            e.setCancelled(true);
        }
    }

    public final boolean isInSpawnRadius(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Intrinsics.areEqual(player.getWorld().getName(), "world")) {
            return false;
        }
        return player.getLocation().distance(player.getWorld().getSpawnLocation()) <= (double)radius;
    }

    private static final void _init_$lambda$0(SpawnElytra this$0) {
        block1: {
            Object object = Bukkit.getWorld((String)"world");
            if (object == null || (object = object.getPlayers()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                if (FlyHandler.Companion.getFly().containsKey(player.getUniqueId()) && Intrinsics.areEqual(FlyHandler.Companion.getFly().get(player.getUniqueId()), true) || player.getGameMode() != GameMode.SURVIVAL) continue;
                Intrinsics.checkNotNull(player);
                player.setAllowFlight(this$0.isInSpawnRadius(player));
                if (!this$0.flying.contains(player.getUniqueId()) || player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) continue;
                player.setAllowFlight(false);
                player.setFlying(false);
                player.setGliding(false);
                this$0.boosted.remove(player.getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)this$0.main, () -> SpawnElytra.lambda$0$0$0(this$0, player), 5L);
            }
        }
    }

    private static final void lambda$0$0$0(SpawnElytra this$0, Player $player) {
        this$0.flying.remove($player.getUniqueId());
    }

    static {
        Object object = Config.Companion.getConfig().get("spawnElytra.active");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        active = (Boolean)object;
        Object object2 = Config.Companion.getConfig().get("spawnElytra.radius");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Int");
        radius = (Integer)object2;
        Object object3 = Config.Companion.getConfig().get("spawnElytra.multiplyValue");
        Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Int");
        multiplyValue = (Integer)object3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lyv/tils/smp/mods/other/SpawnElytra$Companion;", "", "<init>", "()V", "active", "", "getActive", "()Z", "setActive", "(Z)V", "radius", "", "getRadius", "()I", "setRadius", "(I)V", "multiplyValue", "getMultiplyValue", "setMultiplyValue", "instance", "Lyv/tils/smp/mods/other/SpawnElytra;", "getInstance", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getActive() {
            return active;
        }

        public final void setActive(boolean bl) {
            active = bl;
        }

        public final int getRadius() {
            return radius;
        }

        public final void setRadius(int n) {
            radius = n;
        }

        public final int getMultiplyValue() {
            return multiplyValue;
        }

        public final void setMultiplyValue(int n) {
            multiplyValue = n;
        }

        @NotNull
        public final SpawnElytra getInstance() {
            SpawnElytra spawnElytra = instance;
            if (spawnElytra == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                spawnElytra = null;
            }
            return spawnElytra;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

