/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.server.connect;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.mods.admin.vanish.Vanish;
import yv.tils.smp.mods.fusionCrafting.FusionKeys;
import yv.tils.smp.mods.waypoints.WaypointPath;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.logger.Debugger;
import yv.tils.smp.utils.updater.PluginVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lyv/tils/smp/mods/server/connect/PlayerJoin;", "", "<init>", "()V", "state", "", "eventReceiver", "", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "funcStarter", "vanishJoin", "player", "Lorg/bukkit/entity/Player;", "sendJoinMessage", "generateJoinMessage", "Lnet/kyori/adventure/text/Component;", "setupPlayer", "hideWaypointMarkers", "checkFusionDupe", "otherActions", "YVtils-SMP_paper"})
@SourceDebugExtension(value={"SMAP\nPlayerJoin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerJoin.kt\nyv/tils/smp/mods/server/connect/PlayerJoin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1869#2,2:136\n*S KotlinDebug\n*F\n+ 1 PlayerJoin.kt\nyv/tils/smp/mods/server/connect/PlayerJoin\n*L\n101#1:136,2\n*E\n"})
public final class PlayerJoin {
    private int state = 1;

    public final void eventReceiver(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        new Debugger().log("PlayerJoin - Event Receiver", "Player " + e.getPlayer().getName() + " joined the server", "yv.tils.smp.mods.server.connect.PlayerJoin.eventReceiver()");
        this.funcStarter(this.state, e);
    }

    private final void funcStarter(int state, PlayerJoinEvent e) {
        switch (state) {
            case 1: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.vanishJoin(e, player);
                break;
            }
            case 2: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.sendJoinMessage(e, player);
                break;
            }
            case 3: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.setupPlayer(e, player);
                break;
            }
            case 4: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.hideWaypointMarkers(e, player);
                break;
            }
            case 5: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.checkFusionDupe(e, player);
                break;
            }
            case 6: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.otherActions(e, player);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void vanishJoin(PlayerJoinEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.admin");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        if (Vanish.Companion.getVanish().containsKey(player.getUniqueId())) {
            Vanish.VanishedPlayer vanishedPlayer = Vanish.Companion.getVanish().get(player.getUniqueId());
            Boolean bl = vanishedPlayer != null ? Boolean.valueOf(vanishedPlayer.getVanish()) : null;
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue()) {
                e.joinMessage(null);
                this.state = 3;
                return;
            }
        }
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    private final void sendJoinMessage(PlayerJoinEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.server");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        e.joinMessage(this.generateJoinMessage(player));
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    @NotNull
    public final Component generateJoinMessage(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = Config.Companion.getConfig().get("joinMessages");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        List messages = (List)object;
        int random = RangesKt.random(CollectionsKt.getIndices(messages), (Random)Random.Default);
        new Debugger().log("PlayerQuit - Generate Join Message", "Generated Following Join Message: " + messages.get(random), "yv.tils.smp.mods.server.connect.PlayerJoin.generateJoinMessage()");
        Placeholder placeholder = new Placeholder();
        TextComponent textComponent = Component.text((String)((String)messages.get(random)));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        return placeholder.replacer((Component)textComponent, CollectionsKt.listOf("player"), CollectionsKt.listOf(player.getName()));
    }

    private final void setupPlayer(PlayerJoinEvent e, Player player) {
        new Debugger().log("PlayerJoin - Setup Player", "Player " + player.getName() + " joined the server", "yv.tils.smp.mods.server.connect.PlayerJoin.setupPlayer()");
        Language.Companion.getPlayerLang().put(player.getUniqueId(), player.locale());
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    private final void hideWaypointMarkers(PlayerJoinEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.waypoints");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        Iterable $this$forEach$iv = WaypointPath.Companion.getCrystalList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnderCrystal it = (EnderCrystal)element$iv;
            boolean bl = false;
            player.hideEntity((Plugin)YVtils.Companion.getInstance(), (Entity)it);
        }
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    private final void checkFusionDupe(PlayerJoinEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.fusion");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inv = playerInventory;
        ItemStack[] itemStackArray = inv.getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        for (ItemStack i : itemStackArray) {
            if (i == null || !i.getItemMeta().getPersistentDataContainer().has(FusionKeys.FUSION_GUI.getKey(), PersistentDataType.STRING)) continue;
            ItemStack[] itemStackArray2 = new ItemStack[]{i};
            player.getInventory().removeItem(itemStackArray2);
        }
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    private final void otherActions(PlayerJoinEvent e, Player player) {
        new PluginVersion().onPlayerJoin(player);
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }
}

