/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.server.connect;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.mods.admin.vanish.Vanish;
import yv.tils.smp.mods.waypoints.WaypointPath;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.logger.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lyv/tils/smp/mods/server/connect/PlayerQuit;", "", "<init>", "()V", "state", "", "eventReceiver", "", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "funcStarter", "e", "vanishQuit", "player", "Lorg/bukkit/entity/Player;", "sendQuitMessage", "generateQuitMessage", "Lnet/kyori/adventure/text/Component;", "stopNavigation", "YVtils-SMP_paper"})
public final class PlayerQuit {
    private int state = 1;

    public final void eventReceiver(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new Debugger().log("PlayerQuit - Event Receiver", "Player " + event.getPlayer().getName() + " quit the server", "yv.tils.smp.mods.server.connect.PlayerQuit.eventReceiver()");
        this.funcStarter(this.state, event);
    }

    private final void funcStarter(int state, PlayerQuitEvent e) {
        switch (state) {
            case 1: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.vanishQuit(e, player);
                break;
            }
            case 2: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.sendQuitMessage(e, player);
                break;
            }
            case 3: {
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                this.stopNavigation(e, player);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void vanishQuit(PlayerQuitEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.admin");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        if (Vanish.Companion.getVanish().containsKey(player.getUniqueId())) {
            Vanish.VanishedPlayer vanishedPlayer = Vanish.Companion.getVanish().get(player.getUniqueId());
            Boolean bl = vanishedPlayer != null ? Boolean.valueOf(vanishedPlayer.getVanish()) : null;
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue()) {
                e.quitMessage(null);
                Language.Companion.getPlayerLang().remove(player.getUniqueId());
                this.state = -1;
                return;
            }
        }
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    private final void sendQuitMessage(PlayerQuitEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.server");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        e.quitMessage(this.generateQuitMessage(player));
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }

    @NotNull
    public final Component generateQuitMessage(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = Config.Companion.getConfig().get("leaveMessages");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        List messages = (List)object;
        int random = RangesKt.random(CollectionsKt.getIndices(messages), (Random)Random.Default);
        new Debugger().log("PlayerQuit - Generate Quit Message", "Generated Following Quit Message: " + messages.get(random), "yv.tils.smp.mods.server.connect.PlayerQuit.generateQuitMessage()");
        Placeholder placeholder = new Placeholder();
        TextComponent textComponent = Component.text((String)((String)messages.get(random)));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        return placeholder.replacer((Component)textComponent, CollectionsKt.listOf("player"), CollectionsKt.listOf(player.getName()));
    }

    private final void stopNavigation(PlayerQuitEvent e, Player player) {
        Object object = Config.Companion.getConfig().get("modules.waypoints");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            int n = this.state;
            this.state = n + 1;
            this.funcStarter(n, e);
            return;
        }
        Map<Player, WaypointPath.NaviData> navigations = WaypointPath.Companion.getNavigatingPlayers();
        if (navigations.containsKey(player)) {
            WaypointPath.NaviData naviData;
            WaypointPath.NaviData naviData2 = navigations.get(player);
            if (naviData2 != null && (naviData2 = naviData2.getTask()) != null) {
                naviData2.cancel();
            }
            if ((naviData = navigations.get(player)) != null && (naviData = naviData.getEndCrystal()) != null) {
                naviData.remove();
            }
            navigations.remove(player);
        }
        int n = this.state;
        this.state = n + 1;
        this.funcStarter(n, e);
    }
}

