/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.sit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lyv/tils/smp/mods/sit/SitManager;", "", "<init>", "()V", "sit", "", "player", "Lorg/bukkit/entity/Player;", "sitGetter", "sitDown", "Lorg/bukkit/entity/ArmorStand;", "x", "", "y", "z", "location", "Lorg/bukkit/Location;", "standUp", "armorStand", "isSitting", "", "uuid", "Ljava/util/UUID;", "isInAir", "Companion", "YVtils-SMP_paper"})
@SourceDebugExtension(value={"SMAP\nSitManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SitManager.kt\nyv/tils/smp/mods/sit/SitManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n37#2,2:75\n*S KotlinDebug\n*F\n+ 1 SitManager.kt\nyv/tils/smp/mods/sit/SitManager\n*L\n41#1:75,2\n*E\n"})
public final class SitManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<UUID> sittingPlayers = new ArrayList();

    public final void sit(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (this.isSitting(uuid) || this.isInAir(player)) {
            return;
        }
        sittingPlayers.add(uuid);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.sitDown(0.0, 1.975, 0.0, location).addPassenger((Entity)player);
    }

    public final void sitGetter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (player.getVehicle() instanceof ArmorStand) {
            Entity entity = player.getVehicle();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.ArmorStand");
            ArmorStand sit = (ArmorStand)entity;
            this.standUp(player, sit, 0.0, 1.975, 0.0);
        }
    }

    private final ArmorStand sitDown(double x, double y, double z, Location location) {
        World world = location.getWorld();
        Entity entity = world.spawnEntity(location.subtract(x, y, z), EntityType.ARMOR_STAND);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.ArmorStand");
        ArmorStand sit = (ArmorStand)entity;
        sit.setInvulnerable(true);
        sit.setInvisible(true);
        Collection $this$toTypedArray$iv = EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (EquipmentSlot slot : thisCollection$iv.toArray(new EquipmentSlot[0])) {
            sit.addEquipmentLock(slot, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        sit.setGravity(false);
        return sit;
    }

    public final void standUp(@NotNull Player player, @NotNull ArmorStand armorStand, double x, double y, double z) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(armorStand, "armorStand");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (!this.isSitting(uuid)) {
            return;
        }
        armorStand.remove();
        player.teleport(player.getLocation().add(x, y, z));
        sittingPlayers.remove(uuid);
    }

    public final boolean isSitting(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return sittingPlayers.contains(uuid);
    }

    private final boolean isInAir(Player player) {
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Block block = location2.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        Block block3 = block2.getRelative(0, -1, 0);
        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
        Block blockBelow = block3;
        return block2.isEmpty() && blockBelow.isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lyv/tils/smp/mods/sit/SitManager$Companion;", "", "<init>", "()V", "sittingPlayers", "", "Ljava/util/UUID;", "getSittingPlayers", "()Ljava/util/List;", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<UUID> getSittingPlayers() {
            return sittingPlayers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

