/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.status;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.mods.status.StatusTeamManager;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.configs.status.StatusConfig;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lyv/tils/smp/mods/status/StatusHandler;", "", "<init>", "()V", "setStatus", "", "player", "Lorg/bukkit/entity/Player;", "status", "", "setDefaultStatus", "suggestions", "", "clearStatus", "sender", "Lorg/bukkit/command/CommandSender;", "target", "setStatusDisplayHandler", "setStatusDisplay", "", "generateDefaultStatus", "checkBlacklist", "YVtils-SMP_paper"})
public final class StatusHandler {
    public final void setStatus(@NotNull Player player, @NotNull String status) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(status, "status");
        Object object = StatusConfig.Companion.getConfig().get("maxLength");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        int maxLength = (Integer)object;
        if (new ColorUtils().strip(status).length() > maxLength) {
            Language language = new Language();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            player.sendMessage(language.getMessage(uUID, LangStrings.INPUT_TOO_LONG));
            return;
        }
        this.setStatusDisplayHandler(player, status);
    }

    public final void setDefaultStatus(@NotNull Player player, @NotNull String status, @NotNull Collection<String> suggestions) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(status, "status");
        Intrinsics.checkNotNullParameter(suggestions, "suggestions");
        if (!suggestions.contains(status)) {
            Language language = new Language();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            player.sendMessage(language.getMessage(uUID, LangStrings.MODULE_STATUS_NO_DEFAULT_STATUS));
            return;
        }
        this.setStatusDisplayHandler(player, status);
    }

    public final void clearStatus(@NotNull CommandSender sender, @Nullable Player target) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (target == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(new Language().getMessage(sender, LangStrings.MODULE_STATUS_CLEAR_CONSOLE));
                return;
            }
            this.setStatusDisplay((Player)sender, "");
            Language language = new Language();
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            sender.sendMessage(language.getMessage(uUID, LangStrings.MODULE_STATUS_CLEAR_CLEARED));
        } else {
            if (!sender.hasPermission("yvtils.smp.command.status.clear.others")) {
                sender.sendMessage(new Language().getMessage(sender, LangStrings.MODULE_STATUS_CLEAR_OTHER_UNALLOWED));
                return;
            }
            this.setStatusDisplay(target, "");
            sender.sendMessage(new Placeholder().replacer(new Language().getMessage(sender, LangStrings.MODULE_STATUS_CLEAR_OTHER_CLEARED), CollectionsKt.listOf("player"), CollectionsKt.listOf(target.getName())));
            Language language = new Language();
            UUID uUID = target.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            target.sendMessage(language.getMessage(uUID, LangStrings.MODULE_STATUS_CLEAR_CLEARED));
        }
    }

    public static /* synthetic */ void clearStatus$default(StatusHandler statusHandler, CommandSender commandSender, Player player, int n, Object object) {
        if ((n & 2) != 0) {
            player = null;
        }
        statusHandler.clearStatus(commandSender, player);
    }

    private final void setStatusDisplayHandler(Player player, String status) {
        if (this.setStatusDisplay(player, status)) {
            Object object = StatusConfig.Companion.getConfig().get("display");
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
            String display = (String)object;
            Placeholder placeholder = new Placeholder();
            Component component = new ColorUtils().convert(display);
            String[] stringArray = new String[]{"status", "playerName"};
            List<String> list = CollectionsKt.listOf(stringArray);
            stringArray = new String[2];
            stringArray[0] = status;
            Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
            Component displayCompo = placeholder.replacer(component, list, CollectionsKt.listOf(stringArray));
            player.sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.MODULE_STATUS_SET), CollectionsKt.listOf("status"), CollectionsKt.listOf(new ColorUtils().convert(displayCompo))));
        }
    }

    public final boolean setStatusDisplay(@NotNull Player player, @NotNull String status) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(status, "status");
        if (Intrinsics.areEqual(status, "")) {
            ColorUtils colorUtils = new ColorUtils();
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            player.displayName(colorUtils.convert(string));
            ColorUtils colorUtils2 = new ColorUtils();
            String string2 = player.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            player.playerListName(colorUtils2.convert(string2));
            new StatusTeamManager().removePlayer(player);
            StatusConfig statusConfig = new StatusConfig();
            String string3 = player.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            statusConfig.changeValue(string3, "");
            return false;
        }
        if (this.checkBlacklist(status)) {
            Language language = new Language();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            player.sendMessage(language.getMessage(uUID, LangStrings.MODULE_STATUS_BLACKLISTED_STATUS));
            ColorUtils colorUtils = new ColorUtils();
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            player.displayName(colorUtils.convert(string));
            ColorUtils colorUtils3 = new ColorUtils();
            String string4 = player.getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            player.playerListName(colorUtils3.convert(string4));
            new StatusTeamManager().removePlayer(player);
            StatusConfig statusConfig = new StatusConfig();
            String string5 = player.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
            statusConfig.changeValue(string5, "");
            return false;
        }
        Object object = StatusConfig.Companion.getConfig().get("display");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String display = (String)object;
        Placeholder placeholder = new Placeholder();
        Component component = new ColorUtils().convert(display);
        String[] stringArray = new String[]{"status", "playerName"};
        List<String> list = CollectionsKt.listOf(stringArray);
        stringArray = new String[2];
        stringArray[0] = status;
        Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
        Component displayCompo = placeholder.replacer(component, list, CollectionsKt.listOf(stringArray));
        String[] stringArray2 = new String[]{"status", "playerName"};
        List<String> list2 = CollectionsKt.listOf(stringArray2);
        stringArray2 = new String[]{status, ""};
        Component displayCompoNameTag = new Placeholder().replacer(new ColorUtils().convert(display), list2, CollectionsKt.listOf(stringArray2));
        player.displayName(displayCompo);
        player.playerListName(displayCompo);
        new StatusTeamManager().addPlayer(player, displayCompoNameTag);
        StatusConfig statusConfig = new StatusConfig();
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        statusConfig.changeValue(string, status);
        return true;
    }

    @NotNull
    public final Collection<String> generateDefaultStatus() {
        Object object = StatusConfig.Companion.getConfig().get("defaultStatus");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        return (List)object;
    }

    private final boolean checkBlacklist(String status) {
        Object object = StatusConfig.Companion.getConfig().get("blacklist");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        List blacklist = (List)object;
        return blacklist.contains(status);
    }
}

