/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.waypoints;

import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.BukkitExecutable;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.StringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.CommandArguments;
import dev.jorel.commandapi.executors.PlayerCommandExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.mods.waypoints.WaypointPath;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.configs.waypoints.WaypointConfig;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lyv/tils/smp/mods/waypoints/WaypointCommand;", "", "<init>", "()V", "command", "", "getCommand", "()Lkotlin/Unit;", "Lkotlin/Unit;", "handleCommand", "player", "Lorg/bukkit/entity/Player;", "args", "Ldev/jorel/commandapi/executors/CommandArguments;", "createWaypoint", "name", "", "visibility", "location", "Lorg/bukkit/Location;", "deleteWaypoint", "navigateWaypoints", "checkWaypoint", "", "generateSuggestions", "Ljava/util/concurrent/CompletableFuture;", "", "Ldev/jorel/commandapi/IStringTooltip;", "suggestionInfo", "Ldev/jorel/commandapi/SuggestionInfo;", "Lorg/bukkit/command/CommandSender;", "YVtils-SMP_paper"})
@SourceDebugExtension(value={"SMAP\nWaypointCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointCommand.kt\nyv/tils/smp/mods/waypoints/WaypointCommand\n+ 2 CommandTreeDSL.kt\ndev/jorel/commandapi/kotlindsl/CommandTreeDSLKt\n+ 3 ExecutorDSL.kt\ndev/jorel/commandapi/kotlindsl/ExecutorDSLKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n10#2:231\n49#2:232\n151#2:233\n151#2:234\n58#3,3:235\n1#4:238\n*S KotlinDebug\n*F\n+ 1 WaypointCommand.kt\nyv/tils/smp/mods/waypoints/WaypointCommand\n*L\n21#1:231\n26#1:232\n35#1:233\n40#1:234\n45#1:235,3\n*E\n"})
public final class WaypointCommand {
    @NotNull
    private final Unit command;

    /*
     * WARNING - void declaration
     */
    public WaypointCommand() {
        void $this$command_u24lambda_u240_u240_u240_u241;
        void $this$stringArgument$iv;
        void nodeName$iv;
        void $this$command_u24lambda_u240_u240_u240;
        void $this$stringArgument$iv2;
        void nodeName$iv2;
        void $this$command_u24lambda_u240_u240;
        void $this$stringArgument$iv3;
        void nodeName$iv3;
        void $this$command_u24lambda_u240;
        CommandTree commandTree2;
        String name$iv = "waypoint";
        boolean $i$f$commandTree = false;
        CommandTree commandTree3 = commandTree2 = new CommandTree(name$iv);
        WaypointCommand waypointCommand = this;
        boolean bl = false;
        $this$command_u24lambda_u240.withPermission("yvtils.smp.command.waypoint");
        String[] stringArray = new String[]{"waypoint <create/delete/navigate> <name> [visibility]"};
        $this$command_u24lambda_u240.withUsage(stringArray);
        stringArray = new String[]{"position", "pos", "wp"};
        $this$command_u24lambda_u240.withAliases(stringArray);
        stringArray = $this$command_u24lambda_u240;
        String string = "action";
        boolean optional$iv = false;
        boolean $i$f$stringArgument = false;
        Object Impl2 = new StringArgument((String)nodeName$iv3).setOptional(optional$iv);
        Argument argument2 = (Argument)Impl2;
        void var12_13 = $this$stringArgument$iv3;
        boolean bl2 = false;
        String[] stringArray2 = new String[]{"create", "delete", "navigate"};
        $this$command_u24lambda_u240_u240.replaceSuggestions(ArgumentSuggestions.strings(stringArray2));
        stringArray2 = $this$command_u24lambda_u240_u240;
        String string2 = "name";
        boolean optional$iv2 = false;
        boolean $i$f$stringArgument2 = false;
        Object Impl3 = new StringArgument((String)nodeName$iv2).setOptional(optional$iv2);
        Argument argument3 = (Argument)Impl3;
        void var20_21 = $this$stringArgument$iv2;
        boolean bl3 = false;
        $this$command_u24lambda_u240_u240_u240.replaceSuggestions(ArgumentSuggestions.stringsWithTooltipsCollectionAsync(arg_0 -> WaypointCommand.command$lambda$0$0$0$0(this, arg_0)));
        void var22_23 = $this$command_u24lambda_u240_u240_u240;
        String string3 = "visibility";
        boolean optional$iv3 = true;
        boolean $i$f$stringArgument3 = false;
        Object Impl4 = new StringArgument((String)nodeName$iv).setOptional(optional$iv3);
        Argument argument4 = (Argument)Impl4;
        void var28_29 = $this$stringArgument$iv;
        boolean bl4 = false;
        String[] stringArray3 = new String[]{"public", "private", "unlisted"};
        $this$command_u24lambda_u240_u240_u240_u241.replaceSuggestions(ArgumentSuggestions.strings(stringArray3));
        BukkitExecutable $this$playerExecutor$iv = (BukkitExecutable)$this$command_u24lambda_u240_u240_u240_u241;
        boolean $i$f$playerExecutor = false;
        Intrinsics.checkNotNullExpressionValue($this$playerExecutor$iv.executesPlayer(new PlayerCommandExecutor(this){
            final /* synthetic */ WaypointCommand this$0;
            {
                this.this$0 = waypointCommand;
            }

            /*
             * WARNING - void declaration
             */
            public final void run(Player sender, CommandArguments args) {
                void args2;
                Intrinsics.checkNotNull(sender);
                Intrinsics.checkNotNull(args);
                CommandArguments commandArguments = args;
                Player sender2 = sender;
                boolean bl = false;
                WaypointCommand.access$handleCommand(this.this$0, sender2, (CommandArguments)args2);
            }
        }), "executesPlayer(...)");
        Object Impl5 = var28_29.then((AbstractArgumentTree)Impl4);
        Intrinsics.checkNotNullExpressionValue(Impl5, "then(...)");
        Argument cfr_ignored_0 = (Argument)Impl5;
        Object Impl6 = var20_21.then((AbstractArgumentTree)Impl3);
        Intrinsics.checkNotNullExpressionValue(Impl6, "then(...)");
        Argument cfr_ignored_1 = (Argument)Impl6;
        Object Impl7 = var12_13.then((AbstractArgumentTree)Impl2);
        Intrinsics.checkNotNullExpressionValue(Impl7, "then(...)");
        CommandTree cfr_ignored_2 = (CommandTree)Impl7;
        commandTree2.register();
        waypointCommand.command = Unit.INSTANCE;
    }

    @NotNull
    public final Unit getCommand() {
        return this.command;
    }

    private final void handleCommand(Player player, CommandArguments args) {
        Object object = args.get(0);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String action = (String)object;
        Object object2 = args.get(1);
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.String");
        String name = (String)object2;
        String string = (String)args.get(2);
        if (string == null) {
            string = "private";
        }
        String visibility = string;
        switch (action) {
            case "create": {
                if (!this.checkWaypoint(player, name)) {
                    WaypointCommand.createWaypoint$default(this, player, name, visibility, null, 8, null);
                    break;
                }
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_ALREADY_EXISTS), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
                break;
            }
            case "delete": {
                if (this.checkWaypoint(player, name)) {
                    WaypointConfig waypointConfig = new WaypointConfig();
                    String string2 = player.getUniqueId().toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                    if (!waypointConfig.requestCreator(string2, name)) {
                        Placeholder placeholder = new Placeholder();
                        Language language = new Language();
                        UUID uUID = player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                        player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_DELETE_NOT_ALLOWED), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
                        return;
                    }
                    this.deleteWaypoint(player, name);
                    break;
                }
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_NOT_FOUND), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
                break;
            }
            case "navigate": {
                if (this.checkWaypoint(player, name)) {
                    this.navigateWaypoints(player, name);
                    break;
                }
                if (WaypointPath.Companion.getNavigatingPlayers().containsKey(player)) {
                    WaypointPath.NaviData naviData = WaypointPath.Companion.getNavigatingPlayers().get(player);
                    Double x = naviData != null && (naviData = naviData.getLocation()) != null ? Double.valueOf(naviData.getX()) : null;
                    WaypointPath.NaviData naviData2 = WaypointPath.Companion.getNavigatingPlayers().get(player);
                    Double y = naviData2 != null && (naviData2 = naviData2.getLocation()) != null ? Double.valueOf(naviData2.getY()) : null;
                    WaypointPath.NaviData naviData3 = WaypointPath.Companion.getNavigatingPlayers().get(player);
                    Double z = naviData3 != null && (naviData3 = naviData3.getLocation()) != null ? Double.valueOf(naviData3.getZ()) : null;
                    WaypointPath.NaviData naviData4 = WaypointPath.Companion.getNavigatingPlayers().get(player);
                    String world = naviData4 != null && (naviData4 = naviData4.getLocation()) != null && (naviData4 = naviData4.getWorld()) != null ? naviData4.getName() : null;
                    WaypointPath waypointPath = new WaypointPath();
                    Double d = x;
                    Intrinsics.checkNotNull(d);
                    double d2 = d;
                    Double d3 = y;
                    Intrinsics.checkNotNull(d3);
                    double d4 = d3;
                    Double d5 = z;
                    Intrinsics.checkNotNull(d5);
                    double d6 = d5;
                    String string3 = world;
                    Intrinsics.checkNotNull(string3);
                    waypointPath.generatePath(player, d2, d4, d6, string3, name);
                    return;
                }
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_NOT_FOUND), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
            }
        }
    }

    private final void createWaypoint(Player player, String name, String visibility, Location location) {
        WaypointConfig waypointConfig = new WaypointConfig();
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        double d = location.getX();
        double d2 = location.getY();
        double d3 = location.getZ();
        String string2 = location.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        waypointConfig.addWaypoint(string, name, visibility, d, d2, d3, string2);
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_CREATED), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
    }

    static /* synthetic */ void createWaypoint$default(WaypointCommand waypointCommand, Player player, String string, String string2, Location location, int n, Object object) {
        if ((n & 8) != 0) {
            Location location2 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            location = location2;
        }
        waypointCommand.createWaypoint(player, string, string2, location);
    }

    private final void deleteWaypoint(Player player, String name) {
        WaypointConfig waypointConfig = new WaypointConfig();
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        waypointConfig.removeWaypoint(string, name);
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_DELETED), MapsKt.mapOf(TuplesKt.to("waypoint", name))));
    }

    private final void navigateWaypoints(Player player, String name) {
        block15: {
            List<WaypointConfig.Companion.Waypoint> list;
            block20: {
                block19: {
                    Object v10;
                    block11: {
                        String visibility;
                        block16: {
                            List<WaypointConfig.Companion.Waypoint> list2;
                            block18: {
                                block17: {
                                    Object v7;
                                    block10: {
                                        block12: {
                                            List<WaypointConfig.Companion.Waypoint> list3;
                                            block14: {
                                                block13: {
                                                    Object v4;
                                                    block9: {
                                                        WaypointConfig waypointConfig = new WaypointConfig();
                                                        String string = player.getUniqueId().toString();
                                                        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                                                        visibility = waypointConfig.requestVisibility(string, name);
                                                        String string2 = visibility.toLowerCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                                                        if (!Intrinsics.areEqual(string2, "public")) break block12;
                                                        list3 = WaypointConfig.Companion.getWaypoints().get("PUBLIC");
                                                        if (list3 == null) break block13;
                                                        Iterable iterable = list3;
                                                        for (Object t : iterable) {
                                                            WaypointConfig.Companion.Waypoint it = (WaypointConfig.Companion.Waypoint)t;
                                                            boolean bl = false;
                                                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                                                            v4 = t;
                                                            break block9;
                                                        }
                                                        v4 = null;
                                                    }
                                                    if ((list3 = (WaypointConfig.Companion.Waypoint)v4) != null) break block14;
                                                }
                                                return;
                                            }
                                            List<WaypointConfig.Companion.Waypoint> waypoint = list3;
                                            new WaypointPath().generatePath(player, ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getX(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getY(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getZ(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getWorld(), name);
                                            break block15;
                                        }
                                        String string = visibility.toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                                        if (!Intrinsics.areEqual(string, "private")) break block16;
                                        list2 = WaypointConfig.Companion.getWaypoints().get(player.getUniqueId().toString());
                                        if (list2 == null) break block17;
                                        Iterable iterable = list2;
                                        for (Object t : iterable) {
                                            WaypointConfig.Companion.Waypoint it = (WaypointConfig.Companion.Waypoint)t;
                                            boolean bl = false;
                                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                                            v7 = t;
                                            break block10;
                                        }
                                        v7 = null;
                                    }
                                    if ((list2 = (WaypointConfig.Companion.Waypoint)v7) != null) break block18;
                                }
                                return;
                            }
                            List<WaypointConfig.Companion.Waypoint> waypoint = list2;
                            new WaypointPath().generatePath(player, ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getX(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getY(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getZ(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getWorld(), name);
                            break block15;
                        }
                        String string = visibility.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        if (!Intrinsics.areEqual(string, "unlisted")) break block15;
                        list = WaypointConfig.Companion.getWaypoints().get("UNLISTED");
                        if (list == null) break block19;
                        Iterable iterable = list;
                        for (Object t : iterable) {
                            WaypointConfig.Companion.Waypoint it = (WaypointConfig.Companion.Waypoint)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                            v10 = t;
                            break block11;
                        }
                        v10 = null;
                    }
                    if ((list = (WaypointConfig.Companion.Waypoint)v10) != null) break block20;
                }
                return;
            }
            List<WaypointConfig.Companion.Waypoint> waypoint = list;
            new WaypointPath().generatePath(player, ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getX(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getY(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getZ(), ((WaypointConfig.Companion.Waypoint)((Object)waypoint)).getWorld(), name);
        }
    }

    private final boolean checkWaypoint(Player player, String name) {
        List<WaypointConfig.Companion.Waypoint> list;
        List<WaypointConfig.Companion.Waypoint> publicWaypoints;
        List<WaypointConfig.Companion.Waypoint> playerWaypoints = WaypointConfig.Companion.getWaypoints().get(player.getUniqueId().toString());
        if (playerWaypoints != null) {
            for (WaypointConfig.Companion.Waypoint waypoint : playerWaypoints) {
                if (!Intrinsics.areEqual(waypoint.getName(), name)) continue;
                return true;
            }
        }
        if ((publicWaypoints = WaypointConfig.Companion.getWaypoints().get("PUBLIC")) != null) {
            for (WaypointConfig.Companion.Waypoint waypoint : publicWaypoints) {
                if (!Intrinsics.areEqual(waypoint.getName(), name)) continue;
                return true;
            }
        }
        if ((list = WaypointConfig.Companion.getWaypoints().get("UNLISTED")) != null) {
            for (WaypointConfig.Companion.Waypoint waypoint : list) {
                if (!Intrinsics.areEqual(waypoint.getName(), name)) continue;
                return true;
            }
        }
        return false;
    }

    private final CompletableFuture<Collection<IStringTooltip>> generateSuggestions(SuggestionInfo<CommandSender> suggestionInfo) {
        CompletableFuture<Collection<IStringTooltip>> completableFuture = CompletableFuture.supplyAsync(() -> WaypointCommand.generateSuggestions$lambda$0(suggestionInfo));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    private static final CompletableFuture command$lambda$0$0$0$0(WaypointCommand this$0, SuggestionInfo it) {
        Intrinsics.checkNotNull(it);
        return this$0.generateSuggestions(it);
    }

    private static final Collection generateSuggestions$lambda$0(SuggestionInfo $suggestionInfo) {
        List waypointSuggestions;
        block4: {
            List<WaypointConfig.Companion.Waypoint> publicWaypoints;
            List<WaypointConfig.Companion.Waypoint> playerWaypoints;
            CommandSender player = (CommandSender)$suggestionInfo.sender();
            waypointSuggestions = new ArrayList();
            if (!(player instanceof Player)) {
                return waypointSuggestions;
            }
            Map<String, List<WaypointConfig.Companion.Waypoint>> waypointMap = WaypointConfig.Companion.getWaypoints();
            List<WaypointConfig.Companion.Waypoint> list = playerWaypoints = waypointMap.get(((Player)player).getUniqueId().toString());
            if (list != null) {
                List<WaypointConfig.Companion.Waypoint> it = list;
                boolean bl = false;
                for (WaypointConfig.Companion.Waypoint waypoint : it) {
                    String position = MathKt.roundToInt(waypoint.getX()) + " " + MathKt.roundToInt(waypoint.getY()) + " " + MathKt.roundToInt(waypoint.getZ()) + " | " + waypoint.getWorld();
                    StringTooltip stringTooltip = StringTooltip.ofString(waypoint.getName(), position);
                    Intrinsics.checkNotNullExpressionValue(stringTooltip, "ofString(...)");
                    waypointSuggestions.add(stringTooltip);
                }
            }
            List<WaypointConfig.Companion.Waypoint> list2 = publicWaypoints = waypointMap.get("PUBLIC");
            if (list2 == null) break block4;
            List<WaypointConfig.Companion.Waypoint> it = list2;
            boolean bl = false;
            for (WaypointConfig.Companion.Waypoint waypoint : it) {
                String position = MathKt.roundToInt(waypoint.getX()) + " " + MathKt.roundToInt(waypoint.getY()) + " " + MathKt.roundToInt(waypoint.getZ()) + " | " + waypoint.getWorld();
                StringTooltip stringTooltip = StringTooltip.ofString(waypoint.getName(), position);
                Intrinsics.checkNotNullExpressionValue(stringTooltip, "ofString(...)");
                waypointSuggestions.add(stringTooltip);
            }
        }
        return waypointSuggestions;
    }

    public static final /* synthetic */ void access$handleCommand(WaypointCommand $this, Player player, CommandArguments args) {
        $this.handleCommand(player, args);
    }
}

