/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.mods.waypoints;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J(\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0006\u0010!\u001a\u00020\u0005J\b\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0017H\u0002\u00a8\u0006&"}, d2={"Lyv/tils/smp/mods/waypoints/WaypointPath;", "", "<init>", "()V", "generatePath", "", "player", "Lorg/bukkit/entity/Player;", "x", "", "y", "z", "worldName", "", "waypointName", "navigate", "location", "Lorg/bukkit/Location;", "generateActionbar", "currentLoc", "targetLoc", "direction", "spawnEndCrystal", "Lorg/bukkit/entity/EnderCrystal;", "spawnParticle", "spawnSideParticles", "currentParticleLoc", "initialY", "movingUp", "", "spawnParticlesAtY", "handleCrystalRemoval", "endCrystal", "stopNavigations", "runNavigationStopTasks", "removeCrystal", "Companion", "NaviData", "YVtils-SMP_paper"})
public final class WaypointPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<EnderCrystal> crystalList = new ArrayList();
    @NotNull
    private static final Map<Player, NaviData> navigatingPlayers = new LinkedHashMap();

    public final void generatePath(@NotNull Player player, double x, double y, double z, @NotNull String worldName, @NotNull String waypointName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(waypointName, "waypointName");
        World world = Bukkit.getWorld((String)worldName);
        Location location = new Location(world, x, y, z);
        if (navigatingPlayers.containsKey(player)) {
            NaviData naviData;
            NaviData naviData2 = navigatingPlayers.get(player);
            if (Intrinsics.areEqual(naviData2 != null ? naviData2.getLocation() : null, location)) {
                NaviData naviData3;
                NaviData naviData4 = navigatingPlayers.get(player);
                if (naviData4 != null && (naviData4 = naviData4.getTask()) != null) {
                    naviData4.cancel();
                }
                if ((naviData3 = navigatingPlayers.get(player)) != null && (naviData3 = naviData3.getEndCrystal()) != null) {
                    naviData3.remove();
                }
                navigatingPlayers.remove(player);
                Placeholder placeholder = new Placeholder();
                Language language = new Language();
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_NAVIGATE_STOPPED), MapsKt.mapOf(TuplesKt.to("waypoint", waypointName))));
                return;
            }
            NaviData naviData5 = navigatingPlayers.get(player);
            if (naviData5 != null && (naviData5 = naviData5.getTask()) != null) {
                naviData5.cancel();
            }
            if ((naviData = navigatingPlayers.get(player)) != null && (naviData = naviData.getEndCrystal()) != null) {
                naviData.remove();
            }
            navigatingPlayers.remove(player);
        }
        this.navigate(player, location, waypointName);
        Placeholder placeholder = new Placeholder();
        Language language = new Language();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_NAVIGATE_STARTED), MapsKt.mapOf(TuplesKt.to("waypoint", waypointName))));
    }

    private final void navigate(Player player, Location location, String waypointName) {
        EnderCrystal endCrystal = this.spawnEndCrystal(player, location);
        BukkitTask bukkitTask = new BukkitRunnable(this, player, location, endCrystal, waypointName){
            final /* synthetic */ WaypointPath this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ Location $location;
            final /* synthetic */ EnderCrystal $endCrystal;
            final /* synthetic */ String $waypointName;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$location = $location;
                this.$endCrystal = $endCrystal;
                this.$waypointName = $waypointName;
            }

            public void run() {
                Location location = this.$player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                WaypointPath.access$spawnParticle(this.this$0, this.$player, location, this.$location);
                Location location2 = this.$player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
                WaypointPath.access$generateActionbar(this.this$0, this.$player, location2, this.$location);
                if (Intrinsics.areEqual(this.$location.getWorld(), this.$player.getLocation().getWorld()) && this.$location.distance(this.$player.getLocation()) < 10.0) {
                    WaypointPath.access$handleCrystalRemoval(this.this$0, this.$endCrystal);
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID = this.$player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    this.$player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.MODULE_WAYPOINT_NAVIGATE_FINISHED), MapsKt.mapOf(TuplesKt.to("waypoint", this.$waypointName))));
                    WaypointPath.Companion.getNavigatingPlayers().remove(this.$player);
                    this.cancel();
                    return;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)YVtils.Companion.getInstance(), 0L, 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        BukkitTask task2 = bukkitTask;
        navigatingPlayers.put(player, new NaviData(player, location, endCrystal, task2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void generateActionbar(Player player, Location currentLoc, Location targetLoc) {
        if (Intrinsics.areEqual(currentLoc.getWorld(), targetLoc.getWorld())) {
            double distance = currentLoc.distance(targetLoc);
            String direction = this.direction(currentLoc, targetLoc);
            player.sendActionBar(new ColorUtils().convert("<green>" + direction + " <white>| <yellow>" + (int)distance + "<white>m <white>| <green>" + direction + "<white>"));
            return;
        }
        Location dimensionLoc = null;
        if (Intrinsics.areEqual(currentLoc.getWorld(), Bukkit.getWorld((String)"world"))) {
            if (!Intrinsics.areEqual(targetLoc.getWorld(), Bukkit.getWorld((String)"world_nether"))) {
                player.sendActionBar(new ColorUtils().convert(""));
                return;
            }
            dimensionLoc = targetLoc.clone().set(targetLoc.getX() * (double)8, targetLoc.getY(), targetLoc.getZ() * (double)8);
            dimensionLoc.setWorld(Bukkit.getWorld((String)"world"));
        } else if (Intrinsics.areEqual(currentLoc.getWorld(), Bukkit.getWorld((String)"world_nether"))) {
            if (!Intrinsics.areEqual(targetLoc.getWorld(), Bukkit.getWorld((String)"world"))) {
                player.sendActionBar(new ColorUtils().convert(""));
                return;
            }
            dimensionLoc = targetLoc.clone().set(targetLoc.getX() / (double)8, targetLoc.getY(), targetLoc.getZ() / (double)8);
            dimensionLoc.setWorld(Bukkit.getWorld((String)"world_nether"));
        } else {
            if (!Intrinsics.areEqual(currentLoc.getWorld(), Bukkit.getWorld((String)"world_the_end"))) {
                player.sendActionBar(new ColorUtils().convert(""));
                return;
            }
            dimensionLoc = targetLoc.clone().set(0.0, 0.0, 0.0);
            dimensionLoc.setWorld(Bukkit.getWorld((String)"world_the_end"));
        }
        double distance = currentLoc.distance(dimensionLoc);
        String direction = this.direction(currentLoc, dimensionLoc);
        player.sendActionBar(new ColorUtils().convert("<green>" + direction + " <white>| <yellow>" + (int)distance + "<white>m <white>| <green>" + direction + "<white>"));
    }

    private final String direction(Location currentLoc, Location targetLoc) {
        String string;
        block1: {
            double d;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                block2: {
                                    block0: {
                                        double x = targetLoc.getX() - currentLoc.getX();
                                        double z = targetLoc.getZ() - currentLoc.getZ();
                                        double angle = Math.toDegrees(Math.atan2(z, x)) - (double)currentLoc.getYaw();
                                        d = angle = ((angle + (double)180) % (double)360 + (double)360) % (double)360 - (double)180;
                                        boolean bl = -22.5 <= d ? d <= 22.5 : false;
                                        if (!bl) break block0;
                                        string = "\u2190";
                                        break block1;
                                    }
                                    boolean bl = 22.5 <= d ? d <= 67.5 : false;
                                    if (!bl) break block2;
                                    string = "\u2196";
                                    break block1;
                                }
                                boolean bl = 67.5 <= d ? d <= 112.5 : false;
                                if (!bl) break block3;
                                string = "\u2191";
                                break block1;
                            }
                            boolean bl = 112.5 <= d ? d <= 157.5 : false;
                            if (!bl) break block4;
                            string = "\u2197";
                            break block1;
                        }
                        if (157.5 <= d ? d <= 180.0 : false) break block5;
                        boolean bl = -180.0 <= d ? d <= -157.5 : false;
                        if (!bl) break block6;
                    }
                    string = "\u2192";
                    break block1;
                }
                boolean bl = -157.5 <= d ? d <= -112.5 : false;
                if (!bl) break block7;
                string = "\u2198";
                break block1;
            }
            string = (-112.5 <= d ? d <= -67.5 : false) ? "\u2193" : ((-67.5 <= d ? d <= -22.5 : false) ? "\u2199" : "\u2191");
        }
        return string;
    }

    private final EnderCrystal spawnEndCrystal(Player player, Location location) {
        World world = location.getWorld();
        Location location2 = location.clone().set(location.getX(), location.getY(), location.getZ());
        Intrinsics.checkNotNullExpressionValue(location2, "set(...)");
        Location spawnLocation = location2;
        while (spawnLocation.getBlock().isPassable()) {
            while (spawnLocation.getBlock().isPassable()) {
                spawnLocation.subtract(0.0, 1.0, 0.0);
            }
            spawnLocation.subtract(0.0, 5.0, 0.0);
        }
        Location location3 = location.clone().add(0.0, 500.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
        Location beamTarget = location3;
        Entity entity = world.spawnEntity(spawnLocation, EntityType.END_CRYSTAL);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.EnderCrystal");
        EnderCrystal endCrystal = (EnderCrystal)entity;
        endCrystal.setShowingBottom(false);
        endCrystal.setInvulnerable(true);
        endCrystal.setBeamTarget(beamTarget);
        endCrystal.setInvisible(false);
        endCrystal.setGlowing(true);
        endCrystal.setSilent(true);
        for (Player playerLoop : Bukkit.getOnlinePlayers()) {
            playerLoop.hideEntity((Plugin)YVtils.Companion.getInstance(), (Entity)endCrystal);
        }
        player.showEntity((Plugin)YVtils.Companion.getInstance(), (Entity)endCrystal);
        Team team = player.getScoreboard().getTeam("waypoint");
        if (team == null) {
            team = player.getScoreboard().registerNewTeam("waypoint");
            team.color(NamedTextColor.GREEN);
        }
        team.addEntry(endCrystal.getUniqueId().toString());
        crystalList.add(endCrystal);
        return endCrystal;
    }

    private final void spawnParticle(Player player, Location currentLoc, Location targetLoc) {
        if (!Intrinsics.areEqual(currentLoc.getWorld(), targetLoc.getWorld())) {
            return;
        }
        Location location = currentLoc.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location start = location;
        Location location2 = targetLoc.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location end = location2;
        double distance = start.distance(end);
        int particles = 3 * (int)distance;
        Vector vector = end.toVector().subtract(start.toVector()).normalize();
        Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
        Vector direction = vector;
        Vector vector2 = direction.multiply(distance / (double)particles);
        Intrinsics.checkNotNullExpressionValue(vector2, "multiply(...)");
        Vector step = vector2;
        Location location3 = start.clone();
        Intrinsics.checkNotNullExpressionValue(location3, "clone(...)");
        Location currentParticleLoc = location3;
        for (int i = 0; i < particles; ++i) {
            Block blockBelow;
            currentParticleLoc.add(step);
            if (!currentParticleLoc.isChunkLoaded()) break;
            if (!currentParticleLoc.getBlock().isPassable()) {
                initialY = currentParticleLoc.getY();
                while (!currentParticleLoc.getBlock().isPassable()) {
                    currentParticleLoc.setY(currentParticleLoc.getY() + 0.1);
                    this.spawnSideParticles(player, currentParticleLoc, initialY, true);
                }
            } else {
                initialY = currentParticleLoc.getY();
                while (currentParticleLoc.getBlock().isPassable()) {
                    currentParticleLoc.setY(currentParticleLoc.getY() - 0.1);
                }
                currentParticleLoc.setY(currentParticleLoc.getY() + 0.3);
                this.spawnSideParticles(player, currentParticleLoc, initialY, false);
            }
            Intrinsics.checkNotNullExpressionValue(currentParticleLoc.clone().add(0.0, -0.1, 0.0).getBlock(), "getBlock(...)");
            if (!blockBelow.isPassable()) {
                currentParticleLoc.setY((double)blockBelow.getY() + 1.0);
            }
            player.spawnParticle(Particle.END_ROD, currentParticleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void spawnSideParticles(Player player, Location currentParticleLoc, double initialY, boolean movingUp) {
        double stepY = 0.1;
        double y = initialY;
        if (movingUp) {
            while (y < currentParticleLoc.getY()) {
                this.spawnParticlesAtY(player, currentParticleLoc, y += stepY);
            }
        } else {
            while (y > currentParticleLoc.getY()) {
                this.spawnParticlesAtY(player, currentParticleLoc, y -= stepY);
            }
        }
    }

    private final void spawnParticlesAtY(Player player, Location currentParticleLoc, double y) {
        Location location = currentParticleLoc.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location particleLoc = location;
        particleLoc.setY(y);
        double offset = 0.1;
        Vector[] vectorArray = new Vector[]{new Vector(offset, 0.0, 0.0), new Vector(-offset, 0.0, 0.0), new Vector(0.0, 0.0, offset), new Vector(0.0, 0.0, -offset)};
        for (Vector sideDirection : vectorArray) {
            Location sideParticleLoc;
            Intrinsics.checkNotNullExpressionValue(particleLoc.clone().add(sideDirection), "add(...)");
            if (!sideParticleLoc.getBlock().isPassable()) continue;
            player.spawnParticle(Particle.END_ROD, sideParticleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void handleCrystalRemoval(EnderCrystal endCrystal) {
        Bukkit.getScheduler().runTask((Plugin)YVtils.Companion.getInstance(), () -> WaypointPath.handleCrystalRemoval$lambda$0(this, endCrystal));
    }

    public final void stopNavigations() {
        Object object = Config.Companion.getConfig().get("modules.waypoints");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            return;
        }
        if (!YVtils.Companion.getInstance().isEnabled()) {
            this.runNavigationStopTasks();
        } else {
            BukkitTask bukkitTask = new BukkitRunnable(this){
                final /* synthetic */ WaypointPath this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    WaypointPath.access$runNavigationStopTasks(this.this$0);
                }
            }.runTask((Plugin)YVtils.Companion.getInstance());
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    private final void runNavigationStopTasks() {
        List<Player> copyNavigatingPlayers = CollectionsKt.toList((Iterable)navigatingPlayers.keySet());
        for (Player player : copyNavigatingPlayers) {
            NaviData naviData;
            NaviData naviData2 = navigatingPlayers.get(player);
            if (naviData2 != null && (naviData2 = naviData2.getTask()) != null) {
                naviData2.cancel();
            }
            if ((naviData = navigatingPlayers.get(player)) != null && (naviData = naviData.getEndCrystal()) != null) {
                naviData.remove();
            }
            navigatingPlayers.remove(player);
        }
        List<EnderCrystal> copyCrystalList = CollectionsKt.toList((Iterable)crystalList);
        for (EnderCrystal crystal : copyCrystalList) {
            this.removeCrystal(crystal);
        }
    }

    private final void removeCrystal(EnderCrystal endCrystal) {
        block0: {
            Team team;
            endCrystal.remove();
            crystalList.remove(endCrystal);
            Team team2 = team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam("waypoint");
            if (team2 == null) break block0;
            team2.removeEntry(endCrystal.getUniqueId().toString());
        }
    }

    private static final void handleCrystalRemoval$lambda$0(WaypointPath this$0, EnderCrystal $endCrystal) {
        this$0.removeCrystal($endCrystal);
    }

    public static final /* synthetic */ void access$spawnParticle(WaypointPath $this, Player player, Location currentLoc, Location targetLoc) {
        $this.spawnParticle(player, currentLoc, targetLoc);
    }

    public static final /* synthetic */ void access$generateActionbar(WaypointPath $this, Player player, Location currentLoc, Location targetLoc) {
        $this.generateActionbar(player, currentLoc, targetLoc);
    }

    public static final /* synthetic */ void access$handleCrystalRemoval(WaypointPath $this, EnderCrystal endCrystal) {
        $this.handleCrystalRemoval(endCrystal);
    }

    public static final /* synthetic */ void access$runNavigationStopTasks(WaypointPath $this) {
        $this.runNavigationStopTasks();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lyv/tils/smp/mods/waypoints/WaypointPath$Companion;", "", "<init>", "()V", "crystalList", "", "Lorg/bukkit/entity/EnderCrystal;", "getCrystalList", "()Ljava/util/List;", "navigatingPlayers", "", "Lorg/bukkit/entity/Player;", "Lyv/tils/smp/mods/waypoints/WaypointPath$NaviData;", "getNavigatingPlayers", "()Ljava/util/Map;", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<EnderCrystal> getCrystalList() {
            return crystalList;
        }

        @NotNull
        public final Map<Player, NaviData> getNavigatingPlayers() {
            return navigatingPlayers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lyv/tils/smp/mods/waypoints/WaypointPath$NaviData;", "", "player", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "endCrystal", "Lorg/bukkit/entity/EnderCrystal;", "task", "Lorg/bukkit/scheduler/BukkitTask;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lorg/bukkit/entity/EnderCrystal;Lorg/bukkit/scheduler/BukkitTask;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getLocation", "()Lorg/bukkit/Location;", "getEndCrystal", "()Lorg/bukkit/entity/EnderCrystal;", "getTask", "()Lorg/bukkit/scheduler/BukkitTask;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "YVtils-SMP_paper"})
    public static final class NaviData {
        @NotNull
        private final Player player;
        @NotNull
        private final Location location;
        @NotNull
        private final EnderCrystal endCrystal;
        @NotNull
        private final BukkitTask task;

        public NaviData(@NotNull Player player, @NotNull Location location, @NotNull EnderCrystal endCrystal, @NotNull BukkitTask task2) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(endCrystal, "endCrystal");
            Intrinsics.checkNotNullParameter(task2, "task");
            this.player = player;
            this.location = location;
            this.endCrystal = endCrystal;
            this.task = task2;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        @NotNull
        public final EnderCrystal getEndCrystal() {
            return this.endCrystal;
        }

        @NotNull
        public final BukkitTask getTask() {
            return this.task;
        }

        @NotNull
        public final Player component1() {
            return this.player;
        }

        @NotNull
        public final Location component2() {
            return this.location;
        }

        @NotNull
        public final EnderCrystal component3() {
            return this.endCrystal;
        }

        @NotNull
        public final BukkitTask component4() {
            return this.task;
        }

        @NotNull
        public final NaviData copy(@NotNull Player player, @NotNull Location location, @NotNull EnderCrystal endCrystal, @NotNull BukkitTask task2) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(endCrystal, "endCrystal");
            Intrinsics.checkNotNullParameter(task2, "task");
            return new NaviData(player, location, endCrystal, task2);
        }

        public static /* synthetic */ NaviData copy$default(NaviData naviData, Player player, Location location, EnderCrystal enderCrystal, BukkitTask bukkitTask, int n, Object object) {
            if ((n & 1) != 0) {
                player = naviData.player;
            }
            if ((n & 2) != 0) {
                location = naviData.location;
            }
            if ((n & 4) != 0) {
                enderCrystal = naviData.endCrystal;
            }
            if ((n & 8) != 0) {
                bukkitTask = naviData.task;
            }
            return naviData.copy(player, location, enderCrystal, bukkitTask);
        }

        @NotNull
        public String toString() {
            return "NaviData(player=" + this.player + ", location=" + this.location + ", endCrystal=" + this.endCrystal + ", task=" + this.task + ")";
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = result * 31 + this.location.hashCode();
            result = result * 31 + this.endCrystal.hashCode();
            result = result * 31 + this.task.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NaviData)) {
                return false;
            }
            NaviData naviData = (NaviData)other;
            if (!Intrinsics.areEqual(this.player, naviData.player)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.location, naviData.location)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.endCrystal, naviData.endCrystal)) {
                return false;
            }
            return Intrinsics.areEqual(this.task, naviData.task);
        }
    }
}

