/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0007J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lyv/tils/smp/utils/MojangAPI;", "", "<init>", "()V", "name2uuid", "Ljava/util/UUID;", "playerName", "", "uuid2name", "uuid", "getSkinTextures", "name", "getWebsite", "", "url", "YVtils-SMP_paper"})
public final class MojangAPI {
    @Nullable
    public final UUID name2uuid(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        try {
            String url = "https://api.mojang.com/users/profiles/minecraft/" + playerName;
            Map<String, String> map = this.getWebsite(url);
            String string = map.get("id");
            Intrinsics.checkNotNull(string);
            String string2 = string.substring(0, 8);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String string3 = map.get("id");
            Intrinsics.checkNotNull(string3);
            String string4 = string3.substring(8, 12);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            String string5 = map.get("id");
            Intrinsics.checkNotNull(string5);
            String string6 = string5.substring(12, 16);
            Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
            String string7 = map.get("id");
            Intrinsics.checkNotNull(string7);
            String string8 = string7.substring(16, 20);
            Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
            String string9 = map.get("id");
            Intrinsics.checkNotNull(string9);
            String string10 = string9.substring(20);
            Intrinsics.checkNotNullExpressionValue(string10, "substring(...)");
            map.put("id", string2 + "-" + string4 + "-" + string6 + "-" + string8 + "-" + string10);
            return UUID.fromString(map.get("id"));
        }
        catch (Exception e) {
            YVtils.Companion.getInstance().getLogger().warning(e.getMessage());
            return null;
        }
    }

    @Nullable
    public final String uuid2name(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            String string = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + StringsKt.replace$default(string, "-", "", false, 4, null);
            Map<String, String> map = this.getWebsite(url);
            return map.get("name");
        }
        catch (Exception e) {
            YVtils.Companion.getInstance().getLogger().warning(e.getMessage());
            return null;
        }
    }

    @Nullable
    public final String getSkinTextures(@Nullable UUID uuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (uuid == null && Intrinsics.areEqual(name, "")) {
            return null;
        }
        UUID uUID = uuid;
        if (uUID == null) {
            uUID = this.name2uuid(name);
        }
        UUID uniqueId = uUID;
        try {
            String value;
            String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + StringsKt.replace$default(String.valueOf(uniqueId), "-", "", false, 4, null);
            Map<String, String> map = this.getWebsite(url);
            String string = value = map.get("value");
            value = string != null ? StringsKt.replace$default(string, "]", "", false, 4, null) : null;
            byte[] decoded = Base64.getDecoder().decode(value);
            Intrinsics.checkNotNull(decoded);
            String decodedString = new String(decoded, Charsets.UTF_8);
            String[] stringArray = new String[]{","};
            List splited = StringsKt.split$default((CharSequence)decodedString, stringArray, false, 0, 6, null);
            String textureURL = "";
            for (String s : splited) {
                if (!StringsKt.contains$default((CharSequence)s, "textures", false, 2, null) || !StringsKt.contains$default((CharSequence)s, "SKIN", false, 2, null)) continue;
                String[] stringArray2 = new String[]{"url"};
                String s1 = (String)StringsKt.split$default((CharSequence)s, stringArray2, false, 0, 6, null).get(1);
                stringArray2 = new String[]{"\""};
                textureURL = (String)StringsKt.split$default((CharSequence)s1, stringArray2, false, 0, 6, null).get(2);
            }
            return textureURL;
        }
        catch (Exception e) {
            YVtils.Companion.getInstance().getLogger().warning(e.getMessage());
            return null;
        }
    }

    public static /* synthetic */ String getSkinTextures$default(MojangAPI mojangAPI, UUID uUID, String string, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = null;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return mojangAPI.getSkinTextures(uUID, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> getWebsite(String url) {
        Map map = new HashMap();
        URLConnection uRLConnection = new URI(url).toURL().openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            Object object;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            Closeable closeable = reader;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                it.lines().forEach(arg_0 -> MojangAPI.getWebsite$lambda$0$1(arg_0 -> MojangAPI.getWebsite$lambda$0$0(content, arg_0), arg_0));
                object = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            reader.close();
            connection.disconnect();
            String string = content.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String websiteContent = string;
            object = new String[]{","};
            List list = StringsKt.split$default((CharSequence)websiteContent, (String[])object, false, 0, 6, null);
            object = list.iterator();
            while (object.hasNext()) {
                String string2;
                String s = string2 = (String)object.next();
                s = StringsKt.replace$default(s, "{", "", false, 4, null);
                s = StringsKt.replace$default(s, "}", "", false, 4, null);
                s = StringsKt.replace$default(s, "\"", "", false, 4, null);
                s = StringsKt.replace$default(s, " ", "", false, 4, null);
                Map map2 = map;
                Object object2 = new String[]{":"};
                object2 = StringsKt.split$default((CharSequence)s, object2, false, 0, 6, null).get(0);
                Object object3 = new String[]{":"};
                object3 = StringsKt.split$default((CharSequence)s, object3, false, 0, 6, null).get(1);
                map2.put(object2, object3);
            }
        } else {
            YVtils.Companion.getInstance().getLogger().warning("HTTP request failed with response code: " + responseCode);
        }
        return map;
    }

    private static final Unit getWebsite$lambda$0$0(StringBuilder $content, String line) {
        $content.append(line);
        return Unit.INSTANCE;
    }

    private static final void getWebsite$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

