/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils.configs.language;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.logger.Debugger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lyv/tils/smp/utils/configs/language/Language;", "", "<init>", "()V", "yamlConfiguration", "Lorg/bukkit/configuration/file/YamlConfiguration;", "langList", "", "", "getLanguageFiles", "", "registerStrings", "lang", "getMessage", "Lnet/kyori/adventure/text/Component;", "sender", "Lorg/bukkit/command/CommandSender;", "message", "Lyv/tils/smp/utils/configs/language/LangStrings;", "uuid", "Ljava/util/UUID;", "getRawMessage", "directFormat", "en", "de", "Companion", "YVtils-SMP_paper"})
public final class Language {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private YamlConfiguration yamlConfiguration;
    @NotNull
    private final List<String> langList;
    @NotNull
    private static Map<UUID, Locale> playerLang = new HashMap();
    @NotNull
    private static Map<String, String> config_en = new HashMap();
    @NotNull
    private static Map<String, String> config_de = new HashMap();
    @NotNull
    private static Map<String, String> config_global = new HashMap();

    public Language() {
        String[] stringArray = new String[]{"en", "de"};
        this.langList = CollectionsKt.listOf(stringArray);
    }

    public final void getLanguageFiles() {
        for (String lang : this.langList) {
            File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath() + "/language", lang + ".yml");
            if (!file.exists()) {
                file.createNewFile();
                new Debugger().log("Language File created", "Language file " + lang + ".yml created", "yv.tils.smp.utils.configs.language.Language.getLanguageFiles()");
            }
            this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            this.registerStrings(lang);
        }
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath() + "/language", YVtils.Companion.getInstance().getConfig().getString("language") + ".yml");
        if (file.exists()) {
            this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            this.registerStrings("global");
        } else {
            Debugger debugger = new Debugger();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            debugger.log("Language File not found", string, "yv.tils.smp.utils.configs.language.Language.getLanguageFiles()");
            Bukkit.getConsoleSender().sendMessage(this.directFormat("The set language value can't be used. Falling back to english", "Die gesetzte Sprache kann nicht verwendet werden. Es wird als Alternative Englisch genutzt"));
            config_global = config_en;
        }
    }

    private final void registerStrings(String lang) {
        Map config = new HashMap();
        for (LangStrings string : LangStrings.getEntries()) {
            YamlConfiguration yamlConfiguration = this.yamlConfiguration;
            Intrinsics.checkNotNull(yamlConfiguration);
            String message = yamlConfiguration.getString(string.name());
            config.put(string.name(), String.valueOf(message));
        }
        switch (lang) {
            case "en": {
                config_en = config;
                break;
            }
            case "de": {
                config_de = config;
                break;
            }
            case "global": {
                config_global = config;
            }
        }
    }

    @NotNull
    public final Component getMessage(@NotNull CommandSender sender, @NotNull LangStrings message) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)message, "message");
        if (!(sender instanceof Player)) {
            return this.getMessage(message);
        }
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        return this.getMessage(uuid, message);
    }

    @NotNull
    public final Component getMessage(@NotNull UUID uuid, @NotNull LangStrings message) {
        Locale lang;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter((Object)message, "message");
        Locale locale = lang = playerLang.get(uuid);
        return Intrinsics.areEqual(locale, Locale.GERMANY) ? new ColorUtils().convert(String.valueOf(config_de.get(message.name()))) : (Intrinsics.areEqual(locale, Locale.UK) ? new ColorUtils().convert(String.valueOf(config_en.get(message.name()))) : (Intrinsics.areEqual(locale, Locale.US) ? new ColorUtils().convert(String.valueOf(config_en.get(message.name()))) : (Intrinsics.areEqual(locale, Locale.ENGLISH) ? new ColorUtils().convert(String.valueOf(config_en.get(message.name()))) : new ColorUtils().convert(String.valueOf(config_global.get(message.name()))))));
    }

    @NotNull
    public final Component getMessage(@NotNull LangStrings message) {
        Intrinsics.checkNotNullParameter((Object)message, "message");
        if (config_global.get(message.name()) == null) {
            new Debugger().log("Language String not found", message.name(), "yv.tils.smp.utils.configs.language.Language.getMessage()");
            return new ColorUtils().convert(message.name());
        }
        return new ColorUtils().convert(String.valueOf(config_global.get(message.name())));
    }

    @NotNull
    public final String getRawMessage(@NotNull CommandSender sender, @NotNull LangStrings message) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)message, "message");
        if (!(sender instanceof Player)) {
            return this.getRawMessage(message);
        }
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        return this.getRawMessage(uuid, message);
    }

    @NotNull
    public final String getRawMessage(@NotNull UUID uuid, @NotNull LangStrings message) {
        Locale lang;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter((Object)message, "message");
        Locale locale = lang = playerLang.get(uuid);
        return Intrinsics.areEqual(locale, Locale.GERMANY) ? String.valueOf(config_de.get(message.name())) : (Intrinsics.areEqual(locale, Locale.ENGLISH) ? String.valueOf(config_en.get(message.name())) : String.valueOf(config_global.get(message.name())));
    }

    @NotNull
    public final String getRawMessage(@NotNull LangStrings message) {
        Intrinsics.checkNotNullParameter((Object)message, "message");
        if (config_global.get(message.name()) == null) {
            new Debugger().log("Language String not found", message.name(), "yv.tils.smp.utils.configs.language.Language.getMessage()");
            return message.name();
        }
        return String.valueOf(config_global.get(message.name()));
    }

    @NotNull
    public final Component directFormat(@NotNull String en, @NotNull String de) {
        Intrinsics.checkNotNullParameter(en, "en");
        Intrinsics.checkNotNullParameter(de, "de");
        String s = Intrinsics.areEqual(Config.Companion.getConfig().get("Language"), "en") ? en : (Intrinsics.areEqual(Config.Companion.getConfig().get("Language"), "de") ? de : en);
        return new ColorUtils().convert(s);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lyv/tils/smp/utils/configs/language/Language$Companion;", "", "<init>", "()V", "playerLang", "", "Ljava/util/UUID;", "Ljava/util/Locale;", "getPlayerLang", "()Ljava/util/Map;", "setPlayerLang", "(Ljava/util/Map;)V", "config_en", "", "", "config_de", "config_global", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<UUID, Locale> getPlayerLang() {
            return playerLang;
        }

        public final void setPlayerLang(@NotNull Map<UUID, Locale> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            playerLang = map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

