/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils.configs.waypoints;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.configs.multiMine.MultiMineConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J>\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\"\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lyv/tils/smp/utils/configs/waypoints/WaypointConfig;", "", "<init>", "()V", "loadConfig", "", "loadWaypoints", "addWaypoint", "uuid", "", "name", "visibility", "x", "", "y", "z", "world", "removeWaypoint", "requestVisibility", "requestCreator", "", "addWaypointToList", "waypoint", "Lyv/tils/smp/utils/configs/waypoints/WaypointConfig$Companion$Waypoint;", "Companion", "YVtils-SMP_paper"})
@SourceDebugExtension(value={"SMAP\nWaypointConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointConfig.kt\nyv/tils/smp/utils/configs/waypoints/WaypointConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class WaypointConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> config = new LinkedHashMap();
    @NotNull
    private static final Map<String, List<Companion.Waypoint>> waypoints = new LinkedHashMap();

    public final void loadConfig() {
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "waypoints/config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        for (String key : ymlFile.getKeys(true)) {
            Object object;
            Map<String, Object> map = MultiMineConfig.Companion.getConfig();
            Intrinsics.checkNotNull(ymlFile.get(key), "null cannot be cast to non-null type kotlin.Any");
            map.put(key, object);
        }
        this.loadWaypoints();
    }

    private final void loadWaypoints() {
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "waypoints/save.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        for (String key : ymlFile.getKeys(true)) {
            String visibility;
            if (Intrinsics.areEqual(key, "documentation")) continue;
            Intrinsics.checkNotNull(key);
            String[] stringArray = new String[]{"."};
            if (StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null).size() != 2) continue;
            String uuid = null;
            String name = null;
            try {
                String[] stringArray2 = new String[]{"."};
                uuid = (String)StringsKt.split$default((CharSequence)key, stringArray2, false, 0, 6, null).get(0);
                stringArray2 = new String[]{"."};
                name = (String)StringsKt.split$default((CharSequence)key, stringArray2, false, 0, 6, null).get(1);
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            Intrinsics.checkNotNull(ymlFile.getString(key + ".visibility"));
            double d = ymlFile.getDouble(key + ".x");
            double d2 = ymlFile.getDouble(key + ".y");
            double d3 = ymlFile.getDouble(key + ".z");
            String string = ymlFile.getString(key + ".world");
            Intrinsics.checkNotNull(string);
            Companion.Waypoint waypoint = new Companion.Waypoint(name, visibility, d, d2, d3, string);
            this.addWaypointToList(visibility, waypoint, uuid);
        }
    }

    public final void addWaypoint(@NotNull String uuid, @NotNull String name, @NotNull String visibility, double x, double y, double z, @NotNull String world) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        Intrinsics.checkNotNullParameter(world, "world");
        Companion.Waypoint waypoint = new Companion.Waypoint(name, visibility, x, y, z, world);
        this.addWaypointToList(visibility, waypoint, uuid);
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "waypoints/save.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        ymlFile.set(uuid + "." + name + ".visibility", (Object)visibility);
        ymlFile.set(uuid + "." + name + ".x", (Object)x);
        ymlFile.set(uuid + "." + name + ".y", (Object)y);
        ymlFile.set(uuid + "." + name + ".z", (Object)z);
        ymlFile.set(uuid + "." + name + ".world", (Object)world);
        ymlFile.save(file);
        String string = visibility.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (!Intrinsics.areEqual(string, "public") || Intrinsics.areEqual(config.get("announcePublicWaypoints"), true)) {
            // empty if block
        }
    }

    public final void removeWaypoint(@NotNull String uuid, @NotNull String name) {
        YamlConfiguration ymlFile;
        File file;
        block25: {
            List<Companion.Waypoint> list;
            block30: {
                block29: {
                    Object v11;
                    block21: {
                        String visibility;
                        block26: {
                            List<Companion.Waypoint> list2;
                            block28: {
                                block27: {
                                    Object v7;
                                    block20: {
                                        block22: {
                                            List<Companion.Waypoint> list3;
                                            block24: {
                                                block23: {
                                                    Object v3;
                                                    block19: {
                                                        Intrinsics.checkNotNullParameter(uuid, "uuid");
                                                        Intrinsics.checkNotNullParameter(name, "name");
                                                        file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "waypoints/save.yml");
                                                        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                                                        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
                                                        ymlFile = yamlConfiguration;
                                                        visibility = this.requestVisibility(uuid, name);
                                                        String string = visibility.toLowerCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                                                        if (!Intrinsics.areEqual(string, "public")) break block22;
                                                        list3 = waypoints.get("PUBLIC");
                                                        if (list3 == null) break block23;
                                                        Iterable iterable = list3;
                                                        for (Object t : iterable) {
                                                            Companion.Waypoint it = (Companion.Waypoint)t;
                                                            boolean bl = false;
                                                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                                                            v3 = t;
                                                            break block19;
                                                        }
                                                        v3 = null;
                                                    }
                                                    if ((list3 = (Companion.Waypoint)v3) != null) break block24;
                                                }
                                                return;
                                            }
                                            List<Companion.Waypoint> waypoint = list3;
                                            List<Companion.Waypoint> list4 = waypoints.get("PUBLIC");
                                            if (list4 != null) {
                                                list4.remove(waypoint);
                                            }
                                            break block25;
                                        }
                                        String string = visibility.toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                                        if (!Intrinsics.areEqual(string, "private")) break block26;
                                        list2 = waypoints.get(uuid);
                                        if (list2 == null) break block27;
                                        Iterable iterable = list2;
                                        for (Object t : iterable) {
                                            Companion.Waypoint it = (Companion.Waypoint)t;
                                            boolean bl = false;
                                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                                            v7 = t;
                                            break block20;
                                        }
                                        v7 = null;
                                    }
                                    if ((list2 = (Companion.Waypoint)v7) != null) break block28;
                                }
                                return;
                            }
                            List<Companion.Waypoint> waypoint = list2;
                            List<Companion.Waypoint> list5 = waypoints.get(uuid);
                            if (list5 != null) {
                                list5.remove(waypoint);
                            }
                            break block25;
                        }
                        String string = visibility.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        if (!Intrinsics.areEqual(string, "unlisted")) break block25;
                        list = waypoints.get("UNLISTED");
                        if (list == null) break block29;
                        Iterable iterable = list;
                        for (Object t : iterable) {
                            Companion.Waypoint it = (Companion.Waypoint)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                            v11 = t;
                            break block21;
                        }
                        v11 = null;
                    }
                    if ((list = (Companion.Waypoint)v11) != null) break block30;
                }
                return;
            }
            List<Companion.Waypoint> waypoint = list;
            List<Companion.Waypoint> list6 = waypoints.get("UNLISTED");
            if (list6 != null) {
                list6.remove(waypoint);
            }
            List<Companion.Waypoint> list7 = waypoints.get(uuid);
            if (list7 != null) {
                list7.remove(waypoint);
            }
        }
        ymlFile.set(uuid + "." + name, null);
        ymlFile.save(file);
    }

    @NotNull
    public final String requestVisibility(@NotNull String uuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            List<Companion.Waypoint> list;
            block18: {
                Object object;
                block17: {
                    Iterable iterable;
                    block14: {
                        list = waypoints.get("PUBLIC");
                        if (list == null) break block17;
                        Iterable iterable2 = list;
                        for (Iterable iterable3 : iterable2) {
                            Companion.Waypoint it = (Companion.Waypoint)((Object)iterable3);
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                            iterable = iterable3;
                            break block14;
                        }
                        iterable = null;
                    }
                    if ((list = (Companion.Waypoint)((Object)iterable)) != null) break block18;
                }
                List<Companion.Waypoint> list2 = waypoints.get("UNLISTED");
                if (list2 != null) {
                    Object v3;
                    block15: {
                        Iterable iterable3;
                        iterable3 = list2;
                        for (Object t : iterable3) {
                            Companion.Waypoint it = (Companion.Waypoint)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                            v3 = t;
                            break block15;
                        }
                        v3 = null;
                    }
                    object = v3;
                } else {
                    object = list = null;
                }
                if (object == null) {
                    return "private";
                }
            }
            List<Companion.Waypoint> waypoint = list;
            return ((Companion.Waypoint)((Object)waypoint)).getVisibility();
        }
        catch (NullPointerException nullPointerException) {
            List<Companion.Waypoint> list;
            block20: {
                block19: {
                    Object v6;
                    block16: {
                        list = waypoints.get(uuid);
                        if (list == null) break block19;
                        Iterable iterable = list;
                        for (Object t : iterable) {
                            Companion.Waypoint it = (Companion.Waypoint)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getName(), name)) continue;
                            v6 = t;
                            break block16;
                        }
                        v6 = null;
                    }
                    if ((list = (Companion.Waypoint)v6) != null) break block20;
                }
                return "private";
            }
            List<Companion.Waypoint> waypoint = list;
            return ((Companion.Waypoint)((Object)waypoint)).getVisibility();
        }
    }

    public final boolean requestCreator(@NotNull String uuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(name, "name");
        File file = new File(YVtils.Companion.getInstance().getDataFolder().getPath(), "waypoints/save.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration ymlFile = yamlConfiguration;
        return ymlFile.getString(uuid + "." + name) != null;
    }

    private final void addWaypointToList(String visibility, Companion.Waypoint waypoint, String uuid) {
        List<Companion.Waypoint> currentPublicWaypoints = waypoints.get("PUBLIC");
        List<Companion.Waypoint> currentUnlistedWaypoints = waypoints.get("UNLISTED");
        List<Companion.Waypoint> currentPrivateWaypoints = waypoints.get(uuid);
        String string = visibility.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (Intrinsics.areEqual(string, "public")) {
            if (currentPublicWaypoints != null) {
                currentPublicWaypoints.add(waypoint);
            } else {
                Map<String, List<Companion.Waypoint>> map = waypoints;
                String string2 = "PUBLIC";
                Object object = new Companion.Waypoint[]{waypoint};
                object = CollectionsKt.mutableListOf(object);
                map.put(string2, (List<Companion.Waypoint>)object);
            }
        } else {
            String string3 = visibility.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (Intrinsics.areEqual(string3, "unlisted")) {
                Object object;
                Map<String, List<Companion.Waypoint>> map;
                if (currentUnlistedWaypoints != null) {
                    currentUnlistedWaypoints.add(waypoint);
                } else {
                    map = waypoints;
                    object = "UNLISTED";
                    Object object2 = new Companion.Waypoint[]{waypoint};
                    object2 = CollectionsKt.mutableListOf(object2);
                    map.put((String)object, (List<Companion.Waypoint>)object2);
                }
                if (currentPrivateWaypoints != null) {
                    currentPrivateWaypoints.add(waypoint);
                } else {
                    map = waypoints;
                    object = new Companion.Waypoint[]{waypoint};
                    object = CollectionsKt.mutableListOf(object);
                    map.put(uuid, (List<Companion.Waypoint>)object);
                }
            } else if (currentPrivateWaypoints != null) {
                currentPrivateWaypoints.add(waypoint);
            } else {
                Map<String, List<Companion.Waypoint>> map = waypoints;
                Object object = new Companion.Waypoint[]{waypoint};
                object = CollectionsKt.mutableListOf(object);
                map.put(uuid, (List<Companion.Waypoint>)object);
            }
        }
    }

    static /* synthetic */ void addWaypointToList$default(WaypointConfig waypointConfig, String string, Companion.Waypoint waypoint, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        waypointConfig.addWaypointToList(string, waypoint, string2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u000e"}, d2={"Lyv/tils/smp/utils/configs/waypoints/WaypointConfig$Companion;", "", "<init>", "()V", "config", "", "", "getConfig", "()Ljava/util/Map;", "waypoints", "", "Lyv/tils/smp/utils/configs/waypoints/WaypointConfig$Companion$Waypoint;", "getWaypoints", "Waypoint", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> getConfig() {
            return config;
        }

        @NotNull
        public final Map<String, List<Waypoint>> getWaypoints() {
            return waypoints;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006!"}, d2={"Lyv/tils/smp/utils/configs/waypoints/WaypointConfig$Companion$Waypoint;", "", "name", "", "visibility", "x", "", "y", "z", "world", "<init>", "(Ljava/lang/String;Ljava/lang/String;DDDLjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getVisibility", "getX", "()D", "getY", "getZ", "getWorld", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "YVtils-SMP_paper"})
        public static final class Waypoint {
            @NotNull
            private final String name;
            @NotNull
            private final String visibility;
            private final double x;
            private final double y;
            private final double z;
            @NotNull
            private final String world;

            public Waypoint(@NotNull String name, @NotNull String visibility, double x, double y, double z, @NotNull String world) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(visibility, "visibility");
                Intrinsics.checkNotNullParameter(world, "world");
                this.name = name;
                this.visibility = visibility;
                this.x = x;
                this.y = y;
                this.z = z;
                this.world = world;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getVisibility() {
                return this.visibility;
            }

            public final double getX() {
                return this.x;
            }

            public final double getY() {
                return this.y;
            }

            public final double getZ() {
                return this.z;
            }

            @NotNull
            public final String getWorld() {
                return this.world;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final String component2() {
                return this.visibility;
            }

            public final double component3() {
                return this.x;
            }

            public final double component4() {
                return this.y;
            }

            public final double component5() {
                return this.z;
            }

            @NotNull
            public final String component6() {
                return this.world;
            }

            @NotNull
            public final Waypoint copy(@NotNull String name, @NotNull String visibility, double x, double y, double z, @NotNull String world) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(visibility, "visibility");
                Intrinsics.checkNotNullParameter(world, "world");
                return new Waypoint(name, visibility, x, y, z, world);
            }

            public static /* synthetic */ Waypoint copy$default(Waypoint waypoint, String string, String string2, double d, double d2, double d3, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = waypoint.name;
                }
                if ((n & 2) != 0) {
                    string2 = waypoint.visibility;
                }
                if ((n & 4) != 0) {
                    d = waypoint.x;
                }
                if ((n & 8) != 0) {
                    d2 = waypoint.y;
                }
                if ((n & 0x10) != 0) {
                    d3 = waypoint.z;
                }
                if ((n & 0x20) != 0) {
                    string3 = waypoint.world;
                }
                return waypoint.copy(string, string2, d, d2, d3, string3);
            }

            @NotNull
            public String toString() {
                return "Waypoint(name=" + this.name + ", visibility=" + this.visibility + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world=" + this.world + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.visibility.hashCode();
                result = result * 31 + Double.hashCode(this.x);
                result = result * 31 + Double.hashCode(this.y);
                result = result * 31 + Double.hashCode(this.z);
                result = result * 31 + this.world.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Waypoint)) {
                    return false;
                }
                Waypoint waypoint = (Waypoint)other;
                if (!Intrinsics.areEqual(this.name, waypoint.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.visibility, waypoint.visibility)) {
                    return false;
                }
                if (Double.compare(this.x, waypoint.x) != 0) {
                    return false;
                }
                if (Double.compare(this.y, waypoint.y) != 0) {
                    return false;
                }
                if (Double.compare(this.z, waypoint.z) != 0) {
                    return false;
                }
                return Intrinsics.areEqual(this.world, waypoint.world);
            }
        }
    }
}

