/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils.internalAPI;

import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yv.tils.smp.utils.configs.language.LangStrings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lyv/tils/smp/utils/internalAPI/Parser;", "", "<init>", "()V", "parseTime", "Lyv/tils/smp/utils/internalAPI/Parser$ReturnData;", "unit", "", "duration", "", "ReturnData", "YVtils-SMP_paper"})
public final class Parser {
    @NotNull
    public final ReturnData parseTime(@NotNull String unit, int duration) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue(calendar, "getInstance(...)");
        Calendar expireAfter = calendar;
        switch (unit) {
            case "s": {
                expireAfter.add(13, duration);
                break;
            }
            case "m": {
                expireAfter.add(12, duration);
                break;
            }
            case "h": {
                expireAfter.add(10, duration);
                break;
            }
            case "d": {
                expireAfter.add(5, duration);
                break;
            }
            case "w": {
                expireAfter.add(3, duration);
                break;
            }
            default: {
                return new ReturnData(null, LangStrings.UNKNOWN_TIME_FORMAT);
            }
        }
        return new ReturnData(expireAfter, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lyv/tils/smp/utils/internalAPI/Parser$ReturnData;", "", "answer", "Ljava/util/Calendar;", "error", "Lyv/tils/smp/utils/configs/language/LangStrings;", "<init>", "(Ljava/util/Calendar;Lyv/tils/smp/utils/configs/language/LangStrings;)V", "getAnswer", "()Ljava/util/Calendar;", "setAnswer", "(Ljava/util/Calendar;)V", "getError", "()Lyv/tils/smp/utils/configs/language/LangStrings;", "setError", "(Lyv/tils/smp/utils/configs/language/LangStrings;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "YVtils-SMP_paper"})
    public static final class ReturnData {
        @Nullable
        private Calendar answer;
        @Nullable
        private LangStrings error;

        public ReturnData(@Nullable Calendar answer, @Nullable LangStrings error) {
            this.answer = answer;
            this.error = error;
        }

        @Nullable
        public final Calendar getAnswer() {
            return this.answer;
        }

        public final void setAnswer(@Nullable Calendar calendar) {
            this.answer = calendar;
        }

        @Nullable
        public final LangStrings getError() {
            return this.error;
        }

        public final void setError(@Nullable LangStrings langStrings) {
            this.error = langStrings;
        }

        @Nullable
        public final Calendar component1() {
            return this.answer;
        }

        @Nullable
        public final LangStrings component2() {
            return this.error;
        }

        @NotNull
        public final ReturnData copy(@Nullable Calendar answer, @Nullable LangStrings error) {
            return new ReturnData(answer, error);
        }

        public static /* synthetic */ ReturnData copy$default(ReturnData returnData, Calendar calendar, LangStrings langStrings, int n, Object object) {
            if ((n & 1) != 0) {
                calendar = returnData.answer;
            }
            if ((n & 2) != 0) {
                langStrings = returnData.error;
            }
            return returnData.copy(calendar, langStrings);
        }

        @NotNull
        public String toString() {
            return "ReturnData(answer=" + this.answer + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.answer == null ? 0 : this.answer.hashCode();
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnData)) {
                return false;
            }
            ReturnData returnData = (ReturnData)other;
            if (!Intrinsics.areEqual(this.answer, returnData.answer)) {
                return false;
            }
            return this.error == returnData.error;
        }
    }
}

