/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils.inventory;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.utils.color.ColorUtils;
import yv.tils.smp.utils.inventory.CustomHeads;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lyv/tils/smp/utils/inventory/HeadUtils;", "", "<init>", "()V", "createCustomHead", "Lorg/bukkit/inventory/ItemStack;", "headTexture", "Lyv/tils/smp/utils/inventory/CustomHeads;", "itemName", "", "YVtils-SMP_paper"})
public final class HeadUtils {
    @NotNull
    public final ItemStack createCustomHead(@NotNull CustomHeads headTexture, @NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)headTexture, "headTexture");
        Intrinsics.checkNotNullParameter(itemName, "itemName");
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta meta = (SkullMeta)itemMeta;
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
        Intrinsics.checkNotNullExpressionValue(playerProfile, "createProfile(...)");
        PlayerProfile playerProfile2 = playerProfile;
        playerProfile2.setProperties((Collection)Collections.singletonList(new ProfileProperty("textures", headTexture.getTexture(), "")));
        meta.setPlayerProfile(playerProfile2);
        meta.displayName(new ColorUtils().convert(itemName));
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP};
        meta.addItemFlags(itemFlagArray);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }
}

