/*
 * Decompiled with CFR 0.152.
 */
package yv.tils.smp.utils.updater;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import yv.tils.smp.YVtils;
import yv.tils.smp.utils.configs.global.Config;
import yv.tils.smp.utils.configs.language.LangStrings;
import yv.tils.smp.utils.configs.language.Language;
import yv.tils.smp.utils.internalAPI.Placeholder;
import yv.tils.smp.utils.internalAPI.Vars;
import yv.tils.smp.utils.logger.Debugger;
import yv.tils.smp.utils.updater.VersionState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0005H\u0002J\u0006\u0010\u000e\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lyv/tils/smp/utils/updater/PluginVersion;", "", "<init>", "()V", "onPlayerJoin", "", "player", "Lorg/bukkit/entity/Player;", "updateChecker", "serverPluginVersion", "", "compareVersions", "Lyv/tils/smp/utils/updater/VersionState;", "webRequest", "asyncUpdateChecker", "Companion", "YVtils-SMP_paper"})
public final class PluginVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static String version = "x.x.x";
    @NotNull
    private static String plVersion = "x.x.x";

    public final void onPlayerJoin(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = Config.Companion.getConfig().get("playerUpdateMessage");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        if (!((Boolean)object).booleanValue()) {
            return;
        }
        if (player.hasPermission("yvtils.smp.update") || player.isOp()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.compareVersions().ordinal()]) {
                case 1: {
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                    player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.PLAYER_PLUGIN_UPDATE_AVAILABLE_PATCH), list, CollectionsKt.listOf(stringArray)));
                    break;
                }
                case 2: {
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                    player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.PLAYER_PLUGIN_UPDATE_AVAILABLE_MINOR), list, CollectionsKt.listOf(stringArray)));
                    break;
                }
                case 3: {
                    Placeholder placeholder = new Placeholder();
                    Language language = new Language();
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                    List<String> list = CollectionsKt.listOf(stringArray);
                    stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                    player.sendMessage(placeholder.replacer(language.getMessage(uUID, LangStrings.PLAYER_PLUGIN_UPDATE_AVAILABLE_MAJOR), list, CollectionsKt.listOf(stringArray)));
                }
            }
        }
    }

    public final void updateChecker(@NotNull String serverPluginVersion) {
        Intrinsics.checkNotNullParameter(serverPluginVersion, "serverPluginVersion");
        plVersion = serverPluginVersion;
        this.webRequest();
        switch (WhenMappings.$EnumSwitchMapping$0[this.compareVersions().ordinal()]) {
            case 4: {
                Bukkit.getConsoleSender().sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.PLUGIN_UP_TO_DATE), CollectionsKt.listOf("prefix"), CollectionsKt.listOf(new Vars().getPrefix())));
                break;
            }
            case 1: {
                String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                Bukkit.getConsoleSender().sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.PLUGIN_UPDATE_AVAILABLE_PATCH), list, CollectionsKt.listOf(stringArray)));
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                Bukkit.getConsoleSender().sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.PLUGIN_UPDATE_AVAILABLE_MINOR), list, CollectionsKt.listOf(stringArray)));
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"newVersion", "oldVersion", "prefix", "link"};
                List<String> list = CollectionsKt.listOf(stringArray);
                stringArray = new String[]{version, plVersion, new Vars().getPrefix(), "<click:open_url:https://yvtils.net/yvtils/modrinth/smp>https://yvtils.net/yvtils/modrinth/smp</click>"};
                Bukkit.getConsoleSender().sendMessage(new Placeholder().replacer(new Language().getMessage(LangStrings.PLUGIN_UPDATE_AVAILABLE_MAJOR), list, CollectionsKt.listOf(stringArray)));
                break;
            }
            case 5: {
                Bukkit.getConsoleSender().sendMessage(new Language().directFormat("There occurred an error while searching for an update! Please contact the support!", "Auf der Suche nach einem Plugin Update ist ein Fehler aufgetreten! Bitte kontaktiere den Support!"));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final VersionState compareVersions() {
        String[] stringArray = new String[]{"."};
        List newVersion = StringsKt.split$default((CharSequence)version, stringArray, false, 0, 6, null);
        String[] stringArray2 = new String[]{"."};
        List oldVersion = StringsKt.split$default((CharSequence)plVersion, stringArray2, false, 0, 6, null);
        if (newVersion.size() != 3 || oldVersion.size() != 3) {
            return VersionState.UNKNOWN;
        }
        if (Intrinsics.areEqual(newVersion.get(0), "x") || Intrinsics.areEqual(newVersion.get(1), "x") || Intrinsics.areEqual(newVersion.get(2), "x")) {
            return VersionState.UNKNOWN;
        }
        boolean majorHigher = false;
        boolean minorHigher = false;
        boolean patchHigher = false;
        if (Integer.parseInt((String)newVersion.get(0)) > Integer.parseInt((String)oldVersion.get(0))) {
            majorHigher = true;
        }
        if (Integer.parseInt((String)newVersion.get(1)) > Integer.parseInt((String)oldVersion.get(1)) && !majorHigher) {
            minorHigher = true;
        }
        if (Integer.parseInt((String)newVersion.get(2)) > Integer.parseInt((String)oldVersion.get(2)) && !majorHigher && !minorHigher) {
            patchHigher = true;
        }
        return majorHigher ? VersionState.OUTDATED_MAJOR : (minorHigher ? VersionState.OUTDATED_MINOR : (patchHigher ? VersionState.OUTDATED_PATCH : VersionState.UP_TO_DATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void webRequest() {
        block9: {
            try {
                String url = "https://yvtils.net/yvtils/version/smp.txt";
                URLConnection uRLConnection = new URI(url).toURL().openConnection();
                Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    Closeable closeable = reader;
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        it.lines().forEach(arg_0 -> PluginVersion.webRequest$lambda$0$1(arg_0 -> PluginVersion.webRequest$lambda$0$0(content, arg_0), arg_0));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    reader.close();
                    connection.disconnect();
                    String string = content.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    version = string;
                    break block9;
                }
                Bukkit.getConsoleSender().sendMessage(new Language().directFormat("There occurred an error while searching for an update! Please contact the support!", "Auf der Suche nach einem Plugin Update ist ein Fehler aufgetreten! Bitte kontaktiere den Support!"));
                new Debugger().log("Update Check Error", "Response Code: " + responseCode, "yv.tils.smp.utils.updater.PluginVersion.webRequest()");
            }
            catch (Exception e) {
                YVtils.Companion.getInstance().getLogger().warning("Update Check Error: " + e.getMessage());
            }
        }
    }

    public final void asyncUpdateChecker() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)YVtils.Companion.getInstance(), () -> PluginVersion.asyncUpdateChecker$lambda$0(this), 0L, 72000L);
    }

    private static final Unit webRequest$lambda$0$0(StringBuilder $content, String line) {
        $content.append(line);
        return Unit.INSTANCE;
    }

    private static final void webRequest$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void asyncUpdateChecker$lambda$0(PluginVersion this$0) {
        this$0.webRequest();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lyv/tils/smp/utils/updater/PluginVersion$Companion;", "", "<init>", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "plVersion", "getPlVersion", "setPlVersion", "YVtils-SMP_paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        public final void setVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            version = string;
        }

        @NotNull
        public final String getPlVersion() {
            return plVersion;
        }

        public final void setPlVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            plVersion = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VersionState.values().length];
            try {
                nArray[VersionState.OUTDATED_PATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionState.OUTDATED_MINOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionState.OUTDATED_MAJOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionState.UP_TO_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionState.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

