/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings;

import com.nettakrim.signed_paintings.commands.SignedPaintingsCommands;
import com.nettakrim.signed_paintings.gui.SignEditingInfo;
import com.nettakrim.signed_paintings.rendering.PaintingRenderer;
import com.nettakrim.signed_paintings.util.ImageManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8242;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedPaintingsClient
implements ClientModInitializer {
    public static final String MODID = "signed_paintings";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"signed_paintings");
    public static class_310 client;
    public static ImageManager imageManager;
    public static PaintingRenderer paintingRenderer;
    public static SignEditingInfo currentSignEdit;
    public static final class_5251 textColor;
    public static final class_5251 nameTextColor;
    public static boolean renderSigns;
    public static boolean renderBanners;
    public static boolean renderShields;
    public static boolean reduceCulling;
    public static boolean loggingEnabled;
    private static final ArrayList<class_2561> sayBuffer;

    public void onInitializeClient() {
        client = class_310.method_1551();
        imageManager = new ImageManager();
        paintingRenderer = new PaintingRenderer();
        renderSigns = true;
        renderBanners = true;
        renderShields = true;
        reduceCulling = false;
        ClientTickEvents.START_CLIENT_TICK.register(context -> {
            if (!sayBuffer.isEmpty()) {
                int size = sayBuffer.size();
                for (int i = 0; i < size; ++i) {
                    SignedPaintingsClient.sayRaw(sayBuffer.remove(0));
                }
            }
            imageManager.onTick();
        });
        SignedPaintingsCommands.initialize();
    }

    public static String combineSignText(class_8242 text) {
        class_2561[] layers = text.method_49877(false);
        if (layers == null) {
            return "";
        }
        StringBuilder combined = new StringBuilder();
        for (class_2561 line : layers) {
            if (line == null) continue;
            combined.append(line.getString());
        }
        return combined.toString();
    }

    public static int getMaxFittingIndex(String reference, int budgetWidth, class_327 textRenderer) {
        int charLength = reference.length();
        if (charLength > 80 && !class_310.method_1551().method_1542()) {
            charLength = 80;
        }
        int low = 0;
        int high = reference.codePointCount(0, charLength);
        int index = Integer.MAX_VALUE;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int currentWidth = textRenderer.method_1727(SignedPaintingsClient.codePointSubstring(reference, mid));
            if (currentWidth < budgetWidth) {
                low = mid + 1;
            } else if (currentWidth > budgetWidth) {
                high = mid - 1;
            } else {
                return reference.offsetByCodePoints(0, mid);
            }
            index = mid;
        }
        if (textRenderer.method_1727(SignedPaintingsClient.codePointSubstring(reference, index)) > budgetWidth) {
            --index;
        }
        return reference.offsetByCodePoints(0, index);
    }

    public static String codePointSubstring(String s, int end) {
        int a = s.offsetByCodePoints(0, 0);
        return s.substring(a, s.offsetByCodePoints(a, end));
    }

    public static String floatToStringDP(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_UP);
        String s1 = bd.toString();
        String s2 = Float.toString(d);
        return s1.length() < s2.length() ? s1 : s2;
    }

    public static float roundFloatTo3DP(float value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(3, RoundingMode.HALF_UP);
        BigDecimal bd2 = bd.setScale(2, RoundingMode.HALF_UP);
        double difference = Math.abs(bd.subtract(bd2).doubleValue());
        String s = bd.toString();
        if ((difference < 0.0011 || s.contains("00")) && !s.endsWith(".667") && !s.endsWith(".334")) {
            return bd2.floatValue();
        }
        return bd.floatValue();
    }

    public static void sayStyled(String key, class_2583 style, Object ... args) {
        class_5250 text = class_2561.method_43471((String)"signed_paintings.say").method_10862(style.method_27703(nameTextColor)).method_10852((class_2561)class_2561.method_43469((String)("signed_paintings." + key), (Object[])args).method_10862(class_2583.field_24360.method_27703(textColor)));
        SignedPaintingsClient.sayRaw((class_2561)text);
    }

    public static void sayTranslated(String key, Object ... args) {
        SignedPaintingsClient.sayText(class_2561.method_43469((String)("signed_paintings." + key), (Object[])args));
    }

    public static void sayText(class_5250 text) {
        class_5250 newText = class_2561.method_43471((String)"signed_paintings.say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)text.method_10862(text.method_10866().method_27703(textColor)));
        SignedPaintingsClient.sayRaw((class_2561)newText);
    }

    public static void longSay(class_5250 text) {
        class_5250 newText = class_2561.method_43471((String)"signed_paintings.long_say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)text.method_10862(text.method_10866().method_27703(textColor)));
        SignedPaintingsClient.sayRaw((class_2561)newText);
    }

    public static void sayRaw(class_2561 text) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            sayBuffer.add(text);
            return;
        }
        SignedPaintingsClient.client.field_1724.method_7353(text, false);
    }

    public static String getScreenshotDirectory() {
        return String.valueOf(SignedPaintingsClient.client.field_1697) + "\\screenshots\\";
    }

    public static void info(String s, boolean force) {
        if (loggingEnabled || force) {
            LOGGER.info(s);
        }
    }

    public static String getDomain(String url) {
        int start = url.indexOf(47) + 2;
        return url.substring(0, url.substring(start).indexOf(47) + start + 1);
    }

    public static class_2583 getUrlButton(String url) {
        try {
            return class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(new URI(url)));
        }
        catch (Exception ignored) {
            return class_2583.field_24360;
        }
    }

    static {
        textColor = class_5251.method_27717((int)0xAAAAAA);
        nameTextColor = class_5251.method_27717((int)4967587);
        loggingEnabled = false;
        sayBuffer = new ArrayList();
    }
}

