/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.access.AbstractSignEditScreenAccessor;
import com.nettakrim.signed_paintings.access.SignBlockEntityAccessor;
import com.nettakrim.signed_paintings.gui.BackgroundClick;
import com.nettakrim.signed_paintings.gui.InputSlider;
import com.nettakrim.signed_paintings.gui.SignEditingInfo;
import com.nettakrim.signed_paintings.gui.UIHelper;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.rendering.SignSideInfo;
import com.nettakrim.signed_paintings.util.ImageManager;
import com.nettakrim.signed_paintings.util.SignByteMapper;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2508;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_498;
import net.minecraft.class_7743;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8242;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7743.class})
public abstract class AbstractSignEditScreenMixin
extends class_437
implements AbstractSignEditScreenAccessor {
    @Shadow
    private class_8242 field_43362;
    @Final
    @Shadow
    private String[] field_40425;
    @Final
    @Shadow
    protected class_2625 field_40424;
    @Final
    @Shadow
    private boolean field_43363;
    @Shadow
    private int field_40428;
    @Shadow
    private class_3728 field_40429;
    @Unique
    private String url = null;
    @Unique
    private String domain = null;
    @Unique
    private class_7842 disclaimer;
    @Unique
    private class_339 uploadButton;
    @Unique
    private class_339 doneButton;

    protected AbstractSignEditScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract void method_49913(String var1);

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V")})
    private boolean shouldRenderTitle(class_332 context, class_327 textRenderer, class_2561 text, int centerX, int y, int color) {
        return !this.isInfoCorrect();
    }

    @WrapOperation(method={"renderSign"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix3x2fStack;translate(FF)Lorg/joml/Matrix3x2f;")})
    private Matrix3x2f translateForRender(Matrix3x2fStack instance, float x, float y, Operation<Matrix3x2f> original) {
        if (this.isInfoCorrect()) {
            float offset = 0.0f;
            if (this.getClass().equals(class_498.class)) {
                offset = this.field_40424.method_11010().method_26204() instanceof class_2508 ? -16.0f : -4.0f;
            }
            original.call(new Object[]{instance, Float.valueOf(86.0f), Float.valueOf(38.0f + offset)});
            instance.scale(0.5f, 0.5f);
        } else {
            original.call(new Object[]{instance, Float.valueOf(x), Float.valueOf(y)});
        }
        return instance;
    }

    @Unique
    private PaintingInfo getInfo() {
        SignBlockEntityAccessor sign = (SignBlockEntityAccessor)this.field_40424;
        return this.field_43363 ? sign.signedPaintings$getFrontPaintingInfo() : sign.signedPaintings$getBackPaintingInfo();
    }

    @Unique
    private boolean isInfoCorrect() {
        PaintingInfo info = this.getInfo();
        return info != null && info.isReady();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isInfoCorrect() || UIHelper.isBackgroundEnabled()) {
            super.method_25420(context, mouseX, mouseY, delta);
        }
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AbstractSignEditScreen;getTextScale()Lorg/joml/Vector3f;"))
    private Vector3f modifyGetTextScale(class_7743 instance) {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    @Inject(at={@At(value="TAIL")}, method={"init"})
    private void onInit(CallbackInfo ci) {
        if (!this.method_25396().isEmpty()) {
            this.doneButton = (class_339)this.method_25396().get(0);
        }
        UIHelper.init(this.field_43363, this, (SignBlockEntityAccessor)this.field_40424);
        ArrayList<class_339> uiButtons = UIHelper.getButtons();
        for (class_339 widget : uiButtons) {
            this.method_37063((class_364)widget);
            this.method_25429((class_364)widget);
        }
        int y = FabricLoader.getInstance().isModLoaded("stendhal") ? 40 : this.field_22790 / 4 + 144;
        this.disclaimer = new class_7842(0, y - 43, this.field_22789, 25, (class_2561)class_2561.method_43473(), this.field_22793);
        this.disclaimer.field_22764 = false;
        this.method_37063((class_364)this.disclaimer);
        this.uploadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"signed_paintings.create_prompt"), button -> this.createPainting()).method_46434(this.field_22789 / 2 - 100, y - 25, 200, 20).method_46431();
        this.method_37063((class_364)this.uploadButton);
        this.method_25429((class_364)this.uploadButton);
        BackgroundClick backgroundClick = new BackgroundClick(UIHelper.getInputSliders());
        this.method_25429((class_364)backgroundClick);
        UIHelper.addBackground(backgroundClick);
        SignedPaintingsClient.currentSignEdit.setSelectionManager(this.field_40429);
        boolean correct = this.isInfoCorrect();
        this.signedPaintings$setVisibility(correct);
        SignSideInfo sideInfo = ((SignBlockEntityAccessor)this.field_40424).signedPaintings$getSideInfo(this.field_43363);
        String currentUrl = sideInfo.getUrl();
        if (correct || currentUrl.isBlank() || currentUrl.equals("https://")) {
            this.uploadButton.field_22764 = false;
        } else {
            this.url = currentUrl;
            this.updateUploadButton(true);
            this.url = null;
        }
        if (correct) {
            UIHelper.updateUI(sideInfo);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/block/entity/SignBlockEntity;ZZLnet/minecraft/text/Text;)V"})
    private void onScreenOpen(class_2625 blockEntity, boolean front, boolean filtered, class_2561 title, CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = new SignEditingInfo(blockEntity, this);
    }

    @Inject(at={@At(value="TAIL")}, method={"finishEditing"})
    private void onScreenClose(CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = null;
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    private void onKeyPress(class_11908 input, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || !slider.keyPressed(input)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"charTyped"}, cancellable=true)
    private void onCharType(class_11905 input, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || !slider.charTyped(input)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"renderSignText"}, ordinal=0)
    private boolean stopTextCaret(boolean bl) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || this.field_40429 == null) continue;
            this.field_40429.method_35731(this.field_40429.method_16201());
            return false;
        }
        return bl;
    }

    @Override
    public void signedPaintings$clear(boolean setText) {
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = "";
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)""));
        }
        if (setText) {
            this.field_40424.method_49840(this.field_43362, this.field_43363);
        }
        this.field_40428 = 0;
    }

    @Override
    public int signedPaintings$paste(String pasteString, int selectionStart, int selectionEnd, boolean setText) {
        int maxWidthPerLine = this.field_40424.method_45470();
        class_327 textRenderer = SignedPaintingsClient.client.field_1772;
        String pasteURL = SignedPaintingsClient.imageManager.applyURLInferences(pasteString);
        if (ImageManager.isValid(pasteString) || pasteString.matches(".*([/:\\\\]).*\\|$")) {
            this.url = pasteURL;
            if (this.url.startsWith("https://images-ext-1.discordapp.net/external/")) {
                this.url = URLDecoder.decode(this.url.substring(this.url.substring(45).indexOf(47) + 46).replaceFirst("/", "://"), StandardCharsets.UTF_8);
            }
            this.updateUploadButton(false);
        }
        String[] newMessages = new String[this.field_40425.length];
        System.arraycopy(this.field_40425, 0, newMessages, 0, this.field_40425.length);
        selectionStart = class_3532.method_15340((int)selectionStart, (int)0, (int)newMessages[this.field_40428].length());
        selectionEnd = class_3532.method_15340((int)selectionEnd, (int)0, (int)newMessages[this.field_40428].length());
        if (selectionStart > selectionEnd) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        newMessages[this.field_40428] = newMessages[this.field_40428].substring(0, selectionStart) + pasteString + newMessages[this.field_40428].substring(selectionEnd);
        int currentWidth = textRenderer.method_1727(newMessages[this.field_40428]);
        int cursor = selectionStart + pasteString.length();
        if (currentWidth < maxWidthPerLine) {
            this.method_49913(newMessages[this.field_40428]);
            return cursor;
        }
        int cursorRow = this.field_40428;
        while (true) {
            String line = newMessages[this.field_40428];
            int index = SignedPaintingsClient.getMaxFittingIndex(line, maxWidthPerLine, textRenderer);
            newMessages[this.field_40428] = line.substring(0, index);
            if (this.field_40428 == this.field_40425.length - 1 || line.length() <= index) break;
            if (this.field_40428 == cursorRow && cursor > index) {
                ++cursorRow;
                cursor -= index;
            }
            ++this.field_40428;
            newMessages[this.field_40428] = line.substring(index) + newMessages[this.field_40428];
        }
        cursor = class_3532.method_15340((int)cursor, (int)0, (int)newMessages[cursorRow].length());
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = newMessages[i];
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)this.field_40425[i]));
        }
        if (setText) {
            this.field_40424.method_49840(this.field_43362, this.field_43363);
        }
        this.field_40428 = cursorRow;
        return cursor;
    }

    @Unique
    private void updateUploadButton(boolean isExisting) {
        if (this.uploadButton == null) {
            this.onInit(null);
        }
        int start = this.url.indexOf(47) + 2;
        this.domain = this.url.substring(0, this.url.substring(start).indexOf(47) + start + 1);
        boolean blocked = SignedPaintingsClient.imageManager.domainBlocked(this.domain);
        String key = blocked ? (isExisting ? ".trust" : ".create_trust") : ".create";
        this.uploadButton.method_25355((class_2561)class_2561.method_43471((String)("signed_paintings" + key)));
        this.uploadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)("signed_paintings" + key + "_info"), (Object[])new Object[]{this.domain.substring(start, this.domain.length() - 1), class_2561.method_43471((String)"signed_paintings.trust_disclaimer")})));
        this.uploadButton.field_22764 = true;
        if (this.url.startsWith("https://media.discordapp.net")) {
            this.url = this.url.replace("format=webp", "format=png");
            this.activateDisclaimer((class_2561)class_2561.method_43471((String)"signed_paintings.disclaimer.discord"));
            return;
        }
        URI uri = URI.create(this.url);
        String path = uri.getPath();
        int i = Math.max(path.lastIndexOf(46), path.lastIndexOf(64));
        if (i == -1) {
            this.activateDisclaimer((class_2561)class_2561.method_43471((String)"signed_paintings.disclaimer.image_address"));
            return;
        }
        String format = path.substring(i + 1);
        for (String supported : ImageIO.getReaderFormatNames()) {
            if (!supported.equals(format)) continue;
            return;
        }
        this.activateDisclaimer((class_2561)class_2561.method_43469((String)"signed_paintings.disclaimer.format", (Object[])new Object[]{format}));
    }

    @Unique
    private void activateDisclaimer(class_2561 text) {
        this.disclaimer.method_25355(text);
        this.disclaimer.field_22764 = true;
        this.disclaimer.method_46421((this.field_22789 - this.disclaimer.method_25368()) / 2);
    }

    @Unique
    private void createPainting() {
        SignedPaintingsClient.imageManager.trustDomain(this.domain);
        SignedPaintingsClient.imageManager.blockPromptedDomains.remove(this.domain);
        this.uploadButton.field_22764 = false;
        this.disclaimer.field_22764 = false;
        if (this.url == null) {
            return;
        }
        this.signedPaintings$clear(false);
        int newSelection = this.signedPaintings$paste(SignByteMapper.INITIALIZER_STRING + SignByteMapper.encode(SignedPaintingsClient.imageManager.getShortestURLInference(this.url)), 0, 0, false);
        this.field_40429.method_27548(newSelection, newSelection);
        SignSideInfo info = ((SignBlockEntityAccessor)this.field_40424).signedPaintings$getSideInfo(this.field_43363);
        info.loadPainting(this.field_43363, this.field_40424, true);
        this.url = null;
    }

    @Override
    public void signedPaintings$setVisibility(boolean to) {
        for (class_339 clickableWidget : UIHelper.getButtons()) {
            clickableWidget.field_22764 = to;
        }
        if (this.doneButton != null) {
            this.doneButton.field_22764 = !to;
        } else {
            if (this.uploadButton == null) {
                this.onInit(null);
                return;
            }
            class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507(null));
            this.field_40429 = new class_3728(() -> "", s -> {}, () -> "", s -> {}, s -> true);
            this.onInit(null);
        }
    }

    @Override
    public void signedPaintings$initSliders(SignSideInfo info) {
        UIHelper.updateUI(info);
    }

    @Override
    public String signedPaintings$getText() {
        StringBuilder s = new StringBuilder();
        for (String message : this.field_40425) {
            s.append(message);
        }
        return s.toString();
    }

    @Override
    public int signedPaintings$internalRenderState() {
        if (!this.isInfoCorrect()) {
            return 0;
        }
        return this.field_40424.method_11010().method_26204() instanceof class_2508 ? -16 : -4;
    }
}

