/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.OverlayInfo;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.util.ImageManager;
import net.minecraft.class_10377;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PaintingRenderer {
    public void renderOrQueuePainting(class_4587 matrices, class_11659 queue, PaintingInfo info, int light) {
        class_2960 image = info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(info.offsetVec.x, info.offsetVec.y, info.offsetVec.z);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(info.rotationVec.y + (float)(info.isFront ? 0 : 180)));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(info.rotationVec.z));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(info.rotationVec.x));
        if (info.hasTranslucency()) {
            this.renderPainting(matrices, queue, info, light, class_1921.method_23580((class_2960)info.getImageIdentifier()));
        } else {
            this.renderPainting(matrices, queue, info, light, class_1921.method_23576((class_2960)info.getImageIdentifier()));
        }
        matrices.method_22909();
    }

    private void renderPainting(class_4587 matrices, class_11659 queue, PaintingInfo info, int light, class_1921 renderLayer) {
        queue.method_73483(matrices, renderLayer, (matrix, vertexConsumer) -> this.renderImage(matrix, vertexConsumer, info, light));
        if (info.getBackType() != BackType.Type.NONE) {
            class_1058 sprite = info.getBackSprite();
            queue.method_73483(matrices, class_1921.method_23576((class_2960)sprite.method_45852()), (matrix, vertexConsumer) -> this.renderBack(matrix, sprite.method_24108(vertexConsumer), sprite, info, light));
        }
    }

    private void renderImage(class_4587.class_4665 matrix, class_4588 vertexConsumer, PaintingInfo info, int light) {
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(0.0f, 0.0f, 1.0f), false, 0.0f, 1.0f, 0.0f, 1.0f, light);
    }

    private void renderBack(class_4587.class_4665 matrix, class_4588 vertexConsumer, class_1058 backSprite, PaintingInfo info, int light) {
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(0.0f, 0.0f, -1.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(1.0f, 0.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(-1.0f, 0.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(0.0f, 1.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(0.0f, -1.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
    }

    public void renderImageOverlay(class_4587 matrices, class_11659 queue, OverlayInfo info, int light, class_10377 flagBlockModel, float pitch) {
        matrices.method_22903();
        flagBlockModel.method_65188(Float.valueOf(pitch));
        flagBlockModel.method_63512().method_32086("flag").method_22703(matrices);
        matrices.method_22905(1.5f, -1.5f, 1.0f);
        matrices.method_46416(0.0f, 0.0f, -0.2f);
        this.renderOverlay(matrices, queue, info, light);
        matrices.method_22909();
    }

    public void renderItemOverlay(class_4587 matrices, class_11659 queue, OverlayInfo info, int light) {
        matrices.method_22903();
        matrices.method_22905(0.75f, -0.75f, -1.0f);
        matrices.method_46416(0.0f, 0.833f, 0.065f);
        this.renderOverlay(matrices, queue, info, light);
        matrices.method_22909();
    }

    private void renderOverlay(class_4587 matrices, class_11659 queue, OverlayInfo info, int light) {
        class_2960 image = info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        class_1921 layer = info.hasTranslucency() ? class_1921.method_23580((class_2960)image) : class_1921.method_23576((class_2960)image);
        queue.method_73483(matrices, layer, (matrix, vertexConsumer) -> info.cuboid.renderFace(matrix, vertexConsumer, new Vector3f(0.0f, 0.0f, 1.0f), false, 0.0f, 1.0f, 0.0f, 1.0f, light));
    }
}

