/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.util;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.util.ImageManager;
import com.nettakrim.signed_paintings.util.ImageStatus;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import org.joml.Vector2i;

public class ImageData {
    private BufferedImage baseImage;
    private class_2960 baseIdentifier;
    private class_2960 workingIdentifier;
    private final HashMap<Vector2i, VariantData> images = new HashMap();
    public boolean ready = false;
    public boolean needsReload = false;
    public int width;
    public int height;
    private int workingWidth;
    private int workingHeight;
    private int workingRenderTime = -1;
    private int expiredAllAt = -1;

    public void onImageReady(BufferedImage image, class_2960 baseIdentifier) {
        this.baseImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.baseIdentifier = baseIdentifier;
        this.workingIdentifier = baseIdentifier.method_48331("_working");
        this.ready = true;
    }

    public class_2960 getBaseIdentifier() {
        return this.getIdentifier(this.width, this.height, false);
    }

    public class_2960 getIdentifier(int width, int height, boolean working) {
        BufferedImage bufferedImage;
        class_2960 identifier;
        this.expiredAllAt = -1;
        Vector2i resolution = new Vector2i(width, height);
        VariantData variantData = this.images.get(resolution);
        if (variantData != null) {
            variantData.renderTime = SignedPaintingsClient.imageManager.renderTime;
            return variantData.identifier;
        }
        if (working) {
            this.workingRenderTime = SignedPaintingsClient.imageManager.renderTime;
            if (width != this.workingWidth || height != this.workingHeight) {
                this.workingWidth = width;
                this.workingHeight = height;
                ImageManager.saveBufferedImageAsIdentifier(this.scaleImage(this.baseImage, width, height), this.workingIdentifier);
            }
            return this.workingIdentifier;
        }
        if (width == this.width && height == this.height) {
            identifier = this.baseIdentifier;
            bufferedImage = this.baseImage;
        } else {
            identifier = this.baseIdentifier.method_48331("_" + width + "x" + height);
            bufferedImage = this.scaleImage(this.baseImage, width, height);
        }
        ImageManager.saveBufferedImageAsIdentifier(bufferedImage, identifier);
        this.images.put(resolution, new VariantData(identifier));
        return identifier;
    }

    private BufferedImage scaleImage(BufferedImage referenceImage, int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage resizedImage = new BufferedImage(width, height, referenceImage.getType());
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(referenceImage, 0, 0, width, height, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public int reload() {
        this.ready = false;
        int i = 0;
        if (ImageManager.hasImage(this.workingIdentifier)) {
            ++i;
            ImageManager.removeImage(this.workingIdentifier);
        }
        for (VariantData variantData : this.images.values()) {
            ImageManager.removeImage(variantData.identifier);
            ++i;
        }
        this.baseImage = null;
        this.needsReload = true;
        this.images.clear();
        return i;
    }

    public ImageStatus getStatus() {
        ImageStatus imageStatus = new ImageStatus();
        this.images.forEach((key, value) -> imageStatus.addResolution((Vector2i)key, this.getBytes(Objects.requireNonNull(((class_1043)ImageManager.getTexture(value.identifier)).method_4525())), value.identifier != this.baseIdentifier));
        imageStatus.ready = this.ready;
        return imageStatus;
    }

    private long getBytes(class_1011 image) {
        long bytesPerPixel = image.method_4318().method_4335();
        return (long)(image.method_4307() * image.method_4323()) * bytesPerPixel;
    }

    public boolean checkRenderTime(int expireVram, int expireFully) {
        if (!this.ready) {
            return false;
        }
        Iterator<VariantData> iterator = this.images.values().iterator();
        while (iterator.hasNext()) {
            VariantData variantData = iterator.next();
            if (variantData.renderTime >= expireVram) continue;
            SignedPaintingsClient.info("removing expired image variant " + String.valueOf(variantData.identifier), false);
            ImageManager.removeImage(variantData.identifier);
            iterator.remove();
        }
        if (this.workingRenderTime != -1 && this.workingRenderTime < expireVram) {
            SignedPaintingsClient.info("removing expired image variant " + String.valueOf(this.workingIdentifier), false);
            ImageManager.removeImage(this.workingIdentifier);
            this.workingRenderTime = -1;
        }
        if (this.images.isEmpty() && this.workingRenderTime == -1) {
            if (this.expiredAllAt == -1) {
                this.expiredAllAt = SignedPaintingsClient.imageManager.renderTime;
            }
            if (this.expiredAllAt < expireFully) {
                SignedPaintingsClient.info("reloading fully expired image " + String.valueOf(this.baseIdentifier), false);
                this.reload();
                return true;
            }
        }
        return false;
    }

    private static class VariantData {
        public class_2960 identifier;
        public int renderTime;

        public VariantData(class_2960 identifier) {
            this.identifier = identifier;
            this.renderTime = SignedPaintingsClient.imageManager.renderTime;
        }
    }
}

