/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.OverlayInfo;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.util.ImageManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PaintingRenderer {
    private static final List<TranslucentRenderData> translucentQueue = new ArrayList<TranslucentRenderData>();

    private static void queueTranslucentRender(class_4587.class_4665 capturedEntry, class_3879 model, PaintingInfo info, int light, float rotationDegrees) {
        translucentQueue.add(new TranslucentRenderData(capturedEntry, model, info, light, rotationDegrees));
    }

    private void renderTranslucentPaintingImmediately(class_4587 matrices, class_4597 consumers, TranslucentRenderData data) {
        class_2960 image = data.info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        matrices.method_22903();
        matrices.method_34425((Matrix4fc)data.matrixEntry.method_23761());
        data.info.cuboid.setupRendering(matrices.method_23760());
        this.renderPainting(consumers, data.info, data.light, class_1921.method_23580((class_2960)image));
        matrices.method_22909();
    }

    public void renderTranslucentQueue(class_4587 matrices, class_4597 vertexConsumers) {
        for (TranslucentRenderData data : translucentQueue) {
            this.renderTranslucentPaintingImmediately(matrices, vertexConsumers, data);
        }
        translucentQueue.clear();
    }

    public void renderOrQueuePainting(class_4587 matrices, class_4597 vertexConsumers, class_3879 model, PaintingInfo info, int light, float rotationDegrees) {
        class_2960 image = info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_46416(info.offsetVec.x, info.offsetVec.y, info.offsetVec.z);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotationDegrees + info.rotationVec.y + (float)(info.isFront ? 0 : 180)));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(info.rotationVec.z));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(info.rotationVec.x));
        if (info.hasPartialTransparency()) {
            PaintingRenderer.queueTranslucentRender(matrices.method_23760().method_56822(), model, info, light, rotationDegrees);
        } else {
            info.cuboid.setupRendering(matrices.method_23760());
            this.renderPainting(vertexConsumers, info, light, class_1921.method_23576((class_2960)info.getImageIdentifier()));
        }
        matrices.method_22909();
    }

    private void renderPainting(class_4597 vertexConsumers, PaintingInfo info, int light, class_1921 renderLayer) {
        class_4588 imageVertexConsumer = vertexConsumers.getBuffer(renderLayer);
        this.renderImage(imageVertexConsumer, info, light);
        if (info.getBackType() != BackType.Type.NONE) {
            class_1058 sprite = info.getBackSprite();
            class_4588 backVertexConsumer = sprite.method_24108(vertexConsumers.getBuffer(class_1921.method_23576((class_2960)sprite.method_45852())));
            this.renderBack(backVertexConsumer, sprite, info, light);
        }
    }

    private void renderImage(class_4588 vertexConsumer, PaintingInfo info, int light) {
        info.cuboid.renderFace(vertexConsumer, new Vector3f(0.0f, 0.0f, 1.0f), false, 0.0f, 1.0f, 0.0f, 1.0f, light);
    }

    private void renderBack(class_4588 vertexConsumer, class_1058 backSprite, PaintingInfo info, int light) {
        info.cuboid.renderFace(vertexConsumer, new Vector3f(0.0f, 0.0f, -1.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(vertexConsumer, new Vector3f(1.0f, 0.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(vertexConsumer, new Vector3f(-1.0f, 0.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(vertexConsumer, new Vector3f(0.0f, 1.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
        info.cuboid.renderFace(vertexConsumer, new Vector3f(0.0f, -1.0f, 0.0f), true, backSprite.method_4594(), backSprite.method_4577(), backSprite.method_4593(), backSprite.method_4575(), light);
    }

    public void renderImageOverlay(class_4587 matrices, class_4597 vertexConsumers, OverlayInfo info, class_630 canvas, int light) {
        class_2960 image = info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        class_1921 layer = info.hasPartialTransparency() ? class_1921.method_23580((class_2960)image) : class_1921.method_23576((class_2960)image);
        class_4588 imageVertexConsumer = vertexConsumers.getBuffer(layer);
        matrices.method_22903();
        canvas.method_22703(matrices);
        matrices.method_22905(1.5f, -1.5f, 1.0f);
        matrices.method_46416(0.0f, 0.0f, -0.2f);
        info.cuboid.setupRendering(matrices.method_23760());
        info.cuboid.renderFace(imageVertexConsumer, new Vector3f(0.0f, 0.0f, 1.0f), false, 0.0f, 1.0f, 0.0f, 1.0f, light);
        matrices.method_22909();
    }

    public void renderItemOverlay(class_4587 matrices, class_4597 vertexConsumers, OverlayInfo info, int light) {
        class_2960 image = info.getImageIdentifier();
        if (!ImageManager.hasImage(image)) {
            return;
        }
        class_1921 layer = info.hasPartialTransparency() ? class_1921.method_23580((class_2960)image) : class_1921.method_23576((class_2960)image);
        class_4588 imageVertexConsumer = vertexConsumers.getBuffer(layer);
        matrices.method_22903();
        matrices.method_22905(0.75f, -0.75f, -1.0f);
        matrices.method_46416(0.0f, 0.833f, 0.065f);
        info.cuboid.setupRendering(matrices.method_23760());
        info.cuboid.renderFace(imageVertexConsumer, new Vector3f(0.0f, 0.0f, 1.0f), false, 0.0f, 1.0f, 0.0f, 1.0f, light);
        matrices.method_22909();
    }

    private record TranslucentRenderData(class_4587.class_4665 matrixEntry, class_3879 model, PaintingInfo info, int light, float rotationDegrees) {
    }
}

