/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.gui;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.access.SignBlockEntityAccessor;
import com.nettakrim.signed_paintings.gui.BackgroundClick;
import com.nettakrim.signed_paintings.gui.InputSlider;
import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.Centering;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.rendering.SignSideInfo;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3674;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.joml.Vector3f;

public class UIHelper {
    private static final int BUTTON_HEIGHT = 14;
    private static final int BUTTON_WIDTH = 115;
    private static final int PADDING = 10;
    private static final int INPUT_SLIDER_TEXT = 45;
    private static final int INPUT_SLIDER_SLIDER = 64;
    private static final int SPACING_X = 5;
    private static final int SPACING_Y = 18;
    private static final int Y_OFF = 55;
    private static final int AREA_SIZE = 33;
    private static final InputSlider[] inputSliders = new InputSlider[9];
    private static final ArrayList<class_339> buttons = new ArrayList();
    private static class_437 screen;
    private static boolean front;
    private static int screenWidth;
    private static boolean aspectLocked;
    private static boolean isBackgroundEnabled;
    private static float aspectRatio;
    private static PaintingInfo info;
    private static class_4185 backModeButton;
    private static class_4185 untrustButton;
    private static class_339 activeCentering;
    private static Vector3f offsetVec;
    private static Vector3f rotationVec;

    public static void init(boolean isFront, class_437 screen, SignBlockEntityAccessor blockEntity) {
        float pixelsPerBlock;
        BackType.Type backType;
        float height;
        float width;
        front = isFront;
        screenWidth = screen.field_22789;
        UIHelper.screen = screen;
        buttons.clear();
        PaintingInfo paintingInfo = info = front ? blockEntity.signedPaintings$getFrontPaintingInfo() : blockEntity.signedPaintings$getBackPaintingInfo();
        if (info == null) {
            width = 1.0f;
            height = 1.0f;
            backType = BackType.Type.SIGN;
            pixelsPerBlock = 0.0f;
            offsetVec = new Vector3f(0.0f, 0.0f, 0.0f);
            rotationVec = new Vector3f(0.0f, 0.0f, 0.0f);
        } else {
            width = info.getWidth();
            height = info.getHeight();
            backType = info.getBackType();
            offsetVec = UIHelper.info.offsetVec;
            rotationVec = UIHelper.info.rotationVec;
            pixelsPerBlock = info.getPixelsPerBlock();
            UIHelper.info.working = true;
        }
        UIHelper.createCenteringButtons();
        UIHelper.createButton(10, 55, 55, (class_2561)class_2561.method_43471((String)"signed_paintings.copy_url"), UIHelper::copyURL);
        UIHelper.createButton(class_3532.method_15386((float)70.0f), 55, 55, (class_2561)class_2561.method_43471((String)"signed_paintings.copy_data"), UIHelper::copyData);
        UIHelper.inputSliders[3] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 1.25f), "signed_paintings.offset_x", -8.0f, 8.0f, 0.25f, -64.0f, 64.0f, UIHelper.offsetVec.x);
        inputSliders[3].setOnValueChanged(UIHelper::onXOffsetSliderChanged);
        UIHelper.inputSliders[4] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 2.25f), "signed_paintings.offset_y", -8.0f, 8.0f, 0.25f, -64.0f, 64.0f, UIHelper.offsetVec.y);
        inputSliders[4].setOnValueChanged(UIHelper::onYOffsetSliderChanged);
        UIHelper.inputSliders[5] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 3.25f), "signed_paintings.offset_z", -8.0f, 8.0f, 0.25f, -64.0f, 64.0f, UIHelper.offsetVec.z);
        inputSliders[5].setOnValueChanged(UIHelper::onZOffsetSliderChanged);
        UIHelper.inputSliders[6] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 4.5f), "signed_paintings.rotation_x", -180.0f, 180.0f, 22.5f, -360.0f, 360.0f, UIHelper.rotationVec.x);
        inputSliders[6].setOnValueChanged(UIHelper::onXRotationSliderChanged);
        UIHelper.inputSliders[7] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 5.5f), "signed_paintings.rotation_y", -180.0f, 180.0f, 22.5f, -360.0f, 360.0f, UIHelper.rotationVec.y);
        inputSliders[7].setOnValueChanged(UIHelper::onYRotationSliderChanged);
        UIHelper.inputSliders[8] = UIHelper.createInputSlider(10, UIHelper.getYPosition(55, 6.5f), "signed_paintings.rotation_z", -180.0f, 180.0f, 22.5f, -360.0f, 360.0f, UIHelper.rotationVec.z);
        inputSliders[8].setOnValueChanged(UIHelper::onZRotationSliderChanged);
        UIHelper.inputSliders[0] = UIHelper.createInputSlider(-10, 0, "signed_paintings.size.x", 0.5f, 10.0f, 0.5f, 0.03125f, 64.0f, width);
        UIHelper.createButton(-111, 18, 14, UIHelper.getAspectLockIcon(aspectLocked), UIHelper::toggleAspectLock);
        UIHelper.createButton(-10, 18, 96, (class_2561)class_2561.method_43471((String)"signed_paintings.size.reset"), UIHelper::resetSize);
        UIHelper.inputSliders[1] = UIHelper.createInputSlider(-10, UIHelper.getYPosition(0, 2.0f), "signed_paintings.size.y", 0.5f, 10.0f, 0.5f, 0.03125f, 64.0f, height);
        inputSliders[0].setOnValueChanged(value -> UIHelper.onSizeSliderChanged(value.floatValue(), true));
        inputSliders[1].setOnValueChanged(value -> UIHelper.onSizeSliderChanged(value.floatValue(), false));
        aspectRatio = width / height;
        backModeButton = UIHelper.createButton(-10, UIHelper.getYPosition(0, 3.25f), 115, UIHelper.getBackTypeText(backType), UIHelper::cyclePaintingBack);
        UIHelper.inputSliders[2] = UIHelper.createInputSlider(-10, UIHelper.getYPosition(0, 4.25f), "signed_paintings.pixels_per_block", 0.0f, 64.0f, 16.0f, 0.0f, 1024.0f, pixelsPerBlock);
        inputSliders[2].setOnValueChanged(UIHelper::onPixelSliderChanged);
        untrustButton = UIHelper.createButton(-10, UIHelper.getYPosition(55, 4.5f), 115, (class_2561)class_2561.method_43471((String)"signed_paintings.untrust"), UIHelper::untrust);
        UIHelper.createButton(-10, UIHelper.getYPosition(55, 5.5f), 115, UIHelper.getBackgroundText(isBackgroundEnabled), UIHelper::cycleBackground);
        UIHelper.createButton(-10, UIHelper.getYPosition(55, 6.5f), 115, class_5244.field_24334, a -> screen.method_25419());
    }

    private static void createCenteringButtons() {
        Centering.Type[] centering;
        for (Centering.Type yCentering : centering = Centering.Type.values()) {
            for (int i = 0; i < centering.length; ++i) {
                UIHelper.createCenteringButton(centering[centering.length - 1 - i], yCentering);
            }
        }
    }

    private static void createCenteringButton(Centering.Type xCentering, Centering.Type yCentering) {
        String id = (Centering.getName(true, xCentering) + Centering.getName(false, yCentering)).toLowerCase(Locale.ROOT);
        int xPos = UIHelper.getCenteringButtonPosition(33, xCentering, 14, 0) + 16 + 7 + 10;
        int yPos = -UIHelper.getCenteringButtonPosition(33, yCentering, 14, 0) + 16 - 7 + 10;
        class_4185 widget = class_4185.method_46430((class_2561)class_2561.method_43471((String)("signed_paintings.align." + id)), button -> {
            UIHelper.updateActiveCentering((class_339)button);
            UIHelper.getSideInfo().updatePaintingCentering(xCentering, yCentering);
        }).method_46433(xPos, yPos).method_46437(14, 14).method_46431();
        buttons.add((class_339)widget);
    }

    private static int getCenteringButtonPosition(int size, Centering.Type centering, int buttonSize, int screenSize) {
        return class_3532.method_15375((float)Centering.getOffset(size, centering)) + screenSize / 2 - buttonSize / 2;
    }

    private static int getYPosition(int offset, float count) {
        return offset + Math.round(18.0f * count);
    }

    private static int getAlignedOffset(int offset, int width) {
        if (offset >= 0) {
            return offset;
        }
        return screenWidth - width + offset;
    }

    private static class_4185 createButton(int xOffset, int yOffset, int width, class_2561 text, class_4185.class_4241 pressAction) {
        class_4185 button = class_4185.method_46430((class_2561)text, (class_4185.class_4241)pressAction).method_46433(UIHelper.getAlignedOffset(xOffset, width), 10 + yOffset).method_46437(width, 14).method_46431();
        buttons.add((class_339)button);
        return button;
    }

    private static InputSlider createInputSlider(int xOffset, int yOffset, String key, float sliderMin, float sliderMax, float sliderStep, float valueMin, float valueMax, float valueCurrent) {
        InputSlider inputSlider = new InputSlider(UIHelper.getAlignedOffset(xOffset, 115), 10 + yOffset, 45, 64, 14, 6, sliderMin, sliderMax, sliderStep, valueCurrent, valueMin, valueMax, (class_2561)class_2561.method_43471((String)key));
        buttons.add((class_339)inputSlider.sliderWidget);
        buttons.add((class_339)inputSlider.textFieldWidget);
        return inputSlider;
    }

    private static void toggleAspectLock(class_4185 button) {
        UIHelper.setAspectLock(!aspectLocked);
        button.method_25355(UIHelper.getAspectLockIcon(aspectLocked));
    }

    private static void setAspectLock(boolean to) {
        aspectLocked = to;
        if (aspectLocked) {
            aspectRatio = inputSliders[0].getValue() / inputSliders[1].getValue();
        }
    }

    private static void resetSize(class_4185 button) {
        SignSideInfo info = UIHelper.getSideInfo();
        info.resetSize();
        inputSliders[0].setValue(info.paintingInfo.getWidth());
        inputSliders[1].setValue(info.paintingInfo.getHeight());
        aspectRatio = inputSliders[0].getValue() / inputSliders[1].getValue();
    }

    private static class_2561 getAspectLockIcon(boolean aspectLocked) {
        return class_2561.method_43471((String)("signed_paintings.aspect." + (aspectLocked ? "locked" : "unlocked")));
    }

    private static class_2561 getBackTypeText(BackType.Type backType) {
        return class_2561.method_43471((String)("signed_paintings.back_mode." + backType.toString().toLowerCase(Locale.ROOT)));
    }

    private static class_2561 getBackgroundText(boolean isEnabled) {
        return class_2561.method_43471((String)("signed_paintings.background." + (isEnabled ? "y" : "n")));
    }

    private static void cyclePaintingBack(class_4185 button) {
        BackType.Type newType = UIHelper.getSideInfo().cyclePaintingBack();
        button.method_25355(UIHelper.getBackTypeText(newType));
    }

    private static void cycleBackground(class_4185 button) {
        isBackgroundEnabled = !isBackgroundEnabled;
        button.method_25355(UIHelper.getBackgroundText(isBackgroundEnabled));
        SignedPaintingsClient.imageManager.makeChange();
    }

    private static void onSizeSliderChanged(float value, boolean isWidth) {
        if (aspectLocked) {
            if (isWidth) {
                if (aspectRatio > 0.0f) {
                    value /= aspectRatio;
                }
            } else {
                value *= aspectRatio;
            }
            value = SignedPaintingsClient.roundFloatTo3DP(value);
            inputSliders[isWidth ? 1 : 0].setValue(value);
        }
        UIHelper.getSideInfo().updatePaintingSize(inputSliders[0].getValue(), inputSliders[1].getValue());
    }

    private static void onXOffsetSliderChanged(float value) {
        UIHelper.offsetVec.x = value;
        UIHelper.getSideInfo().updatePaintingOffset(offsetVec);
    }

    private static void onYOffsetSliderChanged(float value) {
        UIHelper.offsetVec.y = value;
        UIHelper.getSideInfo().updatePaintingOffset(offsetVec);
    }

    private static void onZOffsetSliderChanged(float value) {
        UIHelper.offsetVec.z = value;
        UIHelper.getSideInfo().updatePaintingOffset(offsetVec);
    }

    private static void onXRotationSliderChanged(float value) {
        UIHelper.rotationVec.x = value;
        UIHelper.getSideInfo().updateRotatingVector(rotationVec);
    }

    private static void onYRotationSliderChanged(float value) {
        UIHelper.rotationVec.y = value;
        UIHelper.getSideInfo().updateRotatingVector(rotationVec);
    }

    private static void onZRotationSliderChanged(float value) {
        UIHelper.rotationVec.z = value;
        UIHelper.getSideInfo().updateRotatingVector(rotationVec);
    }

    private static void onPixelSliderChanged(float value) {
        UIHelper.getSideInfo().updatePaintingPixelsPerBlock(value);
    }

    private static void copyURL(class_4185 button) {
        UIHelper.copyToClipboard(UIHelper.getSideInfo().getUrl());
        screen.method_25419();
    }

    private static void copyData(class_4185 button) {
        UIHelper.copyToClipboard(UIHelper.getSideInfo().getData());
        screen.method_25419();
    }

    private static void copyToClipboard(String string) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_3674 clipboard = new class_3674();
            clipboard.method_15979(client.method_22683(), string);
        }
    }

    private static void untrust(class_4185 button) {
        SignedPaintingsClient.imageManager.untrustDomain(SignedPaintingsClient.getDomain(UIHelper.getSideInfo().getUrl()));
        screen.method_25419();
    }

    public static ArrayList<class_339> getButtons() {
        return buttons;
    }

    public static InputSlider[] getInputSliders() {
        return inputSliders;
    }

    public static PaintingInfo getInfo() {
        return info;
    }

    public static boolean isBackgroundEnabled() {
        return isBackgroundEnabled;
    }

    public static void setBackgroundEnabled(boolean to) {
        isBackgroundEnabled = to;
    }

    public static void updateUI(SignSideInfo info) {
        inputSliders[0].setValue(info.paintingInfo.getWidth());
        inputSliders[1].setValue(info.paintingInfo.getHeight());
        inputSliders[2].setValue(info.paintingInfo.getPixelsPerBlock());
        inputSliders[3].setValue(info.paintingInfo.offsetVec.x);
        inputSliders[4].setValue(info.paintingInfo.offsetVec.y);
        inputSliders[5].setValue(info.paintingInfo.offsetVec.z);
        inputSliders[6].setValue(info.paintingInfo.rotationVec.x);
        inputSliders[7].setValue(info.paintingInfo.rotationVec.y);
        inputSliders[8].setValue(info.paintingInfo.rotationVec.z);
        backModeButton.method_25355(UIHelper.getBackTypeText(info.paintingInfo.getBackType()));
        aspectRatio = info.paintingInfo.getWidth() / info.paintingInfo.getHeight();
        untrustButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"signed_paintings.untrust_info", (Object[])new Object[]{SignedPaintingsClient.getDomain(info.getUrl())})));
        UIHelper.updateActiveCentering(buttons.get(info.paintingInfo.getCenterIndex()));
    }

    private static void updateActiveCentering(class_339 newCentering) {
        if (activeCentering != null) {
            UIHelper.activeCentering.field_22763 = true;
        }
        activeCentering = newCentering;
        UIHelper.activeCentering.field_22763 = false;
    }

    public static void addBackground(BackgroundClick backgroundClick) {
        buttons.add(backgroundClick);
    }

    private static SignSideInfo getSideInfo() {
        return SignedPaintingsClient.currentSignEdit.getSideInfo(front);
    }

    static {
        aspectLocked = true;
        isBackgroundEnabled = false;
    }
}

