/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.signed_paintings.DomainWarningScreen;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class DomainCommand {
    public static final SuggestionProvider<FabricClientCommandSource> untrust = (context, builder) -> {
        if (SignedPaintingsClient.imageManager.trustedDomains.contains("https://")) {
            builder.suggest("anything");
            return CompletableFuture.completedFuture(builder.build());
        }
        for (String url : SignedPaintingsClient.imageManager.trustedDomains) {
            builder.suggest(url);
        }
        if (SignedPaintingsClient.imageManager.trustedDomains.size() >= 2) {
            builder.suggest("all_trusted");
        }
        return CompletableFuture.completedFuture(builder.build());
    };
    public static final SuggestionProvider<FabricClientCommandSource> trust = (context, builder) -> {
        for (String url : SignedPaintingsClient.imageManager.blockPromptedDomains) {
            builder.suggest(url);
        }
        if (SignedPaintingsClient.imageManager.blockPromptedDomains.size() >= 2) {
            builder.suggest("all_prompted");
        }
        builder.suggest("anything", (Message)class_2561.method_43471((String)"signed_paintings.domain.warning"));
        return CompletableFuture.completedFuture(builder.build());
    };

    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode domainNode = ClientCommandManager.literal((String)"paintings:domain").build();
        LiteralCommandNode trustNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"trust").then(ClientCommandManager.argument((String)"domain", (ArgumentType)StringArgumentType.greedyString()).suggests(trust).executes(DomainCommand::trust))).build();
        LiteralCommandNode untrustNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"untrust").then(ClientCommandManager.argument((String)"domain", (ArgumentType)StringArgumentType.greedyString()).suggests(untrust).executes(DomainCommand::untrust))).build();
        LiteralCommandNode listNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(DomainCommand::list)).build();
        domainNode.addChild((CommandNode)trustNode);
        domainNode.addChild((CommandNode)untrustNode);
        domainNode.addChild((CommandNode)listNode);
        return domainNode;
    }

    private static int trust(CommandContext<FabricClientCommandSource> context) {
        String domainTemp = StringArgumentType.getString(context, (String)"domain");
        String domain = domainTemp.equals("anything") ? "https://" : domainTemp;
        if (domain.endsWith("//")) {
            class_5250 warning = class_2561.method_43471((String)"signed_paintings.domain.warning");
            if (SignedPaintingsClient.imageManager.trustedDomains.contains(domain)) {
                SignedPaintingsClient.sayTranslated("commands.domain.trust.anything.exists", warning);
                return 0;
            }
            SignedPaintingsClient.client.method_63588(() -> SignedPaintingsClient.client.method_1507((class_437)new DomainWarningScreen(domain, DomainCommand::confirmAnything)));
            return 1;
        }
        if (domain.equals("all_prompted")) {
            int count = 0;
            for (String prompted : new ArrayList<String>(SignedPaintingsClient.imageManager.blockPromptedDomains)) {
                if (!SignedPaintingsClient.imageManager.trustDomain(prompted)) continue;
                ++count;
            }
            SignedPaintingsClient.sayTranslated("commands.domain.trust.all", String.valueOf(count));
            return count;
        }
        if (domain.contains("//")) {
            if (SignedPaintingsClient.imageManager.trustDomain(domain)) {
                SignedPaintingsClient.sayTranslated("commands.domain.trust", domain);
                return 1;
            }
            SignedPaintingsClient.sayTranslated("commands.domain.trust.exists", domain);
        } else {
            SignedPaintingsClient.sayTranslated("commands.domain.invalid", domain);
        }
        return 0;
    }

    private static void confirmAnything(String domain) {
        class_5250 warning = class_2561.method_43471((String)"signed_paintings.domain.warning");
        if (SignedPaintingsClient.imageManager.trustDomain(domain)) {
            if (domain.equals("https://")) {
                SignedPaintingsClient.sayTranslated("commands.domain.trust.anything", warning);
            } else {
                SignedPaintingsClient.sayTranslated("commands.domain.trust", domain);
                SignedPaintingsClient.sayRaw((class_2561)warning.method_10862(class_2583.field_24360.method_27703(SignedPaintingsClient.textColor)));
            }
        } else if (domain.equals("https://")) {
            SignedPaintingsClient.sayTranslated("commands.domain.trust.anything.exists", warning);
        } else {
            SignedPaintingsClient.sayTranslated("commands.domain.trust.exists", domain);
        }
    }

    private static int untrust(CommandContext<FabricClientCommandSource> context) {
        String domain = StringArgumentType.getString(context, (String)"domain");
        if (domain.equals("anything") || domain.equals("https://")) {
            SignedPaintingsClient.imageManager.untrustDomain("http://");
            if (SignedPaintingsClient.imageManager.untrustDomain("https://")) {
                SignedPaintingsClient.sayTranslated("commands.domain.untrust.anything", new Object[0]);
                return 1;
            }
            SignedPaintingsClient.sayTranslated("commands.domain.untrust.anything.missing", new Object[0]);
        } else {
            if (domain.equals("all_trusted")) {
                int count = 0;
                for (String trusted : new ArrayList<String>(SignedPaintingsClient.imageManager.trustedDomains)) {
                    if (!SignedPaintingsClient.imageManager.untrustDomain(trusted)) continue;
                    ++count;
                }
                SignedPaintingsClient.sayTranslated("commands.domain.untrust.all", String.valueOf(count));
                SignedPaintingsClient.imageManager.trustedDomains.clear();
                SignedPaintingsClient.imageManager.reloadAll();
                return count;
            }
            if (domain.contains("//")) {
                if (SignedPaintingsClient.imageManager.untrustDomain(domain)) {
                    SignedPaintingsClient.sayTranslated("commands.domain.untrust", domain);
                    return 1;
                }
                SignedPaintingsClient.sayTranslated("commands.domain.untrust.missing", domain);
            } else {
                SignedPaintingsClient.sayTranslated("commands.domain.invalid", domain);
            }
        }
        return 0;
    }

    private static int list(CommandContext<FabricClientCommandSource> context) {
        class_5250 text = class_2561.method_43471((String)"signed_paintings.commands.domain.list.start");
        for (String domain : SignedPaintingsClient.imageManager.trustedDomains) {
            if (domain.equals("https://")) continue;
            text.method_10852((class_2561)class_2561.method_43469((String)"signed_paintings.commands.domain.list", (Object[])new Object[]{domain}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, domain))));
        }
        if (SignedPaintingsClient.imageManager.trustedDomains.isEmpty()) {
            text.method_10852((class_2561)class_2561.method_43471((String)"signed_paintings.commands.domain.list.none"));
        } else if (SignedPaintingsClient.imageManager.trustedDomains.contains("https://")) {
            text.method_10852((class_2561)class_2561.method_43469((String)"signed_paintings.commands.domain.list.anything", (Object[])new Object[]{class_2561.method_43471((String)"signed_paintings.domain.warning")}));
        }
        SignedPaintingsClient.longSay(text);
        return SignedPaintingsClient.imageManager.trustedDomains.size();
    }
}

