/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.commands.SignedPaintingsCommands;
import com.nettakrim.signed_paintings.util.ImageStatus;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class StatusCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode statusNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"paintings:status").executes(StatusCommand::statusAll)).then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).suggests(SignedPaintingsCommands.images).executes(StatusCommand::status))).build();
        return statusNode;
    }

    private static int statusAll(CommandContext<FabricClientCommandSource> context) {
        ArrayList<ImageStatus> statuses = SignedPaintingsClient.imageManager.getAllStatus();
        long totalSize = 0L;
        statuses.sort(Collections.reverseOrder());
        for (ImageStatus status : statuses) {
            totalSize += status.getTotalSize();
        }
        class_5250 text = StatusCommand.getStatusText("unique", Integer.toString(statuses.size()));
        text.method_10852((class_2561)StatusCommand.getStatusText("total_size", StatusCommand.getKBString(totalSize)));
        for (ImageStatus status : statuses) {
            if (!status.ready) continue;
            class_5250 linkText = StatusCommand.getStatusText("size.link", StatusCommand.getKBString(status.getTotalSize()), status.url);
            linkText.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, status.url)));
            text.method_10852((class_2561)linkText);
        }
        SignedPaintingsClient.longSay(text);
        return 1;
    }

    private static int status(CommandContext<FabricClientCommandSource> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        if (url.equals("all")) {
            return StatusCommand.statusAll(context);
        }
        ImageStatus status = SignedPaintingsClient.imageManager.getUrlStatus(url);
        if (status == null || !status.ready) {
            SignedPaintingsClient.sayTranslated("commands.status.none", url);
            return 0;
        }
        class_5250 text = class_2561.method_43470((String)"").method_10852((class_2561)StatusCommand.getStatusText("link", status.url).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, status.url))));
        text.method_10852((class_2561)StatusCommand.getStatusText("resolutions", Integer.toString(status.getResolutionsCount())));
        text.method_10852((class_2561)StatusCommand.getStatusText("total_size", StatusCommand.getKBString(status.getTotalSize())));
        status.resolutionStatuses.sort(Collections.reverseOrder());
        for (ImageStatus.ResolutionStatus r : status.resolutionStatuses) {
            String size = r.pixels().x + "x" + r.pixels().y;
            text.method_10852((class_2561)StatusCommand.getStatusText("size." + (r.isScaled() ? "scaled" : "default"), StatusCommand.getKBString(r.bytes()), size));
        }
        SignedPaintingsClient.longSay(text);
        return 1;
    }

    private static String getKBString(long bytes) {
        String s;
        int index;
        float amount = (float)bytes / 1024.0f;
        String unit = "KB";
        if (amount > 1024.0f) {
            amount /= 1024.0f;
            unit = "MB";
        }
        if ((index = (s = Float.toString(SignedPaintingsClient.roundFloatTo3DP(amount))).indexOf(46)) >= 4) {
            return s.substring(0, index) + unit;
        }
        return s.substring(0, Math.min(5, s.length())) + unit;
    }

    private static class_5250 getStatusText(String key, Object ... args) {
        return class_2561.method_43469((String)("signed_paintings.commands.status." + key), (Object[])args);
    }
}

