/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.util;

import com.nettakrim.signed_paintings.util.URLAlias;
import java.util.Locale;

public class NormalAlias
extends URLAlias {
    String domain;
    String[] aliases;
    String defaultImageFormat;

    public NormalAlias(String domain, String[] aliases, String defaultImageFormat) {
        this.domain = domain;
        this.aliases = aliases;
        this.defaultImageFormat = defaultImageFormat;
    }

    @Override
    public String tryApply(String url) {
        String lowercaseUrl = url.toLowerCase(Locale.ROOT);
        for (String alias : this.aliases) {
            if (!lowercaseUrl.startsWith(alias)) continue;
            String id = url.substring(alias.length());
            String newText = this.domain + id;
            if (!id.contains(".")) {
                newText = newText + this.defaultImageFormat;
            }
            return newText;
        }
        return url;
    }

    @Override
    public String getShortestAlias(String url) {
        String current;
        String lowercaseUrl = ((String)url).toLowerCase(Locale.ROOT);
        String shortest = current = this.domain;
        if (!lowercaseUrl.startsWith(this.domain)) {
            for (String alias : this.aliases) {
                if (lowercaseUrl.startsWith(alias)) {
                    current = alias;
                }
                if (alias.length() >= shortest.length()) continue;
                shortest = alias;
            }
            if (current.equals(this.domain)) {
                return url;
            }
        }
        url = shortest + ((String)url).substring(current.length());
        return url;
    }
}

