/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.audio;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.phonkedit.PhonkEditMod;
import com.phonkedit.config.ModConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;

public final class CustomSongs {
    private static final Gson GSON = new Gson();
    private static volatile class_2960[] discoveredSoundIds = new class_2960[0];

    private CustomSongs() {
    }

    public static void initializeOnClientStart() {
        CustomSongs.tryCreateTutorialPack();
    }

    public static void onResourceReload(class_3300 manager) {
        CustomSongs.scanLayeredSounds(manager);
    }

    public static class_3414[] getCurrentPhonkSoundEvents(class_3414[] builtin) {
        class_2960[] ids = discoveredSoundIds;
        boolean onlyCustom = ModConfig.INSTANCE.onlyUseCustomSongs;
        if (ids.length == 0) {
            if (onlyCustom) {
                return new class_3414[0];
            }
            return builtin;
        }
        ArrayList<Object> events = new ArrayList<Object>(ids.length + (onlyCustom ? 0 : builtin.length));
        for (class_2960 class_29602 : ids) {
            events.add(class_3414.method_47908((class_2960)class_29602));
        }
        if (!onlyCustom) {
            for (class_2960 class_29603 : builtin) {
                events.add(class_29603);
            }
        }
        return events.toArray(new class_3414[0]);
    }

    private static void scanLayeredSounds(class_3300 manager) {
        HashSet<String> keys = new HashSet<String>();
        List resources = manager.method_14489(class_2960.method_60655((String)"phonkedit", (String)"sounds.json"));
        for (class_3298 res : resources) {
            try (BufferedReader r2 = new BufferedReader(new InputStreamReader(res.method_14482(), StandardCharsets.UTF_8));){
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)r2, JsonObject.class);
                if (obj == null) continue;
                for (String k : obj.keySet()) {
                    JsonElement v = obj.get(k);
                    if (v == null || !v.isJsonObject()) continue;
                    keys.add(k);
                }
            }
            catch (Exception r2) {}
        }
        if (!keys.isEmpty()) {
            ArrayList<String> customKeys = new ArrayList<String>();
            for (String k : keys) {
                if (!k.startsWith("custom/")) continue;
                customKeys.add(k);
            }
            if (!customKeys.isEmpty()) {
                keys = new HashSet(customKeys);
            }
        }
        if (keys.isEmpty()) {
            discoveredSoundIds = new class_2960[0];
            return;
        }
        ArrayList<class_2960> out = new ArrayList<class_2960>(keys.size());
        for (String k : keys) {
            out.add(class_2960.method_60655((String)"phonkedit", (String)k));
        }
        discoveredSoundIds = out.toArray(new class_2960[0]);
        PhonkEditMod.LOGGER.info("Discovered {} phonk sound events from resource packs", (Object)discoveredSoundIds.length);
    }

    private static void tryCreateTutorialPack() {
        try {
            Path packsDir = FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
            Path packRoot = packsDir.resolve("PhonkEdit-CustomSongs");
            Files.createDirectories(packRoot, new FileAttribute[0]);
            String mcmeta = "{\n  \"pack\": {\n    \"pack_format\": 48,\n    \"description\": \"Phonk Edit Custom Songs Tutorial\"\n  }\n}";
            Files.writeString(packRoot.resolve("pack.mcmeta"), (CharSequence)mcmeta, StandardCharsets.UTF_8, new OpenOption[0]);
            Path assetsRoot = packRoot.resolve("assets").resolve("phonkedit");
            Path soundsDir = assetsRoot.resolve("sounds");
            Files.createDirectories(soundsDir, new FileAttribute[0]);
            String readme = "How to add custom songs (2025-10-24)\r\n\r\n1) Create your own resource pack (zip or folder inside resourcepacks).\r\n2) Inside it, create these paths:\r\n   assets/phonkedit/sounds.json\r\n \r\n3) Put your .ogg files in assets/phonkedit/sounds/.\r\n   Example: assets/phonkedit/sounds/custom/bruh.ogg\r\n\r\n4) Edit assets/phonkedit/sounds.json to reference them. Example:\r\n\r\n{\r\n  \"custom/bruh\": { \"category\": \"master\", \"sounds\": [ \"phonkedit:custom/bruh\" ] },\r\n  \"custom/hahahafunisong\": { \"category\": \"master\", \"sounds\": [ \"phonkedit:custom/hahahafunisong\" ] }\r\n}\r\n\r\n5) Enable your pack in Options -> Resource Packs.\r\n6) Trigger the Phonk effect; the mod prefers keys starting with custom/.\r\n\r\nTips:\r\n- Use an audio editor like Audacity, FL Studio, or Adobe Audition to export .ogg files.\r\n- Names in sounds.json map to files under assets/phonkedit/sounds/.\r\n- Use stream: true in your entries for long tracks.\r\n- Keep filenames lowercase and avoid spaces.\r\n";
            Files.writeString(soundsDir.resolve("HOW TO ADD CUSTOM SONGS.txt"), (CharSequence)readme, StandardCharsets.UTF_8, new OpenOption[0]);
            Path exampleJson = assetsRoot.resolve("sounds.json");
            if (!Files.exists(exampleJson, new LinkOption[0])) {
                String example = "{\n  \"custom/bruh\": { \"category\": \"master\", \"sounds\": [ \"phonkedit:custom/bruh\" ] },\n  \"custom/hahahafunisong\": { \"category\": \"master\", \"sounds\": [ \"phonkedit:custom/hahahafunisong\" ] }\n}\n";
                Files.writeString(exampleJson, (CharSequence)example, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.debug("Failed to create tutorial pack: {}", (Object)e.toString());
        }
    }
}

