/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.audio;

import com.phonkedit.ModSounds;
import com.phonkedit.PhonkEditMod;
import com.phonkedit.config.ModConfig;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class PhonkManager {
    private static final PhonkManager INSTANCE = new PhonkManager();
    private final Random random = new Random();
    private class_1113 currentInstance;
    private class_3414 currentSoundEvent;
    private float currentPitch = 1.0f;
    private boolean isPlaying;

    public static PhonkManager getInstance() {
        return INSTANCE;
    }

    public TrackSelection pickRandomTrackAndPitch() {
        double range;
        class_3414 event = this.chooseRandomEvent();
        double max = ModConfig.INSTANCE.phonkPitchMax;
        double min = ModConfig.INSTANCE.phonkPitchMin;
        if (max < min) {
            double temp = min;
            min = max;
            max = temp;
        }
        float pitch = (float)((range = Math.max(0.0, max - min)) == 0.0 ? min : min + this.random.nextDouble() * range);
        return new TrackSelection(event, pitch);
    }

    public void playRandomTrack() {
        TrackSelection selection = this.pickRandomTrackAndPitch();
        this.playSelection(selection.event, selection.pitch);
    }

    public void playTrackById(class_2960 id, float pitch) {
        class_3414 event = class_7923.field_41172.method_17966(id).orElse(null);
        if (event == null) {
            event = this.chooseRandomEvent();
        }
        this.playSelection(event, pitch);
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isCurrentTrackPlaying() {
        class_310 client = class_310.method_1551();
        if (client == null || this.currentInstance == null) {
            return false;
        }
        return client.method_1483().method_4877(this.currentInstance);
    }

    public class_3414 getCurrentSoundEvent() {
        return this.currentSoundEvent;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public void stopAll() {
        class_310 client = class_310.method_1551();
        if (client != null && this.currentInstance != null) {
            client.method_1483().method_4870(this.currentInstance);
        }
        this.currentInstance = null;
        this.currentSoundEvent = null;
        this.isPlaying = false;
    }

    private void playSelection(class_3414 event, float pitch) {
        if (event == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        this.stopAll();
        class_1109 instance = class_1109.method_4757((class_3414)event, (float)1.0f, (float)pitch);
        this.currentInstance = instance;
        this.currentSoundEvent = event;
        this.currentPitch = pitch;
        this.isPlaying = true;
        client.method_1483().method_4873((class_1113)instance);
        PhonkEditMod.LOGGER.info("Playing phonk track {}", (Object)class_7923.field_41172.method_10221((Object)event));
    }

    private class_3414 chooseRandomEvent() {
        class_3414[] sounds = ModSounds.getAllPhonkSounds();
        if (sounds.length == 0) {
            return null;
        }
        return sounds[this.random.nextInt(sounds.length)];
    }

    public static final class TrackSelection {
        public final class_3414 event;
        public final float pitch;

        private TrackSelection(class_3414 event, float pitch) {
            this.event = event;
            this.pitch = pitch;
        }
    }
}

