/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.block.ritual;

import com.phonkedit.ModAdvancements;
import com.phonkedit.ModBlocks;
import com.phonkedit.network.NetworkHandler;
import com.phonkedit.state.PhonkCurseState;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public final class PhlonckRitual {
    private PhlonckRitual() {
    }

    public static boolean start(class_3218 world, class_2338 pos, class_2680 state, class_1542 diamondEntity) {
        if (!state.method_27852(ModBlocks.PHLONCK)) {
            return false;
        }
        if (!diamondEntity.method_6983().method_31574(class_1802.field_8477)) {
            return false;
        }
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return false;
        }
        if (PhonkCurseState.get(server).isCurseBroken()) {
            return false;
        }
        class_243 center = class_243.method_24953((class_2382)pos).method_1031(0.0, 0.1, 0.0);
        PhlonckRitual.consumeDiamond(diamondEntity);
        world.method_8650(pos, false);
        PhlonckRitual.spawnParticles(world, center);
        PhlonckRitual.playSounds(world, center);
        PhlonckRitual.applyShockwave(world, center);
        PhlonckRitual.notifyPlayers(world, server);
        return true;
    }

    private static void consumeDiamond(class_1542 diamondEntity) {
        class_1799 stack = diamondEntity.method_6983();
        stack.method_7934(1);
        if (stack.method_7960()) {
            diamondEntity.method_31472();
        } else {
            diamondEntity.method_6979(stack);
        }
    }

    private static void spawnParticles(class_3218 world, class_243 center) {
        for (int layer = 0; layer < 4; ++layer) {
            double radius = 0.4 + (double)layer * 0.25;
            int count = 32 + layer * 12;
            double height = 0.2 + (double)layer * 0.2;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)count + world.field_9229.method_43058() * 0.2;
                double x = center.field_1352 + Math.cos(angle) * radius;
                double y = center.field_1351 + height;
                double z = center.field_1350 + Math.sin(angle) * radius;
                world.method_14199((class_2394)class_2398.field_22246, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        world.method_14199((class_2394)class_2398.field_11251, center.field_1352, center.field_1351 + 0.3, center.field_1350, 80, 0.6, 0.6, 0.6, 0.01);
        world.method_14199((class_2394)class_2398.field_11221, center.field_1352, center.field_1351 + 0.4, center.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void playSounds(class_3218 world, class_243 center) {
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_23116, class_3419.field_15245, 2.0f, 0.6f);
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14792, class_3419.field_15251, 1.5f, 0.5f);
        world.method_60511(null, center.field_1352, center.field_1351, center.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15245, 2.0f, 0.8f);
    }

    private static void applyShockwave(class_3218 world, class_243 center) {
        List nearby = world.method_18766(player -> player.method_5707(center) <= 36.0);
        for (class_3222 player2 : nearby) {
            player2.method_5643(world.method_48963().method_48831(), 4.0f);
        }
    }

    private static void notifyPlayers(class_3218 world, MinecraftServer server) {
        PhonkCurseState state = PhonkCurseState.get(server);
        state.setCurseBroken(true);
        NetworkHandler.broadcastCurseStatus(server, true);
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            player.field_13987.method_14364((class_2596)new class_5905(10, 60, 20));
            player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)"CURSE BROKEN").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})));
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)"The Phonk Edit Curse Has Been Lifted!").method_27692(class_124.field_1080)));
            ModAdvancements.grantSkullMeOnce(player);
        }
    }
}

