/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.phonkedit.ModSounds;
import com.phonkedit.PhonkEditMod;
import com.phonkedit.audio.CustomSongs;
import com.phonkedit.audio.PhonkManager;
import com.phonkedit.config.ModConfig;
import com.phonkedit.network.NetworkHandler;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_433;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class PhonkEditClient
implements ClientModInitializer {
    private static final class_2960[] BUILTIN_SKULL_TEXTURES = new class_2960[]{class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull1.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull2.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull3.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull4.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull5.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull6.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull7.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull8.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull9.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull10.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull11.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull12.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull13.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull14.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull15.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull16.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull17.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull18.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull19.png")};
    private static final class_2960 SPECIAL_SKULL_PHONK6 = class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull20.png");
    private static final List<class_2960> SKULL_TEXTURES = new ArrayList<class_2960>();
    private static final List<CustomTexture> USER_SKULL_TEXTURES = new ArrayList<CustomTexture>();
    private static final Path USER_CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("phonkedit");
    private static final Path USER_IMAGES_DIR = USER_CONFIG_DIR.resolve("images");
    private static final String DEFAULT_EXPORT_MARKER = ".defaults_copied";
    private static final Set<String> SUPPORTED_IMAGE_EXTENSIONS = Set.of("png", "jpg", "jpeg", "gif", "bmp", "wbmp", "tif", "tiff");
    private static final int SKULL_TEXTURE_SIZE = 256;
    private static final int SKULL_RENDER_SIZE = 256;
    private static int userSkullIdCounter = 0;
    private static int specialSkullIdCounter = 0;
    private static CustomTexture customSpecialSkull = null;
    private static class_2960 currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
    private static class_2960 overrideSkullTexture = null;
    private static boolean curseBroken = false;
    private static boolean wasUsingItemLastTick = false;
    private static boolean wasSleepingLastTick = false;
    private static boolean ridingTargetVehicleLastTick = false;
    private static boolean isFreezeModeActive = false;
    private static int currentSkullIndex = 0;
    private static long worldJoinTime = 0L;
    private static final long WORLD_JOIN_COOLDOWN = 3000L;
    private static final long EFFECT_DELAY = 300L;
    private static long pendingEffectTime = 0L;
    private static final long TRACK_PLAY_GRACE_MS = 600L;
    private static long trackPlayWaitDeadline = 0L;
    private static long freezeActivationTime = 0L;
    private static final long SHAKE_DURATION = 500L;
    private static final int SHAKE_INTENSITY = 8;
    private static final int MAX_BLUR_LAYERS = 8;
    private static final float SCREEN_SHAKE_RANGE = 6.0f;
    private static boolean wasAttackingEntityLastTick = false;
    private static float lastHealth = -1.0f;
    private static boolean lastHealthInitialized = false;
    private static boolean wasBelowLowHealth = false;
    private static boolean requestCapture = false;
    private static class_2960 freezeTextureId = null;
    private static class_1043 freezeTexture = null;
    private static int freezeTexWidth = 0;
    private static int freezeTexHeight = 0;
    private static class_243 preservedVelocity = class_243.field_1353;
    private static boolean hasPreservedVelocity = false;
    private static boolean preservedSprinting = false;
    private static boolean wasOnGroundLastTick = true;
    private static long airStartTimeMs = 0L;
    private static boolean airTriggerConsumed = false;
    private static boolean wasEatingFoodLastTick = false;

    private static void reloadSkullTextureList() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_1060 textureManager = client.method_1531();
        class_3300 resourceManager = client.method_1478();
        if (resourceManager == null) {
            PhonkEditMod.LOGGER.debug("Skipping skull reload; resource manager not ready yet");
            return;
        }
        PhonkEditClient.clearUserSkullTextures(textureManager);
        SKULL_TEXTURES.clear();
        currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
        overrideSkullTexture = null;
        try {
            Files.createDirectories(USER_CONFIG_DIR, new FileAttribute[0]);
            Files.createDirectories(USER_IMAGES_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.error("Unable to prepare skull image directory {}", (Object)USER_IMAGES_DIR, (Object)e);
            currentSkullIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
            return;
        }
        PhonkEditClient.exportDefaultImagesIfNeeded(resourceManager);
        PhonkEditClient.loadCustomSkulls(textureManager);
        if (SKULL_TEXTURES.isEmpty()) {
            Collections.addAll(SKULL_TEXTURES, BUILTIN_SKULL_TEXTURES);
        }
        PhonkEditClient.updateSpecialSkullSelection(resourceManager);
        currentSkullIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
        int userTextureCount = USER_SKULL_TEXTURES.size() + (customSpecialSkull != null ? 1 : 0);
        int totalTextures = SKULL_TEXTURES.size() + (customSpecialSkull != null ? 1 : 0);
        PhonkEditMod.LOGGER.info("Loaded {} skull textures ({} from user directory)", (Object)totalTextures, (Object)userTextureCount);
        if (userTextureCount > 0) {
            PhonkEditMod.LOGGER.info("Custom skull directory: {}", (Object)USER_IMAGES_DIR.toAbsolutePath());
        }
    }

    private static void clearUserSkullTextures(class_1060 textureManager) {
        if (!USER_SKULL_TEXTURES.isEmpty()) {
            for (CustomTexture texture : USER_SKULL_TEXTURES) {
                texture.destroy(textureManager);
            }
            USER_SKULL_TEXTURES.clear();
        }
        if (customSpecialSkull != null) {
            customSpecialSkull.destroy(textureManager);
            customSpecialSkull = null;
        }
        currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
        userSkullIdCounter = 0;
        specialSkullIdCounter = 0;
        overrideSkullTexture = null;
    }

    private static void exportDefaultImagesIfNeeded(class_3300 resourceManager) {
        Path markerInConfig = USER_CONFIG_DIR.resolve(DEFAULT_EXPORT_MARKER);
        Path markerInImages = USER_IMAGES_DIR.resolve(DEFAULT_EXPORT_MARKER);
        if (Files.exists(markerInConfig, new LinkOption[0]) || Files.exists(markerInImages, new LinkOption[0])) {
            return;
        }
        PhonkEditClient.exportBuiltinSkulls(resourceManager);
        PhonkEditClient.exportSpecialSkull(resourceManager);
        try {
            Files.createFile(markerInConfig, new FileAttribute[0]);
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.debug("Unable to record default export marker {}: {}", (Object)markerInConfig, (Object)e.getMessage());
        }
    }

    private static void updateSpecialSkullSelection(class_3300 resourceManager) {
        if (customSpecialSkull != null) {
            currentSpecialSkullTexture = customSpecialSkull.id();
            return;
        }
        boolean hasBuiltinSpecial = resourceManager != null && resourceManager.method_14486(SPECIAL_SKULL_PHONK6).isPresent();
        currentSpecialSkullTexture = hasBuiltinSpecial ? SPECIAL_SKULL_PHONK6 : null;
    }

    private static void exportBuiltinSkulls(class_3300 resourceManager) {
        for (class_2960 id : BUILTIN_SKULL_TEXTURES) {
            String fileName = PhonkEditClient.getFileName(id);
            Path target = USER_IMAGES_DIR.resolve(fileName);
            if (Files.exists(target, new LinkOption[0])) continue;
            resourceManager.method_14486(id).ifPresent(res -> {
                try (InputStream inputStream = res.method_14482();){
                    Files.copy(inputStream, target, new CopyOption[0]);
                }
                catch (IOException ex) {
                    PhonkEditMod.LOGGER.warn("Failed to export default skull {}", (Object)fileName, (Object)ex);
                }
            });
        }
    }

    private static void exportSpecialSkull(class_3300 resourceManager) {
        String fileName = PhonkEditClient.getFileName(SPECIAL_SKULL_PHONK6);
        Path target = USER_IMAGES_DIR.resolve(fileName);
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        resourceManager.method_14486(SPECIAL_SKULL_PHONK6).ifPresent(res -> {
            try (InputStream inputStream = res.method_14482();){
                Files.copy(inputStream, target, new CopyOption[0]);
            }
            catch (IOException ex) {
                PhonkEditMod.LOGGER.warn("Failed to export special skull {}", (Object)fileName, (Object)ex);
            }
        });
    }

    private static void loadCustomSkulls(class_1060 textureManager) {
        try (Stream<Path> paths = Files.list(USER_IMAGES_DIR);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String lower = path.getFileName().toString().toLowerCase(Locale.ROOT);
                String extension = PhonkEditClient.getFileExtension(lower);
                return extension != null && SUPPORTED_IMAGE_EXTENSIONS.contains(extension);
            }).sorted().forEach(path -> {
                String baseName = PhonkEditClient.stripExtension(path.getFileName().toString());
                boolean special = PhonkEditClient.isSpecialName(baseName);
                if (special && customSpecialSkull != null) {
                    return;
                }
                PhonkEditClient.registerCustomSkull(path, textureManager, special);
            });
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.warn("Failed to scan custom skulls in {}", (Object)USER_IMAGES_DIR, (Object)e);
        }
    }

    private static void registerCustomSkull(Path imagePath, class_1060 textureManager, boolean special) {
        LoadedImageData imageData;
        try {
            imageData = PhonkEditClient.loadCustomImageData(imagePath);
        }
        catch (Exception e) {
            PhonkEditMod.LOGGER.warn("Skipping custom skull image {}: {}", (Object)imagePath.getFileName(), (Object)e.getMessage());
            return;
        }
        ArrayList<class_1011> frames = new ArrayList<class_1011>(imageData.frames());
        ArrayList<Integer> frameDurations = new ArrayList<Integer>(imageData.frameDurations());
        boolean animated = frames.size() > 1;
        String baseName = PhonkEditClient.stripExtension(imagePath.getFileName().toString());
        String sanitized = PhonkEditClient.sanitizeResourceName(baseName);
        int suffix = special ? specialSkullIdCounter : userSkullIdCounter;
        String texturePath = special ? "user/skull_special/" + sanitized + "_" + suffix : "user/skull/" + sanitized + "_" + suffix;
        class_2960 id = class_2960.method_60655((String)"phonkedit", (String)texturePath);
        class_1043 texture = null;
        GifAnimation animation = null;
        try {
            class_1011 initialFrameCopy = PhonkEditClient.copyImage((class_1011)frames.get(0));
            texture = new class_1043(initialFrameCopy);
            textureManager.method_4616(id, (class_1044)texture);
            texture.method_4524();
            if (animated) {
                animation = new GifAnimation(frames, frameDurations);
                animation.reset(texture);
            } else {
                for (class_1011 frame : frames) {
                    frame.close();
                }
                frames.clear();
            }
            if (special) {
                ++specialSkullIdCounter;
            } else {
                ++userSkullIdCounter;
            }
            CustomTexture handle = new CustomTexture(id, texture, animation, imagePath);
            if (special) {
                customSpecialSkull = handle;
                currentSpecialSkullTexture = id;
                PhonkEditMod.LOGGER.info("Registered custom special skull texture {}", (Object)imagePath.getFileName());
            } else {
                USER_SKULL_TEXTURES.add(handle);
                SKULL_TEXTURES.add(id);
                PhonkEditMod.LOGGER.debug("Registered custom skull texture {}", (Object)imagePath.getFileName());
            }
        }
        catch (Exception e) {
            if (animation != null) {
                animation.close();
            } else if (!frames.isEmpty()) {
                for (class_1011 frame : frames) {
                    try {
                        frame.close();
                    }
                    catch (Exception exception) {}
                }
                frames.clear();
            }
            if (texture != null) {
                textureManager.method_4615(id);
                try {
                    texture.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PhonkEditMod.LOGGER.warn("Skipping custom skull image {}: {}", (Object)imagePath.getFileName(), (Object)e.getMessage());
        }
    }

    private static String getFileExtension(String filename) {
        int dot = filename.lastIndexOf(46);
        if (dot < 0 || dot == filename.length() - 1) {
            return null;
        }
        return filename.substring(dot + 1).toLowerCase(Locale.ROOT);
    }

    private static boolean isSpecialName(String name) {
        String normalized = name.toLowerCase(Locale.ROOT);
        return normalized.equals("skull20");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoadedImageData loadCustomImageData(Path imagePath) throws IOException {
        String filename = imagePath.getFileName().toString();
        String extension = PhonkEditClient.getFileExtension(filename);
        if ("gif".equals(extension)) {
            return PhonkEditClient.loadGif(imagePath);
        }
        try (InputStream inputStream = Files.newInputStream(imagePath, new OpenOption[0]);){
            LoadedImageData loadedImageData;
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                throw new IOException("Unsupported image format");
            }
            class_1011 nativeImage = PhonkEditClient.bufferedToNative(bufferedImage);
            try {
                class_1011 scaled = PhonkEditClient.scaleToSquare(nativeImage, 256);
                loadedImageData = new LoadedImageData(Collections.singletonList(scaled), Collections.singletonList(Integer.MAX_VALUE));
            }
            catch (Throwable throwable) {
                nativeImage.close();
                throw throwable;
            }
            nativeImage.close();
            return loadedImageData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoadedImageData loadGif(Path imagePath) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("gif");
        if (!readers.hasNext()) {
            throw new IOException("GIF support is unavailable");
        }
        ImageReader reader = readers.next();
        try {
            LoadedImageData loadedImageData;
            block21: {
                ImageInputStream stream = ImageIO.createImageInputStream(Files.newInputStream(imagePath, new OpenOption[0]));
                try {
                    reader.setInput(stream, false, false);
                    int canvasW = -1;
                    int canvasH = -1;
                    try {
                        IIOMetadata streamMeta = reader.getStreamMetadata();
                        int[] wh = PhonkEditClient.parseGifLogicalScreenSize(streamMeta);
                        canvasW = wh[0];
                        canvasH = wh[1];
                    }
                    catch (Exception streamMeta) {
                        // empty catch block
                    }
                    int frameCount = Math.max(1, reader.getNumImages(true));
                    if (canvasW <= 0 || canvasH <= 0) {
                        BufferedImage first = reader.read(0);
                        canvasW = first.getWidth();
                        canvasH = first.getHeight();
                    }
                    BufferedImage canvas = new BufferedImage(canvasW, canvasH, 2);
                    Graphics2D g = canvas.createGraphics();
                    g.setComposite(AlphaComposite.SrcOver);
                    ArrayList<class_1011> frames = new ArrayList<class_1011>(frameCount);
                    ArrayList<Integer> durations = new ArrayList<Integer>(frameCount);
                    for (int i = 0; i < frameCount; ++i) {
                        Composite old;
                        BufferedImage frameImg = reader.read(i);
                        IIOMetadata meta = reader.getImageMetadata(i);
                        int delay = PhonkEditClient.extractGifDelay(meta);
                        GifFrameInfo info = PhonkEditClient.parseGifFrameInfo(meta, frameImg);
                        g.drawImage((Image)frameImg, info.left, info.top, null);
                        BufferedImage snapshot = new BufferedImage(canvasW, canvasH, 2);
                        Graphics2D g2 = snapshot.createGraphics();
                        g2.drawImage((Image)canvas, 0, 0, null);
                        g2.dispose();
                        try (class_1011 nativeComposed = PhonkEditClient.bufferedToNative(snapshot);){
                            class_1011 scaled = PhonkEditClient.scaleToSquare(nativeComposed, 256);
                            frames.add(scaled);
                        }
                        durations.add(delay);
                        if ("restoreToBackgroundColor".equals(info.disposal)) {
                            old = g.getComposite();
                            g.setComposite(AlphaComposite.Clear);
                            g.fillRect(info.left, info.top, info.width, info.height);
                            g.setComposite(old);
                            continue;
                        }
                        if (!"restoreToPrevious".equals(info.disposal)) continue;
                        old = g.getComposite();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(info.left, info.top, info.width, info.height);
                        g.setComposite(old);
                    }
                    g.dispose();
                    if (frames.isEmpty()) {
                        throw new IOException("GIF contains no readable frames");
                    }
                    while (durations.size() < frames.size()) {
                        durations.add(100);
                    }
                    loadedImageData = new LoadedImageData(frames, durations);
                    if (stream == null) break block21;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return loadedImageData;
        }
        finally {
            reader.dispose();
        }
    }

    private static int extractGifDelay(IIOMetadata metadata) {
        int delayCs = 10;
        if (metadata != null) {
            try {
                String format = metadata.getNativeMetadataFormatName();
                Node tree = metadata.getAsTree(format);
                int parsed = PhonkEditClient.findGifDelay(tree);
                if (parsed >= 0) {
                    delayCs = parsed;
                }
            }
            catch (Exception format) {
                // empty catch block
            }
        }
        int delayMs = Math.max(1, delayCs) * 10;
        return Math.max(20, delayMs);
    }

    private static int findGifDelay(Node node) {
        Node delayNode;
        NamedNodeMap attributes;
        if (node == null) {
            return -1;
        }
        if ("GraphicControlExtension".equals(node.getNodeName()) && (attributes = node.getAttributes()) != null && (delayNode = attributes.getNamedItem("delayTime")) != null) {
            try {
                return Integer.parseInt(delayNode.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            int delay = PhonkEditClient.findGifDelay(child);
            if (delay < 0) continue;
            return delay;
        }
        return -1;
    }

    private static int[] parseGifLogicalScreenSize(IIOMetadata streamMeta) {
        int w = -1;
        int h = -1;
        if (streamMeta != null) {
            try {
                String format = streamMeta.getNativeMetadataFormatName();
                Node root = streamMeta.getAsTree(format);
                for (Node n = root.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!"LogicalScreenDescriptor".equals(n.getNodeName())) continue;
                    NamedNodeMap at = n.getAttributes();
                    w = PhonkEditClient.parseIntAttr(at, "logicalScreenWidth", -1);
                    h = PhonkEditClient.parseIntAttr(at, "logicalScreenHeight", -1);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{w, h};
    }

    private static GifFrameInfo parseGifFrameInfo(IIOMetadata meta, BufferedImage img) {
        int left = 0;
        int top = 0;
        int w = img.getWidth();
        int h = img.getHeight();
        String disposal = "none";
        if (meta != null) {
            try {
                String format = meta.getNativeMetadataFormatName();
                Node root = meta.getAsTree(format);
                for (Node n = root.getFirstChild(); n != null; n = n.getNextSibling()) {
                    Node disp;
                    NamedNodeMap at;
                    if ("ImageDescriptor".equals(n.getNodeName())) {
                        at = n.getAttributes();
                        left = PhonkEditClient.parseIntAttr(at, "imageLeftPosition", left);
                        top = PhonkEditClient.parseIntAttr(at, "imageTopPosition", top);
                        w = PhonkEditClient.parseIntAttr(at, "imageWidth", w);
                        h = PhonkEditClient.parseIntAttr(at, "imageHeight", h);
                        continue;
                    }
                    if (!"GraphicControlExtension".equals(n.getNodeName()) || (disp = (at = n.getAttributes()).getNamedItem("disposalMethod")) == null) continue;
                    disposal = disp.getNodeValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new GifFrameInfo(left, top, w, h, disposal);
    }

    private static int parseIntAttr(NamedNodeMap at, String name, int def) {
        if (at == null) {
            return def;
        }
        Node n = at.getNamedItem(name);
        if (n == null) {
            return def;
        }
        try {
            return Integer.parseInt(n.getNodeValue());
        }
        catch (Exception e) {
            return def;
        }
    }

    private static class_1011 bufferedToNative(BufferedImage image) {
        class_1011 nativeImage = new class_1011(image.getWidth(), image.getHeight(), true);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    private static class_1011 copyImage(class_1011 source) {
        class_1011 copy = new class_1011(source.method_4307(), source.method_4323(), true);
        PhonkEditClient.copyImageData(source, copy);
        return copy;
    }

    private static void copyImageData(class_1011 source, class_1011 target) {
        int width = Math.min(source.method_4307(), target.method_4307());
        int height = Math.min(source.method_4323(), target.method_4323());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                target.method_4305(x, y, source.method_4315(x, y));
            }
        }
    }

    private static void tickCustomTextureAnimations() {
        if (!isFreezeModeActive) {
            return;
        }
        class_2960 activeTexture = overrideSkullTexture != null ? overrideSkullTexture : PhonkEditClient.getCurrentSkullTexture();
        CustomTexture active = PhonkEditClient.findCustomTexture(activeTexture);
        if (active != null) {
            active.tick();
        }
    }

    private static CustomTexture findCustomTexture(class_2960 textureId) {
        if (textureId == null) {
            return null;
        }
        if (customSpecialSkull != null && customSpecialSkull.id().equals((Object)textureId)) {
            return customSpecialSkull;
        }
        for (CustomTexture texture : USER_SKULL_TEXTURES) {
            if (!texture.id().equals((Object)textureId)) continue;
            return texture;
        }
        return null;
    }

    private static void resetAnimationFor(class_2960 textureId) {
        CustomTexture texture = PhonkEditClient.findCustomTexture(textureId);
        if (texture != null) {
            texture.resetAnimation();
        }
    }

    private static class_2960 resolveSpecialSkullTexture() {
        if (currentSpecialSkullTexture != null) {
            return currentSpecialSkullTexture;
        }
        if (customSpecialSkull != null) {
            return customSpecialSkull.id();
        }
        if (!USER_SKULL_TEXTURES.isEmpty()) {
            CustomTexture random = USER_SKULL_TEXTURES.get((int)(Math.random() * (double)USER_SKULL_TEXTURES.size()));
            return random.id();
        }
        if (!SKULL_TEXTURES.isEmpty()) {
            return SKULL_TEXTURES.get((int)(Math.random() * (double)SKULL_TEXTURES.size()));
        }
        return BUILTIN_SKULL_TEXTURES.length > 0 ? BUILTIN_SKULL_TEXTURES[0] : null;
    }

    private static boolean isSpecialTrack(class_3414 event) {
        return event == ModSounds.PHONK6;
    }

    private static class_1011 scaleToSquare(class_1011 source, int size) {
        class_1011 result = new class_1011(size, size, true);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                result.method_4305(x, y, 0);
            }
        }
        double scale = Math.min((double)size / (double)source.method_4307(), (double)size / (double)source.method_4323());
        int scaledWidth = Math.max(1, (int)Math.round((double)source.method_4307() * scale));
        int scaledHeight = Math.max(1, (int)Math.round((double)source.method_4323() * scale));
        int offsetX = (size - scaledWidth) / 2;
        int offsetY = (size - scaledHeight) / 2;
        double ratioX = (double)source.method_4307() / (double)scaledWidth;
        double ratioY = (double)source.method_4323() / (double)scaledHeight;
        for (int y = 0; y < scaledHeight; ++y) {
            int srcY = Math.min(source.method_4323() - 1, (int)Math.floor((double)y * ratioY));
            for (int x = 0; x < scaledWidth; ++x) {
                int srcX = Math.min(source.method_4307() - 1, (int)Math.floor((double)x * ratioX));
                int color = source.method_4315(srcX, srcY);
                result.method_4305(offsetX + x, offsetY + y, color);
            }
        }
        return result;
    }

    private static String stripExtension(String filename) {
        int dot = filename.lastIndexOf(46);
        return dot >= 0 ? filename.substring(0, dot) : filename;
    }

    private static String sanitizeResourceName(String input) {
        StringBuilder builder = new StringBuilder();
        String lower = input.toLowerCase(Locale.ROOT);
        for (int i = 0; i < lower.length(); ++i) {
            char c = lower.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-') {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        String sanitized = builder.toString().replaceAll("__+", "_");
        return sanitized.isEmpty() ? "custom" : sanitized;
    }

    private static String getFileName(class_2960 id) {
        String path = id.method_12832();
        int slash = path.lastIndexOf(47);
        return slash >= 0 ? path.substring(slash + 1) : path;
    }

    public void onInitializeClient() {
        NetworkHandler.initClient(payload -> PhonkEditClient.onActivateFromNetwork(payload.soundId(), payload.pitch(), payload.imagePng().orElse(null)), payload -> PhonkEditClient.onCurseStatus(payload.curseBroken()), payload -> PhonkEditClient.onTriggerSuggestion(payload.reason()));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"phonkedit", (String)"custom_songs_loader");
            }

            public void method_14491(class_3300 manager) {
                CustomSongs.onResourceReload(manager);
            }
        });
        PhonkEditMod.LOGGER.info("Phonk Edit client initialized");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            PhonkEditClient.reloadSkullTextureList();
            CustomSongs.initializeOnClientStart();
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> PhonkEditClient.renderOverlayIfActive(drawContext));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean targetIsEntity;
            if (ModConfig.INSTANCE.devDisablePauseOnLostFocus) {
                try {
                    if (client != null && client.field_1690 != null && client.field_1690.field_1837) {
                        client.field_1690.field_1837 = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            PhonkEditClient.tickCustomTextureAnimations();
            if (isFreezeModeActive && !ModConfig.INSTANCE.hardcoreMode && (client.method_1493() || client.field_1755 instanceof class_433)) {
                client.method_1507(null);
            }
            if (pendingEffectTime > 0L && System.currentTimeMillis() >= pendingEffectTime) {
                pendingEffectTime = 0L;
                PhonkEditClient.triggerSyncedOrLocal();
            }
            if (isFreezeModeActive) {
                boolean trackKnown = PhonkManager.getInstance().isPlaying();
                boolean stillPlaying = PhonkManager.getInstance().isCurrentTrackPlaying();
                if (trackKnown) {
                    if (!(stillPlaying || trackPlayWaitDeadline != 0L && System.currentTimeMillis() < trackPlayWaitDeadline)) {
                        PhonkEditClient.endFreezeEffect();
                    }
                } else if (System.currentTimeMillis() - freezeActivationTime >= (long)ModConfig.INSTANCE.effectDuration) {
                    PhonkEditClient.endFreezeEffect();
                }
                if (isFreezeModeActive && !ModConfig.INSTANCE.hardcoreMode && client.field_1724 != null) {
                    client.field_1724.method_18800(0.0, 0.0, 0.0);
                    if (client.field_1724.field_3913 != null) {
                        client.field_1724.field_3913.field_3905 = 0.0f;
                        client.field_1724.field_3913.field_3907 = 0.0f;
                        client.field_1724.field_3913.field_3904 = false;
                        client.field_1724.field_3913.field_3903 = false;
                    }
                    client.field_1724.method_5728(false);
                }
            }
            class_315 options = client.field_1690;
            boolean attackKey = options.field_1886.method_1434();
            boolean bl = targetIsEntity = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331;
            if (ModConfig.INSTANCE.triggerOnEntityHit) {
                boolean entityAttackStarted;
                boolean bl2 = entityAttackStarted = attackKey && targetIsEntity && !wasAttackingEntityLastTick;
                if (entityAttackStarted) {
                    PhonkEditClient.tryTriggerEffect();
                }
                boolean bl3 = wasAttackingEntityLastTick = attackKey && targetIsEntity;
            }
            if (client.field_1724 != null) {
                class_1799 stack;
                class_1268 hand;
                boolean below;
                float currentHealth = client.field_1724.method_6032();
                if (lastHealthInitialized && ModConfig.INSTANCE.triggerOnDamageTaken && currentHealth < lastHealth - 0.001f) {
                    PhonkEditClient.tryTriggerEffect();
                }
                boolean bl4 = below = currentHealth <= ModConfig.INSTANCE.lowHealthThreshold;
                if (ModConfig.INSTANCE.triggerOnLowHealth && below && !wasBelowLowHealth) {
                    PhonkEditClient.tryTriggerEffect();
                }
                wasBelowLowHealth = below;
                lastHealth = currentHealth;
                lastHealthInitialized = true;
                boolean onGround = client.field_1724.method_24828();
                if (onGround) {
                    airStartTimeMs = 0L;
                    airTriggerConsumed = false;
                } else {
                    if (wasOnGroundLastTick || airStartTimeMs == 0L) {
                        airStartTimeMs = System.currentTimeMillis();
                    }
                    if (ModConfig.INSTANCE.triggerOnAirTime && !airTriggerConsumed && airStartTimeMs > 0L) {
                        double thresholdMillis = ModConfig.INSTANCE.airTimeThresholdSeconds * 1000.0;
                        if ((double)(System.currentTimeMillis() - airStartTimeMs) >= thresholdMillis) {
                            airTriggerConsumed = true;
                            PhonkEditClient.tryTriggerEffect();
                        }
                    }
                }
                wasOnGroundLastTick = onGround;
                boolean usingItem = client.field_1724.method_6115();
                boolean eatingThisTick = false;
                if (usingItem && (hand = client.field_1724.method_6058()) != null && !(stack = client.field_1724.method_5998(hand)).method_7960() && stack.method_57353().method_57832(class_9334.field_50075)) {
                    eatingThisTick = true;
                }
                if (!usingItem && wasUsingItemLastTick && wasEatingFoodLastTick) {
                    PhonkEditClient.onFoodStarted();
                }
                wasEatingFoodLastTick = eatingThisTick;
                wasUsingItemLastTick = usingItem;
                boolean sleeping = client.field_1724.method_6113();
                if (sleeping && !wasSleepingLastTick) {
                    PhonkEditClient.onBedUsed();
                }
                wasSleepingLastTick = sleeping;
                boolean ridingTarget = false;
                class_1297 vehicle = client.field_1724.method_5854();
                if (vehicle instanceof class_1690 || vehicle instanceof class_1688) {
                    ridingTarget = true;
                }
                if (ridingTarget && !ridingTargetVehicleLastTick) {
                    PhonkEditClient.onVehicleMounted();
                }
                ridingTargetVehicleLastTick = ridingTarget;
            } else {
                lastHealthInitialized = false;
                wasBelowLowHealth = false;
                wasOnGroundLastTick = true;
                airStartTimeMs = 0L;
                airTriggerConsumed = false;
                wasUsingItemLastTick = false;
                wasSleepingLastTick = false;
                ridingTargetVehicleLastTick = false;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> PhonkEditClient.onWorldJoin());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (isFreezeModeActive) {
                PhonkEditClient.endFreezeEffect();
            }
            pendingEffectTime = 0L;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> PhonkEditClient.onWorldJoin());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (isFreezeModeActive) {
                PhonkEditClient.endFreezeEffect();
            }
            pendingEffectTime = 0L;
        });
    }

    public static void renderOverlayIfActive(class_332 drawContext) {
        if (!isFreezeModeActive) {
            return;
        }
        if (requestCapture) {
            PhonkEditClient.tryCaptureFreezeFrame();
        }
        PhonkEditClient.renderFreezeOverlay(drawContext);
    }

    public static void renderFreezeOverlay(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        long timeSinceActivation = Math.max(0L, System.currentTimeMillis() - freezeActivationTime);
        double shakeFalloff = 0.0;
        if (timeSinceActivation < 500L) {
            double shakeProgress = (double)timeSinceActivation / 500.0;
            double easeOut = 1.0 - Math.pow(1.0 - shakeProgress, 3.0);
            shakeFalloff = 1.0 - easeOut;
        }
        float screenShakeOffsetY = 0.0f;
        if (shakeFalloff > 0.0) {
            float amplitude = (float)(shakeFalloff * 6.0);
            screenShakeOffsetY = (float)((Math.random() * 2.0 - 1.0) * (double)amplitude);
        }
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, screenShakeOffsetY, 0.0f);
        if (freezeTextureId != null && freezeTexWidth > 0 && freezeTexHeight > 0) {
            float sx = (float)screenWidth / (float)Math.max(1, freezeTexWidth);
            float sy = (float)screenHeight / (float)Math.max(1, freezeTexHeight);
            matrices.method_22903();
            matrices.method_22905(sx, sy, 1.0f);
            drawContext.method_25290(freezeTextureId, 0, 0, 0.0f, 0.0f, freezeTexWidth, freezeTexHeight, freezeTexWidth, freezeTexHeight);
            matrices.method_22909();
        }
        if (ModConfig.INSTANCE.darkenScreenDuringEffect) {
            drawContext.method_25294(0, 0, screenWidth, screenHeight, new Color(0, 0, 0, 110).getRGB());
        }
        matrices.method_22909();
        if (!ModConfig.INSTANCE.renderSkullOverlay) {
            return;
        }
        int shakeOffsetX = 0;
        int shakeOffsetY = 0;
        double blurStrength = 0.0;
        double blurEnvelope = 0.0;
        double blurRadius = 0.0;
        boolean allowShake = ModConfig.INSTANCE.skullShakeEnabled;
        boolean allowBlur = ModConfig.INSTANCE.skullBlurEnabled;
        if ((allowShake || allowBlur) && shakeFalloff > 0.0) {
            if (allowShake) {
                double shakeIntensity = shakeFalloff * 8.0 * ModConfig.INSTANCE.shakeIntensity;
                shakeOffsetX = (int)((Math.random() * 2.0 - 1.0) * shakeIntensity);
                shakeOffsetY = (int)((Math.random() * 2.0 - 1.0) * shakeIntensity);
            }
            if (allowBlur) {
                double intensity = 5.0;
                double easePower = Math.max(0.1, ModConfig.INSTANCE.skullBlurEasePower);
                blurEnvelope = Math.pow(shakeFalloff, easePower);
                blurStrength = blurEnvelope * intensity;
                blurRadius = blurStrength * 8.0;
            }
        }
        int skullBaseSize = Math.max(1, Math.round(256.0f * (float)Math.max(0.1, Math.min(2.0, ModConfig.INSTANCE.skullScale))));
        double scaleFactor = class_310.method_1551().method_22683().method_4495();
        double targetGuiScale = 3.0;
        int skullSize = Math.max(1, (int)Math.round((double)skullBaseSize * (targetGuiScale / Math.max(1.0, scaleFactor))));
        int hotbarHeight = 22;
        int padding = 40;
        int y = screenHeight - hotbarHeight - skullSize - padding;
        int xCenter = screenWidth / 2 - skullSize / 2;
        class_2960 skullCenter = PhonkEditClient.getCurrentSkullTexture();
        int shakeXCenter = shakeOffsetX;
        int shakeYCenter = shakeOffsetY;
        if (allowBlur && blurStrength > 0.01) {
            double radius = Math.max(0.5, blurRadius);
            int blurLayers = Math.min(8, Math.max(2, (int)Math.ceil(radius)));
            double sigma = radius / 2.0;
            double twoSigmaSq = 2.0 * sigma * sigma;
            double weightSum = 0.0;
            double[] weights = new double[blurLayers];
            for (int i = 0; i < blurLayers; ++i) {
                double weight;
                double offset = i + 1;
                weights[i] = weight = Math.exp(-(offset * offset) / twoSigmaSq);
                weightSum += weight * 2.0;
            }
            float alphaScale = (float)Math.min(1.0, blurEnvelope);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (int i = 0; i < blurLayers; ++i) {
                double offset = i + 1;
                double weight = weights[i] / weightSum;
                float layerAlpha = (float)((double)alphaScale * weight * 2.0);
                float blurOffset = (float)(offset * radius / (double)blurLayers);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)layerAlpha);
                int drawX = Math.round((float)(xCenter + shakeXCenter) + blurOffset);
                int drawXMirror = Math.round((float)(xCenter + shakeXCenter) - blurOffset);
                PhonkEditClient.drawScaledSkull(drawContext, skullCenter, drawX, y + shakeYCenter, skullSize);
                PhonkEditClient.drawScaledSkull(drawContext, skullCenter, drawXMirror, y + shakeYCenter, skullSize);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        PhonkEditClient.drawScaledSkull(drawContext, skullCenter, xCenter + shakeXCenter, y + shakeYCenter, skullSize);
    }

    private static void drawScaledSkull(class_332 drawContext, class_2960 texture, int x, int y, int size) {
        float scale = (float)size / 256.0f;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        matrices.method_22905(scale, scale, 1.0f);
        drawContext.method_25290(texture, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        matrices.method_22909();
    }

    public static void renderTopLayer(class_332 drawContext) {
        float targetAspect;
        int screenHeight;
        if (!isFreezeModeActive || !ModConfig.INSTANCE.showCinematicBars) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        float currentAspect = (float)screenWidth / (float)(screenHeight = client.method_22683().method_4502());
        if (Math.abs(currentAspect - (targetAspect = 0.5625f)) <= 0.001f) {
            return;
        }
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (currentAspect > targetAspect) {
            float expectedWidth = (float)screenHeight * targetAspect;
            int barWidth = Math.round(((float)screenWidth - expectedWidth) / 2.0f);
            if (barWidth > 0) {
                drawContext.method_25294(0, 0, barWidth, screenHeight, -16777216);
                drawContext.method_25294(screenWidth - barWidth, 0, screenWidth, screenHeight, -16777216);
            }
        } else {
            float expectedHeight = (float)screenWidth / targetAspect;
            int barHeight = Math.round(((float)screenHeight - expectedHeight) / 2.0f);
            if (barHeight > 0) {
                drawContext.method_25294(0, 0, screenWidth, barHeight, -16777216);
                drawContext.method_25294(0, screenHeight - barHeight, screenWidth, screenHeight, -16777216);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        matrices.method_22909();
    }

    public static void activateFreezeEffect() {
        isFreezeModeActive = true;
        freezeActivationTime = System.currentTimeMillis();
        overrideSkullTexture = null;
        currentSkullIndex = 0;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            preservedVelocity = client.field_1724.method_18798();
            preservedSprinting = client.field_1724.method_5624();
            hasPreservedVelocity = true;
        } else {
            preservedVelocity = class_243.field_1353;
            preservedSprinting = false;
            hasPreservedVelocity = false;
        }
        PhonkManager manager = PhonkManager.getInstance();
        manager.playRandomTrack();
        class_3414 currentEvent = manager.getCurrentSoundEvent();
        class_2960 selectedTexture = null;
        if (PhonkEditClient.isSpecialTrack(currentEvent)) {
            class_2960 specialTexture = PhonkEditClient.resolveSpecialSkullTexture();
            if (specialTexture != null) {
                overrideSkullTexture = specialTexture;
                selectedTexture = specialTexture;
            } else if (!SKULL_TEXTURES.isEmpty()) {
                currentSkullIndex = (int)(Math.random() * (double)SKULL_TEXTURES.size());
                selectedTexture = SKULL_TEXTURES.get(currentSkullIndex);
            } else {
                selectedTexture = overrideSkullTexture = SPECIAL_SKULL_PHONK6;
            }
        } else if (!SKULL_TEXTURES.isEmpty()) {
            currentSkullIndex = (int)(Math.random() * (double)SKULL_TEXTURES.size());
            selectedTexture = SKULL_TEXTURES.get(currentSkullIndex);
        } else {
            selectedTexture = overrideSkullTexture = SPECIAL_SKULL_PHONK6;
        }
        if (selectedTexture != null) {
            PhonkEditClient.resetAnimationFor(selectedTexture);
        }
        trackPlayWaitDeadline = manager.isPlaying() && !manager.isCurrentTrackPlaying() ? System.currentTimeMillis() + 600L : 0L;
        requestCapture = true;
        PhonkEditMod.LOGGER.info("Activated freeze effect");
    }

    private static void triggerSyncedOrLocal() {
        boolean canNet;
        if (curseBroken) {
            return;
        }
        class_310 mc = class_310.method_1551();
        boolean bl = canNet = mc != null && mc.method_1562() != null;
        if (canNet) {
            PhonkManager.TrackSelection sel = PhonkManager.getInstance().pickRandomTrackAndPitch();
            class_2960 chosenTexture = PhonkEditClient.chooseSkullTextureForEvent(sel.event);
            byte[] skullPng = PhonkEditClient.encodeSkullTextureToPng(chosenTexture);
            NetworkHandler.sendActivateRequestToServer(PhonkEditClient.getSoundId(sel.event), sel.pitch, skullPng);
        } else {
            PhonkEditClient.activateFreezeEffect();
        }
    }

    private static class_2960 chooseSkullTextureForEvent(class_3414 currentEvent) {
        class_2960 selectedTexture = null;
        if (PhonkEditClient.isSpecialTrack(currentEvent)) {
            class_2960 specialTexture = PhonkEditClient.resolveSpecialSkullTexture();
            if (specialTexture != null) {
                selectedTexture = specialTexture;
            } else if (!SKULL_TEXTURES.isEmpty()) {
                currentSkullIndex = (int)(Math.random() * (double)SKULL_TEXTURES.size());
                selectedTexture = SKULL_TEXTURES.get(currentSkullIndex);
            } else {
                selectedTexture = SPECIAL_SKULL_PHONK6;
            }
        } else if (!SKULL_TEXTURES.isEmpty()) {
            currentSkullIndex = (int)(Math.random() * (double)SKULL_TEXTURES.size());
            selectedTexture = SKULL_TEXTURES.get(currentSkullIndex);
        } else {
            selectedTexture = SPECIAL_SKULL_PHONK6;
        }
        return selectedTexture;
    }

    private static String getSoundId(class_3414 event) {
        class_2960 id = class_7923.field_41172.method_10221((Object)event);
        return id != null ? id.toString() : "phonkedit:phonk1";
    }

    private static byte[] encodeSkullTextureToPng(class_2960 id) {
        class_1043 nibt;
        class_1011 img;
        block11: {
            byte[] byArray;
            block12: {
                class_3300 rm2 = class_310.method_1551().method_1478();
                Optional opt = rm2.method_14486(id);
                if (!opt.isPresent()) break block11;
                InputStream in = ((class_3298)opt.get()).method_14482();
                try {
                    byArray = in.readAllBytes();
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception rm2) {
                        // empty catch block
                    }
                }
                in.close();
            }
            return byArray;
        }
        class_310 mc = class_310.method_1551();
        class_1060 tm = mc.method_1531();
        class_1044 tex = tm.method_4619(id);
        if (tex instanceof class_1043 && (img = (nibt = (class_1043)tex).method_4525()) != null) {
            try {
                Path tmp = Files.createTempFile("phonk-skull", ".png", new FileAttribute[0]);
                img.method_4325(tmp.toFile());
                byte[] bytes = Files.readAllBytes(tmp);
                Files.deleteIfExists(tmp);
                return bytes;
            }
            catch (Exception e) {
                PhonkEditMod.LOGGER.warn("Failed to encode skull texture to PNG: {}", (Object)e.toString());
            }
        }
        return null;
    }

    public static void onActivateFromNetwork(String soundId, float pitch, byte[] skullPng) {
        class_2960 dyn = null;
        if (skullPng != null && skullPng.length > 0) {
            dyn = PhonkEditClient.registerDynamicSkull(skullPng);
        }
        isFreezeModeActive = true;
        freezeActivationTime = System.currentTimeMillis();
        overrideSkullTexture = dyn;
        currentSkullIndex = 0;
        PhonkManager manager = PhonkManager.getInstance();
        class_2960 sid = class_2960.method_12829((String)soundId);
        if (sid != null) {
            manager.playTrackById(sid, pitch);
        } else {
            manager.playRandomTrack();
        }
        if (overrideSkullTexture != null) {
            PhonkEditClient.resetAnimationFor(overrideSkullTexture);
        }
        trackPlayWaitDeadline = manager.isPlaying() && !manager.isCurrentTrackPlaying() ? System.currentTimeMillis() + 600L : 0L;
        requestCapture = true;
        PhonkEditMod.LOGGER.info("Activated freeze effect (synced)");
    }

    private static class_2960 registerDynamicSkull(byte[] png) {
        try {
            class_1011 img = class_1011.method_4309((InputStream)new ByteArrayInputStream(png));
            class_1011 scaled = PhonkEditClient.scaleToSquare(img, 256);
            img.close();
            class_1043 tex = new class_1043(scaled);
            class_2960 id = class_2960.method_60655((String)"phonkedit", (String)("net/skull_" + System.currentTimeMillis()));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
            return id;
        }
        catch (Exception e) {
            PhonkEditMod.LOGGER.warn("Failed to register dynamic skull from PNG: {}", (Object)e.toString());
            return null;
        }
    }

    public static void endFreezeEffect() {
        isFreezeModeActive = false;
        overrideSkullTexture = null;
        class_310 client = class_310.method_1551();
        if (hasPreservedVelocity && client != null && client.field_1724 != null) {
            client.field_1724.method_18799(preservedVelocity);
            client.field_1724.field_6037 = true;
            client.field_1724.method_5728(preservedSprinting);
        }
        hasPreservedVelocity = false;
        preservedVelocity = class_243.field_1353;
        preservedSprinting = false;
        PhonkManager.getInstance().stopAll();
        PhonkEditClient.clearFreezeFrame();
        try {
            NetworkHandler.sendEndEffectToServer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PhonkEditMod.LOGGER.info("Ended freeze effect");
    }

    public static boolean isFreezeModeActive() {
        return isFreezeModeActive;
    }

    public static class_2960 getCurrentSkullTexture() {
        if (overrideSkullTexture != null) {
            return overrideSkullTexture;
        }
        if (SKULL_TEXTURES.isEmpty()) {
            return BUILTIN_SKULL_TEXTURES[0];
        }
        int safeIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
        return SKULL_TEXTURES.get(safeIndex);
    }

    public static void onWorldJoin() {
        worldJoinTime = System.currentTimeMillis();
        pendingEffectTime = 0L;
        curseBroken = false;
        hasPreservedVelocity = false;
        preservedVelocity = class_243.field_1353;
        preservedSprinting = false;
        wasOnGroundLastTick = true;
        airStartTimeMs = 0L;
        airTriggerConsumed = false;
        wasUsingItemLastTick = false;
        wasSleepingLastTick = false;
        ridingTargetVehicleLastTick = false;
    }

    public static boolean canTrigger() {
        return System.currentTimeMillis() - worldJoinTime >= 3000L;
    }

    public static void onBlockBroken() {
        if (!ModConfig.INSTANCE.triggerOnBlockBreak) {
            return;
        }
        PhonkEditClient.scheduleEffect();
    }

    public static void onBlockPlaced() {
        if (!ModConfig.INSTANCE.triggerOnBlockPlace) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    public static void onLeverUsed() {
        if (!ModConfig.INSTANCE.triggerOnLeverUse) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    public static void onDoorUsed() {
        if (!ModConfig.INSTANCE.triggerOnDoorUse) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    public static void onVehicleMounted() {
        if (!ModConfig.INSTANCE.triggerOnVehicleMount) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    public static void onFoodStarted() {
        if (!ModConfig.INSTANCE.triggerOnEatFood) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    public static void onBedUsed() {
        if (!ModConfig.INSTANCE.triggerOnUseBed) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    private static void scheduleEffect() {
        PhonkEditClient.scheduleEffect(false);
    }

    private static void scheduleEffect(boolean force) {
        if (curseBroken) {
            return;
        }
        if (!ModConfig.INSTANCE.enablePhonkEffect) {
            return;
        }
        if (!PhonkEditClient.canTrigger()) {
            return;
        }
        if (isFreezeModeActive) {
            return;
        }
        if (pendingEffectTime > 0L) {
            return;
        }
        if (!force && Math.random() > ModConfig.INSTANCE.triggerChance) {
            return;
        }
        pendingEffectTime = System.currentTimeMillis() + 300L;
    }

    private static void tryTriggerEffect() {
        PhonkEditClient.scheduleEffect(false);
    }

    private static void tryCaptureFreezeFrame() {
        requestCapture = false;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        try {
            int y;
            class_276 fb = client.method_1522();
            int w = client.method_22683().method_4489();
            int h = client.method_22683().method_4506();
            class_1011 image = null;
            try {
                Class<?> sr = Class.forName("net.minecraft.client.util.ScreenshotRecorder");
                Method method = null;
                for (Method m : sr.getDeclaredMethods()) {
                    if (!m.getName().equals("takeScreenshot") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(fb.getClass()) || !class_1011.class.isAssignableFrom(m.getReturnType())) continue;
                    method = m;
                    break;
                }
                if (method != null) {
                    method.setAccessible(true);
                    image = (class_1011)method.invoke(null, fb);
                }
            }
            catch (Throwable sr) {
                // empty catch block
            }
            if (image == null) {
                image = new class_1011(w, h, false);
                fb.method_35610();
                image.method_4327(0, false);
                fb.method_1242();
            }
            int half = h / 2;
            for (y = 0; y < half; ++y) {
                int opposite = h - 1 - y;
                for (int x = 0; x < w; ++x) {
                    int c1 = image.method_4315(x, y);
                    int c2 = image.method_4315(x, opposite);
                    image.method_4305(x, y, c2);
                    image.method_4305(x, opposite, c1);
                }
            }
            if (ModConfig.INSTANCE.grayscaleFreezeFrame) {
                for (y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int argb = image.method_4315(x, y);
                        int a = argb >> 24 & 0xFF;
                        int r = argb & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb >> 16 & 0xFF;
                        int gray = (int)Math.min(255L, Math.round(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b));
                        int newAbgr = a << 24 | gray << 16 | gray << 8 | gray;
                        image.method_4305(x, y, newAbgr);
                    }
                }
            }
            PhonkEditClient.clearFreezeFrame();
            freezeTexture = new class_1043(image);
            freezeTextureId = class_2960.method_60655((String)"phonkedit", (String)"freeze_frame");
            class_1060 tm = client.method_1531();
            tm.method_4616(freezeTextureId, (class_1044)freezeTexture);
            freezeTexWidth = w;
            freezeTexHeight = h;
        }
        catch (Throwable t) {
            PhonkEditMod.LOGGER.warn("Failed to capture freeze frame: {}", (Object)t.toString());
        }
    }

    private static void clearFreezeFrame() {
        class_310 client = class_310.method_1551();
        if (client != null && freezeTextureId != null) {
            try {
                client.method_1531().method_4615(freezeTextureId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (freezeTexture != null) {
            try {
                freezeTexture.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        freezeTexture = null;
        freezeTextureId = null;
        freezeTexWidth = 0;
        freezeTexHeight = 0;
    }

    private static void onCurseStatus(boolean broken) {
        curseBroken = broken;
        if (broken) {
            pendingEffectTime = 0L;
        }
    }

    private static void onTriggerSuggestion(String reason) {
        boolean allowed;
        if (curseBroken) {
            return;
        }
        switch (reason) {
            case "boss:dragon": {
                boolean bl = ModConfig.INSTANCE.triggerOnDragonKill;
                break;
            }
            case "boss:wither": {
                boolean bl = ModConfig.INSTANCE.triggerOnWitherKill;
                break;
            }
            case "boss:warden": {
                boolean bl = ModConfig.INSTANCE.triggerOnWardenKill;
                break;
            }
            case "boss:elder_guardian": {
                boolean bl = ModConfig.INSTANCE.triggerOnElderGuardianKill;
                break;
            }
            default: {
                boolean bl = allowed = false;
            }
        }
        if (!allowed) {
            return;
        }
        PhonkEditClient.scheduleEffect(false);
    }

    private static final class CustomTexture {
        private final class_2960 id;
        private final class_1043 texture;
        private final GifAnimation animation;
        private final Path sourcePath;

        private CustomTexture(class_2960 id, class_1043 texture, GifAnimation animation, Path sourcePath) {
            this.id = id;
            this.texture = texture;
            this.animation = animation;
            this.sourcePath = sourcePath;
        }

        private class_2960 id() {
            return this.id;
        }

        private void tick() {
            if (this.animation != null) {
                this.animation.tick(this.texture);
            }
        }

        private void resetAnimation() {
            if (this.animation != null) {
                this.animation.reset(this.texture);
            }
        }

        private void destroy(class_1060 textureManager) {
            if (textureManager != null) {
                textureManager.method_4615(this.id);
            }
            if (this.animation != null) {
                this.animation.close();
            }
            try {
                this.texture.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "CustomTexture{" + String.valueOf(this.id) + " from " + String.valueOf(this.sourcePath.getFileName()) + "}";
        }
    }

    private static final class LoadedImageData {
        private final List<class_1011> frames;
        private final List<Integer> frameDurations;

        private LoadedImageData(List<class_1011> frames, List<Integer> durations) {
            if (frames == null || frames.isEmpty()) {
                throw new IllegalArgumentException("frames must not be empty");
            }
            this.frames = List.copyOf(frames);
            if (durations == null || durations.isEmpty()) {
                durations = Collections.nCopies(this.frames.size(), 100);
            } else if (durations.size() < this.frames.size()) {
                ArrayList<Integer> copy = new ArrayList<Integer>(durations);
                while (copy.size() < this.frames.size()) {
                    copy.add(100);
                }
                durations = copy;
            }
            this.frameDurations = List.copyOf(durations);
        }

        private List<class_1011> frames() {
            return this.frames;
        }

        private List<Integer> frameDurations() {
            return this.frameDurations;
        }
    }

    private static final class GifAnimation
    implements AutoCloseable {
        private final List<class_1011> frames;
        private final int[] frameDurations;
        private int frameIndex = 0;
        private long frameStartTime = System.currentTimeMillis();

        private GifAnimation(List<class_1011> frames, List<Integer> durations) {
            this.frames = new ArrayList<class_1011>(frames);
            this.frameDurations = new int[this.frames.size()];
            for (int i = 0; i < this.frames.size(); ++i) {
                int duration = i < durations.size() ? durations.get(i) : (durations.isEmpty() ? 100 : durations.get(durations.size() - 1));
                this.frameDurations[i] = Math.max(20, duration);
            }
        }

        private void reset(class_1043 texture) {
            this.frameIndex = 0;
            this.frameStartTime = System.currentTimeMillis();
            this.apply(texture);
        }

        private void tick(class_1043 texture) {
            int duration;
            if (this.frames.size() <= 1) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.frameStartTime >= (long)(duration = this.frameDurations[this.frameIndex])) {
                this.frameIndex = (this.frameIndex + 1) % this.frames.size();
                this.frameStartTime = now;
                this.apply(texture);
            }
        }

        private void apply(class_1043 texture) {
            class_1011 target = texture.method_4525();
            if (target == null) {
                return;
            }
            PhonkEditClient.copyImageData(this.frames.get(this.frameIndex), target);
            texture.method_4524();
        }

        @Override
        public void close() {
            for (class_1011 frame : this.frames) {
                frame.close();
            }
        }
    }

    private static class GifFrameInfo {
        final int left;
        final int top;
        final int width;
        final int height;
        final String disposal;

        GifFrameInfo(int left, int top, int width, int height, String disposal) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.disposal = disposal;
        }
    }
}

