/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.phonkedit.PhonkEditMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("phonkedit.json");
    public boolean enablePhonkEffect = true;
    public double triggerChance = 0.3;
    public int effectDuration = 3000;
    public double shakeIntensity = 1.0;
    public double phonkPitchMin = 0.95;
    public double phonkPitchMax = 1.05;
    public boolean onlyUseCustomSongs = false;
    public boolean grayscaleFreezeFrame = true;
    public boolean darkenScreenDuringEffect = true;
    public boolean showCinematicBars = true;
    public boolean renderSkullOverlay = true;
    public double skullScale = 0.4;
    public boolean skullShakeEnabled = true;
    public boolean skullBlurEnabled = true;
    public double skullBlurIntensity = 5.0;
    public double skullBlurEasePower = 1.5;
    public double airTimeThresholdSeconds = 1.3;
    public float lowHealthThreshold = 6.0f;
    public boolean triggerOnBlockBreak = true;
    public boolean triggerOnBlockPlace = true;
    public boolean triggerOnEntityHit = true;
    public boolean triggerOnDamageTaken = true;
    public boolean triggerOnLowHealth = true;
    public boolean triggerOnAirTime = true;
    public boolean triggerOnLeverUse = true;
    public boolean triggerOnDoorUse = true;
    public boolean triggerOnVehicleMount = true;
    public boolean triggerOnEatFood = true;
    public boolean triggerOnUseBed = true;
    public boolean triggerOnDragonKill = true;
    public boolean triggerOnWitherKill = true;
    public boolean triggerOnWardenKill = true;
    public boolean triggerOnElderGuardianKill = true;
    public boolean pauseServerDuringEffect = true;
    public boolean lockMouseDuringEffect = true;
    public boolean lockCameraDuringEffect = true;
    public boolean hardcoreMode = false;
    public boolean devDisablePauseOnLostFocus = false;
    public boolean devDontEndOnPause = false;
    public boolean modMenuDisclaimerShown = false;
    public static ModConfig INSTANCE = new ModConfig();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                INSTANCE = (ModConfig)GSON.fromJson(json, ModConfig.class);
            }
            catch (IOException e) {
                PhonkEditMod.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
        INSTANCE.normalize();
        ModConfig.save();
    }

    public static void save() {
        try {
            INSTANCE.normalize();
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)INSTANCE), new OpenOption[0]);
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private void normalize() {
        double min = Math.min(this.phonkPitchMin, this.phonkPitchMax);
        double max = Math.max(this.phonkPitchMin, this.phonkPitchMax);
        min = ModConfig.clampPitch(min);
        max = ModConfig.clampPitch(max);
        this.phonkPitchMin = min;
        this.phonkPitchMax = max;
        if (Math.abs(this.triggerChance - 0.1) < 1.0E-9) {
            this.triggerChance = 0.5;
        }
        this.triggerChance = ModConfig.clamp(this.triggerChance, 0.0, 1.0);
        this.skullBlurIntensity = ModConfig.clamp(this.skullBlurIntensity, 0.0, 5.0);
        this.skullBlurEasePower = ModConfig.clamp(this.skullBlurEasePower, 0.1, 5.0);
        this.airTimeThresholdSeconds = ModConfig.clamp(this.airTimeThresholdSeconds, 0.1, 10.0);
        this.skullScale = ModConfig.clamp(this.skullScale, 0.1, 2.0);
    }

    private static double clampPitch(double value) {
        return Math.max(0.5, Math.min(2.0, value));
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }
}

