/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.network;

import com.phonkedit.config.ModConfig;
import com.phonkedit.network.CurseStatusPayload;
import com.phonkedit.network.EffectSyncPayload;
import com.phonkedit.network.EndEffectPayload;
import com.phonkedit.network.TriggerSuggestionPayload;
import com.phonkedit.state.PhonkCurseState;
import com.phonkedit.state.ServerFreezeState;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class NetworkHandler {
    private static boolean registered;

    private NetworkHandler() {
    }

    private static synchronized void ensureRegistered() {
        if (registered) {
            return;
        }
        PayloadTypeRegistry.playC2S().register(EffectSyncPayload.ID, EffectSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(EndEffectPayload.ID, EndEffectPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(EffectSyncPayload.ID, EffectSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CurseStatusPayload.ID, CurseStatusPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TriggerSuggestionPayload.ID, TriggerSuggestionPayload.CODEC);
        registered = true;
    }

    public static void initServer() {
        NetworkHandler.ensureRegistered();
        ServerPlayNetworking.registerGlobalReceiver(EffectSyncPayload.ID, (payload, context) -> context.server().execute(() -> {
            MinecraftServer server = context.server();
            if (PhonkCurseState.get(server).isCurseBroken()) {
                return;
            }
            if (!ModConfig.INSTANCE.hardcoreMode) {
                ServerFreezeState.protectDamageForMillis(Long.MAX_VALUE);
                if (!server.method_3816() && ModConfig.INSTANCE.pauseServerDuringEffect) {
                    ServerFreezeState.freezeWorldForMillis(Long.MAX_VALUE);
                }
            }
            NetworkHandler.broadcast(server, payload.soundId(), payload.pitch(), payload.imagePng().orElse(null));
        }));
        ServerPlayNetworking.registerGlobalReceiver(EndEffectPayload.ID, (payload, context) -> context.server().execute(() -> ServerFreezeState.endProtectionNow()));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> NetworkHandler.sendCurseStatus(handler.field_14140, PhonkCurseState.get(server).isCurseBroken()));
    }

    public static void initClient(Consumer<EffectSyncPayload> effectHandler, Consumer<CurseStatusPayload> statusHandler, Consumer<TriggerSuggestionPayload> triggerHandler) {
        NetworkHandler.ensureRegistered();
        ClientPlayNetworking.registerGlobalReceiver(EffectSyncPayload.ID, (payload, context) -> context.client().execute(() -> effectHandler.accept((EffectSyncPayload)payload)));
        ClientPlayNetworking.registerGlobalReceiver(CurseStatusPayload.ID, (payload, context) -> context.client().execute(() -> statusHandler.accept((CurseStatusPayload)payload)));
        ClientPlayNetworking.registerGlobalReceiver(TriggerSuggestionPayload.ID, (payload, context) -> context.client().execute(() -> triggerHandler.accept((TriggerSuggestionPayload)payload)));
    }

    public static void sendActivateRequestToServer(String soundId, float pitch, byte[] skullPng) {
        ClientPlayNetworking.send((class_8710)new EffectSyncPayload(soundId, pitch, Optional.ofNullable(skullPng)));
    }

    public static void sendEndEffectToServer() {
        ClientPlayNetworking.send((class_8710)new EndEffectPayload());
    }

    public static void sendEffectToAll(MinecraftServer server, String soundId, float pitch, byte[] imagePng) {
        NetworkHandler.ensureRegistered();
        NetworkHandler.broadcast(server, soundId, pitch, imagePng);
    }

    public static void sendEffectToAll(MinecraftServer server, String soundId, float pitch) {
        NetworkHandler.sendEffectToAll(server, soundId, pitch, null);
    }

    public static void sendCurseStatus(class_3222 player, boolean broken) {
        NetworkHandler.ensureRegistered();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new CurseStatusPayload(broken));
    }

    public static void broadcastCurseStatus(MinecraftServer server, boolean broken) {
        NetworkHandler.ensureRegistered();
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new CurseStatusPayload(broken));
        }
    }

    public static void sendTriggerSuggestion(class_3222 player, String reason) {
        NetworkHandler.ensureRegistered();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TriggerSuggestionPayload(reason));
    }

    private static void broadcast(MinecraftServer server, String soundId, float pitch, byte[] imagePng) {
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new EffectSyncPayload(soundId, pitch, Optional.ofNullable(imagePng)));
        }
    }
}

