/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.phonkedit.ModSounds;
import com.phonkedit.PhonkEditMod;
import com.phonkedit.audio.PhonkManager;
import com.phonkedit.config.ModConfig;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class PhonkEditClient
implements ClientModInitializer {
    private static final class_2960[] BUILTIN_SKULL_TEXTURES = new class_2960[]{class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull1.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull2.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull3.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull4.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull5.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull6.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull7.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull8.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull9.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull10.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull11.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull12.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull13.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull14.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull15.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull16.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull17.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull18.png"), class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull19.png")};
    private static final class_2960 SPECIAL_SKULL_PHONK6 = class_2960.method_60655((String)"phonkedit", (String)"textures/gui/skull20.png");
    private static final List<class_2960> SKULL_TEXTURES = new ArrayList<class_2960>();
    private static final List<class_2960> USER_SKULL_TEXTURE_IDS = new ArrayList<class_2960>();
    private static final Path USER_IMAGES_DIR = FabricLoader.getInstance().getConfigDir().resolve("phonkedit").resolve("images");
    private static final int SKULL_TEXTURE_SIZE = 256;
    private static final int SKULL_RENDER_SIZE = 256;
    private static final float SKULL_RENDER_SCALE = 0.4f;
    private static int userSkullIdCounter = 0;
    private static int specialSkullIdCounter = 0;
    private static class_2960 customSpecialSkullId = null;
    private static class_2960 currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
    private static class_2960 overrideSkullTexture = null;
    private static boolean isFreezeModeActive = false;
    private static int currentSkullIndex = 0;
    private static long worldJoinTime = 0L;
    private static final long WORLD_JOIN_COOLDOWN = 3000L;
    private static final long EFFECT_DELAY = 300L;
    private static long pendingEffectTime = 0L;
    private static long freezeActivationTime = 0L;
    private static final long SHAKE_DURATION = 500L;
    private static final int SHAKE_INTENSITY = 8;
    private static final int MAX_BLUR_LAYERS = 8;
    private static final float SCREEN_SHAKE_RANGE = 6.0f;
    private static boolean wasAttackingEntityLastTick = false;
    private static float lastHealth = -1.0f;
    private static boolean lastHealthInitialized = false;
    private static boolean wasBelowLowHealth = false;
    private static boolean requestCapture = false;
    private static class_2960 freezeTextureId = null;
    private static class_1043 freezeTexture = null;
    private static int freezeTexWidth = 0;
    private static int freezeTexHeight = 0;
    private static class_243 preservedVelocity = class_243.field_1353;
    private static boolean hasPreservedVelocity = false;
    private static boolean preservedSprinting = false;
    private static boolean wasOnGroundLastTick = true;
    private static long airStartTimeMs = 0L;
    private static boolean airTriggerConsumed = false;

    private static void reloadSkullTextureList() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_1060 textureManager = client.method_1531();
        class_3300 resourceManager = client.method_1478();
        if (resourceManager == null) {
            PhonkEditMod.LOGGER.debug("Skipping skull reload; resource manager not ready yet");
            return;
        }
        PhonkEditClient.clearUserSkullTextures(textureManager);
        SKULL_TEXTURES.clear();
        Collections.addAll(SKULL_TEXTURES, BUILTIN_SKULL_TEXTURES);
        currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
        overrideSkullTexture = null;
        try {
            Files.createDirectories(USER_IMAGES_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.error("Unable to prepare skull image directory {}", (Object)USER_IMAGES_DIR, (Object)e);
            currentSkullIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
            return;
        }
        PhonkEditClient.exportBuiltinSkulls(resourceManager);
        PhonkEditClient.exportSpecialSkull(resourceManager);
        PhonkEditClient.loadCustomSkulls(textureManager);
        if (SKULL_TEXTURES.isEmpty()) {
            Collections.addAll(SKULL_TEXTURES, BUILTIN_SKULL_TEXTURES);
        }
        currentSkullIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
        int customCount = Math.max(0, SKULL_TEXTURES.size() - BUILTIN_SKULL_TEXTURES.length);
        PhonkEditMod.LOGGER.info("Loaded {} skull textures ({} custom)", (Object)SKULL_TEXTURES.size(), (Object)customCount);
        if (customCount > 0) {
            PhonkEditMod.LOGGER.info("Custom skull directory: {}", (Object)USER_IMAGES_DIR.toAbsolutePath());
        }
    }

    private static void clearUserSkullTextures(class_1060 textureManager) {
        if (!USER_SKULL_TEXTURE_IDS.isEmpty()) {
            for (class_2960 id : USER_SKULL_TEXTURE_IDS) {
                textureManager.method_4615(id);
            }
            USER_SKULL_TEXTURE_IDS.clear();
        }
        if (customSpecialSkullId != null) {
            textureManager.method_4615(customSpecialSkullId);
            customSpecialSkullId = null;
        }
        currentSpecialSkullTexture = SPECIAL_SKULL_PHONK6;
        userSkullIdCounter = 0;
        specialSkullIdCounter = 0;
        overrideSkullTexture = null;
    }

    private static void exportBuiltinSkulls(class_3300 resourceManager) {
        for (class_2960 id : BUILTIN_SKULL_TEXTURES) {
            String fileName = PhonkEditClient.getFileName(id);
            Path target = USER_IMAGES_DIR.resolve(fileName);
            if (Files.exists(target, new LinkOption[0])) continue;
            resourceManager.method_14486(id).ifPresent(res -> {
                try (InputStream inputStream = res.method_14482();){
                    Files.copy(inputStream, target, new CopyOption[0]);
                }
                catch (IOException ex) {
                    PhonkEditMod.LOGGER.warn("Failed to export default skull {}", (Object)fileName, (Object)ex);
                }
            });
        }
    }

    private static void exportSpecialSkull(class_3300 resourceManager) {
        String fileName = PhonkEditClient.getFileName(SPECIAL_SKULL_PHONK6);
        Path target = USER_IMAGES_DIR.resolve(fileName);
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        resourceManager.method_14486(SPECIAL_SKULL_PHONK6).ifPresent(res -> {
            try (InputStream inputStream = res.method_14482();){
                Files.copy(inputStream, target, new CopyOption[0]);
            }
            catch (IOException ex) {
                PhonkEditMod.LOGGER.warn("Failed to export special skull {}", (Object)fileName, (Object)ex);
            }
        });
    }

    private static void loadCustomSkulls(class_1060 textureManager) {
        try (Stream<Path> paths = Files.list(USER_IMAGES_DIR);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String lower = path.getFileName().toString().toLowerCase(Locale.ROOT);
                return lower.endsWith(".png");
            }).sorted().forEach(path -> {
                String baseName = PhonkEditClient.stripExtension(path.getFileName().toString()).toLowerCase(Locale.ROOT);
                boolean special = baseName.equals("skull20");
                if (special && customSpecialSkullId != null) {
                    return;
                }
                PhonkEditClient.registerCustomSkull(path, textureManager, special);
            });
        }
        catch (IOException e) {
            PhonkEditMod.LOGGER.warn("Failed to scan custom skulls in {}", (Object)USER_IMAGES_DIR, (Object)e);
        }
    }

    private static void registerCustomSkull(Path imagePath, class_1060 textureManager, boolean special) {
        try (class_1011 source = class_1011.method_4309((InputStream)Files.newInputStream(imagePath, new OpenOption[0]));){
            class_2960 id;
            class_1011 scaled = PhonkEditClient.scaleToSquare(source, 256);
            class_1043 texture = new class_1043(scaled);
            String baseName = PhonkEditClient.stripExtension(imagePath.getFileName().toString());
            String sanitized = PhonkEditClient.sanitizeResourceName(baseName);
            if (special) {
                String texturePath = "user/skull_special/" + sanitized + "_" + specialSkullIdCounter++;
                id = class_2960.method_60655((String)"phonkedit", (String)texturePath);
            } else {
                String texturePath = "user/skull/" + sanitized + "_" + userSkullIdCounter++;
                id = class_2960.method_60655((String)"phonkedit", (String)texturePath);
            }
            textureManager.method_4616(id, (class_1044)texture);
            if (special) {
                customSpecialSkullId = id;
                currentSpecialSkullTexture = id;
                PhonkEditMod.LOGGER.info("Registered custom special skull texture {} for phonk6", (Object)imagePath.getFileName());
            } else {
                USER_SKULL_TEXTURE_IDS.add(id);
                SKULL_TEXTURES.add(id);
            }
        }
        catch (Exception e) {
            PhonkEditMod.LOGGER.warn("Skipping custom skull image {}: {}", (Object)imagePath.getFileName(), (Object)e.getMessage());
        }
    }

    private static class_1011 scaleToSquare(class_1011 source, int size) {
        class_1011 result = new class_1011(size, size, true);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                result.method_4305(x, y, 0);
            }
        }
        double scale = Math.min((double)size / (double)source.method_4307(), (double)size / (double)source.method_4323());
        int scaledWidth = Math.max(1, (int)Math.round((double)source.method_4307() * scale));
        int scaledHeight = Math.max(1, (int)Math.round((double)source.method_4323() * scale));
        int offsetX = (size - scaledWidth) / 2;
        int offsetY = (size - scaledHeight) / 2;
        double ratioX = (double)source.method_4307() / (double)scaledWidth;
        double ratioY = (double)source.method_4323() / (double)scaledHeight;
        for (int y = 0; y < scaledHeight; ++y) {
            int srcY = Math.min(source.method_4323() - 1, (int)Math.floor((double)y * ratioY));
            for (int x = 0; x < scaledWidth; ++x) {
                int srcX = Math.min(source.method_4307() - 1, (int)Math.floor((double)x * ratioX));
                int color = source.method_4315(srcX, srcY);
                result.method_4305(offsetX + x, offsetY + y, color);
            }
        }
        return result;
    }

    private static String stripExtension(String filename) {
        int dot = filename.lastIndexOf(46);
        return dot >= 0 ? filename.substring(0, dot) : filename;
    }

    private static String sanitizeResourceName(String input) {
        StringBuilder builder = new StringBuilder();
        String lower = input.toLowerCase(Locale.ROOT);
        for (int i = 0; i < lower.length(); ++i) {
            char c = lower.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-') {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        String sanitized = builder.toString().replaceAll("__+", "_");
        return sanitized.isEmpty() ? "custom" : sanitized;
    }

    private static String getFileName(class_2960 id) {
        String path = id.method_12832();
        int slash = path.lastIndexOf(47);
        return slash >= 0 ? path.substring(slash + 1) : path;
    }

    public void onInitializeClient() {
        PhonkEditMod.LOGGER.info("Phonk Edit client initialized");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> PhonkEditClient.reloadSkullTextureList());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (class_310.method_1551().field_1755 != null) {
                return;
            }
            PhonkEditClient.renderOverlayIfActive(drawContext);
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean targetIsEntity;
            if (pendingEffectTime > 0L && System.currentTimeMillis() >= pendingEffectTime) {
                pendingEffectTime = 0L;
                PhonkEditClient.activateFreezeEffect();
            }
            if (isFreezeModeActive) {
                boolean trackKnown = PhonkManager.getInstance().isPlaying();
                boolean stillPlaying = PhonkManager.getInstance().isCurrentTrackPlaying();
                if (trackKnown) {
                    if (!stillPlaying) {
                        PhonkEditClient.endFreezeEffect();
                    }
                } else if (System.currentTimeMillis() - freezeActivationTime >= (long)ModConfig.INSTANCE.effectDuration) {
                    PhonkEditClient.endFreezeEffect();
                }
                if (isFreezeModeActive && client.field_1724 != null) {
                    client.field_1724.method_18800(0.0, 0.0, 0.0);
                    if (client.field_1724.field_3913 != null) {
                        client.field_1724.field_3913.field_3905 = 0.0f;
                        client.field_1724.field_3913.field_3907 = 0.0f;
                        client.field_1724.field_3913.field_3904 = false;
                        client.field_1724.field_3913.field_3903 = false;
                    }
                    client.field_1724.method_5728(false);
                }
            }
            class_315 options = client.field_1690;
            boolean attackKey = options.field_1886.method_1434();
            boolean bl = targetIsEntity = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331;
            if (ModConfig.INSTANCE.triggerOnEntityHit) {
                boolean entityAttackStarted;
                boolean bl2 = entityAttackStarted = attackKey && targetIsEntity && !wasAttackingEntityLastTick;
                if (entityAttackStarted) {
                    PhonkEditClient.tryTriggerEffect();
                }
                boolean bl3 = wasAttackingEntityLastTick = attackKey && targetIsEntity;
            }
            if (client.field_1724 != null) {
                boolean below;
                float currentHealth = client.field_1724.method_6032();
                if (lastHealthInitialized && ModConfig.INSTANCE.triggerOnDamageTaken && currentHealth < lastHealth - 0.001f) {
                    PhonkEditClient.tryTriggerEffect();
                }
                boolean bl4 = below = currentHealth <= ModConfig.INSTANCE.lowHealthThreshold;
                if (ModConfig.INSTANCE.triggerOnLowHealth && below && !wasBelowLowHealth) {
                    PhonkEditClient.tryTriggerEffect();
                }
                wasBelowLowHealth = below;
                lastHealth = currentHealth;
                lastHealthInitialized = true;
                boolean onGround = client.field_1724.method_24828();
                if (onGround) {
                    airStartTimeMs = 0L;
                    airTriggerConsumed = false;
                } else {
                    if (wasOnGroundLastTick || airStartTimeMs == 0L) {
                        airStartTimeMs = System.currentTimeMillis();
                    }
                    if (ModConfig.INSTANCE.triggerOnAirTime && !airTriggerConsumed && airStartTimeMs > 0L) {
                        double thresholdMillis = ModConfig.INSTANCE.airTimeThresholdSeconds * 1000.0;
                        if ((double)(System.currentTimeMillis() - airStartTimeMs) >= thresholdMillis) {
                            airTriggerConsumed = true;
                            PhonkEditClient.tryTriggerEffect();
                        }
                    }
                }
                wasOnGroundLastTick = onGround;
            } else {
                lastHealthInitialized = false;
                wasBelowLowHealth = false;
                wasOnGroundLastTick = true;
                airStartTimeMs = 0L;
                airTriggerConsumed = false;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> PhonkEditClient.onWorldJoin());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (isFreezeModeActive) {
                PhonkEditClient.endFreezeEffect();
            }
            pendingEffectTime = 0L;
        });
    }

    public static void renderOverlayIfActive(class_332 drawContext) {
        if (!isFreezeModeActive) {
            return;
        }
        if (requestCapture) {
            PhonkEditClient.tryCaptureFreezeFrame();
        }
        PhonkEditClient.renderFreezeOverlay(drawContext);
    }

    public static void renderFreezeOverlay(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        long timeSinceActivation = Math.max(0L, System.currentTimeMillis() - freezeActivationTime);
        double shakeFalloff = 0.0;
        if (timeSinceActivation < 500L) {
            double shakeProgress = (double)timeSinceActivation / 500.0;
            double easeOut = 1.0 - Math.pow(1.0 - shakeProgress, 3.0);
            shakeFalloff = 1.0 - easeOut;
        }
        float screenShakeOffsetY = 0.0f;
        if (shakeFalloff > 0.0) {
            float amplitude = (float)(shakeFalloff * 6.0);
            screenShakeOffsetY = (float)((Math.random() * 2.0 - 1.0) * (double)amplitude);
        }
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, screenShakeOffsetY, 0.0f);
        if (freezeTextureId != null && freezeTexWidth > 0 && freezeTexHeight > 0) {
            float sx = (float)screenWidth / (float)Math.max(1, freezeTexWidth);
            float sy = (float)screenHeight / (float)Math.max(1, freezeTexHeight);
            matrices.method_22903();
            matrices.method_22905(sx, sy, 1.0f);
            drawContext.method_25290(freezeTextureId, 0, 0, 0.0f, 0.0f, freezeTexWidth, freezeTexHeight, freezeTexWidth, freezeTexHeight);
            matrices.method_22909();
        }
        if (ModConfig.INSTANCE.darkenScreenDuringEffect) {
            drawContext.method_25294(0, 0, screenWidth, screenHeight, new Color(0, 0, 0, 110).getRGB());
        }
        matrices.method_22909();
        if (!ModConfig.INSTANCE.renderSkullOverlay) {
            return;
        }
        int shakeOffsetX = 0;
        int shakeOffsetY = 0;
        double blurStrength = 0.0;
        double blurEnvelope = 0.0;
        double blurRadius = 0.0;
        boolean allowShake = ModConfig.INSTANCE.skullShakeEnabled;
        boolean allowBlur = ModConfig.INSTANCE.skullBlurEnabled;
        if ((allowShake || allowBlur) && shakeFalloff > 0.0) {
            if (allowShake) {
                double shakeIntensity = shakeFalloff * 8.0 * ModConfig.INSTANCE.shakeIntensity;
                shakeOffsetX = (int)((Math.random() * 2.0 - 1.0) * shakeIntensity);
                shakeOffsetY = (int)((Math.random() * 2.0 - 1.0) * shakeIntensity);
            }
            if (allowBlur) {
                double intensity = 5.0;
                double easePower = Math.max(0.1, ModConfig.INSTANCE.skullBlurEasePower);
                blurEnvelope = Math.pow(shakeFalloff, easePower);
                blurStrength = blurEnvelope * intensity;
                blurRadius = blurStrength * 8.0;
            }
        }
        int skullSize = Math.max(1, Math.round(102.4f));
        int hotbarHeight = 22;
        int padding = 40;
        int y = screenHeight - hotbarHeight - skullSize - padding;
        int xCenter = screenWidth / 2 - skullSize / 2;
        class_2960 skullCenter = PhonkEditClient.getCurrentSkullTexture();
        int shakeXCenter = shakeOffsetX;
        int shakeYCenter = shakeOffsetY;
        if (allowBlur && blurStrength > 0.01) {
            double radius = Math.max(0.5, blurRadius);
            int blurLayers = Math.min(8, Math.max(2, (int)Math.ceil(radius)));
            double sigma = radius / 2.0;
            double twoSigmaSq = 2.0 * sigma * sigma;
            double weightSum = 0.0;
            double[] weights = new double[blurLayers];
            for (int i = 0; i < blurLayers; ++i) {
                double weight;
                double offset = i + 1;
                weights[i] = weight = Math.exp(-(offset * offset) / twoSigmaSq);
                weightSum += weight * 2.0;
            }
            float alphaScale = (float)Math.min(1.0, blurEnvelope);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (int i = 0; i < blurLayers; ++i) {
                double offset = i + 1;
                double weight = weights[i] / weightSum;
                float layerAlpha = (float)((double)alphaScale * weight * 2.0);
                float blurOffset = (float)(offset * radius / (double)blurLayers);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)layerAlpha);
                int drawX = Math.round((float)(xCenter + shakeXCenter) + blurOffset);
                int drawXMirror = Math.round((float)(xCenter + shakeXCenter) - blurOffset);
                PhonkEditClient.drawScaledSkull(drawContext, skullCenter, drawX, y + shakeYCenter, skullSize);
                PhonkEditClient.drawScaledSkull(drawContext, skullCenter, drawXMirror, y + shakeYCenter, skullSize);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        PhonkEditClient.drawScaledSkull(drawContext, skullCenter, xCenter + shakeXCenter, y + shakeYCenter, skullSize);
    }

    private static void drawScaledSkull(class_332 drawContext, class_2960 texture, int x, int y, int size) {
        float scale = (float)size / 256.0f;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        matrices.method_22905(scale, scale, 1.0f);
        drawContext.method_25290(texture, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        matrices.method_22909();
    }

    public static void renderTopLayer(class_332 drawContext) {
        float targetAspect;
        int screenHeight;
        if (!isFreezeModeActive || !ModConfig.INSTANCE.showCinematicBars) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        float currentAspect = (float)screenWidth / (float)(screenHeight = client.method_22683().method_4502());
        if (Math.abs(currentAspect - (targetAspect = 0.5625f)) <= 0.001f) {
            return;
        }
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (currentAspect > targetAspect) {
            float expectedWidth = (float)screenHeight * targetAspect;
            int barWidth = Math.round(((float)screenWidth - expectedWidth) / 2.0f);
            if (barWidth > 0) {
                drawContext.method_25294(0, 0, barWidth, screenHeight, -16777216);
                drawContext.method_25294(screenWidth - barWidth, 0, screenWidth, screenHeight, -16777216);
            }
        } else {
            float expectedHeight = (float)screenWidth / targetAspect;
            int barHeight = Math.round(((float)screenHeight - expectedHeight) / 2.0f);
            if (barHeight > 0) {
                drawContext.method_25294(0, 0, screenWidth, barHeight, -16777216);
                drawContext.method_25294(0, screenHeight - barHeight, screenWidth, screenHeight, -16777216);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        matrices.method_22909();
    }

    public static void activateFreezeEffect() {
        isFreezeModeActive = true;
        freezeActivationTime = System.currentTimeMillis();
        overrideSkullTexture = null;
        currentSkullIndex = 0;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            preservedVelocity = client.field_1724.method_18798();
            preservedSprinting = client.field_1724.method_5624();
            hasPreservedVelocity = true;
        } else {
            preservedVelocity = class_243.field_1353;
            preservedSprinting = false;
            hasPreservedVelocity = false;
        }
        PhonkManager manager = PhonkManager.getInstance();
        manager.playRandomTrack();
        if (manager.getCurrentSoundEvent() == ModSounds.PHONK6) {
            overrideSkullTexture = currentSpecialSkullTexture;
        } else if (!SKULL_TEXTURES.isEmpty()) {
            currentSkullIndex = (int)(Math.random() * (double)SKULL_TEXTURES.size());
        }
        requestCapture = true;
        PhonkEditMod.LOGGER.info("Activated freeze effect");
    }

    public static void endFreezeEffect() {
        isFreezeModeActive = false;
        overrideSkullTexture = null;
        class_310 client = class_310.method_1551();
        if (hasPreservedVelocity && client != null && client.field_1724 != null) {
            client.field_1724.method_18799(preservedVelocity);
            client.field_1724.field_6037 = true;
            client.field_1724.method_5728(preservedSprinting);
        }
        hasPreservedVelocity = false;
        preservedVelocity = class_243.field_1353;
        preservedSprinting = false;
        PhonkManager.getInstance().stopAll();
        PhonkEditClient.clearFreezeFrame();
        PhonkEditMod.LOGGER.info("Ended freeze effect");
    }

    public static boolean isFreezeModeActive() {
        return isFreezeModeActive;
    }

    public static class_2960 getCurrentSkullTexture() {
        if (overrideSkullTexture != null) {
            return overrideSkullTexture;
        }
        if (SKULL_TEXTURES.isEmpty()) {
            return BUILTIN_SKULL_TEXTURES[0];
        }
        int safeIndex = Math.min(currentSkullIndex, Math.max(0, SKULL_TEXTURES.size() - 1));
        return SKULL_TEXTURES.get(safeIndex);
    }

    public static void onWorldJoin() {
        worldJoinTime = System.currentTimeMillis();
        pendingEffectTime = 0L;
        hasPreservedVelocity = false;
        preservedVelocity = class_243.field_1353;
        preservedSprinting = false;
        wasOnGroundLastTick = true;
        airStartTimeMs = 0L;
        airTriggerConsumed = false;
    }

    public static boolean canTrigger() {
        return System.currentTimeMillis() - worldJoinTime >= 3000L;
    }

    public static void onBlockBroken() {
        if (!ModConfig.INSTANCE.triggerOnBlockBreak) {
            return;
        }
        PhonkEditClient.scheduleEffect();
    }

    public static void onBlockPlaced() {
        if (!ModConfig.INSTANCE.triggerOnBlockPlace) {
            return;
        }
        PhonkEditClient.scheduleEffect(true);
    }

    private static void scheduleEffect() {
        PhonkEditClient.scheduleEffect(false);
    }

    private static void scheduleEffect(boolean force) {
        if (!ModConfig.INSTANCE.enablePhonkEffect) {
            return;
        }
        if (!PhonkEditClient.canTrigger()) {
            return;
        }
        if (isFreezeModeActive) {
            return;
        }
        if (pendingEffectTime > 0L) {
            return;
        }
        if (!force && Math.random() > ModConfig.INSTANCE.triggerChance) {
            return;
        }
        pendingEffectTime = System.currentTimeMillis() + 300L;
    }

    private static void tryTriggerEffect() {
        PhonkEditClient.scheduleEffect(false);
    }

    private static void tryCaptureFreezeFrame() {
        requestCapture = false;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        try {
            class_276 fb = client.method_1522();
            int w = client.method_22683().method_4489();
            int h = client.method_22683().method_4506();
            class_1011 image = null;
            try {
                Class<?> sr = Class.forName("net.minecraft.client.util.ScreenshotRecorder");
                Method method = null;
                for (Method m : sr.getDeclaredMethods()) {
                    if (!m.getName().equals("takeScreenshot") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(fb.getClass()) || !class_1011.class.isAssignableFrom(m.getReturnType())) continue;
                    method = m;
                    break;
                }
                if (method != null) {
                    method.setAccessible(true);
                    image = (class_1011)method.invoke(null, fb);
                }
            }
            catch (Throwable sr) {
                // empty catch block
            }
            if (image == null) {
                image = new class_1011(w, h, false);
                fb.method_35610();
                image.method_4327(0, false);
                fb.method_1242();
            }
            if (ModConfig.INSTANCE.grayscaleFreezeFrame) {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int argb = image.method_4315(x, y);
                        int a = argb >> 24 & 0xFF;
                        int r = argb & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb >> 16 & 0xFF;
                        int gray = (int)Math.min(255L, Math.round(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b));
                        int newAbgr = a << 24 | gray << 16 | gray << 8 | gray;
                        image.method_4305(x, y, newAbgr);
                    }
                }
            }
            int yTop = 0;
            for (int yBot = h - 1; yTop < yBot; ++yTop, --yBot) {
                for (int x = 0; x < w; ++x) {
                    int top = image.method_4315(x, yTop);
                    int bot = image.method_4315(x, yBot);
                    image.method_4305(x, yTop, bot);
                    image.method_4305(x, yBot, top);
                }
            }
            PhonkEditClient.clearFreezeFrame();
            freezeTexture = new class_1043(image);
            freezeTextureId = class_2960.method_60655((String)"phonkedit", (String)"freeze_frame");
            class_1060 tm = client.method_1531();
            tm.method_4616(freezeTextureId, (class_1044)freezeTexture);
            freezeTexWidth = w;
            freezeTexHeight = h;
        }
        catch (Throwable t) {
            PhonkEditMod.LOGGER.warn("Failed to capture freeze frame: {}", (Object)t.toString());
        }
    }

    private static void clearFreezeFrame() {
        class_310 client = class_310.method_1551();
        if (client != null && freezeTextureId != null) {
            try {
                client.method_1531().method_4615(freezeTextureId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (freezeTexture != null) {
            try {
                freezeTexture.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        freezeTexture = null;
        freezeTextureId = null;
        freezeTexWidth = 0;
        freezeTexHeight = 0;
    }
}

