/*
 * Decompiled with CFR 0.152.
 */
package com.phonkedit.config.menu;

import com.phonkedit.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class VisualConfigScreen
extends class_437 {
    private final class_437 parent;
    private final List<OptionEntry> optionEntries = new ArrayList<OptionEntry>();
    private double scrollOffset = 0.0;
    private int contentHeight = 0;
    private static final int OPTION_WIDTH = 200;
    private static final int OPTION_AREA_TOP = 36;
    private static final int OPTION_AREA_BOTTOM_MARGIN = 48;

    public VisualConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Phonk Edit - Visuals"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.optionEntries.clear();
        this.scrollOffset = 0.0;
        this.addOption((class_339)this.toggleButton("Grayscale Freeze Frame", () -> ModConfig.INSTANCE.grayscaleFreezeFrame, v -> {
            ModConfig.INSTANCE.grayscaleFreezeFrame = v;
        }), 28);
        this.addOption((class_339)this.toggleButton("Screen Darkening Overlay", () -> ModConfig.INSTANCE.darkenScreenDuringEffect, v -> {
            ModConfig.INSTANCE.darkenScreenDuringEffect = v;
        }), 28);
        this.addOption((class_339)this.toggleButton("9:16 Cinematic Bars", () -> ModConfig.INSTANCE.showCinematicBars, v -> {
            ModConfig.INSTANCE.showCinematicBars = v;
        }), 28);
        this.addOption((class_339)this.toggleButton("Render Skull Overlay", () -> ModConfig.INSTANCE.renderSkullOverlay, v -> {
            ModConfig.INSTANCE.renderSkullOverlay = v;
        }), 28);
        this.addOption((class_339)this.toggleButton("Skull Shake", () -> ModConfig.INSTANCE.skullShakeEnabled, v -> {
            ModConfig.INSTANCE.skullShakeEnabled = v;
        }), 28);
        this.addOption((class_339)this.toggleButton("Skull Blur Trails", () -> ModConfig.INSTANCE.skullBlurEnabled, v -> {
            ModConfig.INSTANCE.skullBlurEnabled = v;
        }), 28);
        this.addOption((class_339)this.sliderWidget("Blur Intensity", 0.0, 5.0, () -> ModConfig.INSTANCE.skullBlurIntensity, v -> {
            ModConfig.INSTANCE.skullBlurIntensity = v;
        }), 32);
        this.addOption((class_339)this.sliderWidget("Blur Ease Power", 0.1, 5.0, () -> ModConfig.INSTANCE.skullBlurEasePower, v -> {
            ModConfig.INSTANCE.skullBlurEasePower = v;
        }), 32);
        this.addOption((class_339)this.sliderWidget("Shake Intensity", 0.0, 20.0, () -> ModConfig.INSTANCE.shakeIntensity, v -> {
            ModConfig.INSTANCE.shakeIntensity = v;
        }), 32);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> {
            ModConfig.save();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 32, 200, 20).method_46431());
        this.updateOptionWidgetPositions();
    }

    private class_2561 toggleText(String label, boolean enabled) {
        return class_2561.method_43470((String)(label + ": " + (enabled ? "ON" : "OFF")));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.updateOptionWidgetPositions();
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        ModConfig.save();
        class_310.method_1551().method_1507(this.parent);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.optionEntries.isEmpty() && verticalAmount != 0.0) {
            double maxScroll = Math.max(0.0, (double)(this.contentHeight - this.getVisibleAreaHeight()));
            this.scrollOffset = class_3532.method_15350((double)(this.scrollOffset - verticalAmount * 12.0), (double)0.0, (double)maxScroll);
            this.updateOptionWidgetPositions();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void addOption(class_339 widget, int rowHeight) {
        widget = (class_339)this.method_37063((class_364)widget);
        this.optionEntries.add(new OptionEntry(widget, rowHeight));
    }

    private class_4185 toggleButton(String label, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return class_4185.method_46430((class_2561)this.toggleText(label, getter.get()), btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            setter.accept(newValue);
            btn.method_25355(this.toggleText(label, newValue));
        }).method_46434(0, 0, 200, 20).method_46431();
    }

    private DoubleSlider sliderWidget(String label, double min, double max, DoubleSupplier getter, DoubleConsumer setter) {
        return new DoubleSlider(0, 0, 200, 20, (class_2561)class_2561.method_43470((String)label), getter.getAsDouble(), min, max, setter);
    }

    private void updateOptionWidgetPositions() {
        int centerX = this.field_22789 / 2 - 100;
        int y = 36;
        int visibleBottom = this.field_22790 - 48;
        this.contentHeight = 0;
        for (OptionEntry entry : this.optionEntries) {
            boolean visible;
            class_339 widget = entry.widget();
            int widgetY = y - (int)Math.round(this.scrollOffset);
            widget.method_46421(centerX);
            widget.method_46419(widgetY);
            widget.field_22764 = visible = widgetY + widget.method_25364() >= 36 && widgetY <= visibleBottom;
            widget.field_22763 = visible;
            y += entry.rowHeight();
        }
        this.contentHeight = Math.max(0, y - 36);
    }

    private int getVisibleAreaHeight() {
        return this.field_22790 - 48 - 36;
    }

    private static class DoubleSlider
    extends class_357 {
        private final double min;
        private final double max;
        private final DoubleConsumer onChange;
        private final String base;

        public DoubleSlider(int x, int y, int width, int height, class_2561 text, double value, double min, double max, DoubleConsumer onChange) {
            super(x, y, width, height, text, (value - min) / (max - min));
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.base = text.getString();
            this.method_25346();
        }

        protected void method_25346() {
            double v = this.field_22753 * (this.max - this.min) + this.min;
            double shown = (double)Math.round(v * 100.0) / 100.0;
            this.method_25355((class_2561)class_2561.method_43470((String)(this.base + ": " + shown)));
        }

        protected void method_25344() {
            double v = this.field_22753 * (this.max - this.min) + this.min;
            this.onChange.accept(v);
        }
    }

    private record OptionEntry(class_339 widget, int rowHeight) {
    }
}

