/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.config.ConfigManager;
import github.jorgaomc.events.CobblemonMasteryEventHandler;
import github.jorgaomc.item.ResearchBookItem;
import github.jorgaomc.network.ClaimGlobalRewardPayload;
import github.jorgaomc.network.ClaimSpeciesRewardPayload;
import github.jorgaomc.network.OpenUiPayload;
import github.jorgaomc.storage.MasteryManager;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonMastery
implements ModInitializer {
    public static final String MOD_ID = "cobblemonresearchtasks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemonresearchtasks");

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(OpenUiPayload.TYPE, OpenUiPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClaimGlobalRewardPayload.TYPE, ClaimGlobalRewardPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClaimSpeciesRewardPayload.TYPE, ClaimSpeciesRewardPayload.CODEC);
        ConfigManager.load();
        MasteryManager.get();
        class_1792 RESEARCH_BOOK = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"research_book"), (Object)((Object)new ResearchBookItem(new class_1792.class_1793().method_7889(1))));
        class_1761 group = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)RESEARCH_BOOK)).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.cobblemonresearchtasks.main")).method_47317((displayContext, entries) -> entries.method_45421((class_1935)RESEARCH_BOOK)).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"main"), (Object)group);
        ServerPlayNetworking.registerGlobalReceiver(ClaimGlobalRewardPayload.TYPE, (payload, context) -> context.player().field_13995.execute(() -> {
            try {
                MasteryManager.get().claimGlobalTier(context.player(), payload.tier());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to claim global reward", (Throwable)e);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ClaimSpeciesRewardPayload.TYPE, (payload, context) -> context.player().field_13995.execute(() -> {
            try {
                MasteryManager.get().claimSpeciesReward(context.player(), payload.speciesKey());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to claim species reward", (Throwable)e);
            }
        }));
        CobblemonMasteryEventHandler.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try {
                MasteryManager.get().resetForNewWorld(server);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to reset mastery data on world start", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                Path worldDir = server.method_27050(class_5218.field_24188);
                MasteryManager.get().loadBackup(worldDir, handler.field_14140.method_5667());
                MasteryManager.get().ensureResearchBookGranted(handler.field_14140, worldDir);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to handle mastery data on join", (Throwable)e);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long time;
            long intervalTicks = (long)ConfigManager.getAutosaveSeconds() * 20L;
            if (intervalTicks <= 0L) {
                intervalTicks = 1200L;
            }
            long l = time = server.method_30002() != null ? server.method_30002().method_8510() : 0L;
            if (time % intervalTicks == 0L) {
                try {
                    MasteryManager.get().autosave(server);
                }
                catch (Exception e) {
                    LOGGER.warn("Mastery autosave failed", (Throwable)e);
                }
            }
            if (time % 10L == 0L) {
                try {
                    MasteryManager.get().scanAndUpdateFriendship(server);
                }
                catch (Exception e) {
                    LOGGER.debug("Friendship scan failed", (Throwable)e);
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            try {
                Path worldDir = server.method_27050(class_5218.field_24188);
                MasteryManager.get().saveBackup(worldDir, handler.field_14140.method_5667());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to save mastery backup on disconnect", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                MasteryManager.get().autosave(server);
            }
            catch (Exception e) {
                LOGGER.warn("Mastery save on stop failed", (Throwable)e);
            }
        });
        LOGGER.info("Cobblemon Mastery initialized");
    }
}

