/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.gui;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import github.jorgaomc.network.ClaimGlobalRewardPayload;
import github.jorgaomc.network.ClaimSpeciesRewardPayload;
import github.jorgaomc.storage.MasteryManager;
import github.jorgaomc.tasks.SpeciesTasks;
import github.jorgaomc.tasks.TaskDefinition;
import github.jorgaomc.tasks.TaskType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class MasteryScreen
extends class_437 {
    private static final int ENTRY_HEIGHT = 24;
    private static final int ICON_SIZE = 16;
    private static final int SEARCH_HEIGHT = 18;
    private final List<PokemonEntry> allEntries = new ArrayList<PokemonEntry>();
    private final List<PokemonEntry> entries = new ArrayList<PokemonEntry>();
    private int selectedIndex = 0;
    private double scrollOffset = 0.0;
    private Map<String, Map<String, Integer>> taskProgressBySpecies = new HashMap<String, Map<String, Integer>>();
    private Map<String, Set<String>> taskCompletedBySpecies = new HashMap<String, Set<String>>();
    private final Set<String> speciesCompleted = new HashSet<String>();
    private class_342 searchField;
    private boolean draggingScrollbar = false;
    private int dragOffsetY = 0;
    private static final class_2960 CHECKMARK_TEX = class_2960.method_60655((String)"cobblemonresearchtasks", (String)"textures/gui/checkmark.png");
    private static final class_2960 GIFT_TEX = class_2960.method_60655((String)"cobblemonresearchtasks", (String)"textures/gui/gift.png");
    private final Set<Integer> claimedGlobal = new HashSet<Integer>();
    private final Set<String> claimedSpecies = new HashSet<String>();
    private int totalTasksSnapshot = 0;
    private int completedTasksSnapshot = 0;
    private Map<Integer, List<class_1799>> globalRewardStacks = new HashMap<Integer, List<class_1799>>();
    private Map<String, List<class_1799>> speciesRewardStacks = new HashMap<String, List<class_1799>>();

    public MasteryScreen() {
        super((class_2561)class_2561.method_43470((String)"Research Tasks"));
    }

    public MasteryScreen(String snapshotJson) {
        this();
        this.parseSnapshot(snapshotJson);
    }

    private void parseSnapshot(String snapshotJson) {
        try {
            JsonObject gr;
            JsonArray arr;
            if (snapshotJson == null || snapshotJson.isBlank()) {
                return;
            }
            JsonObject json = JsonParser.parseString((String)snapshotJson).getAsJsonObject();
            JsonObject speciesObj = json.getAsJsonObject("species");
            if (speciesObj != null) {
                for (Map.Entry entry : speciesObj.entrySet()) {
                    String speciesKey = this.normalizeSpeciesKey((String)entry.getKey());
                    JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    HashMap<String, Integer> prog = new HashMap<String, Integer>();
                    HashSet<String> comp = new HashSet<String>();
                    if (obj.has("progress") && obj.get("progress").isJsonObject()) {
                        JsonObject p = obj.getAsJsonObject("progress");
                        for (Map.Entry e : p.entrySet()) {
                            prog.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsInt());
                        }
                    }
                    if (obj.has("completed") && obj.get("completed").isJsonArray()) {
                        JsonArray a = obj.getAsJsonArray("completed");
                        Iterator iterator = a.iterator();
                        while (iterator.hasNext()) {
                            JsonElement v = (JsonElement)iterator.next();
                            comp.add(v.getAsString());
                        }
                    }
                    if (obj.has("allCompleted") && obj.get("allCompleted").isJsonPrimitive() && obj.get("allCompleted").getAsBoolean()) {
                        this.speciesCompleted.add(speciesKey);
                    }
                    this.taskProgressBySpecies.put(speciesKey, prog);
                    this.taskCompletedBySpecies.put(speciesKey, comp);
                }
            }
            if (json.has("claimedGlobal")) {
                arr = json.getAsJsonArray("claimedGlobal");
                for (JsonElement el : arr) {
                    this.claimedGlobal.add(el.getAsInt());
                }
            }
            if (json.has("claimedSpecies")) {
                arr = json.getAsJsonArray("claimedSpecies");
                for (JsonElement el : arr) {
                    this.claimedSpecies.add(this.normalizeSpeciesKey(el.getAsString()));
                }
            }
            if (json.has("totalTasks")) {
                this.totalTasksSnapshot = json.get("totalTasks").getAsInt();
            }
            if (json.has("completedTasks")) {
                this.completedTasksSnapshot = json.get("completedTasks").getAsInt();
            }
            if (json.has("globalRewards") && (gr = json.getAsJsonObject("globalRewards")).has("tiers")) {
                for (JsonElement tierEl : gr.getAsJsonArray("tiers")) {
                    JsonObject tObj = tierEl.getAsJsonObject();
                    int tier = tObj.get("tier").getAsInt();
                    ArrayList<class_1799> list = new ArrayList<class_1799>();
                    if (tObj.has("items")) {
                        for (JsonElement itEl : tObj.getAsJsonArray("items")) {
                            JsonObject it = itEl.getAsJsonObject();
                            String id = it.get("id").getAsString();
                            int count = it.has("count") ? it.get("count").getAsInt() : 1;
                            class_2960 itemId = class_2960.method_12829((String)id);
                            class_1792 item = itemId != null ? (class_1792)class_7923.field_41178.method_10223(itemId) : null;
                            if (item == null) continue;
                            list.add(new class_1799((class_1935)item, Math.max(1, count)));
                        }
                    }
                    this.globalRewardStacks.put(tier, list);
                }
            }
            if (json.has("speciesRewards")) {
                JsonObject sr = json.getAsJsonObject("speciesRewards");
                for (Map.Entry e : sr.entrySet()) {
                    String key = this.normalizeSpeciesKey((String)e.getKey());
                    ArrayList<class_1799> list = new ArrayList<class_1799>();
                    if (((JsonElement)e.getValue()).isJsonArray()) {
                        for (JsonElement itEl : ((JsonElement)e.getValue()).getAsJsonArray()) {
                            JsonObject it = itEl.getAsJsonObject();
                            String id = it.get("id").getAsString();
                            int count = it.has("count") ? it.get("count").getAsInt() : 1;
                            class_2960 itemId = class_2960.method_12829((String)id);
                            class_1792 item = itemId != null ? (class_1792)class_7923.field_41178.method_10223(itemId) : null;
                            if (item == null) continue;
                            list.add(new class_1799((class_1935)item, Math.max(1, count)));
                        }
                    }
                    this.speciesRewardStacks.put(key, list);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String normalizeSpeciesKey(String key) {
        if (key == null) {
            return "";
        }
        Object k = key.toLowerCase(Locale.ROOT);
        if (!((String)k).contains(":")) {
            k = "cobblemon:" + (String)k;
        }
        return k;
    }

    private Map<String, Integer> getProgressMapFor(String speciesKey) {
        String k = this.normalizeSpeciesKey(speciesKey);
        Map<String, Integer> m = this.taskProgressBySpecies.get(k);
        return m != null ? m : Collections.emptyMap();
    }

    private Set<String> getCompletedSetFor(String speciesKey) {
        String k = this.normalizeSpeciesKey(speciesKey);
        Set<String> s = this.taskCompletedBySpecies.get(k);
        return s != null ? s : Collections.emptySet();
    }

    private boolean isSpeciesComplete(String speciesKeyRaw) {
        String key = this.normalizeSpeciesKey(speciesKeyRaw);
        if (this.speciesCompleted.contains(key)) {
            return true;
        }
        SpeciesTasks stasks = MasteryManager.get().getSpeciesTasks(key);
        if (stasks == null || stasks.tasks == null || stasks.tasks.isEmpty()) {
            return false;
        }
        Map<String, Integer> prog = this.getProgressMapFor(key);
        Set<String> comp = this.getCompletedSetFor(key);
        int done = 0;
        for (TaskDefinition t : stasks.tasks) {
            boolean ok = comp.contains(t.id);
            if (!ok) {
                int amt = t.getAmountOrDefault(1);
                switch (t.type) {
                    case DEFEAT_ANY_COUNT: 
                    case DEFEAT_SPECIES: 
                    case DEFEAT_TYPE_COUNT: 
                    case LEVEL_UP_COUNT: 
                    case FISH_THIS: {
                        int p = prog.getOrDefault(t.id, 0);
                        if (p < Math.max(1, amt)) break;
                        ok = true;
                        break;
                    }
                    case FRIENDSHIP_AT_LEAST: {
                        int thr;
                        int p = prog.getOrDefault(t.id, 0);
                        int n = thr = t.friendship != null ? t.friendship : amt;
                        if (p < Math.max(1, thr)) break;
                        ok = true;
                        break;
                    }
                    case CAPTURE_THIS: 
                    case EVOLVE_THIS: {
                        break;
                    }
                }
            }
            if (!ok) continue;
            ++done;
        }
        return done >= stasks.tasks.size();
    }

    protected void method_25426() {
        super.method_25426();
        this.buildEntries();
        int w = this.field_22789;
        int h = this.field_22790;
        int leftPanelWidth = (int)Math.floor((double)w * 0.65);
        int rightPanelWidth = w - leftPanelWidth;
        int rightX = leftPanelWidth;
        int topY = 0;
        int listX = rightX + 8;
        int listW = rightPanelWidth - 16;
        int searchY = topY + 12;
        if (this.searchField == null) {
            this.searchField = new class_342(this.field_22793, listX, searchY, listW, 18, (class_2561)class_2561.method_43470((String)"Search"));
            this.searchField.method_1880(64);
            this.searchField.method_1863(s -> this.applyFilter((String)s));
            this.method_37063((class_364)this.searchField);
            this.method_48265((class_364)this.searchField);
            this.searchField.method_25365(true);
        } else {
            this.searchField.method_46421(listX);
            this.searchField.method_46419(searchY);
            this.searchField.method_25358(listW);
        }
    }

    private void buildEntries() {
        this.allEntries.clear();
        this.entries.clear();
        try {
            Collection speciesContainer = PokemonSpecies.INSTANCE.getSpecies();
            Collection speciesCollection = null;
            if (speciesContainer instanceof Map) {
                Map map = (Map)((Object)speciesContainer);
                speciesCollection = map.values();
            } else if (speciesContainer instanceof Collection) {
                Collection col;
                speciesCollection = col = speciesContainer;
            } else {
                try {
                    Method valuesMethod = speciesContainer.getClass().getMethod("values", new Class[0]);
                    Object vals = valuesMethod.invoke((Object)speciesContainer, new Object[0]);
                    if (vals instanceof Collection) {
                        Collection col2;
                        speciesCollection = col2 = (Collection)vals;
                    }
                }
                catch (Throwable valuesMethod) {
                    // empty catch block
                }
            }
            if (speciesCollection != null) {
                for (Object species : speciesCollection) {
                    try {
                        int dex;
                        String name;
                        String pathName = null;
                        String fullId = null;
                        try {
                            Object idObj = species.getClass().getMethod("getIdentifier", new Class[0]).invoke(species, new Object[0]);
                            if (idObj instanceof class_2960) {
                                class_2960 id = (class_2960)idObj;
                                pathName = id.method_12832();
                                fullId = id.toString();
                            } else if (idObj != null) {
                                String s;
                                fullId = s = String.valueOf(idObj);
                                int colon = s.indexOf(":");
                                pathName = colon >= 0 ? s.substring(colon + 1) : s;
                            }
                        }
                        catch (Throwable idObj) {
                            // empty catch block
                        }
                        if (pathName != null && !pathName.isEmpty()) {
                            name = MasteryScreen.prettifyFromPath(pathName);
                        } else {
                            try {
                                String raw = (String)species.getClass().getMethod("getName", new Class[0]).invoke(species, new Object[0]);
                                name = MasteryScreen.sanitizeDisplayName(raw);
                            }
                            catch (Throwable ex2) {
                                name = MasteryScreen.sanitizeDisplayName(species.toString());
                            }
                        }
                        try {
                            dex = (Integer)species.getClass().getMethod("getNationalPokedexNumber", new Class[0]).invoke(species, new Object[0]);
                        }
                        catch (Throwable ex) {
                            try {
                                int n;
                                Object idObj = species.getClass().getMethod("getDexNumber", new Class[0]).invoke(species, new Object[0]);
                                if (idObj instanceof Number) {
                                    Number n2 = (Number)idObj;
                                    n = n2.intValue();
                                } else {
                                    n = 0;
                                }
                                dex = n;
                            }
                            catch (Throwable ex2) {
                                dex = 0;
                            }
                        }
                        class_1799 icon = this.createPokemonIconFromSpecies(species, name);
                        Object speciesKey = fullId != null ? fullId : (pathName != null ? "cobblemon:" + pathName : name.toLowerCase());
                        this.allEntries.add(new PokemonEntry(name, dex, icon, (String)speciesKey));
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (!this.allEntries.isEmpty()) {
                this.allEntries.sort(Comparator.comparingInt(e -> e.dex));
            } else {
                this.allEntries.add(new PokemonEntry("Pikachu", 25, new class_1799((class_1935)class_1802.field_8407)));
            }
        }
        catch (Throwable t) {
            this.allEntries.add(new PokemonEntry("Pikachu", 25, new class_1799((class_1935)class_1802.field_8407)));
        }
        this.applyFilter(this.searchField != null ? this.searchField.method_1882() : "");
        if (this.selectedIndex >= this.entries.size()) {
            this.selectedIndex = Math.max(0, this.entries.size() - 1);
        }
    }

    private class_1799 createPokemonIconSafe(String speciesName) {
        try {
            Class<?> pokemonItemCls = Class.forName("com.cobblemon.mod.common.item.PokemonItem");
            try {
                Method[] m;
                for (Method method : m = pokemonItemCls.getMethods()) {
                    Object stackObj;
                    if (!method.getName().equals("from") || method.getParameterCount() != 1 || method.getParameterTypes()[0] != String.class || !((stackObj = method.invoke(null, speciesName)) instanceof class_1799)) continue;
                    class_1799 is = (class_1799)stackObj;
                    return is;
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            try {
                Class<?> cobblemonItems = Class.forName("com.cobblemon.mod.common.CobblemonItems");
                Field field = cobblemonItems.getField("POKEMON_MODEL");
                Object itemLike = field.get(null);
                if (itemLike instanceof class_1792) {
                    class_1792 item = (class_1792)itemLike;
                    return new class_1799((class_1935)item);
                }
                if (itemLike instanceof class_1935) {
                    class_1935 conv = (class_1935)itemLike;
                    return new class_1799(conv);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new class_1799((class_1935)class_1802.field_8407);
    }

    private class_1799 createPokemonIconFromSpecies(Object speciesObj, String speciesName) {
        block27: {
            try {
                Object speciesRef = speciesObj;
                if (speciesRef == null) {
                    try {
                        Species resolved = PokemonSpecies.INSTANCE.getByName(speciesName);
                        if (resolved != null) {
                            speciesRef = resolved;
                        }
                    }
                    catch (Throwable resolved) {
                        // empty catch block
                    }
                }
                Object pokemon = null;
                if (speciesRef != null) {
                    try {
                        Method m = speciesRef.getClass().getMethod("create", Integer.TYPE);
                        pokemon = m.invoke(speciesRef, 1);
                    }
                    catch (Throwable e1) {
                        try {
                            Method m2 = speciesRef.getClass().getMethod("create", new Class[0]);
                            pokemon = m2.invoke(speciesRef, new Object[0]);
                        }
                        catch (Throwable e2) {
                            try {
                                Class<?> pokemonCls = Class.forName("com.cobblemon.mod.common.pokemon.Pokemon");
                                for (Method m3 : pokemonCls.getMethods()) {
                                    Class<?>[] pts;
                                    if (!m3.getName().equals("fromSpecies") && !m3.getName().equals("create") && !m3.getName().equals("of") || m3.getParameterCount() < 1 || !(pts = m3.getParameterTypes())[0].isInstance(speciesRef)) continue;
                                    Object[] args = m3.getParameterCount() >= 2 && pts[1] == Integer.TYPE ? new Object[]{speciesRef, 1} : new Object[]{speciesRef};
                                    try {
                                        pokemon = m3.invoke(null, args);
                                        if (pokemon == null) continue;
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (pokemon == null) {
                    try {
                        Species resolved = PokemonSpecies.INSTANCE.getByName(speciesName);
                        if (resolved != null) {
                            try {
                                Method m = resolved.getClass().getMethod("create", Integer.TYPE);
                                pokemon = m.invoke((Object)resolved, 1);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable resolved) {
                        // empty catch block
                    }
                }
                if (pokemon == null) break block27;
                try {
                    Class<?> pokemonItemCls = Class.forName("com.cobblemon.mod.common.item.PokemonItem");
                    for (Method method : pokemonItemCls.getMethods()) {
                        Object stackObj;
                        Class<?> pt;
                        if (!method.getName().equals("from") || method.getParameterCount() != 1 || !(pt = method.getParameterTypes()[0]).isInstance(pokemon) || !((stackObj = method.invoke(null, pokemon)) instanceof class_1799)) continue;
                        class_1799 is = (class_1799)stackObj;
                        return is;
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable speciesRef) {
                // empty catch block
            }
        }
        class_1799 fallback = this.createPokemonIconSafe(speciesName);
        if (fallback != null) {
            return fallback;
        }
        return new class_1799((class_1935)class_1802.field_8407);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25393() {
        super.method_25393();
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        int w = this.field_22789;
        int h = this.field_22790;
        int leftPanelWidth = (int)Math.floor((double)w * 0.65);
        int rightPanelWidth = w - leftPanelWidth;
        int leftX = 0;
        int rightX = leftPanelWidth;
        int topY = 0;
        int bottomY = h;
        int bg = -1441787888;
        drawContext.method_25294(leftX + 8, topY + 8, leftX + leftPanelWidth - 8, bottomY - 8, bg);
        drawContext.method_25294(rightX + 4, topY + 8, rightX + rightPanelWidth - 8, bottomY - 8, bg);
        drawContext.method_51439(this.field_22793, this.field_22785, leftX + 16, topY + 16, 0xFFFFFF, false);
        int buttonsY = topY + 12;
        int btnW = 18;
        int btnH = 18;
        int gap = 4;
        int startX = leftX + 16 + this.field_22793.method_27525((class_5348)this.field_22785) + 6;
        float overallPct = 0.0f;
        if (this.totalTasksSnapshot > 0) {
            overallPct = (float)this.completedTasksSnapshot * 100.0f / (float)this.totalTasksSnapshot;
        }
        int[] requiredPct = new int[]{10, 25, 40, 55, 70, 85, 100};
        for (int i = 1; i <= 7; ++i) {
            int bx = startX + (i - 1) * (btnW + gap);
            int by = buttonsY;
            int col = -13619152;
            boolean eligible = (double)overallPct + 1.0E-6 >= (double)requiredPct[i - 1];
            boolean claimed = this.claimedGlobal.contains(i);
            col = claimed ? -13746642 : (eligible ? -13088712 : -13619152);
            drawContext.method_25294(bx, by, bx + btnW, by + btnH, col);
            drawContext.method_49601(bx, by, btnW, btnH, -11184811);
            String roman = switch (i) {
                case 1 -> "I";
                case 2 -> "II";
                case 3 -> "III";
                case 4 -> "IV";
                case 5 -> "V";
                case 6 -> "VI";
                default -> "VII";
            };
            int tw = this.field_22793.method_1727(roman);
            drawContext.method_51433(this.field_22793, roman, bx + (btnW - tw) / 2, by + 5, -1911670, false);
            if (claimed) {
                drawContext.method_25290(CHECKMARK_TEX, bx + 1, by + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (mouseX < bx || mouseX > bx + btnW || mouseY < by || mouseY > by + btnH) continue;
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            lines.add(class_2561.method_43470((String)("Requires: " + requiredPct[i - 1] + "% | You: " + String.format(Locale.ROOT, "%.1f%%", Float.valueOf(overallPct)))));
            lines.add(class_2561.method_43470((String)("Tier " + roman + " rewards:")));
            List<class_1799> list = this.globalRewardStacks.get(i);
            if (list != null) {
                for (class_1799 st : list) {
                    if (st.method_7960()) continue;
                    lines.add(class_2561.method_43470((String)("- " + st.method_7964().getString() + " x" + st.method_7947())));
                }
            }
            if (lines.isEmpty()) continue;
            drawContext.method_51434(this.field_22793, lines, mouseX, mouseY);
        }
        if (!this.entries.isEmpty() && this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
            PokemonEntry sel = this.entries.get(this.selectedIndex);
            int headerX = leftX + 16;
            int headerY = topY + 36;
            drawContext.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("Pok\u00e9mon: " + sel.name + " (#" + sel.dex + ")")), headerX, headerY, 16769402, false);
            int giftX = headerX + this.field_22793.method_1727("Pok\u00e9mon: " + sel.name + " (#" + sel.dex + ")") + 8;
            int giftY = headerY - 4;
            int giftW = 18;
            int giftH = 18;
            boolean speciesComplete = this.isSpeciesComplete(this.normalizeSpeciesKey(sel.speciesKey));
            boolean speciesClaimed = this.claimedSpecies.contains(this.normalizeSpeciesKey(sel.speciesKey));
            int giftCol = speciesClaimed ? -13746642 : (speciesComplete ? -13088712 : -13619152);
            drawContext.method_25294(giftX, giftY, giftX + giftW, giftY + giftH, giftCol);
            drawContext.method_49601(giftX, giftY, giftW, giftH, -11184811);
            drawContext.method_25290(GIFT_TEX, giftX + 1, giftY + 1, 0.0f, 0.0f, giftW - 2, giftH - 2, 16, 16);
            if (speciesClaimed) {
                drawContext.method_25290(CHECKMARK_TEX, giftX + 1, giftY + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (mouseX >= giftX && mouseX <= giftX + giftW && mouseY >= giftY && mouseY <= giftY + giftH) {
                ArrayList<class_5250> lines = new ArrayList<class_5250>();
                lines.add(class_2561.method_43470((String)"Species rewards:"));
                List rlist = this.speciesRewardStacks.getOrDefault(this.normalizeSpeciesKey(sel.speciesKey), List.of());
                for (class_1799 st : rlist) {
                    if (st.method_7960()) continue;
                    lines.add(class_2561.method_43470((String)("- " + st.method_7964().getString() + " x" + st.method_7947())));
                }
                if (!lines.isEmpty()) {
                    drawContext.method_51434(this.field_22793, lines, mouseX, mouseY);
                }
            }
            int y = topY + 60;
            SpeciesTasks tasks = MasteryManager.get().getSpeciesTasks(sel.speciesKey);
            if (tasks != null && tasks.tasks != null && !tasks.tasks.isEmpty()) {
                Map<String, Integer> progMap = this.getProgressMapFor(sel.speciesKey);
                Set<String> compSet = this.getCompletedSetFor(sel.speciesKey);
                for (TaskDefinition t : tasks.tasks) {
                    String label = t.title != null && !t.title.isBlank() ? t.title : this.defaultTaskLabel(sel.name, t);
                    int amt = t.getAmountOrDefault(1);
                    int prog = progMap.getOrDefault(t.id, 0);
                    boolean completed = compSet.contains(t.id);
                    if (!completed) {
                        switch (t.type) {
                            case DEFEAT_ANY_COUNT: 
                            case DEFEAT_SPECIES: 
                            case DEFEAT_TYPE_COUNT: 
                            case LEVEL_UP_COUNT: 
                            case FISH_THIS: 
                            case CAPTURE_THIS: {
                                if (prog < Math.max(1, amt)) break;
                                completed = true;
                                break;
                            }
                            case FRIENDSHIP_AT_LEAST: {
                                if (prog < Math.max(1, t.friendship != null ? t.friendship : amt)) break;
                                completed = true;
                                break;
                            }
                        }
                    }
                    int boxLeft = leftX + 16;
                    int boxTop = y + 2;
                    int boxRight = boxLeft + 12;
                    int boxBottom = boxTop + 12;
                    drawContext.method_25294(boxLeft, boxTop, boxRight, boxBottom, -13619152);
                    drawContext.method_49601(boxLeft, boxTop, 12, 12, -11184811);
                    if (completed) {
                        drawContext.method_25290(CHECKMARK_TEX, boxLeft - 2, boxTop - 2, 0.0f, 0.0f, 16, 16, 16, 16);
                    }
                    int textX = leftX + 34;
                    int labelColor = -1;
                    drawContext.method_51433(this.field_22793, label, textX, boxTop - 2, labelColor, false);
                    String progressText = switch (t.type) {
                        case TaskType.EVOLVE_THIS -> {
                            if (completed) {
                                yield "Done";
                            }
                            yield "0/1";
                        }
                        case TaskType.CAPTURE_THIS -> {
                            if (completed) {
                                yield "Done";
                            }
                            yield prog + "/" + Math.max(1, amt);
                        }
                        case TaskType.FRIENDSHIP_AT_LEAST -> prog + "/" + (t.friendship != null ? t.friendship : amt);
                        default -> prog + "/" + Math.max(1, amt);
                    };
                    drawContext.method_51433(this.field_22793, progressText, textX, boxTop + 8, -5592406, false);
                    y += 20;
                }
            } else {
                drawContext.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"No tasks configured for this species."), leftX + 16, y, 0xAAAAAA, false);
            }
        }
        if (this.searchField == null || !this.searchField.method_25370()) {
            // empty if block
        }
        int listX = rightX + 8;
        int searchY = topY + 12;
        int listW = rightPanelWidth - 16;
        int listY = searchY + 18 + 6;
        int listH = bottomY - listY - 20;
        int totalHeight = this.entries.size() * 24;
        int maxScroll = Math.max(0, totalHeight - listH);
        int scrollY = (int)Math.round(this.scrollOffset);
        if (scrollY < 0) {
            scrollY = 0;
        }
        if (scrollY > maxScroll) {
            scrollY = maxScroll;
        }
        this.scrollOffset = scrollY;
        this.enableScissor(drawContext, listX, listY, listX + listW, listY + listH);
        int startIndex = Math.max(0, scrollY / 24);
        int endIndex = Math.min(this.entries.size(), startIndex + listH / 24 + 2);
        int y = listY - scrollY % 24;
        for (int i = startIndex; i < endIndex; ++i) {
            PokemonEntry e = this.entries.get(i);
            int entryTop = y + (i - startIndex) * 24;
            int entryBottom = entryTop + 24 - 2;
            int entryLeft = listX;
            int entryRight = listX + listW;
            int bgCol = i == this.selectedIndex ? -14663584 : -14671840;
            drawContext.method_25294(entryLeft, entryTop, entryRight, entryBottom, bgCol);
            int iconX = entryLeft + 6;
            int iconY = entryTop + 4;
            try {
                drawContext.method_51427(e.icon, iconX, iconY);
            }
            catch (Throwable boxLeft) {
                // empty catch block
            }
            int textBaseX = iconX + 16 + 6;
            String label = e.name + "  #" + e.dex;
            drawContext.method_51433(this.field_22793, label, textBaseX, entryTop + 6, 0xFFFFFF, false);
            boolean spComplete = this.isSpeciesComplete(this.normalizeSpeciesKey(e.speciesKey));
            if (!spComplete) continue;
            int tw = this.field_22793.method_1727(label);
            int cx = textBaseX + tw + 6;
            int cy = entryTop + 4;
            drawContext.method_25290(CHECKMARK_TEX, cx, cy, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        this.disableScissor(drawContext);
        if (maxScroll > 0) {
            float ratio = (float)listH / (float)totalHeight;
            int barH = Math.max(12, (int)((float)listH * ratio));
            int barY = listY + (int)((float)(listH - barH) * ((float)scrollY / (float)maxScroll));
            int barX = listX + listW - 6;
            drawContext.method_25294(barX, listY, barX + 4, listY + listH, -15592942);
            drawContext.method_25294(barX, barY, barX + 4, barY + barH, -10855846);
        }
        super.method_25394(drawContext, mouseX, mouseY, delta);
    }

    private static String sanitizeDisplayName(String in) {
        if (in == null) {
            return "";
        }
        String s = in;
        s = s.replace("\u2019", "'").replace("`", "'");
        s = s.replace("'", "");
        s = s.replaceAll("[\\p{Cntrl}]", "");
        s = s.replaceAll("[^\\p{ASCII}]", "");
        s = s.trim().replaceAll("\\s+", " ");
        return s;
    }

    private static String prettifyFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        String base = path.replace('_', ' ').replace('-', ' ');
        base = base.trim().replaceAll("\\s+", " ");
        String[] parts = base.split(" ");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.isEmpty()) continue;
            String word = p.substring(0, 1).toUpperCase() + (p.length() > 1 ? p.substring(1) : "");
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(word);
        }
        return MasteryScreen.sanitizeDisplayName(sb.toString());
    }

    private void applyFilter(String query) {
        String q = query == null ? "" : query.trim().toLowerCase();
        this.entries.clear();
        if (q.isEmpty()) {
            this.entries.addAll(this.allEntries);
        } else {
            for (PokemonEntry e2 : this.allEntries) {
                if (e2.name == null || !e2.name.toLowerCase().startsWith(q)) continue;
                this.entries.add(e2);
            }
        }
        this.entries.sort(Comparator.comparingInt(e -> e.dex));
        this.scrollOffset = 0.0;
        if (this.entries.isEmpty()) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            this.selectedIndex = 0;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int leftPanelWidth;
        int w = this.field_22789;
        int rightX = leftPanelWidth = (int)Math.floor((double)w * 0.65);
        int rightW = w - leftPanelWidth;
        int listX = rightX + 8;
        int searchY = 12;
        int listY = searchY + 18 + 6;
        int listW = rightW - 16;
        int listH = this.field_22790 - listY - 20;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + listH)) {
            this.scrollOffset -= verticalAmount * 24.0;
            if (this.scrollOffset < 0.0) {
                this.scrollOffset = 0.0;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int relY;
        int idx;
        int leftPanelWidth;
        if (this.searchField != null && this.searchField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int w = this.field_22789;
        int rightX = leftPanelWidth = (int)Math.floor((double)w * 0.65);
        int rightW = w - leftPanelWidth;
        int listX = rightX + 8;
        int searchY = 12;
        int listY = searchY + 18 + 6;
        int listW = rightW - 16;
        int listH = this.field_22790 - listY - 20;
        int topY = 0;
        int leftX = 0;
        int buttonsY = topY + 12;
        int btnW = 18;
        int btnH = 18;
        int gap = 4;
        float overallPct = 0.0f;
        if (this.totalTasksSnapshot > 0) {
            overallPct = (float)this.completedTasksSnapshot * 100.0f / (float)this.totalTasksSnapshot;
        }
        int[] requiredPct = new int[]{10, 25, 40, 55, 70, 85, 100};
        int startX = leftX + 16 + this.field_22793.method_27525((class_5348)this.field_22785) + 6;
        for (int i = 1; i <= 7; ++i) {
            int bx = startX + (i - 1) * (btnW + gap);
            int by = buttonsY;
            if (!(mouseX >= (double)bx) || !(mouseX <= (double)(bx + btnW)) || !(mouseY >= (double)by) || !(mouseY <= (double)(by + btnH))) continue;
            boolean eligible = (double)overallPct + 1.0E-6 >= (double)requiredPct[i - 1];
            boolean claimed = this.claimedGlobal.contains(i);
            if (button != 0 || !eligible || claimed) continue;
            try {
                ClientPlayNetworking.send((class_8710)new ClaimGlobalRewardPayload(i));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.claimedGlobal.add(i);
            return true;
        }
        if (!this.entries.isEmpty() && this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
            PokemonEntry sel = this.entries.get(this.selectedIndex);
            int headerX = leftX + 16;
            int headerY = topY + 36;
            int giftX = headerX + this.field_22793.method_1727("Pok\u00e9mon: " + sel.name + " (#" + sel.dex + ")") + 8;
            int giftY = headerY - 4;
            int giftW = 18;
            int giftH = 18;
            if (mouseX >= (double)giftX && mouseX <= (double)(giftX + giftW) && mouseY >= (double)giftY && mouseY <= (double)(giftY + giftH)) {
                boolean complete = this.isSpeciesComplete(this.normalizeSpeciesKey(sel.speciesKey));
                String key = this.normalizeSpeciesKey(sel.speciesKey);
                boolean already = this.claimedSpecies.contains(key);
                if (button == 0 && complete && !already) {
                    try {
                        ClientPlayNetworking.send((class_8710)new ClaimSpeciesRewardPayload(key));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.claimedSpecies.add(key);
                    return true;
                }
            }
        }
        int totalHeight = this.entries.size() * 24;
        int maxScroll = Math.max(0, totalHeight - listH);
        int barX = listX + listW - 6;
        if (maxScroll > 0) {
            float ratio = (float)listH / (float)totalHeight;
            int barH = Math.max(12, (int)((float)listH * ratio));
            int barY = listY + (int)((float)(listH - barH) * ((float)this.scrollOffset / (float)maxScroll));
            if (mouseX >= (double)barX && mouseX <= (double)(barX + 4) && mouseY >= (double)barY && mouseY <= (double)(barY + barH) && button == 0) {
                this.draggingScrollbar = true;
                this.dragOffsetY = (int)(mouseY - (double)barY);
                return true;
            }
        }
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + listH) && (idx = (relY = (int)(mouseY - (double)listY + this.scrollOffset)) / 24) >= 0 && idx < this.entries.size()) {
            this.selectedIndex = idx;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingScrollbar && button == 0) {
            int leftPanelWidth;
            int w = this.field_22789;
            int rightX = leftPanelWidth = (int)Math.floor((double)w * 0.65);
            int rightW = w - leftPanelWidth;
            int listX = rightX + 8;
            int searchY = 12;
            int listY = searchY + 18 + 6;
            int listW = rightW - 16;
            int listH = this.field_22790 - listY - 20;
            int totalHeight = this.entries.size() * 24;
            int maxScroll = Math.max(0, totalHeight - listH);
            if (maxScroll > 0) {
                float ratio = (float)listH / (float)totalHeight;
                int barH = Math.max(12, (int)((float)listH * ratio));
                int barTrack = listH - barH;
                double handleTop = mouseY - (double)listY - (double)this.dragOffsetY;
                if (handleTop < 0.0) {
                    handleTop = 0.0;
                }
                if (handleTop > (double)barTrack) {
                    handleTop = barTrack;
                }
                double progress = handleTop / (double)barTrack;
                this.scrollOffset = progress * (double)maxScroll;
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField != null && this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    private void enableScissor(class_332 ctx, int x1, int y1, int x2, int y2) {
        ctx.method_44379(x1, y1, x2, y2);
    }

    private void disableScissor(class_332 ctx) {
        ctx.method_44380();
    }

    private String defaultTaskLabel(String speciesDisplay, TaskDefinition t) {
        if (t == null || t.type == null) {
            return "Task";
        }
        String s = speciesDisplay == null ? "this Pok\u00e9mon" : speciesDisplay;
        int amt = t.getAmountOrDefault(1);
        String type = t.targetType != null ? t.targetType : "";
        String targetSpecies = t.targetSpecies != null ? t.targetSpecies : "target";
        String move = t.move != null ? t.move : "configured move";
        switch (t.type) {
            case DEFEAT_ANY_COUNT: {
                return "Defeat " + amt + " Pok\u00e9mon using " + s;
            }
            case CAPTURE_THIS: {
                return "Capture this Pok\u00e9mon";
            }
            case EVOLVE_THIS: {
                return "Evolve this Pok\u00e9mon";
            }
            case DEFEAT_SPECIES: {
                return "Defeat " + targetSpecies + " " + amt + "\u00d7 using " + s;
            }
            case DEFEAT_TYPE_COUNT: {
                return "Defeat " + amt + " " + type + "-type Pok\u00e9mon using " + s;
            }
            case FRIENDSHIP_AT_LEAST: {
                int thr = t.friendship != null ? t.friendship : amt;
                return "Reach friendship " + thr + "+ with " + s;
            }
            case FISH_THIS: {
                return "Fish up this Pok\u00e9mon " + amt + "\u00d7";
            }
            case LEVEL_UP_COUNT: {
                return "Level up " + s + " " + amt + "\u00d7";
            }
        }
        return "Task";
    }

    private static class PokemonEntry {
        final String name;
        final int dex;
        final class_1799 icon;
        final String speciesKey;

        PokemonEntry(String name, int dex, class_1799 icon) {
            this(name, dex, icon, name.toLowerCase());
        }

        PokemonEntry(String name, int dex, class_1799 icon, String speciesKey) {
            this.name = name;
            this.dex = dex;
            this.icon = icon;
            this.speciesKey = speciesKey == null ? name.toLowerCase() : speciesKey.toLowerCase();
        }
    }
}

