/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.config;

import github.jorgaomc.CobblemonMastery;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class ConfigManager {
    private static int autosaveSeconds = 60;

    public static void load() {
        block16: {
            try {
                Path cfgDir = ConfigManager.getConfigDir();
                Files.createDirectories(cfgDir, new FileAttribute[0]);
                Path props = cfgDir.resolve("cobblemonresearchtasks.properties");
                if (Files.exists(props, new LinkOption[0])) {
                    Properties p = new Properties();
                    try (InputStream in = Files.newInputStream(props, new OpenOption[0]);){
                        p.load(in);
                    }
                    autosaveSeconds = Integer.parseInt(p.getProperty("autosave_seconds", String.valueOf(autosaveSeconds)));
                    break block16;
                }
                Properties p = new Properties();
                p.setProperty("autosave_seconds", String.valueOf(autosaveSeconds));
                try (OutputStream out = Files.newOutputStream(props, new OpenOption[0]);){
                    p.store(out, "CobblemonMastery config");
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.warn("Failed to load config, using defaults", (Throwable)e);
            }
        }
    }

    public static int getAutosaveSeconds() {
        return autosaveSeconds;
    }

    public static Path getConfigDir() {
        return Path.of("config", new String[0]).resolve("cobblemonresearchtasks");
    }

    public static Path getPokemonConfigDir() {
        return ConfigManager.getConfigDir().resolve("pokemon");
    }

    public static Path getBackupPlayerDataDir(Path worldDir) {
        return worldDir.resolve("cobblemonresearchtasks").resolve("playerdata");
    }

    public static Path getRewardsDir() {
        return ConfigManager.getConfigDir().resolve("rewards");
    }

    public static Path getGlobalRewardsFile() {
        return ConfigManager.getRewardsDir().resolve("global.json");
    }

    public static Path getSpeciesRewardsDir() {
        return ConfigManager.getRewardsDir().resolve("species");
    }
}

